/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.akjrcp.ffmpeg;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import jp.sourceforge.akjrcp.util.ProcessMonitor;
import jp.sourceforge.akjrcp.util.SimpleProcessPrinter;

public final class FFMpegUtils {
    public static boolean isFFMpegAvailable(String path) {
        return path != null && !path.equals("") && path.endsWith("ffmpeg.exe") && new File(path).exists();
    }

    public static String toAVSScript(String path) {
        return "DirectShowSource(\"" + path + "\")";
    }

    public static boolean shouldUseAvisynth(File file) {
        String[] notsupport = new String[]{"flv", "mpg", "mp3"};
        int i = 0;
        while (i < notsupport.length) {
            if (file.getName().endsWith("." + notsupport[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isAvisynthAvailable(File ffmpeg) {
        File tmp = null;
        try {
            tmp = File.createTempFile("avisynth", ".avs");
            FileWriter writer = new FileWriter(tmp);
            writer.write("BlankClip()");
            writer.close();
            Runtime runtime = Runtime.getRuntime();
            Process p = runtime.exec(new String[]{ffmpeg.getAbsolutePath(), "-i", tmp.getAbsolutePath()});
            SimpleProcessPrinter ffmpegMonitor = new SimpleProcessPrinter();
            ProcessMonitor monitor = new ProcessMonitor(p, ffmpegMonitor);
            monitor.startMonitor();
            try {
                p.waitFor();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            tmp.delete();
            String log = ffmpegMonitor.getLog();
            if (log.indexOf("Video: rawvideo") != -1) {
                return true;
            }
        }
        catch (IOException e) {
            tmp.delete();
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isProgressString(String line) {
        return line.startsWith("size=") || line.startsWith("frame=");
    }

    public static int getProgressSize(String line) {
        int end;
        int r = 0;
        int s = line.indexOf("size=");
        if (s != -1 && (end = line.indexOf("k", s + 5)) != -1) {
            String tmp = line.substring(s + 5, end);
            r = Integer.parseInt(tmp.replaceAll(" ", ""));
        }
        return r;
    }
}

