/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.view.preferences;

import cc.arduino.i18n.Language;
import cc.arduino.i18n.Languages;
import cc.arduino.view.preferences.AdditionalBoardsManagerURLTextArea;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import processing.app.Base;
import processing.app.BaseNoGui;
import processing.app.Editor;
import processing.app.I18n;
import processing.app.PreferencesData;
import processing.app.Theme;
import processing.app.helpers.FileUtils;
import processing.app.legacy.PApplet;

public class Preferences
extends JDialog {
    private final WarningItem[] warningItems;
    private final Base base;
    private JTextField additionalBoardsManagerField;
    private JLabel additionalBoardsManagerLabel;
    private JLabel arduinoNotRunningLabel;
    private JRadioButton autoProxy;
    private JTextField autoProxyPACURL;
    private JPasswordField autoProxyPassword;
    private JLabel autoProxyPasswordLabel;
    private JCheckBox autoProxyUsePAC;
    private JTextField autoProxyUsername;
    private JLabel autoProxyUsernameLabel;
    private JCheckBox autoScaleCheckBox;
    private JButton browseButton;
    private JCheckBox checkUpdatesBox;
    private JPanel checkboxesContainer;
    private JComboBox comboLanguage;
    private JLabel comboLanguageLabel;
    private JComboBox comboWarnings;
    private JLabel comboWarningsLabel;
    private JCheckBox displayLineNumbersBox;
    private JCheckBox enableCodeFoldingBox;
    private JButton extendedAdditionalUrlFieldWindow;
    private JCheckBox externalEditorBox;
    private JCheckBox cacheCompiledCore;
    private JTextField fontSizeField;
    private JLabel fontSizeLabel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JRadioButton manualProxy;
    private JRadioButton manualProxyHTTP;
    private JTextField manualProxyHostName;
    private JLabel manualProxyHostNameLabel;
    private JPasswordField manualProxyPassword;
    private JLabel manualProxyPasswordLabel;
    private JTextField manualProxyPort;
    private JLabel manualProxyPortLabel;
    private JRadioButton manualProxySOCKS;
    private ButtonGroup manualProxyTypeButtonGroup;
    private JTextField manualProxyUsername;
    private JLabel manualProxyUsernameLabel;
    private JLabel morePreferencesLabel;
    private JRadioButton noProxy;
    private JLabel preferencesFileLabel;
    private ButtonGroup proxyTypeButtonGroup;
    private JLabel requiresRestartLabel;
    private JCheckBox saveVerifyUploadBox;
    private JSpinner scaleSpinner;
    private JLabel showVerboseLabel;
    private JTextField sketchbookLocationField;
    private JLabel sketchbookLocationLabel;
    private JCheckBox updateExtensionBox;
    private JCheckBox verboseCompilationBox;
    private JCheckBox verboseUploadBox;
    private JCheckBox verifyUploadBox;

    public Preferences(Window parent, Base base) {
        super(parent);
        this.base = base;
        this.warningItems = new WarningItem[]{new WarningItem("none", I18n.tr((String)"None")), new WarningItem("default", I18n.tr((String)"Default")), new WarningItem("more", I18n.tr((String)"More")), new WarningItem("all", I18n.tr((String)"All"))};
        this.initComponents();
        Base.registerWindowCloseKeys(this.getRootPane(), this::cancelButtonActionPerformed);
        this.showPrerefencesData();
    }

    private void initComponents() {
        this.proxyTypeButtonGroup = new ButtonGroup();
        this.manualProxyTypeButtonGroup = new ButtonGroup();
        JPanel jPanel2 = new JPanel();
        JTabbedPane jTabbedPane1 = new JTabbedPane();
        this.jPanel1 = new JPanel();
        this.sketchbookLocationLabel = new JLabel();
        this.sketchbookLocationField = new JTextField();
        this.browseButton = new JButton();
        this.comboLanguageLabel = new JLabel();
        this.comboLanguage = new JComboBox<Language>(Languages.languages);
        this.requiresRestartLabel = new JLabel();
        this.fontSizeLabel = new JLabel();
        this.fontSizeField = new JTextField();
        this.showVerboseLabel = new JLabel();
        this.verboseCompilationBox = new JCheckBox();
        this.verboseUploadBox = new JCheckBox();
        this.comboWarningsLabel = new JLabel();
        this.comboWarnings = new JComboBox<WarningItem>(this.warningItems);
        this.additionalBoardsManagerLabel = new JLabel();
        this.additionalBoardsManagerField = new JTextField();
        this.extendedAdditionalUrlFieldWindow = new JButton();
        this.morePreferencesLabel = new JLabel();
        this.preferencesFileLabel = new JLabel();
        this.arduinoNotRunningLabel = new JLabel();
        this.checkboxesContainer = new JPanel();
        this.displayLineNumbersBox = new JCheckBox();
        this.enableCodeFoldingBox = new JCheckBox();
        this.verifyUploadBox = new JCheckBox();
        this.externalEditorBox = new JCheckBox();
        this.cacheCompiledCore = new JCheckBox();
        this.checkUpdatesBox = new JCheckBox();
        this.updateExtensionBox = new JCheckBox();
        this.saveVerifyUploadBox = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.scaleSpinner = new JSpinner();
        this.autoScaleCheckBox = new JCheckBox();
        this.jLabel3 = new JLabel();
        JPanel jPanel4 = new JPanel();
        this.noProxy = new JRadioButton();
        this.autoProxy = new JRadioButton();
        this.manualProxy = new JRadioButton();
        this.autoProxyUsePAC = new JCheckBox();
        this.autoProxyPACURL = new JTextField();
        this.manualProxyHTTP = new JRadioButton();
        this.manualProxySOCKS = new JRadioButton();
        this.manualProxyHostNameLabel = new JLabel();
        this.manualProxyPortLabel = new JLabel();
        this.manualProxyHostName = new JTextField();
        this.manualProxyPort = new JTextField();
        this.manualProxyUsernameLabel = new JLabel();
        this.manualProxyUsername = new JTextField();
        this.manualProxyPasswordLabel = new JLabel();
        this.manualProxyPassword = new JPasswordField();
        this.autoProxyUsernameLabel = new JLabel();
        this.autoProxyUsername = new JTextField();
        this.autoProxyPassword = new JPasswordField();
        this.autoProxyPasswordLabel = new JLabel();
        JPanel jPanel3 = new JPanel();
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle(I18n.tr((String)"Preferences"));
        this.setModal(true);
        this.setResizable(false);
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jTabbedPane1.setFocusable(false);
        jTabbedPane1.setRequestFocusEnabled(false);
        this.sketchbookLocationLabel.setText(I18n.tr((String)"Sketchbook location:"));
        this.sketchbookLocationField.setColumns(40);
        this.browseButton.setText(I18n.PROMPT_BROWSE);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Preferences.this.browseButtonActionPerformed(evt);
            }
        });
        this.comboLanguageLabel.setText(I18n.tr((String)"Editor language: "));
        this.requiresRestartLabel.setText(I18n.tr((String)"  (requires restart of Arduino)"));
        this.fontSizeLabel.setText(I18n.tr((String)"Editor font size: "));
        this.fontSizeField.setColumns(4);
        this.showVerboseLabel.setText(I18n.tr((String)"Show verbose output during: "));
        this.verboseCompilationBox.setText(I18n.tr((String)"compilation "));
        this.verboseUploadBox.setText(I18n.tr((String)"upload"));
        this.comboWarningsLabel.setText(I18n.tr((String)"Compiler warnings: "));
        this.additionalBoardsManagerLabel.setText(I18n.tr((String)"Additional Boards Manager URLs: "));
        this.additionalBoardsManagerLabel.setToolTipText(I18n.tr((String)"Enter a comma separated list of urls"));
        this.additionalBoardsManagerField.setToolTipText(I18n.tr((String)"Enter a comma separated list of urls"));
        this.extendedAdditionalUrlFieldWindow.setIcon(new ImageIcon(Theme.getThemeImage("newwindow", this, Theme.scale(16), Theme.scale(14))));
        this.extendedAdditionalUrlFieldWindow.setMargin(new Insets(1, 1, 1, 1));
        this.extendedAdditionalUrlFieldWindow.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Preferences.this.extendedAdditionalUrlFieldWindowActionPerformed(evt);
            }
        });
        this.morePreferencesLabel.setForeground(Color.GRAY);
        this.morePreferencesLabel.setText(I18n.tr((String)"More preferences can be edited directly in the file"));
        this.preferencesFileLabel.setText(PreferencesData.getPreferencesFile().getAbsolutePath());
        this.preferencesFileLabel.setCursor(new Cursor(12));
        this.preferencesFileLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                Preferences.this.preferencesFileLabelMousePressed(evt);
            }

            @Override
            public void mouseExited(MouseEvent evt) {
                Preferences.this.preferencesFileLabelMouseExited(evt);
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                Preferences.this.preferencesFileLabelMouseEntered(evt);
            }
        });
        this.arduinoNotRunningLabel.setForeground(Color.GRAY);
        this.arduinoNotRunningLabel.setText(I18n.tr((String)"(edit only when Arduino is not running)"));
        this.checkboxesContainer.setLayout(new BoxLayout(this.checkboxesContainer, 1));
        this.displayLineNumbersBox.setText(I18n.tr((String)"Display line numbers"));
        this.checkboxesContainer.add(this.displayLineNumbersBox);
        this.enableCodeFoldingBox.setText(I18n.tr((String)"Enable Code Folding"));
        this.checkboxesContainer.add(this.enableCodeFoldingBox);
        this.verifyUploadBox.setText(I18n.tr((String)"Verify code after upload"));
        this.checkboxesContainer.add(this.verifyUploadBox);
        this.externalEditorBox.setText(I18n.tr((String)"Use external editor"));
        this.externalEditorBox.addItemListener(ev -> {
            if (ev.getStateChange() == 1) {
                for (Editor e : this.base.getEditors()) {
                    if (!e.getSketch().isModified()) continue;
                    String msg = I18n.tr((String)"You have unsaved changes!\nYou must save all your sketches to enable this option.");
                    JOptionPane.showMessageDialog(null, msg, I18n.tr((String)"Can't enable external editor"), 1);
                    this.externalEditorBox.setSelected(false);
                    return;
                }
            }
        });
        this.checkboxesContainer.add(this.externalEditorBox);
        this.cacheCompiledCore.setText(I18n.tr((String)"Aggressively cache compiled core"));
        this.checkboxesContainer.add(this.cacheCompiledCore);
        this.checkUpdatesBox.setText(I18n.tr((String)"Check for updates on startup"));
        this.checkboxesContainer.add(this.checkUpdatesBox);
        this.updateExtensionBox.setText(I18n.tr((String)"Update sketch files to new extension on save (.pde -> .ino)"));
        this.checkboxesContainer.add(this.updateExtensionBox);
        this.saveVerifyUploadBox.setText(I18n.tr((String)"Save when verifying or uploading"));
        this.checkboxesContainer.add(this.saveVerifyUploadBox);
        this.jLabel1.setText(I18n.tr((String)"Interface scale:"));
        this.jLabel2.setText(I18n.tr((String)"  (requires restart of Arduino)"));
        this.scaleSpinner.setModel(new SpinnerNumberModel(100, 100, 400, 5));
        this.scaleSpinner.setEnabled(false);
        this.autoScaleCheckBox.setSelected(true);
        this.autoScaleCheckBox.setText(I18n.tr((String)"Automatic"));
        this.autoScaleCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Preferences.this.autoScaleCheckBoxItemStateChanged(evt);
            }
        });
        this.jLabel3.setText("%");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.sketchbookLocationField, -1, 553, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)).addComponent(this.checkboxesContainer, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.comboWarningsLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboWarnings, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.autoScaleCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scaleSpinner, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2)))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.showVerboseLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.verboseCompilationBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.verboseUploadBox)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.comboLanguageLabel).addComponent(this.fontSizeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fontSizeField, -2, -1, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.comboLanguage, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.requiresRestartLabel)))).addComponent(this.arduinoNotRunningLabel).addComponent(this.morePreferencesLabel).addComponent(this.preferencesFileLabel).addComponent(this.sketchbookLocationLabel).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.additionalBoardsManagerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.additionalBoardsManagerField, -2, 500, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.extendedAdditionalUrlFieldWindow))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.comboLanguageLabel, this.comboWarningsLabel, this.fontSizeLabel, this.jLabel1, this.showVerboseLabel);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.sketchbookLocationLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.sketchbookLocationField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboLanguageLabel).addComponent(this.comboLanguage, -2, -1, -2).addComponent(this.requiresRestartLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fontSizeLabel).addComponent(this.fontSizeField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.scaleSpinner, -2, -1, -2).addComponent(this.autoScaleCheckBox).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.showVerboseLabel).addComponent(this.verboseCompilationBox).addComponent(this.verboseUploadBox)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboWarningsLabel).addComponent(this.comboWarnings, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.checkboxesContainer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.additionalBoardsManagerLabel).addComponent(this.additionalBoardsManagerField, -2, -1, -2)).addComponent(this.extendedAdditionalUrlFieldWindow)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.morePreferencesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.preferencesFileLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.arduinoNotRunningLabel).addContainerGap()));
        jTabbedPane1.addTab(I18n.tr((String)"Settings"), this.jPanel1);
        this.proxyTypeButtonGroup.add(this.noProxy);
        this.noProxy.setText(I18n.tr((String)"No proxy"));
        this.noProxy.setActionCommand("none");
        this.proxyTypeButtonGroup.add(this.autoProxy);
        this.autoProxy.setText(I18n.tr((String)"Auto-detect proxy settings"));
        this.autoProxy.setActionCommand("auto");
        this.autoProxy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Preferences.this.autoProxyItemStateChanged(evt);
            }
        });
        this.proxyTypeButtonGroup.add(this.manualProxy);
        this.manualProxy.setText(I18n.tr((String)"Manual proxy configuration"));
        this.manualProxy.setActionCommand("manual");
        this.manualProxy.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Preferences.this.manualProxyItemStateChanged(evt);
            }
        });
        this.autoProxyUsePAC.setText(I18n.tr((String)"Automatic proxy configuration URL:"));
        this.autoProxyUsePAC.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                Preferences.this.autoProxyUsePACItemStateChanged(evt);
            }
        });
        this.manualProxyTypeButtonGroup.add(this.manualProxyHTTP);
        this.manualProxyHTTP.setText("HTTP");
        this.manualProxyHTTP.setActionCommand("HTTP");
        this.manualProxyTypeButtonGroup.add(this.manualProxySOCKS);
        this.manualProxySOCKS.setText("SOCKS");
        this.manualProxySOCKS.setActionCommand("SOCKS");
        this.manualProxyHostNameLabel.setText(I18n.tr((String)"Host name:"));
        this.manualProxyPortLabel.setText(I18n.tr((String)"Port number:"));
        this.manualProxyUsernameLabel.setText(I18n.tr((String)"Username:"));
        this.manualProxyPasswordLabel.setText(I18n.tr((String)"Password:"));
        this.manualProxyPassword.setToolTipText("");
        this.autoProxyUsernameLabel.setText(I18n.tr((String)"Username:"));
        this.autoProxyPassword.setToolTipText("");
        this.autoProxyPasswordLabel.setText(I18n.tr((String)"Password:"));
        GroupLayout jPanel4Layout = new GroupLayout(jPanel4);
        jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoProxyUsePAC).addGroup(jPanel4Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoProxyUsernameLabel).addComponent(this.autoProxyPasswordLabel)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoProxyPACURL).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoProxyUsername, -2, 178, -2).addComponent(this.autoProxyPassword, -2, 180, -2)).addGap(0, 0, Short.MAX_VALUE)))).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.noProxy).addComponent(this.autoProxy).addComponent(this.manualProxy).addGroup(jPanel4Layout.createSequentialGroup().addGap(12, 12, 12).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addComponent(this.manualProxyHTTP).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.manualProxySOCKS)).addGroup(jPanel4Layout.createSequentialGroup().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.manualProxyHostNameLabel).addComponent(this.manualProxyPortLabel).addComponent(this.manualProxyUsernameLabel).addComponent(this.manualProxyPasswordLabel)).addGap(18, 18, 18).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.manualProxyHostName, -2, 541, -2).addComponent(this.manualProxyPort, -2, 74, -2).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.manualProxyPassword, GroupLayout.Alignment.LEADING).addComponent(this.manualProxyUsername, GroupLayout.Alignment.LEADING, -2, 180, -2))))))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addComponent(this.noProxy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoProxy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoProxyUsePAC).addComponent(this.autoProxyPACURL, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoProxyUsername, -2, -1, -2).addComponent(this.autoProxyUsernameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.autoProxyPasswordLabel).addComponent(this.autoProxyPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.manualProxy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.manualProxyHTTP).addComponent(this.manualProxySOCKS)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.manualProxyHostNameLabel).addComponent(this.manualProxyHostName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.manualProxyPort, -2, -1, -2).addComponent(this.manualProxyPortLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.manualProxyUsername, -2, -1, -2).addComponent(this.manualProxyUsernameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.manualProxyPassword, -2, -1, -2).addComponent(this.manualProxyPasswordLabel)).addContainerGap(50, Short.MAX_VALUE)));
        jTabbedPane1.addTab(I18n.tr((String)"Network"), jPanel4);
        jPanel2.add(jTabbedPane1);
        okButton.setText(I18n.PROMPT_OK);
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Preferences.this.okButtonActionPerformed(evt);
            }
        });
        cancelButton.setText(I18n.PROMPT_CANCEL);
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Preferences.this.cancelButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(cancelButton).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(okButton).addComponent(cancelButton))));
        jPanel2.add(jPanel3);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 691, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel2, -1, -1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 580, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel2, -1, -1, Short.MAX_VALUE)));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispatchEvent(new WindowEvent(this, 201));
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        List<String> errors = this.validateData();
        if (!errors.isEmpty()) {
            Base.showWarning(I18n.tr((String)"Error"), errors.get(0), null);
            return;
        }
        this.savePreferencesData();
        this.base.getEditors().forEach(Editor::applyPreferences);
        this.cancelButtonActionPerformed(evt);
    }

    private void autoProxyItemStateChanged(ItemEvent evt) {
        this.disableAllProxyFields();
        this.autoProxyFieldsSetEnabled(this.autoProxy.isSelected());
    }

    private void manualProxyItemStateChanged(ItemEvent evt) {
        this.disableAllProxyFields();
        this.manualProxyFieldsSetEnabled(this.manualProxy.isSelected());
    }

    private void autoProxyUsePACItemStateChanged(ItemEvent evt) {
        this.autoProxyPACFieldsSetEnabled(this.autoProxyUsePAC.isSelected());
    }

    private void preferencesFileLabelMouseEntered(MouseEvent evt) {
        this.preferencesFileLabel.setForeground(new Color(0, 0, 140));
    }

    private void preferencesFileLabelMouseExited(MouseEvent evt) {
        this.preferencesFileLabel.setForeground(new Color(76, 76, 76));
    }

    private void preferencesFileLabelMousePressed(MouseEvent evt) {
        Base.openFolder(PreferencesData.getPreferencesFile().getParentFile());
    }

    private void extendedAdditionalUrlFieldWindowActionPerformed(ActionEvent evt) {
        AdditionalBoardsManagerURLTextArea additionalBoardsManagerURLTextArea = new AdditionalBoardsManagerURLTextArea((Window)this);
        additionalBoardsManagerURLTextArea.setText(this.additionalBoardsManagerField.getText());
        additionalBoardsManagerURLTextArea.onOk(e -> this.additionalBoardsManagerField.setText(additionalBoardsManagerURLTextArea.getText()));
        additionalBoardsManagerURLTextArea.setVisible(true);
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File dflt = new File(this.sketchbookLocationField.getText());
        File file = Base.selectFolder(I18n.tr((String)"Select new sketchbook location"), dflt, this);
        if (file != null) {
            String path = file.getAbsolutePath();
            this.sketchbookLocationField.setText(path);
        }
    }

    private void autoScaleCheckBoxItemStateChanged(ItemEvent evt) {
        this.scaleSpinner.setEnabled(!this.autoScaleCheckBox.isSelected());
    }

    private List<String> validateData() {
        LinkedList<String> errors = new LinkedList<String>();
        if (FileUtils.isSubDirectory((File)new File(this.sketchbookLocationField.getText()), (File)new File(PreferencesData.get((String)"runtime.ide.path")))) {
            errors.add(I18n.tr((String)"The specified sketchbook folder contains your copy of the IDE.\nPlease choose a different folder for your sketchbook."));
        }
        return errors;
    }

    private void savePreferencesData() {
        String oldPath = PreferencesData.get((String)"sketchbook.path");
        String newPath = this.sketchbookLocationField.getText();
        if (newPath.isEmpty()) {
            newPath = BaseNoGui.getPortableFolder() == null ? this.base.getDefaultSketchbookFolderOrPromptForIt().toString() : BaseNoGui.getPortableSketchbookFolder();
        }
        if (!newPath.equals(oldPath)) {
            this.base.rebuildSketchbookMenus();
            PreferencesData.set((String)"sketchbook.path", (String)newPath);
        }
        Language newLanguage = (Language)this.comboLanguage.getSelectedItem();
        PreferencesData.set((String)"editor.languages.current", (String)newLanguage.getIsoCode());
        String newSizeText = this.fontSizeField.getText();
        try {
            int newSize = Integer.parseInt(newSizeText.trim());
            String[] pieces = PApplet.split((String)PreferencesData.get((String)"editor.font"), (char)',');
            pieces[2] = String.valueOf(newSize);
            PreferencesData.set((String)"editor.font", (String)PApplet.join((String[])pieces, (char)','));
        }
        catch (Exception e) {
            System.err.println(I18n.format((String)I18n.tr((String)"ignoring invalid font size {0}"), (Object[])new Object[]{newSizeText}));
        }
        if (this.autoScaleCheckBox.isSelected()) {
            PreferencesData.set((String)"gui.scale", (String)"auto");
        } else {
            PreferencesData.set((String)"gui.scale", (String)this.scaleSpinner.getValue().toString());
        }
        PreferencesData.setBoolean((String)"build.verbose", (boolean)this.verboseCompilationBox.isSelected());
        PreferencesData.setBoolean((String)"upload.verbose", (boolean)this.verboseUploadBox.isSelected());
        WarningItem warningItem = (WarningItem)this.comboWarnings.getSelectedItem();
        PreferencesData.set((String)"compiler.warning_level", (String)warningItem.getValue());
        PreferencesData.setBoolean((String)"editor.linenumbers", (boolean)this.displayLineNumbersBox.isSelected());
        PreferencesData.setBoolean((String)"editor.code_folding", (boolean)this.enableCodeFoldingBox.isSelected());
        PreferencesData.setBoolean((String)"upload.verify", (boolean)this.verifyUploadBox.isSelected());
        PreferencesData.setBoolean((String)"editor.save_on_verify", (boolean)this.saveVerifyUploadBox.isSelected());
        PreferencesData.setBoolean((String)"editor.external", (boolean)this.externalEditorBox.isSelected());
        PreferencesData.setBoolean((String)"compiler.cache_core", (boolean)this.cacheCompiledCore.isSelected());
        PreferencesData.setBoolean((String)"update.check", (boolean)this.checkUpdatesBox.isSelected());
        PreferencesData.setBoolean((String)"editor.update_extension", (boolean)this.updateExtensionBox.isSelected());
        PreferencesData.setBoolean((String)"editor.save_on_verify", (boolean)this.saveVerifyUploadBox.isSelected());
        PreferencesData.set((String)"boardsmanager.additional.urls", (String)this.additionalBoardsManagerField.getText().replace("\r\n", "\n").replace("\r", "\n").replace("\n", ","));
        PreferencesData.set((String)"proxy.type", (String)this.proxyTypeButtonGroup.getSelection().getActionCommand());
        PreferencesData.set((String)"proxy.pac.url", (String)(this.autoProxyUsePAC.isSelected() ? this.autoProxyPACURL.getText() : ""));
        PreferencesData.set((String)"proxy.manual.type", (String)this.manualProxyTypeButtonGroup.getSelection().getActionCommand());
        PreferencesData.set((String)"proxy.manual.hostname", (String)this.manualProxyHostName.getText());
        PreferencesData.set((String)"proxy.manual.port", (String)this.manualProxyPort.getText());
        PreferencesData.set((String)"proxy.manual.username", (String)this.manualProxyUsername.getText());
        PreferencesData.set((String)"proxy.manual.password", (String)String.valueOf(this.manualProxyPassword.getPassword()));
        PreferencesData.set((String)"proxy.manual.username", (String)this.autoProxyUsername.getText());
        PreferencesData.set((String)"proxy.manual.password", (String)String.valueOf(this.autoProxyPassword.getPassword()));
    }

    private void showPrerefencesData() {
        this.sketchbookLocationField.setText(PreferencesData.get((String)"sketchbook.path"));
        String currentLanguageISOCode = PreferencesData.get((String)"editor.languages.current");
        for (Language language : Languages.languages) {
            if (!language.getIsoCode().equals(currentLanguageISOCode)) continue;
            this.comboLanguage.setSelectedItem(language);
        }
        Font editorFont = PreferencesData.getFont((String)"editor.font");
        this.fontSizeField.setText(String.valueOf(editorFont.getSize()));
        try {
            int scale = PreferencesData.getInteger((String)"gui.scale", (int)-1);
            if (scale != -1) {
                this.autoScaleCheckBox.setSelected(false);
                this.scaleSpinner.setValue(scale);
            }
        }
        catch (NumberFormatException scale) {
            // empty catch block
        }
        this.verboseCompilationBox.setSelected(PreferencesData.getBoolean((String)"build.verbose"));
        this.verboseUploadBox.setSelected(PreferencesData.getBoolean((String)"upload.verbose"));
        String currentWarningLevel = PreferencesData.get((String)"compiler.warning_level", (String)"none");
        for (WarningItem item : this.warningItems) {
            if (!currentWarningLevel.equals(item.getValue())) continue;
            this.comboWarnings.setSelectedItem(item);
        }
        this.displayLineNumbersBox.setSelected(PreferencesData.getBoolean((String)"editor.linenumbers"));
        this.enableCodeFoldingBox.setSelected(PreferencesData.getBoolean((String)"editor.code_folding"));
        this.verifyUploadBox.setSelected(PreferencesData.getBoolean((String)"upload.verify"));
        this.externalEditorBox.setSelected(PreferencesData.getBoolean((String)"editor.external"));
        this.cacheCompiledCore.setSelected(PreferencesData.get((String)"compiler.cache_core") == null || PreferencesData.getBoolean((String)"compiler.cache_core"));
        this.checkUpdatesBox.setSelected(PreferencesData.getBoolean((String)"update.check"));
        this.updateExtensionBox.setSelected(PreferencesData.get((String)"editor.update_extension") == null || PreferencesData.getBoolean((String)"editor.update_extension"));
        this.saveVerifyUploadBox.setSelected(PreferencesData.getBoolean((String)"editor.save_on_verify"));
        this.additionalBoardsManagerField.setText(PreferencesData.get((String)"boardsmanager.additional.urls"));
        this.disableAllProxyFields();
        String proxyType = PreferencesData.get((String)"proxy.type", (String)"auto");
        if ("none".equals(proxyType)) {
            this.noProxy.setSelected(true);
        } else if ("auto".equals(proxyType)) {
            this.autoProxy.setSelected(true);
            this.autoProxyFieldsSetEnabled(true);
            if (!PreferencesData.get((String)"proxy.pac.url", (String)"").isEmpty()) {
                this.autoProxyUsePAC.setSelected(true);
                this.autoProxyPACURL.setText(PreferencesData.get((String)"proxy.pac.url"));
                this.autoProxyUsername.setText(PreferencesData.get((String)"proxy.manual.username"));
                this.autoProxyPassword.setText(PreferencesData.get((String)"proxy.manual.password"));
            }
        } else {
            this.manualProxy.setSelected(true);
            this.manualProxyFieldsSetEnabled(true);
            this.manualProxyHostName.setText(PreferencesData.get((String)"proxy.manual.hostname"));
            this.manualProxyPort.setText(PreferencesData.get((String)"proxy.manual.port"));
            this.manualProxyUsername.setText(PreferencesData.get((String)"proxy.manual.username"));
            this.manualProxyPassword.setText(PreferencesData.get((String)"proxy.manual.password"));
        }
        String selectedManualProxyType = PreferencesData.get((String)"proxy.manual.type", (String)"HTTP");
        this.manualProxyHTTP.setSelected("HTTP".equals(selectedManualProxyType));
        this.manualProxySOCKS.setSelected("SOCKS".equals(selectedManualProxyType));
    }

    private void manualProxyFieldsSetEnabled(boolean enabled) {
        this.manualProxySOCKS.setEnabled(enabled);
        this.manualProxyHTTP.setEnabled(enabled);
        this.manualProxyHostNameLabel.setEnabled(enabled);
        this.manualProxyHostName.setEnabled(enabled);
        this.manualProxyPortLabel.setEnabled(enabled);
        this.manualProxyPort.setEnabled(enabled);
        this.manualProxyUsernameLabel.setEnabled(enabled);
        this.manualProxyUsername.setEnabled(enabled);
        this.manualProxyPasswordLabel.setEnabled(enabled);
        this.manualProxyPassword.setEnabled(enabled);
    }

    private void autoProxyFieldsSetEnabled(boolean enabled) {
        this.autoProxyUsePAC.setEnabled(enabled);
        this.autoProxyPACFieldsSetEnabled(enabled && this.autoProxyUsePAC.isSelected());
    }

    private void autoProxyPACFieldsSetEnabled(boolean enabled) {
        this.autoProxyPACURL.setEnabled(enabled);
        this.autoProxyUsername.setEnabled(enabled);
        this.autoProxyUsernameLabel.setEnabled(enabled);
        this.autoProxyPassword.setEnabled(enabled);
        this.autoProxyPasswordLabel.setEnabled(enabled);
    }

    private void disableAllProxyFields() {
        this.autoProxyFieldsSetEnabled(false);
        this.manualProxyFieldsSetEnabled(false);
    }

    private static class WarningItem {
        private final String value;
        private final String translation;

        public WarningItem(String value, String translation) {
            this.value = value;
            this.translation = translation;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.translation;
        }
    }
}

