/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.plugins.wifi101;

import cc.arduino.packages.BoardPort;
import cc.arduino.plugins.wifi101.CertificateListModel;
import cc.arduino.plugins.wifi101.SerialPortListModel;
import cc.arduino.plugins.wifi101.UpdaterJFrame;
import cc.arduino.plugins.wifi101.firmwares.WINC1500Firmware;
import cc.arduino.plugins.wifi101.flashers.Flasher;
import cc.arduino.plugins.wifi101.flashers.java.JavaFlasher;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import processing.app.Base;

public class UpdaterImpl
extends UpdaterJFrame {
    private Flasher flasher;
    private List<String> websites = new ArrayList<String>();
    private SerialPortListModel listModel;

    public UpdaterImpl() throws Exception {
        Base.registerWindowCloseKeys((JRootPane)this.getRootPane(), actionEvent -> this.setVisible(false));
        Base.setIcon((Frame)this);
        for (WINC1500Firmware wINC1500Firmware : WINC1500Firmware.available) {
            this.getFirmwareSelector().addItem(wINC1500Firmware);
        }
        this.refreshSerialPortList();
        this.websites.add("arduino.cc:443");
        this.refreshCertList();
        this.flasher = new JavaFlasher(){

            @Override
            public void progress(int n, String string) {
                if (string.length() > 60) {
                    string = string.substring(0, 60) + "...";
                }
                UpdaterImpl.this.getUpdateProgressBar().setValue(n);
                UpdaterImpl.this.getUpdateProgressBar().setStringPainted(true);
                UpdaterImpl.this.getUpdateProgressBar().setString(string);
            }
        };
    }

    private void refreshCertList() {
        CertificateListModel certificateListModel = new CertificateListModel(this.websites);
        this.getCertSelector().setModel(certificateListModel);
    }

    @Override
    protected void refreshSerialPortList() {
        this.listModel = new SerialPortListModel();
        this.getSerialPortList().setModel(this.listModel);
    }

    private BoardPort getSelectedPort() {
        int n = this.getSerialPortList().getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return this.listModel.getPort(n);
    }

    @Override
    protected void testConnection() {
        final BoardPort boardPort = this.getSelectedPort();
        if (boardPort == null) {
            JOptionPane.showMessageDialog(this, "Please select a port to run the test!");
            return;
        }
        this.setEnabled(false);
        new Thread(){

            @Override
            public void run() {
                try {
                    UpdaterImpl.this.flasher.testConnection(boardPort.getAddress());
                    JOptionPane.showMessageDialog(UpdaterImpl.this, "The programmer is working!", "Test successful", 1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(UpdaterImpl.this, exception.getMessage(), "Connection error.", 0);
                }
                UpdaterImpl.this.setEnabled(true);
                UpdaterImpl.this.resetProgress();
            }
        }.start();
    }

    @Override
    protected void updateFirmware() {
        final BoardPort boardPort = this.getSelectedPort();
        if (boardPort == null) {
            JOptionPane.showMessageDialog(this, "Please select a port to update firmware!");
            return;
        }
        final WINC1500Firmware wINC1500Firmware = (WINC1500Firmware)this.getFirmwareSelector().getSelectedItem();
        this.setEnabled(false);
        new Thread(){

            @Override
            public void run() {
                try {
                    UpdaterImpl.this.flasher.updateFirmware(boardPort.getAddress(), wINC1500Firmware);
                    JOptionPane.showMessageDialog(UpdaterImpl.this, "The firmware has been updated!", "Success", 1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(UpdaterImpl.this, exception.getMessage(), "Upload error.", 0);
                }
                UpdaterImpl.this.setEnabled(true);
                UpdaterImpl.this.resetProgress();
            }
        }.start();
    }

    @Override
    protected void addCertificate() {
        String string = JOptionPane.showInputDialog(this, "Enter the website to fetch SSL certificate:", "Add SSL certificate from website", 3);
        if (string.startsWith("http://")) {
            JOptionPane.showMessageDialog(this, "Sorry \"http://\" protocol doesn't support SSL", "Invalid URL error.", 0);
            return;
        }
        if (string.startsWith("https://")) {
            string = string.substring(8);
        }
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        if (!string.contains(":")) {
            string = string + ":443";
        }
        if (string.contains("/")) {
            JOptionPane.showMessageDialog(this, "Error: please use enter the addres using the format:\nwww.example.com:443", "Invalid URL error.", 0);
            return;
        }
        if (!this.websites.contains(string)) {
            this.websites.add(string);
        }
        this.refreshCertList();
    }

    @Override
    protected void removeCertificate() {
        int n = this.getCertSelector().getSelectedIndex();
        if (n == -1) {
            return;
        }
        this.websites.remove(n);
        this.refreshCertList();
    }

    @Override
    protected void uploadCertificates() {
        final BoardPort boardPort = this.getSelectedPort();
        if (boardPort == null) {
            JOptionPane.showMessageDialog(this, "Please select a port to upload SSL certificates!");
            return;
        }
        this.setEnabled(false);
        new Thread(){

            @Override
            public void run() {
                try {
                    UpdaterImpl.this.flasher.uploadCertificates(boardPort.getAddress(), UpdaterImpl.this.websites);
                    JOptionPane.showMessageDialog(UpdaterImpl.this, "The certificates have been uploaded!", "Success", 1);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    JOptionPane.showMessageDialog(UpdaterImpl.this, exception.getMessage(), "Upload error.", 0);
                }
                UpdaterImpl.this.setEnabled(true);
                UpdaterImpl.this.resetProgress();
            }
        }.start();
    }

    public void resetProgress() {
        this.getUpdateProgressBar().setValue(0);
        this.getUpdateProgressBar().setStringPainted(false);
    }
}

