/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.contributions.libraries;

import cc.arduino.contributions.DownloadableContributionBuiltInAtTheBottomComparator;
import cc.arduino.contributions.filters.InstalledPredicate;
import cc.arduino.contributions.libraries.ContributedLibrary;
import cc.arduino.contributions.libraries.filters.LibraryWithNamePredicate;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public abstract class LibrariesIndex {
    public abstract List<ContributedLibrary> getLibraries();

    public List<ContributedLibrary> find(String name) {
        return this.getLibraries().stream().filter(new LibraryWithNamePredicate(name)).collect(Collectors.toList());
    }

    public ContributedLibrary find(String name, String version) {
        if (name == null || version == null) {
            return null;
        }
        for (ContributedLibrary lib : this.find(name)) {
            if (!version.equals(lib.getParsedVersion())) continue;
            return lib;
        }
        return null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (ContributedLibrary library : this.getLibraries()) {
            sb.append(library.toString());
        }
        return sb.toString();
    }

    public List<String> getCategories() {
        LinkedList<String> categories = new LinkedList<String>();
        for (ContributedLibrary lib : this.getLibraries()) {
            if (lib.getCategory() == null || categories.contains(lib.getCategory())) continue;
            categories.add(lib.getCategory());
        }
        Collections.sort(categories);
        return categories;
    }

    public List<String> getTypes() {
        HashSet<String> typesAccumulator = new HashSet<String>();
        for (ContributedLibrary lib : this.getLibraries()) {
            if (lib.getTypes() == null) continue;
            typesAccumulator.addAll(lib.getTypes());
        }
        LinkedList<String> types = new LinkedList<String>(typesAccumulator);
        Collections.sort(types);
        return types;
    }

    public ContributedLibrary getInstalled(String name) {
        List installedReleases = this.find(name).stream().filter(new InstalledPredicate()).collect(Collectors.toList());
        Collections.sort(installedReleases, new DownloadableContributionBuiltInAtTheBottomComparator());
        if (installedReleases.isEmpty()) {
            return null;
        }
        return (ContributedLibrary)installedReleases.get(0);
    }
}

