/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.workspace;

import edu.mit.blocks.codeblockutil.CGraphite;
import edu.mit.blocks.codeblockutil.CHoverScrollPane;
import edu.mit.blocks.codeblockutil.CScrollPane;
import edu.mit.blocks.renderable.RenderableBlock;
import edu.mit.blocks.workspace.ContextMenu;
import edu.mit.blocks.workspace.ISupportMemento;
import edu.mit.blocks.workspace.Page;
import edu.mit.blocks.workspace.PageChangeEventManager;
import edu.mit.blocks.workspace.PageChangeListener;
import edu.mit.blocks.workspace.PageDivider;
import edu.mit.blocks.workspace.PageDrawerLoadingUtils;
import edu.mit.blocks.workspace.Workspace;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.SwingUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BlockCanvas
implements PageChangeListener,
ISupportMemento {
    private static final long serialVersionUID = 7458721329L;
    private List<Page> pages = new ArrayList<Page>();
    private List<PageDivider> dividers = new ArrayList<PageDivider>();
    private JComponent canvas;
    private CScrollPane scrollPane;
    private final Workspace workspace;
    private boolean collapsible = false;

    public BlockCanvas(Workspace workspace) {
        this.workspace = workspace;
        this.canvas = new Canvas();
        this.scrollPane = new CHoverScrollPane(this.canvas, CScrollPane.ScrollPolicy.VERTICAL_BAR_ALWAYS, CScrollPane.ScrollPolicy.HORIZONTAL_BAR_ALWAYS, 18, CGraphite.blue, null);
        this.scrollPane.setScrollingUnit(5);
        this.canvas.setLayout(null);
        this.canvas.setBackground(Color.gray);
        this.canvas.setOpaque(true);
        PageChangeEventManager.addPageChangeListener(this);
    }

    public void reset() {
        this.pages.clear();
        this.canvas.removeAll();
        this.dividers.clear();
        this.scrollPane.revalidate();
    }

    public int getX() {
        return this.scrollPane.getX();
    }

    public int getY() {
        return this.scrollPane.getY();
    }

    public int getWidth() {
        return this.scrollPane.getWidth();
    }

    public int getHeight() {
        return this.scrollPane.getHeight();
    }

    public BoundedRangeModel getVerticalModel() {
        return this.scrollPane.getVerticalModel();
    }

    public BoundedRangeModel getHorizontalModel() {
        return this.scrollPane.getHorizontalModel();
    }

    public JComponent getCanvas() {
        return this.canvas;
    }

    public JComponent getJComponent() {
        return this.scrollPane;
    }

    public String toString() {
        return "BlockCanvas " + this.pages.size() + " pages.";
    }

    public List<Page> getLeftmostPages(int left) {
        ArrayList<Page> leftmostPages = new ArrayList<Page>();
        int scrollPosition = this.scrollPane.getHorizontalModel().getValue();
        int pagePosition = 0;
        for (Page p : this.pages) {
            if ((pagePosition += p.getJComponent().getWidth()) < scrollPosition || pagePosition - p.getJComponent().getWidth() - scrollPosition > left - 10) continue;
            leftmostPages.add(p);
        }
        return leftmostPages;
    }

    public Iterable<RenderableBlock> getBlocks() {
        ArrayList<RenderableBlock> allPageBlocks = new ArrayList<RenderableBlock>();
        for (Page p : this.pages) {
            allPageBlocks.addAll((Collection<RenderableBlock>)p.getBlocks());
        }
        return allPageBlocks;
    }

    public void arrangeAllBlocks() {
        for (Page page : this.pages) {
            page.reformBlockOrdering();
        }
    }

    public Iterable<RenderableBlock> getTopLevelBlocks() {
        return null;
    }

    public void scrollToShowBlock(RenderableBlock block) {
    }

    public void scrollToComponent(JComponent c) {
    }

    public int numOfPages() {
        return this.pages.size();
    }

    public boolean hasPageAt(int position) {
        return position >= 0 && position < this.pages.size();
    }

    public Page getPageAt(int position) {
        if (this.hasPageAt(position)) {
            return this.pages.get(position);
        }
        return null;
    }

    public Page getPageNamed(String name) {
        for (Page p : this.pages) {
            if (!p.getPageName().equals(name)) continue;
            return p;
        }
        return null;
    }

    public List<Page> getPages() {
        return new ArrayList<Page>(this.pages);
    }

    public void addPage(Page page) {
        this.addPage(page, this.pages.size());
    }

    public void addPage(Page page, int position) {
        if (page == null) {
            throw new RuntimeException("Invariant Violated: May not add null Pages");
        }
        if (position < 0 || position > this.pages.size()) {
            System.out.println(position + ", " + this.pages.size());
            throw new RuntimeException("Invariant Violated: Specified position out of bounds");
        }
        this.pages.add(position, page);
        this.canvas.add((Component)page.getJComponent(), 0);
        PageDivider pd = new PageDivider(this.workspace, page);
        this.dividers.add(pd);
        this.canvas.add((Component)pd, 0);
        PageChangeEventManager.notifyListeners();
    }

    public Page removePage(Page page) {
        if (page != null) {
            page.clearPage();
            this.pages.remove(page);
            for (PageDivider div : this.dividers) {
                if (div.getLeftPage() != page) continue;
                this.dividers.remove(div);
                this.canvas.remove(div);
                break;
            }
            this.canvas.remove(page.getJComponent());
            this.canvas.revalidate();
            this.canvas.repaint();
            PageChangeEventManager.notifyListeners();
        }
        return page;
    }

    public Page removePage(int position) {
        if (this.hasPageAt(position)) {
            return this.removePage(this.pages.get(position));
        }
        return null;
    }

    public void switchViewToPage(Page page) {
        this.scrollPane.getHorizontalModel().setValue(page.getJComponent().getX());
    }

    public Page renamePage(String oldName, String newName) {
        for (Page page : this.pages) {
            if (!page.getPageName().equals(oldName)) continue;
            page.setPageName(newName);
            this.update();
            return page;
        }
        return null;
    }

    @Override
    public void update() {
        this.reformBlockCanvas();
    }

    public void reformBlockCanvas() {
        int widthCounter = 0;
        for (int i = 0; i < this.pages.size(); ++i) {
            Page p = this.pages.get(i);
            if (p.getDefaultPageColor() == null) {
                if (i % 2 == 1) {
                    p.setPageColor(new Color(30, 30, 30));
                } else {
                    p.setPageColor(new Color(40, 40, 40));
                }
            } else {
                p.setPageColor(p.getDefaultPageColor());
            }
            widthCounter += p.reformBounds(widthCounter);
        }
        for (PageDivider d : this.dividers) {
            d.setBounds(d.getLeftPage().getJComponent().getX() + d.getLeftPage().getJComponent().getWidth() - 3, 0, 5, d.getLeftPage().getJComponent().getHeight());
        }
        this.canvas.setPreferredSize(new Dimension(widthCounter, (int)(3000.0 * Page.getZoomLevel())));
        this.scrollPane.revalidate();
        this.scrollPane.repaint();
    }

    public Node getSaveNode(Document document) {
        if (this.pages.size() > 0) {
            Element pageElement = document.createElement("Pages");
            if (Workspace.everyPageHasDrawer) {
                pageElement.setAttribute("drawer-with-page", "yes");
            }
            pageElement.setAttribute("collapsible-pages", this.collapsible ? "yes" : "no");
            for (Page page : this.pages) {
                Node pageNode = page.getSaveNode(document);
                pageElement.appendChild(pageNode);
            }
            return pageElement;
        }
        return null;
    }

    protected void loadSaveString(Element root) {
        int screenWidth;
        int canvasWidth;
        Node pagesNode;
        PageDrawerLoadingUtils.loadPagesAndDrawers(this.workspace, root, this.workspace.getFactoryManager());
        NodeList pagesRoot = root.getElementsByTagName("Pages");
        if (pagesRoot != null && pagesRoot.getLength() > 0 && (pagesNode = pagesRoot.item(0)) != null) {
            this.collapsible = PageDrawerLoadingUtils.getBooleanValue(pagesNode, "collapsible-pages");
        }
        if (!GraphicsEnvironment.isHeadless() && (canvasWidth = this.canvas.getPreferredSize().width) < (screenWidth = Toolkit.getDefaultToolkit().getScreenSize().width)) {
            Page p = this.pages.get(this.pages.size() - 1);
            p.addPixelWidth(screenWidth - canvasWidth);
            PageChangeEventManager.notifyListeners();
        }
    }

    @Override
    public Object getState() {
        HashMap<String, Object> pageStates = new HashMap<String, Object>();
        for (Page page : this.pages) {
            pageStates.put(page.getPageName(), page.getState());
        }
        return pageStates;
    }

    @Override
    public void loadState(Object memento) {
        assert (memento instanceof HashMap) : "ISupportMemento contract violated in BlockCanvas";
        if (memento instanceof HashMap) {
            String existingPageName;
            HashMap pageStates = (HashMap)memento;
            LinkedList<String> unloadedPages = new LinkedList<String>();
            LinkedList<String> loadedPages = new LinkedList<String>();
            for (String name : pageStates.keySet()) {
                unloadedPages.add(name);
            }
            for (Page existingPage : this.pages) {
                existingPageName = existingPage.getPageName();
                if (!pageStates.containsKey(existingPageName)) continue;
                existingPage.loadState(pageStates.get(existingPageName));
                unloadedPages.remove(existingPageName);
                loadedPages.add(existingPageName);
            }
            for (Page existingPage : this.pages) {
                existingPageName = existingPage.getPageName();
                if (loadedPages.contains(existingPageName)) continue;
                this.pages.remove(existingPage);
            }
            for (String newPageName : unloadedPages) {
                Page newPage = new Page(this.workspace, newPageName);
                newPage.loadState(pageStates.get(newPageName));
                this.pages.add(newPage);
            }
        }
    }

    public class Canvas
    extends JLayeredPane
    implements MouseListener,
    MouseMotionListener {
        private static final long serialVersionUID = 438974092314L;
        private Point p = null;

        public Canvas() {
            this.addMouseListener(this);
            this.addMouseMotionListener(this);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.p = e.getPoint();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e) || e.isControlDown()) {
                PopupMenu popup = ContextMenu.getContextMenuFor(BlockCanvas.this);
                this.add(popup);
                popup.show(this, e.getX(), e.getY());
            }
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            if (this.p != null) {
                BoundedRangeModel hModel = BlockCanvas.this.scrollPane.getHorizontalModel();
                BoundedRangeModel vModel = BlockCanvas.this.scrollPane.getVerticalModel();
                hModel.setValue(hModel.getValue() + (this.p.x - e.getX()));
                vModel.setValue(vModel.getValue() + (this.p.y - e.getY()));
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.p = null;
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }
}

