/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CButton;
import edu.mit.blocks.codeblockutil.CHoverScrollPane;
import edu.mit.blocks.codeblockutil.CScrollPane;
import edu.mit.blocks.codeblockutil.CTabButton;
import edu.mit.blocks.codeblockutil.Canvas;
import edu.mit.blocks.codeblockutil.TabbedExplorer;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JMenuItem;

public class TabCard
implements PropertyChangeListener {
    private int index;
    private Canvas canvas;
    private TabbedExplorer explorer;
    private JComponent scroll;
    private CButton button;
    private JMenuItem menuItem;

    TabCard(int i, Canvas canvas, TabbedExplorer ex, boolean scrollable) {
        this.index = i;
        this.canvas = canvas;
        this.explorer = ex;
        this.scroll = scrollable ? new CHoverScrollPane(canvas.getJComponent(), CScrollPane.ScrollPolicy.VERTICAL_BAR_AS_NEEDED, CScrollPane.ScrollPolicy.HORIZONTAL_BAR_AS_NEEDED, 18, canvas.getColor(), Color.darkGray) : canvas.getJComponent();
        this.button = new CTabButton(canvas.getName());
        this.menuItem = new JMenuItem(this.button.getText());
        this.button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabCard.this.explorer.selectCanvas(TabCard.this.index);
            }
        });
        this.menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabCard.this.explorer.selectCanvas(TabCard.this.index);
                TabCard.this.explorer.scrollToWheelItem(TabCard.this.index);
            }
        });
        canvas.getJComponent().addPropertyChangeListener(this);
    }

    Canvas getCanvas() {
        return this.canvas;
    }

    JComponent getScroll() {
        return this.scroll;
    }

    CButton getButton() {
        return this.button;
    }

    JMenuItem getMenuItem() {
        return this.menuItem;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName().equals("label_change_property")) {
            this.button.setText(this.canvas.getName());
            this.menuItem.setText(this.canvas.getName());
        }
    }
}

