/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblocks;

import edu.mit.blocks.codeblocks.BlockConnector;
import edu.mit.blocks.codeblocks.BlockGenus;
import edu.mit.blocks.codeblocks.BlockStub;
import edu.mit.blocks.renderable.BlockImageIcon;
import edu.mit.blocks.workspace.ISupportMemento;
import edu.mit.blocks.workspace.Workspace;
import edu.mit.blocks.workspace.WorkspaceEnvironment;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Block
implements ISupportMemento {
    public static final Long NULL = -1L;
    private final Long blockID;
    private String label;
    private String pageLabel = null;
    private String genusName;
    private List<BlockConnector> sockets;
    private BlockConnector plug;
    private BlockConnector before;
    private BlockConnector after;
    private List<List<BlockConnector>> expandGroups;
    private boolean linkToStubs = true;
    private boolean isBad = false;
    private String badMsg;
    private boolean hasFocus = false;
    private HashMap<String, String> properties = new HashMap();
    private ArrayList<String> argumentDescriptions;
    protected final Workspace workspace;
    private final WorkspaceEnvironment env;

    protected Block(Workspace workspace, Long id, String genusName, String label, boolean linkToStubs) {
        this.workspace = workspace;
        this.env = workspace.getEnv();
        this.blockID = id;
        this.genusName = genusName;
        this.label = label;
        workspace.getEnv().addBlock(this);
        this.sockets = new ArrayList<BlockConnector>();
        this.argumentDescriptions = new ArrayList();
        BlockGenus genus = this.env.getGenusWithName(genusName);
        if (genus == null) {
            throw new RuntimeException("genusName: " + genusName + " does not exist.");
        }
        for (BlockConnector con : genus.getInitSockets()) {
            this.sockets.add(new BlockConnector(con));
        }
        if (genus.getInitPlug() != null) {
            this.plug = new BlockConnector(genus.getInitPlug());
        }
        if (genus.getInitBefore() != null) {
            this.before = new BlockConnector(genus.getInitBefore());
        }
        if (genus.getInitAfter() != null) {
            this.after = new BlockConnector(genus.getInitAfter());
        }
        for (String arg : genus.getInitialArgumentDescriptions()) {
            this.argumentDescriptions.add(arg.trim());
        }
        this.expandGroups = new ArrayList<List<BlockConnector>>(genus.getExpandGroups());
        if (linkToStubs && this.hasStubs()) {
            BlockStub.putNewParentInStubMap(workspace, this.blockID);
        }
    }

    public Block(Workspace workspace, String genusName, String label, boolean linkToStubs) {
        this(workspace, workspace.getEnv().getNextBlockID(), genusName, label, linkToStubs);
    }

    public Block(Workspace workspace, String genusName, String label) {
        this(workspace, workspace.getEnv().getNextBlockID(), genusName, label, true);
    }

    public Block(Workspace workspace, String genusName) {
        this(workspace, genusName, workspace.getEnv().getGenusWithName(genusName).getInitialLabel());
    }

    public Block(Workspace workspace, String genusName, boolean linkToStubs) {
        this(workspace, genusName, workspace.getEnv().getGenusWithName(genusName).getInitialLabel(), linkToStubs);
    }

    public Workspace getWorkspace() {
        return this.workspace;
    }

    public Long getBlockID() {
        return this.blockID;
    }

    public boolean setProperty(String property, String value) {
        if (this.getGenus().getProperty(property) != null) {
            return false;
        }
        this.properties.put(property, value);
        return true;
    }

    public String getBlockLabel() {
        return this.getGenus().getLabelPrefix() + this.label + this.getGenus().getLabelSuffix();
    }

    public boolean hasPageLabel() {
        return this.pageLabel != null && !this.pageLabel.equals("");
    }

    public String getPageLabel() {
        return this.pageLabel;
    }

    public void setBlockLabel(String newLabel) {
        if (this.linkToStubs && this.hasStubs()) {
            BlockStub.parentNameChanged(this.workspace, this.label, newLabel, this.blockID);
        }
        this.label = newLabel;
    }

    public void setPageLabel(String newPageLabel) {
        if (this.linkToStubs && this.hasStubs()) {
            BlockStub.parentPageLabelChanged(this.workspace, newPageLabel, this.blockID);
        }
        this.pageLabel = newPageLabel;
    }

    private BlockGenus getGenus() {
        return this.env.getGenusWithName(this.genusName);
    }

    public void changeGenusTo(String genusName) {
        this.genusName = genusName;
        this.label = this.env.getGenusWithName(genusName).getInitialLabel();
    }

    public Long getBeforeBlockID() {
        if (this.before == null) {
            return NULL;
        }
        return this.before.getBlockID();
    }

    public Long getAfterBlockID() {
        if (this.after == null) {
            return NULL;
        }
        return this.after.getBlockID();
    }

    public BlockConnector getAfterConnector() {
        return this.after;
    }

    public BlockConnector getBeforeConnector() {
        return this.before;
    }

    void resetBeforeAndAfter() {
        this.before = new BlockConnector(this.getGenus().getInitBefore());
        this.after = new BlockConnector(this.getGenus().getInitAfter());
    }

    void removeBeforeAndAfter() {
        this.before = null;
        this.after = null;
    }

    private static List<BlockConnector> getExpandGroup(List<List<BlockConnector>> groups, String group) {
        for (List<BlockConnector> list : groups) {
            if (!list.get(0).getExpandGroup().equals(group)) continue;
            return list;
        }
        return null;
    }

    private void expandSocketGroup(String group) {
        BlockConnector conn;
        int index;
        List<BlockConnector> expandSockets = Block.getExpandGroup(this.expandGroups, group);
        assert (expandSockets != null);
        String label = expandSockets.get(expandSockets.size() - 1).getLabel();
        for (index = this.sockets.size() - 1; !(index < 0 || (conn = this.sockets.get(index)).getLabel().equals(label) && conn.getExpandGroup().equals(group)); --index) {
        }
        assert (index >= 0);
        for (BlockConnector conn2 : expandSockets) {
            BlockConnector newConn = new BlockConnector(conn2);
            this.sockets.add(++index, newConn);
        }
    }

    private void shrinkSocketGroup(BlockConnector socket) {
        BlockConnector con;
        int index;
        String group = socket.getExpandGroup();
        List<BlockConnector> expandSockets = Block.getExpandGroup(this.expandGroups, group);
        assert (expandSockets != null);
        String label = expandSockets.get(0).getLabel();
        for (index = this.getSocketIndex(socket); !(index < 0 || (con = this.sockets.get(index)).getLabel().equals(label) && con.getExpandGroup().equals(group)); --index) {
        }
        assert (index >= 0);
        this.removeSocket(index);
        int total = expandSockets.size();
        int i = 1;
        while (i < total) {
            BlockConnector con2 = this.sockets.get(index);
            if (con2.getLabel().equals(expandSockets.get(i).getLabel()) && con2.getExpandGroup().equals(group)) {
                this.removeSocket(index);
                ++i;
                continue;
            }
            ++index;
        }
    }

    private boolean canRemoveSocket(BlockConnector socket) {
        int total = this.sockets.size();
        int first = -1;
        for (int i = 0; i < total; ++i) {
            BlockConnector conn = this.sockets.get(i);
            if (conn == socket) {
                if (first == -1) {
                    first = i;
                    continue;
                }
                return true;
            }
            if (!conn.getPositionType().equals((Object)socket.getPositionType()) || conn.isExpandable() != socket.isExpandable() || !conn.initKind().equals(socket.initKind()) || !conn.getExpandGroup().equals(socket.getExpandGroup())) continue;
            if (first == -1) {
                first = i;
                continue;
            }
            return true;
        }
        return false;
    }

    public void blockConnected(BlockConnector connectedSocket, Long connectedBlockID) {
        if (connectedSocket.isExpandable()) {
            if (connectedSocket.getExpandGroup().length() > 0) {
                this.expandSocketGroup(connectedSocket.getExpandGroup());
            } else {
                int index = this.getSocketIndex(connectedSocket);
                if (this.isProcedureDeclBlock()) {
                    this.addSocket(index + 1, connectedSocket.initKind(), connectedSocket.getPositionType(), "", connectedSocket.isLabelEditable(), connectedSocket.isExpandable(), NULL);
                } else {
                    this.addSocket(index + 1, connectedSocket.initKind(), connectedSocket.getPositionType(), connectedSocket.getLabel(), connectedSocket.isLabelEditable(), connectedSocket.isExpandable(), NULL);
                }
            }
        }
        if (this.hasStubs()) {
            BlockStub.parentConnectorsChanged(this.workspace, this.getBlockID());
        }
    }

    public void blockDisconnected(BlockConnector disconnectedSocket) {
        if (disconnectedSocket.isExpandable() && this.canRemoveSocket(disconnectedSocket)) {
            if (disconnectedSocket.getExpandGroup().length() > 0) {
                this.shrinkSocketGroup(disconnectedSocket);
            } else {
                this.removeSocket(disconnectedSocket);
            }
        }
        if (this.hasStubs()) {
            BlockStub.parentConnectorsChanged(this.workspace, this.blockID);
        }
    }

    public Iterable<BlockConnector> getSockets() {
        return Collections.unmodifiableList(new ArrayList<BlockConnector>(this.sockets));
    }

    public int getNumSockets() {
        return this.sockets.size();
    }

    public BlockConnector getSocketAt(int index) {
        assert (index < this.sockets.size()) : "Index " + index + " is greater than the num of sockets: " + this.sockets.size() + " of " + this;
        return this.sockets.get(index);
    }

    public boolean setSocketAt(int index, String kind, BlockConnector.PositionType pos, String label, boolean isLabelEditable, boolean isExpandable, Long blockID) {
        return this.sockets.set(index, new BlockConnector(this.workspace, kind, pos, label, isLabelEditable, isExpandable, blockID)) != null;
    }

    public int getSocketIndex(BlockConnector socket) {
        for (int i = 0; i < this.sockets.size(); ++i) {
            BlockConnector currentSocket = this.sockets.get(i);
            if (currentSocket != socket) continue;
            return i;
        }
        return -1;
    }

    public void addSocket(String kind, BlockConnector.PositionType positionType, String label, boolean isLabelEditable, boolean isExpandable, Long blockID) {
        BlockConnector newSocket = new BlockConnector(this.workspace, kind, positionType, label, isLabelEditable, isExpandable, blockID);
        this.sockets.add(newSocket);
    }

    public BlockConnector addSocket(int index, String kind, BlockConnector.PositionType positionType, String label, boolean isLabelEditable, boolean isExpandable, Long blockID) {
        BlockConnector newSocket = new BlockConnector(this.workspace, kind, positionType, label, isLabelEditable, isExpandable, blockID);
        this.sockets.add(index, newSocket);
        return newSocket;
    }

    public void removeSocket(int index) {
        this.removeSocket(this.sockets.get(index));
    }

    public void removeSocket(BlockConnector socket) {
        if (socket.getBlockID() != NULL) {
            Block connectedBlock = this.workspace.getEnv().getBlock(socket.getBlockID());
            connectedBlock.getConnectorTo(this.blockID).setConnectorBlockID(NULL);
            socket.setConnectorBlockID(NULL);
            this.workspace.getEnv().getRenderableBlock(this.blockID).blockDisconnected(socket);
        }
        this.sockets.remove(socket);
    }

    public boolean hasPlug() {
        return this.plug != null;
    }

    public BlockConnector getPlug() {
        return this.plug;
    }

    public void setPlug(String kind, BlockConnector.PositionType positionType, String label, boolean isLabelEditable, Long blockID) {
        this.plug = new BlockConnector(this.workspace, kind, positionType, label, isLabelEditable, false, blockID);
    }

    public void setPlugKind(String kind) {
        assert (this.plug != null) : "Plug is null!  Can not set this information.";
        if (this.hasPlug()) {
            this.plug.setKind(kind);
        }
    }

    public void setPlugLabel(String label) {
        assert (this.plug != null) : "Plug is null!  Can not set this information.";
        if (this.hasPlug()) {
            this.plug.setLabel(label);
        }
    }

    public void setPlugBlockID(Long id) {
        assert (this.plug != null) : "Plug is null!  Can not set this information.";
        if (this.hasPlug()) {
            this.plug.setConnectorBlockID(id);
        }
    }

    public String getPlugKind() {
        if (this.hasPlug()) {
            return this.plug.getKind();
        }
        return null;
    }

    public String getPlugLabel() {
        if (this.hasPlug()) {
            return this.plug.getLabel();
        }
        return null;
    }

    public Long getPlugBlockID() {
        if (this.plug == null) {
            return NULL;
        }
        return this.plug.getBlockID();
    }

    void removePlug() {
        this.plug = null;
    }

    public BlockConnector getConnectorTo(Long otherBlockID) {
        if (otherBlockID == null || otherBlockID == NULL) {
            return null;
        }
        if (this.getPlugBlockID().equals(otherBlockID)) {
            return this.plug;
        }
        if (this.getBeforeBlockID().equals(otherBlockID)) {
            return this.before;
        }
        if (this.getAfterBlockID().equals(otherBlockID)) {
            return this.after;
        }
        for (BlockConnector socket : this.getSockets()) {
            if (!socket.getBlockID().equals(otherBlockID)) continue;
            return socket;
        }
        return null;
    }

    public boolean isBad() {
        return this.isBad;
    }

    public void setBad(boolean isBad) {
        this.isBad = isBad;
    }

    public String getBadMsg() {
        return this.badMsg;
    }

    public void setBadMsg(String badMsg) {
        this.badMsg = badMsg;
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    public void setFocus(boolean hasFocus) {
        this.hasFocus = hasFocus;
    }

    public Iterable<Long> linkAllDefaultArgs() {
        if (this.getGenus().hasDefaultArgs()) {
            ArrayList<Long> defargIDs = new ArrayList<Long>();
            for (BlockConnector con : this.sockets) {
                Long id = con.linkDefArgument();
                defargIDs.add(id);
                if (id == NULL) continue;
                this.workspace.getEnv().getBlock(id).getPlug().setConnectorBlockID(this.blockID);
            }
            return defargIDs;
        }
        return null;
    }

    public Iterable<BlockStub> getFreshStubs() {
        if (this.linkToStubs && this.hasStubs()) {
            ArrayList<BlockStub> newStubBlocks = new ArrayList<BlockStub>();
            for (String stubGenus : this.getStubList()) {
                newStubBlocks.add(new BlockStub(this.workspace, this.getBlockID(), this.getGenusName(), this.getBlockLabel(), stubGenus));
            }
            return newStubBlocks;
        }
        return null;
    }

    public void notifyRenderable() {
        this.workspace.getEnv().getRenderableBlock(this.blockID).repaintBlock();
    }

    public List<String> getSiblingsList() {
        return this.getGenus().getSiblingsList();
    }

    public boolean hasSiblings() {
        return this.getGenus().hasSiblings();
    }

    public Iterable<String> getStubList() {
        if (this.linkToStubs) {
            return this.getGenus().getStubList();
        }
        return new ArrayList<String>();
    }

    public boolean hasStubs() {
        return this.linkToStubs && this.getGenus().hasStubs();
    }

    public boolean hasDefaultArgs() {
        return this.getGenus().hasDefaultArgs();
    }

    public boolean isCommandBlock() {
        return this.getGenus().isCommandBlock();
    }

    public boolean isDataBlock() {
        return this.getGenus().isDataBlock();
    }

    public boolean isFunctionBlock() {
        return this.getGenus().isFunctionBlock();
    }

    public boolean isVariableDeclBlock() {
        return this.getGenus().isVariableDeclBlock();
    }

    public boolean isProcedureDeclBlock() {
        return this.getGenus().isProcedureDeclBlock();
    }

    public boolean isDeclaration() {
        return this.getGenus().isDeclaration();
    }

    public boolean isProcedureParamBlock() {
        return this.getGenus().isProcedureParamBlock();
    }

    public boolean isListRelated() {
        return this.getGenus().isListRelated();
    }

    public boolean hasBeforeConnector() {
        return this.before != null;
    }

    public boolean hasAfterConnector() {
        return this.after != null;
    }

    public BlockConnector getInitBefore() {
        return this.getGenus().getInitBefore();
    }

    public BlockConnector getInitAfter() {
        return this.getGenus().getInitAfter();
    }

    public boolean isLabelValue() {
        return this.getGenus().isLabelValue();
    }

    public boolean isLabelEditable() {
        return this.getGenus().isLabelEditable();
    }

    public boolean isPageLabelSetByPage() {
        return this.getGenus().isPageLabelSetByPage();
    }

    public boolean labelMustBeUnique() {
        return this.getGenus().labelMustBeUnique();
    }

    public boolean isInfix() {
        return this.getGenus().isInfix();
    }

    public boolean areSocketsExpandable() {
        return this.getGenus().areSocketsExpandable();
    }

    public String getGenusName() {
        return this.genusName;
    }

    public String getInitialLabel() {
        return this.getGenus().getInitialLabel();
    }

    public String getLabelPrefix() {
        return this.getGenus().getLabelPrefix();
    }

    public String getLabelSuffix() {
        return this.getGenus().getLabelSuffix();
    }

    public String getBlockDescription() {
        return this.getGenus().getBlockDescription();
    }

    public String getArgumentDescription(int index) {
        if (index < this.argumentDescriptions.size() && index >= 0) {
            return this.argumentDescriptions.get(index);
        }
        return null;
    }

    public Color getColor() {
        return this.getGenus().getColor();
    }

    public Map<BlockImageIcon.ImageLocation, BlockImageIcon> getInitBlockImageMap() {
        return this.getGenus().getInitBlockImageMap();
    }

    public String getProperty(String property) {
        String prop = this.properties.get(property);
        if (prop != null) {
            return prop;
        }
        return this.getGenus().getProperty(property);
    }

    public Iterable<BlockConnector> getInitSockets() {
        return this.getGenus().getInitSockets();
    }

    public BlockConnector getInitPlug() {
        return this.getGenus().getInitPlug();
    }

    public String toString() {
        return "Block " + this.blockID + ": " + this.label + " with sockets: " + this.sockets + " and plug: " + this.plug + " before: " + this.before + " after: " + this.after;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Block)) {
            return false;
        }
        Block otherBlock = (Block)other;
        return this.blockID == otherBlock.blockID;
    }

    public int hashCode() {
        return this.blockID.hashCode();
    }

    public Node getSaveNode(Document document, int x, int y, Node commentNode, boolean isCollapsed) {
        Element blockIdElement;
        Element blockElement = document.createElement("Block");
        blockElement.setAttribute("id", Long.toString(this.blockID));
        blockElement.setAttribute("genus-name", this.getGenusName());
        if (this.hasFocus) {
            blockElement.setAttribute("has-focus", "yes");
        }
        if (!this.label.equals(this.getInitialLabel())) {
            Element labelElement = document.createElement("Label");
            labelElement.appendChild(document.createTextNode(this.label));
            blockElement.appendChild(labelElement);
        }
        if (this.pageLabel != null && !this.pageLabel.equals("")) {
            Element pageLabelElement = document.createElement("PageLabel");
            pageLabelElement.appendChild(document.createTextNode(this.pageLabel));
            blockElement.appendChild(pageLabelElement);
        }
        if (this.isBad) {
            Element msgElement = document.createElement("CompilerErrorMsg");
            msgElement.appendChild(document.createTextNode(this.badMsg));
            blockElement.appendChild(msgElement);
        }
        Element locationElement = document.createElement("Location");
        Element xElement = document.createElement("X");
        xElement.appendChild(document.createTextNode(String.valueOf(x)));
        locationElement.appendChild(xElement);
        Element yElement = document.createElement("Y");
        yElement.appendChild(document.createTextNode(String.valueOf(y)));
        locationElement.appendChild(yElement);
        blockElement.appendChild(locationElement);
        if (isCollapsed) {
            Element collapsedElement = document.createElement("Collapsed");
            blockElement.appendChild(collapsedElement);
        }
        if (commentNode != null) {
            blockElement.appendChild(commentNode);
        }
        if (this.hasBeforeConnector() && !this.getBeforeBlockID().equals(NULL)) {
            blockIdElement = document.createElement("BeforeBlockId");
            blockIdElement.appendChild(document.createTextNode(String.valueOf(this.getBeforeBlockID())));
            blockElement.appendChild(blockIdElement);
        }
        if (this.hasAfterConnector() && !this.getAfterBlockID().equals(NULL)) {
            blockIdElement = document.createElement("AfterBlockId");
            blockIdElement.appendChild(document.createTextNode(String.valueOf(this.getAfterBlockID())));
            blockElement.appendChild(blockIdElement);
        }
        if (this.plug != null) {
            Element plugElement = document.createElement("Plug");
            Node blockConnectorNode = this.plug.getSaveNode(document, "plug");
            plugElement.appendChild(blockConnectorNode);
            blockElement.appendChild(plugElement);
        }
        if (this.sockets.size() > 0) {
            Element socketsElement = document.createElement("Sockets");
            socketsElement.setAttribute("num-sockets", String.valueOf(this.getNumSockets()));
            for (BlockConnector blockConnector : this.getSockets()) {
                Node blockConnectorNode = blockConnector.getSaveNode(document, "socket");
                socketsElement.appendChild(blockConnectorNode);
            }
            blockElement.appendChild(socketsElement);
        }
        if (!this.properties.isEmpty()) {
            Element propertiesElement = document.createElement("LangSpecProperties");
            for (Map.Entry entry : this.properties.entrySet()) {
                Element propertyElement = document.createElement("LangSpecProperty");
                propertyElement.setAttribute("key", (String)entry.getKey());
                propertyElement.setAttribute("value", (String)entry.getValue());
                propertiesElement.appendChild(propertyElement);
            }
            blockElement.appendChild(propertiesElement);
        }
        return blockElement;
    }

    public static Block loadBlockFrom(Workspace workspace, Node node, HashMap<Long, Long> idMapping) {
        Block block = null;
        Long id = null;
        String genusName = null;
        String label = null;
        String pagelabel = null;
        String badMsg = null;
        Long beforeID = null;
        Long afterID = null;
        BlockConnector plug = null;
        ArrayList<BlockConnector> sockets = new ArrayList<BlockConnector>();
        HashMap<String, String> blockLangProperties = null;
        boolean hasFocus = false;
        boolean isStubBlock = false;
        String stubParentName = null;
        String stubParentGenus = null;
        Pattern attrExtractor = Pattern.compile("\"(.*)\"");
        if (node.getNodeName().equals("BlockStub")) {
            isStubBlock = true;
            Node blockNode = null;
            NodeList stubChildren = node.getChildNodes();
            for (int j = 0; j < stubChildren.getLength(); ++j) {
                Node infoNode = stubChildren.item(j);
                if (infoNode.getNodeName().equals("StubParentName")) {
                    stubParentName = infoNode.getTextContent();
                    continue;
                }
                if (infoNode.getNodeName().equals("StubParentGenus")) {
                    stubParentGenus = infoNode.getTextContent();
                    continue;
                }
                if (!infoNode.getNodeName().equals("Block")) continue;
                blockNode = infoNode;
            }
            node = blockNode;
        }
        if (node.getNodeName().equals("Block")) {
            Node opt_item;
            Matcher nameMatcher = attrExtractor.matcher(node.getAttributes().getNamedItem("id").toString());
            if (nameMatcher.find()) {
                id = Block.translateLong(workspace, Long.parseLong(nameMatcher.group(1)), idMapping);
            }
            if ((nameMatcher = attrExtractor.matcher(node.getAttributes().getNamedItem("genus-name").toString())).find()) {
                genusName = nameMatcher.group(1);
            }
            if ((opt_item = node.getAttributes().getNamedItem("has-focus")) != null && (nameMatcher = attrExtractor.matcher(opt_item.toString())).find()) {
                hasFocus = nameMatcher.group(1).equals("yes");
            }
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeName().equals("Label")) {
                    label = child.getTextContent();
                    continue;
                }
                if (child.getNodeName().equals("PageLabel")) {
                    pagelabel = child.getTextContent();
                    continue;
                }
                if (child.getNodeName().equals("CompilerErrorMsg")) {
                    badMsg = child.getTextContent();
                    continue;
                }
                if (child.getNodeName().equals("BeforeBlockId")) {
                    beforeID = Block.translateLong(workspace, Long.parseLong(child.getTextContent()), idMapping);
                    continue;
                }
                if (child.getNodeName().equals("AfterBlockId")) {
                    afterID = Block.translateLong(workspace, Long.parseLong(child.getTextContent()), idMapping);
                    continue;
                }
                if (child.getNodeName().equals("Plug")) {
                    NodeList plugs = child.getChildNodes();
                    for (int j = 0; j < plugs.getLength(); ++j) {
                        Node plugNode = plugs.item(j);
                        if (!plugNode.getNodeName().equals("BlockConnector")) continue;
                        plug = BlockConnector.loadBlockConnector(workspace, plugNode, idMapping);
                    }
                    continue;
                }
                if (child.getNodeName().equals("Sockets")) {
                    NodeList socketNodes = child.getChildNodes();
                    for (int k = 0; k < socketNodes.getLength(); ++k) {
                        Node socketNode = socketNodes.item(k);
                        if (!socketNode.getNodeName().equals("BlockConnector")) continue;
                        sockets.add(BlockConnector.loadBlockConnector(workspace, socketNode, idMapping));
                    }
                    continue;
                }
                if (!child.getNodeName().equals("LangSpecProperties")) continue;
                blockLangProperties = new HashMap<String, String>();
                NodeList propertyNodes = child.getChildNodes();
                String key = null;
                String value = null;
                for (int m = 0; m < propertyNodes.getLength(); ++m) {
                    Node propertyNode = propertyNodes.item(m);
                    if (!propertyNode.getNodeName().equals("LangSpecProperty")) continue;
                    nameMatcher = attrExtractor.matcher(propertyNode.getAttributes().getNamedItem("key").toString());
                    if (nameMatcher.find()) {
                        key = nameMatcher.group(1);
                    }
                    if ((opt_item = propertyNode.getAttributes().getNamedItem("value")) != null) {
                        nameMatcher = attrExtractor.matcher(opt_item.toString());
                        if (nameMatcher.find()) {
                            value = nameMatcher.group(1);
                        }
                    } else {
                        value = propertyNode.getTextContent();
                    }
                    if (key == null || value == null) continue;
                    blockLangProperties.put(key, value);
                    key = null;
                    value = null;
                }
            }
            assert (genusName != null && id != null) : "Block did not contain required info id: " + id + " genus: " + genusName;
            if (!isStubBlock) {
                block = label == null ? new Block(workspace, id, genusName, workspace.getEnv().getGenusWithName(genusName).getInitialLabel(), true) : new Block(workspace, id, genusName, label, true);
            } else {
                assert (label != null) : "Loading a block stub, but has a null label!";
                block = new BlockStub(workspace, id, genusName, label, stubParentName, stubParentGenus);
            }
            if (plug != null) {
                assert (beforeID == null && afterID == null);
                block.plug = plug;
                block.removeBeforeAndAfter();
            }
            if (sockets.size() > 0) {
                block.sockets = sockets;
            }
            if (beforeID != null) {
                block.before.setConnectorBlockID(beforeID);
            }
            if (afterID != null) {
                block.after.setConnectorBlockID(afterID);
            }
            if (pagelabel != null) {
                block.pageLabel = pagelabel;
            }
            if (badMsg != null) {
                block.isBad = true;
                block.badMsg = badMsg;
            }
            block.hasFocus = hasFocus;
            if (blockLangProperties != null && !blockLangProperties.isEmpty()) {
                block.properties = blockLangProperties;
            }
            return block;
        }
        return null;
    }

    public static Long translateLong(Workspace workspace, Long input, HashMap<Long, Long> mapping) {
        if (mapping == null) {
            return input;
        }
        if (mapping.containsKey(input)) {
            return mapping.get(input);
        }
        Long newID = workspace.getEnv().getNextBlockID();
        mapping.put(input, newID);
        return newID;
    }

    @Override
    public Object getState() {
        BlockState state = new BlockState();
        state.label = this.label;
        state.pageLabel = this.getPageLabel();
        state.isBad = this.isBad();
        state.badMsg = this.getBadMsg();
        state.hasFocus = this.hasFocus();
        state.properties = new HashMap();
        for (String name : this.properties.keySet()) {
            state.properties.put(name, this.getProperty(name));
        }
        state.genusName = this.getGenusName();
        state.plug = this.plug != null ? this.plug.getState() : null;
        state.before = this.before != null ? this.before.getState() : null;
        state.after = this.after != null ? this.after.getState() : null;
        state.numberOfSockets = this.getNumSockets();
        state.sockets = new ArrayList();
        for (BlockConnector socket : this.getSockets()) {
            state.sockets.add(socket.getState());
        }
        return state;
    }

    @Override
    public void loadState(Object memento) {
        if (memento instanceof BlockState) {
            int i;
            BlockState state = (BlockState)memento;
            this.setPageLabel(state.pageLabel);
            this.setBlockLabel(state.label);
            this.setBad(state.isBad);
            this.setBadMsg(state.badMsg);
            this.setFocus(state.hasFocus);
            for (String name : state.properties.keySet()) {
                this.setProperty(name, state.properties.get(name));
            }
            if (this.genusName != state.genusName) {
                this.changeGenusTo(state.genusName);
            }
            this.plug = state.plug == null ? null : BlockConnector.instantiateFromState(this.workspace, state.plug);
            this.before = state.before == null ? null : BlockConnector.instantiateFromState(this.workspace, state.before);
            this.after = state.after == null ? null : BlockConnector.instantiateFromState(this.workspace, state.after);
            for (i = 0; i < state.numberOfSockets; ++i) {
                if (i >= this.getNumSockets()) {
                    this.sockets.add(BlockConnector.instantiateFromState(this.workspace, state.sockets.get(i)));
                    continue;
                }
                this.sockets.get(i).loadState(state.sockets.get(i));
            }
            for (i = state.numberOfSockets; i < this.getNumSockets(); ++i) {
                this.removeSocket(i);
            }
        }
    }

    private class BlockState {
        public String label;
        public String pageLabel;
        public boolean isBad;
        public String badMsg;
        public boolean hasFocus;
        public HashMap<String, String> properties;
        public String genusName;
        public int numberOfSockets;
        public ArrayList<Object> sockets;
        public Object plug;
        public Object before;
        public Object after;

        private BlockState() {
        }
    }
}

