/*
 * Decompiled with CFR 0.152.
 */
package com.ardublock.translator.block;

import com.ardublock.translator.Translator;
import com.ardublock.translator.block.TranslatorBlock;
import com.ardublock.translator.block.exception.SocketNullException;
import com.ardublock.translator.block.exception.SubroutineNotDeclaredException;

public class ESP32_SimpleWiFiWebServerBlock
extends TranslatorBlock {
    public ESP32_SimpleWiFiWebServerBlock(Long blockId, Translator translator, String codePrefix, String codeSuffix, String label) {
        super(blockId, translator, codePrefix, codeSuffix, label);
    }

    public String toCode() throws SocketNullException, SubroutineNotDeclaredException {
        String ret = "";
        ret = " WiFiClient client = server.available();";
        TranslatorBlock tb = this.getRequiredTranslatorBlockAtSocket(0);
        String ssid = tb.toCode();
        tb = this.getRequiredTranslatorBlockAtSocket(1);
        String passphase = tb.toCode();
        this.translator.addHeaderFile("WiFi.h");
        this.translator.addDefinitionCommand(" WiFiServer server(80);");
        this.translator.addSetupCommand(" WiFi.begin(" + ssid + "," + passphase + ");");
        this.translator.addSetupCommand("");
        this.translator.addSetupCommand(" while (WiFi.status() != WL_CONNECTED) {");
        this.translator.addSetupCommand(" delay(500);");
        this.translator.addSetupCommand(" Serial.print(\".\");");
        this.translator.addSetupCommand(" }");
        this.translator.addSetupCommand(" Serial.println(\"\");");
        this.translator.addSetupCommand(" Serial.println(\"WiFi connected\");");
        this.translator.addSetupCommand(" Serial.println(\"IP address: \");");
        this.translator.addSetupCommand(" Serial.println(WiFi.localIP());");
        this.translator.addSetupCommand(" server.begin(); ");
        return ret;
    }
}

