/*
 * Decompiled with CFR 0.152.
 */
package ajd4jp;

import ajd4jp.AJD;

public class AJDRange {
    private AJD start;
    private AJD end;

    public AJDRange(AJD a, AJD b) {
        if (a.compareTo(b) < 0) {
            this.start = a;
            this.end = b;
        } else {
            this.start = b;
            this.end = a;
        }
    }

    public AJD getFrom() {
        return this.start;
    }

    public AJD getTo() {
        return this.end;
    }

    public Relationship compare(AJDRange target) {
        if (this.start.equals(target.start) && this.end.equals(target.end)) {
            return Relationship.EQUALS;
        }
        if (this.start.equals(target.start)) {
            if (this.end.compareTo(target.end) < 0) {
                return Relationship.GREATER_EQUALS;
            }
            return Relationship.LESS_INNER;
        }
        if (this.end.equals(target.end)) {
            if (this.start.compareTo(target.start) < 0) {
                return Relationship.GREATER_INNER;
            }
            return Relationship.LESS_EQUALS;
        }
        if (this.start.equals(target.end)) {
            return Relationship.LESS_BORDER;
        }
        if (this.end.equals(target.start)) {
            return Relationship.GREATER_BORDER;
        }
        if (this.start.compareTo(target.start) < 0 && target.end.compareTo(this.end) < 0) {
            return Relationship.INNER;
        }
        if (this.start.compareTo(target.start) > 0 && target.end.compareTo(this.end) > 0) {
            return Relationship.OVER;
        }
        if (this.start.compareTo(target.start) > 0) {
            if (this.start.compareTo(target.end) > 0) {
                return Relationship.LESS_OUTER;
            }
            return Relationship.LESS_OVER;
        }
        if (this.end.compareTo(target.start) < 0) {
            return Relationship.GREATER_OUTER;
        }
        return Relationship.GREATER_OVER;
    }

    public String toString() {
        return this.start.toString() + " - " + this.end.toString();
    }

    public static enum Relationship {
        LESS_OUTER(false, false, false),
        LESS_BORDER(true, false, false),
        LESS_OVER(false, true, false),
        LESS_EQUALS(false, true, true),
        EQUALS(false, true, true),
        LESS_INNER(false, true, true),
        INNER(false, true, false),
        GREATER_INNER(false, true, true),
        OVER(false, true, false),
        GREATER_EQUALS(false, true, true),
        GREATER_OVER(false, true, false),
        GREATER_BORDER(true, false, false),
        GREATER_OUTER(false, false, false);

        private boolean bd;
        private boolean ov;
        private boolean eq;

        private Relationship(boolean b, boolean o, boolean e) {
            this.bd = b;
            this.ov = o;
            this.eq = e;
        }

        public boolean isBorder() {
            return this.bd;
        }

        public boolean isOverlap() {
            return this.ov;
        }

        public boolean isEquals() {
            return this.eq;
        }
    }
}

