/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.sound;

import com.sun.j3d.audioengines.AudioEngine3DL2;
import com.sun.j3d.audioengines.Sample;
import java.util.ArrayList;
import java.util.HashMap;
import javax.media.j3d.AudioDevice;
import javax.media.j3d.AudioDevice3D;
import javax.media.j3d.AudioDevice3DL2;
import javax.media.j3d.MediaContainer;
import javax.media.j3d.PhysicalEnvironment;
import javax.media.j3d.Sound;
import javax.media.j3d.Transform3D;
import javax.media.j3d.View;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import jp.sourceforge.acerola3d.sound.JOALSample2;
import net.java.games.joal.AL;
import net.java.games.joal.ALC;
import net.java.games.joal.ALCcontext;
import net.java.games.joal.ALCdevice;
import net.java.games.joal.ALException;
import net.java.games.joal.ALFactory;

public class JOALMixer2
extends AudioEngine3DL2
implements AudioDevice,
AudioDevice3D,
AudioDevice3DL2 {
    private static boolean debug = false;
    private static boolean debugVersion = true;
    private static boolean debugView = false;
    private static boolean debugPrepareSound = true;
    private static boolean debugGetTotalChannels = false;
    private static boolean debugSampleDuration = false;
    private static boolean debugVelocity = false;
    private static boolean debugPosition = false;
    private static boolean debugDirection = false;
    private static boolean debugDistanceGain = false;
    private static boolean debugGain = false;
    private static boolean debugLoopCount = false;
    private static boolean debugMute = true;
    private static boolean debugUnmute = true;
    private static boolean debugStart = true;
    private static boolean debugStartTime = true;
    private static boolean debugStop = false;
    private static boolean debugClearSound = true;
    private boolean shareBuffer = true;
    private HashMap<Object, int[]> sharedBuffers = new HashMap();
    private boolean calculateDopplerEffect = false;
    static final int ADD_TO_LIST = 1;
    static final int SET_INTO_LIST = 2;
    static AL al;
    static ALC alc;
    private float[] singleArray = new float[1];
    private float[] tripleArray = new float[3];
    private View reference;
    private Transform3D transform = new Transform3D();
    private float[] position = new float[3];
    private float[] lastPosition = new float[3];
    private Vector3f positionVector = new Vector3f();
    private Vector3f viewVector = new Vector3f(0.0f, 0.0f, -1.0f);
    private Vector3f upVector = new Vector3f(0.0f, 1.0f, 0.0f);
    private float[] velocity = new float[]{0.0f, 0.0f, 0.0f};
    private float[] noVelocity = new float[]{0.0f, 0.0f, 0.0f};
    private float[] orientation = new float[]{0.0f, 0.0f, -1.0f, 0.0f, 1.0f, 0.0f};
    private long timeOfThisViewUpdate = -1L;
    private long timeSinceLastViewUpdate = -1L;
    private float timeSinceLastViewUpdateInSeconds = -1.0f;
    private long timeOfLastViewUpdate = -1L;

    public JOALMixer2(PhysicalEnvironment physicalEnvironment) {
        super(physicalEnvironment);
        if (debug) {
            System.out.println("JOALMixer - constructor...");
        }
    }

    public void setGain(float scaleFactor) {
        this.singleArray[0] = scaleFactor;
        al.alListenerfv(4106, this.singleArray, 0);
    }

    public void resume() {
    }

    public void pause() {
    }

    public void setView(View reference) {
        if (debug && debugView) {
            System.out.println("JOALMixer - setView...");
        }
        if (reference.getAllCanvas3Ds().hasMoreElements()) {
            reference.getUserHeadToVworld(this.transform);
            this.transform.get(this.positionVector);
            this.position[0] = this.positionVector.x;
            this.position[1] = this.positionVector.y;
            this.position[2] = this.positionVector.z;
            al.alListenerfv(4100, this.position, 0);
            if (this.timeOfLastViewUpdate == -1L) {
                this.timeOfLastViewUpdate = System.nanoTime();
                this.lastPosition[0] = this.positionVector.x;
                this.lastPosition[1] = this.positionVector.y;
                this.lastPosition[2] = this.positionVector.z;
            } else {
                this.timeOfThisViewUpdate = System.nanoTime();
                this.timeSinceLastViewUpdate = this.timeOfLastViewUpdate - this.timeOfThisViewUpdate;
                this.timeOfLastViewUpdate = this.timeOfThisViewUpdate;
                if (this.calculateDopplerEffect) {
                    this.timeSinceLastViewUpdateInSeconds = this.timeSinceLastViewUpdate / 1000000L;
                    this.velocity[0] = (this.lastPosition[0] - this.position[0]) / this.timeSinceLastViewUpdateInSeconds;
                    this.velocity[1] = (this.lastPosition[1] - this.position[1]) / this.timeSinceLastViewUpdateInSeconds;
                    this.velocity[2] = (this.lastPosition[2] - this.position[2]) / this.timeSinceLastViewUpdateInSeconds;
                    al.alListenerfv(4102, this.velocity, 0);
                    if (debug & debugVelocity) {
                        System.out.println("JOALMixer - velocity: " + this.velocity[0] + ", " + this.velocity[1] + ", " + this.velocity[2]);
                    }
                } else {
                    al.alListenerfv(4102, this.noVelocity, 0);
                }
                this.lastPosition[0] = this.positionVector.x;
                this.lastPosition[1] = this.positionVector.y;
                this.lastPosition[2] = this.positionVector.z;
            }
            this.viewVector.set(0.0f, 0.0f, -1.0f);
            this.upVector.set(0.0f, 1.0f, 0.0f);
            this.transform.transform(this.viewVector);
            this.transform.transform(this.upVector);
            this.orientation[0] = this.viewVector.x;
            this.orientation[1] = this.viewVector.y;
            this.orientation[2] = this.viewVector.z;
            this.orientation[3] = this.upVector.x;
            this.orientation[4] = this.upVector.y;
            this.orientation[5] = this.upVector.z;
            al.alListenerfv(4111, this.orientation, 0);
        }
        super.setView(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int prepareSound(int soundType, MediaContainer soundData) {
        if (debug && debugPrepareSound) {
            if (soundData.getURLObject() != null) {
                System.out.println("JOALMixer - prepareSound - " + soundData + " - " + soundData.getURLObject());
            } else if (soundData.getURLString() != null) {
                System.out.println("JOALMixer - prepareSound - " + soundData + " - " + soundData.getURLString());
            } else {
                System.out.println("JOALMixer - prepareSound - " + soundData + " - " + soundData.getInputStream());
            }
        }
        int index = -1;
        int methodType = 1;
        if (soundData == null) {
            return -1;
        }
        ArrayList arrayList = this.samples;
        synchronized (arrayList) {
            int samplesSize;
            index = samplesSize = this.samples.size();
            this.samples.ensureCapacity(index + 1);
            JOALSample2 joalSample = new JOALSample2();
            boolean error = true;
            if (this.shareBuffer) {
                if (soundData.getURLObject() != null) {
                    if (this.sharedBuffers.containsKey(soundData.getURLObject())) {
                        error = joalSample.load(al, this.sharedBuffers.get(soundData.getURLObject()), soundType);
                    } else {
                        error = joalSample.load(al, soundData, soundType);
                        this.sharedBuffers.put(soundData.getURLObject(), joalSample.getBuffer());
                    }
                } else if (soundData.getURLString() != null) {
                    if (this.sharedBuffers.containsKey(soundData.getURLString())) {
                        error = joalSample.load(al, this.sharedBuffers.get(soundData.getURLString()), soundType);
                    } else {
                        error = joalSample.load(al, soundData, soundType);
                        this.sharedBuffers.put(soundData.getURLString(), joalSample.getBuffer());
                    }
                } else if (this.sharedBuffers.containsKey(soundData.getInputStream())) {
                    error = joalSample.load(al, this.sharedBuffers.get(soundData.getInputStream()), soundType);
                } else {
                    error = joalSample.load(al, soundData, soundType);
                    this.sharedBuffers.put(soundData.getInputStream(), joalSample.getBuffer());
                }
            } else {
                error = joalSample.load(al, soundData, soundType);
            }
            if (error) {
                return -1;
            }
            if (methodType == 2) {
                this.samples.set(index, joalSample);
            } else {
                this.samples.add(index, joalSample);
            }
            if (debug) {
                System.out.println("JOALMixer - prepareSound - return: " + index);
            }
            return index;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearSound(int index) {
        if (debug && debugClearSound) {
            System.out.println("JOALMixer - clearSound " + index);
        }
        Sample sample = null;
        sample = this.getSample(index);
        if (sample == null) {
            return;
        }
        sample.clear();
        ArrayList arrayList = this.samples;
        synchronized (arrayList) {
            this.samples.set(index, null);
        }
    }

    public long getSampleDuration(int index) {
        if (debug && debugSampleDuration) {
            System.out.println("JOALMixer - getSampleDuration for " + index);
        }
        return super.getSampleDuration(index);
    }

    public int getNumberOfChannelsUsed(int index) {
        return super.getNumberOfChannelsUsed(index);
    }

    public int getNumberOfChannelsUsed(int index, boolean muteFlag) {
        return 1;
    }

    public int startSample(int index) {
        JOALSample2 s;
        if (debug & debugStart) {
            System.out.println("JOALMixer - start..." + index);
        }
        if ((s = (JOALSample2)this.getSample(index)) == null) {
            return -1;
        }
        return s.startSample();
    }

    public long getStartTime(int index) {
        if (debug && debugStartTime) {
            System.out.println("JOALMixer - getStartTime for " + index);
        }
        return -1L;
    }

    public int stopSample(int index) {
        JOALSample2 s;
        if (debug & debugStop) {
            System.out.println("JOALMixer - stopSample " + index);
        }
        if ((s = (JOALSample2)this.getSample(index)) == null) {
            return -1;
        }
        return s.stopSample();
    }

    public void setSampleGain(int index, float scaleFactor) {
        JOALSample2 s;
        if (debug & debugGain) {
            System.out.println("JOALMixer - setSampleGain for " + index + " to " + scaleFactor);
        }
        if ((s = (JOALSample2)this.getSample(index)) == null) {
            return;
        }
        s.setGain(scaleFactor);
    }

    public void setLoop(int index, int count) {
        if (debug & debugLoopCount) {
            System.out.println("JOALMixer - setLoop for " + index + " to " + count);
        }
        super.setLoop(index, count);
    }

    public void setVworldXfrm(int index, Transform3D trans) {
        if (debug) {
            System.out.println("JOALMixer - setVworldXfrm...");
        }
        super.setVworldXfrm(index, trans);
    }

    public void setPosition(int index, Point3d position) {
        if (debug & debugPosition) {
            System.out.println("JOALMixer - setPosition for " + index + " to " + position);
        }
        super.setPosition(index, position);
    }

    public void setDistanceGain(int index, double[] frontDistance, float[] frontAttenuationScaleFactor, double[] backDistance, float[] backAttenuationScaleFactor) {
        if (debug & debugDistanceGain) {
            System.out.println("JOALMixer - setDistanceGain for " + index + " with " + frontDistance + ", " + frontAttenuationScaleFactor + ", " + backDistance + ", " + backAttenuationScaleFactor);
        }
        super.setDistanceGain(index, frontDistance, frontAttenuationScaleFactor, backDistance, backAttenuationScaleFactor);
    }

    public void setDirection(int index, Vector3d direction) {
        if (debug & debugDirection) {
            System.out.println("JOALMixer - setDirection for " + index + " to " + direction);
        }
        super.setDirection(index, direction);
    }

    public void setAngularAttenuation(int index, int filterType, double[] angle, float[] attenuationScaleFactor, float[] filterCutoff) {
        if (debug) {
            System.out.println("JOALMixer - setAngularAttenuation...");
        }
        super.setAngularAttenuation(index, filterType, angle, attenuationScaleFactor, filterCutoff);
    }

    public void setRolloff(float rolloff) {
        if (debug) {
            System.out.println("JOALMixer - setRolloff...");
        }
    }

    public void setReflectionCoefficient(float coefficient) {
        if (debug) {
            System.out.println("JOALMixer - setReflectionCoefficient...");
        }
    }

    public void setReverbDelay(float reverbDelay) {
        if (debug) {
            System.out.println("JOALMixer - setReverbDelay...");
        }
    }

    public void setReverbOrder(int reverbOrder) {
        if (debug) {
            System.out.println("JOALMixer - setReverbOrder...");
        }
    }

    public void setDistanceFilter(int filterType, double[] distance, float[] dist) {
        if (debug) {
            System.out.println("JOALMixer - setDistanceFilter...");
        }
    }

    public void setFrequencyScaleFactor(float frequencyScaleFactor) {
        if (debug) {
            System.out.println("JOALMixer - setFrequencyScaleFactor to " + frequencyScaleFactor);
        }
    }

    public void setVelocityScaleFactor(float velocityScaleFactor) {
        if (debug) {
            System.out.println("JOALMixer - setVelocityScaleFactor to " + velocityScaleFactor);
        }
        super.setVelocityScaleFactor(velocityScaleFactor);
    }

    public void muteSample(int index) {
        Sample sample;
        if (debug && debugMute) {
            System.out.println("JOALMixer - muteSample " + index);
        }
        if ((sample = this.getSample(index)) != null) {
            sample.setMuteFlag(true);
        }
    }

    public void unmuteSample(int index) {
        Sample sample;
        if (debug && debugUnmute) {
            System.out.println("JOALMixer - unmuteSample for " + index);
        }
        if ((sample = this.getSample(index)) != null) {
            sample.setMuteFlag(false);
        }
    }

    public void pauseSample(int index) {
        if (debug) {
            System.out.println("JOALMixer - pauseSample for " + index);
        }
        al.alSourcePause(index);
    }

    public void unpauseSample(int index) {
        if (debug) {
            System.out.println("JOALMixer - unpauseSample for " + index);
        }
        al.alSourcePlay(index);
    }

    public void updateSample(int index) {
    }

    public boolean initialize() {
        if (debug) {
            System.out.println("JOALMixer - initialize...");
        }
        try {
            ALCcontext context;
            ALC alc = ALFactory.getALC();
            ALCdevice device = alc.alcOpenDevice(null);
            if (device != null && (context = alc.alcCreateContext(device, null)) != null) {
                alc.alcMakeContextCurrent(context);
            }
            al = ALFactory.getAL();
            al.alDistanceModel(53249);
            if (debug & debugVersion) {
                System.out.println("JOALMixer - JOAL renderer: " + al.alGetString(45059));
            }
            if (debug & debugVersion) {
                System.out.println("JOALMixer - JOAL vendor: " + al.alGetString(45057));
            }
            if (debug & debugVersion) {
                System.out.println("JOALMixer - JOAL extension: " + al.alGetString(45060));
            }
        }
        catch (ALException e) {
            e.printStackTrace();
            if (debug) {
                System.out.println("JOALMixer - initialize failed - Error initializing JOALMixer, code: " + al.alGetError());
            }
            return false;
        }
        if (debug) {
            System.out.println("JOALMixer - initialize success.");
        }
        return true;
    }

    public boolean close() {
        if (debug) {
            System.out.println("JOALMixer - close...");
        }
        return false;
    }

    public void setAudioPlaybackType(int type) {
        if (debug) {
            System.out.println("JOALMixer - setAudioPlaybackType to " + type);
        }
        super.setAudioPlaybackType(type);
    }

    public int getAudioPlaybackType() {
        if (debug) {
            System.out.println("JOALMixer - getAudioPlaybackType...");
        }
        return super.getAudioPlaybackType();
    }

    public void setCenterEarToSpeaker(float distance) {
        if (debug) {
            System.out.println("JOALMixer - setCenterEarToSpeaker to " + distance);
        }
        super.setCenterEarToSpeaker(distance);
    }

    public float getCenterEarToSpeaker() {
        if (debug) {
            System.out.println("JOALMixer - getCenterEarToSpeaker...");
        }
        return super.getCenterEarToSpeaker();
    }

    public void setAngleOffsetToSpeaker(float angle) {
        if (debug) {
            System.out.println("JOALMixer - setAngleOffsetToSpeaker " + angle);
        }
        super.setAngleOffsetToSpeaker(angle);
    }

    public float getAngleOffsetToSpeaker() {
        if (debug) {
            System.out.println("JOALMixer - getAngleOffsetToSpeaker...");
        }
        return super.getAngleOffsetToSpeaker();
    }

    public int getTotalChannels() {
        if (debug && debugGetTotalChannels) {
            System.out.println("JOALMixer - getTotalChannels...");
        }
        return 64;
    }

    public int getChannelsAvailable() {
        if (debug) {
            System.out.println("JOALMixer - getChannelsAvailable...");
        }
        return 8;
    }

    public int getChannelsUsedForSound(Sound sound) {
        if (debug) {
            System.out.println("JOALMixer - getChannelsUsedForSound...");
        }
        return super.getChannelsUsedForSound(sound);
    }

    public void setRateScaleFactor(int index, float scaleFactor) {
        JOALSample2 s = (JOALSample2)this.getSample(index);
        if (s == null) {
            return;
        }
        s.setRateScaleFactor(scaleFactor);
    }

    public void setReverbCoefficient(float coefficient) {
    }

    public void setReflectionDelay(float reflectionDelay) {
    }

    public void setDecayTime(float time) {
    }

    public void setDecayFilter(float frequencyCutoff) {
    }

    public void setDiffusion(float diffusion) {
    }

    public void setDensity(float density) {
    }

    public void setObstructionGain(int index, float scaleFactor) {
    }

    public void setObstructionFilter(int index, float frequencyCutoff) {
    }

    public void setOcclusionGain(int index, float scaleFactor) {
    }

    public void setOcclusionFilter(int index, float frequencyCutoff) {
    }

    static int initOpenAL() {
        String deviceName = "DirectSound3D";
        ALCdevice device = alc.alcOpenDevice(deviceName);
        String deviceSpecifier = alc.alcGetString(device, 4101);
        System.out.println("Using device " + deviceSpecifier);
        ALCcontext context = alc.alcCreateContext(device, null);
        alc.alcMakeContextCurrent(context);
        if (alc.alcGetError(device) != 0) {
            return 0;
        }
        return 1;
    }

    static void exitOpenAL() {
        ALCcontext curContext = alc.alcGetCurrentContext();
        ALCdevice curDevice = alc.alcGetContextsDevice(curContext);
        alc.alcMakeContextCurrent(null);
        alc.alcDestroyContext(curContext);
        alc.alcCloseDevice(curDevice);
    }

    private void calculateOrientation(View view) {
        Vector3f viewPosition = new Vector3f();
        Vector3f viewVector = new Vector3f(0.0f, 0.0f, -1.0f);
        Vector3f upVector = new Vector3f(0.0f, 1.0f, 0.0f);
        Transform3D viewTransform = new Transform3D();
        view.getUserHeadToVworld(viewTransform);
        viewTransform.get(viewPosition);
        viewTransform.transform(viewVector);
        viewTransform.transform(upVector);
        System.out.println("Position: " + viewPosition);
        System.out.println("viewVector: " + viewVector);
        System.out.println("upVector: " + upVector);
    }
}

