/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3;

import java.io.Serializable;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.A23;
import jp.sourceforge.acerola3d.a3.A3InitData;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.A3UpdateData;
import jp.sourceforge.acerola3d.a3.SkeletonBehavior;

public class Skeleton
extends A3Object {
    SkeletonBehavior skeletonBehavior;

    public Skeleton(String url) throws Exception {
        super(new A3InitData("jp.sourceforge.acerola3d.a3.Skeleton"));
        A3InitData d = new A3InitData("jp.sourceforge.acerola3d.a3.Skeleton");
        d.set(new Serializable[]{url, Boolean.valueOf(true), Boolean.valueOf(false)});
        this.realConstructor(d);
    }

    public Skeleton(A3InitData d) throws Exception {
        super(d);
        this.realConstructor(d);
    }

    void realConstructor(A3InitData d) throws Exception {
        A23.initA23();
        String urlString = d.getString(0);
        this.skeletonBehavior = new SkeletonBehavior(this, urlString);
        this.setNode(this.skeletonBehavior.getNode());
        this.skeletonBehavior.init();
        if (d.getBoolean(1)) {
            this.defaultPose();
        } else if (d.getBoolean(2)) {
            this.pause();
        } else {
            this.start();
        }
        if (d.getDataCount() >= 4) {
            this.setPauseTime(d.getDouble(3));
        }
        if (d.getDataCount() >= 5) {
            String[] selectedBones = (String[])d.get(4);
            for (int i = 0; i < selectedBones.length; ++i) {
                this.setBoneSelected(selectedBones[i], true);
            }
        }
    }

    public void defaultPose() {
        this.skeletonBehavior.defaultPose();
    }

    public void start() {
        this.skeletonBehavior.start();
    }

    public void pause() {
        this.skeletonBehavior.pause();
    }

    public void setPauseTime(double t) {
        this.skeletonBehavior.setPauseTime(t);
    }

    public void setBoneSelected(String boneName, boolean b) {
        this.skeletonBehavior.setBoneSelected(boneName, b);
    }

    public String getRootBone() {
        return this.skeletonBehavior.getRootBone();
    }

    public String getParentBone(String boneName) {
        return this.skeletonBehavior.getParentBone(boneName);
    }

    public String[] getChildBones(String boneName) {
        return this.skeletonBehavior.getChildBones(boneName);
    }

    public Vector3d getOffset(String boneName) {
        return this.skeletonBehavior.getOffset(boneName);
    }

    public double getMotionLength() {
        return this.skeletonBehavior.getMotionLength();
    }

    @Override
    public void update(A3UpdateData d) {
        int i;
        super.update(d);
        if (d.getBoolean(0)) {
            this.defaultPose();
        } else if (d.getBoolean(1)) {
            this.pause();
        } else {
            this.start();
        }
        if (d.getDataCount() >= 3) {
            this.setPauseTime(d.getDouble(2));
        }
        if (d.getDataCount() >= 4) {
            String[] selectedBones = (String[])d.get(3);
            for (i = 0; i < selectedBones.length; ++i) {
                this.setBoneSelected(selectedBones[i], true);
            }
        }
        if (d.getDataCount() >= 5) {
            String[] unSelectedBones = (String[])d.get(4);
            for (i = 0; i < unSelectedBones.length; ++i) {
                this.setBoneSelected(unSelectedBones[i], false);
            }
        }
    }

    public String[] getBones() {
        return this.skeletonBehavior.getAllBones();
    }

    public void resetSelected() {
        for (String bn : this.getBones()) {
            this.setBoneSelected(bn, false);
        }
    }
}

