/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.WakeupOnElapsedTime;

class WakeupOnElapsedTimeHeap
implements Cloneable {
    WakeupOnElapsedTime[] data;
    int size = 0;

    WakeupOnElapsedTimeHeap(int n) {
        this.data = new WakeupOnElapsedTime[n + 1];
    }

    WakeupOnElapsedTimeHeap() {
        this(10);
    }

    final int size() {
        return this.size;
    }

    final boolean isEmpty() {
        return this.size == 0;
    }

    final WakeupOnElapsedTime getMin() {
        return this.data[1];
    }

    final void insert(WakeupOnElapsedTime wakeupOnElapsedTime) {
        if (this.data.length == this.size + 1) {
            WakeupOnElapsedTime[] wakeupOnElapsedTimeArray = this.data;
            this.data = new WakeupOnElapsedTime[wakeupOnElapsedTimeArray.length << 1];
            System.arraycopy(wakeupOnElapsedTimeArray, 0, this.data, 0, wakeupOnElapsedTimeArray.length);
        }
        int n = ++this.size;
        int n2 = n >> 1;
        WakeupOnElapsedTime wakeupOnElapsedTime2 = this.data[n2];
        long l = wakeupOnElapsedTime.triggeredTime;
        while (n > 1 && wakeupOnElapsedTime2.triggeredTime > l) {
            this.data[n] = wakeupOnElapsedTime2;
            n = n2;
            wakeupOnElapsedTime2 = this.data[n2 >>= 1];
        }
        this.data[n] = wakeupOnElapsedTime;
    }

    final void extract(BehaviorRetained behaviorRetained) {
        for (int i = 1; i <= this.size; ++i) {
            if (this.data[i].behav != behaviorRetained) continue;
            this.extract(i);
        }
    }

    final boolean extract(WakeupOnElapsedTime wakeupOnElapsedTime) {
        for (int i = 1; i <= this.size; ++i) {
            if (this.data[i] != wakeupOnElapsedTime) continue;
            this.extract(i);
            return true;
        }
        return false;
    }

    final WakeupOnElapsedTime extractMin() {
        return this.extract(1);
    }

    final WakeupOnElapsedTime extract(int n) {
        WakeupOnElapsedTime wakeupOnElapsedTime = this.data[n];
        this.data[n] = this.data[this.size];
        this.data[this.size] = null;
        --this.size;
        while (true) {
            int n2 = n << 1;
            int n3 = n2 + 1;
            int n4 = n2 <= this.size && this.data[n2].triggeredTime < this.data[n].triggeredTime ? n2 : n;
            if (n3 <= this.size && this.data[n3].triggeredTime < this.data[n4].triggeredTime) {
                n4 = n3;
            }
            if (n4 == n) break;
            WakeupOnElapsedTime wakeupOnElapsedTime2 = this.data[n4];
            this.data[n4] = this.data[n];
            this.data[n] = wakeupOnElapsedTime2;
            n = n4;
        }
        return wakeupOnElapsedTime;
    }

    final void trimToSize() {
        if (this.data.length > this.size + 1) {
            WakeupOnElapsedTime[] wakeupOnElapsedTimeArray = this.data;
            this.data = new WakeupOnElapsedTime[this.size + 1];
            System.arraycopy(wakeupOnElapsedTimeArray, 0, this.data, 0, this.data.length);
        }
    }

    protected final Object clone() {
        try {
            WakeupOnElapsedTimeHeap wakeupOnElapsedTimeHeap = (WakeupOnElapsedTimeHeap)super.clone();
            wakeupOnElapsedTimeHeap.data = new WakeupOnElapsedTime[this.size + 1];
            System.arraycopy(this.data, 0, wakeupOnElapsedTimeHeap.data, 0, this.size + 1);
            return wakeupOnElapsedTimeHeap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ ");
        if (this.size > 0) {
            stringBuffer.append(this.data[1]);
        }
        for (int i = 2; i <= this.size; ++i) {
            stringBuffer.append("," + this.data[i]);
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

