/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.CompileState;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.GroupRetained;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Locale;
import javax.media.j3d.MasterControl;
import javax.media.j3d.PickInfo;
import javax.media.j3d.PickShape;
import javax.media.j3d.RestrictedAccessException;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.SetLiveState;
import javax.media.j3d.VirtualUniverse;

class BranchGroupRetained
extends GroupRetained {
    boolean isDirty = false;
    boolean isNew = false;
    boolean attachedToLocale = false;

    BranchGroupRetained() {
        this.nodeType = 19;
    }

    void setLocale(Locale locale) {
        this.locale = locale;
    }

    Locale getLocale() {
        return this.locale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detach() {
        this.dirtyBoundsCache();
        if (this.universe != null) {
            this.universe.resetWaitMCFlag();
            Object object = this.universe.sceneGraphLock;
            synchronized (object) {
                boolean bl = this.source.isLive();
                if (bl) {
                    this.notifySceneGraphChanged(true);
                }
                GroupRetained groupRetained = (GroupRetained)this.parent;
                this.do_detach();
                this.universe.setLiveState.clear();
                if (bl) {
                    if (groupRetained == null) {
                        this.universe.notifyStructureChangeListeners(false, (Object)this.locale, (BranchGroup)this.source);
                    } else {
                        this.universe.notifyStructureChangeListeners(false, (Object)groupRetained.source, (BranchGroup)this.source);
                    }
                }
            }
            this.universe.waitForMC();
        } else {
            this.do_detach();
            if (this.universe != null) {
                Object object = this.universe.sceneGraphLock;
                synchronized (object) {
                    this.universe.setLiveState.clear();
                }
            }
        }
    }

    void do_detach() {
        if (this.attachedToLocale) {
            this.locale.doRemoveBranchGraph((BranchGroup)this.source, null, 0);
        } else if (this.parent != null) {
            GroupRetained groupRetained = (GroupRetained)this.parent;
            groupRetained.doRemoveChild(groupRetained.children.indexOf(this), null, 0);
        }
    }

    void setNodeData(SetLiveState setLiveState) {
        setLiveState.parentBranchGroupPaths = this.branchGroupPaths;
        super.setNodeData(setLiveState);
        if (!this.inSharedGroup) {
            this.setAuxData(setLiveState, 0, 0);
        } else {
            for (int i = 0; i < setLiveState.keys.length; ++i) {
                int n = setLiveState.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n >= 0) {
                    this.setAuxData(setLiveState, i, n);
                    continue;
                }
                MasterControl.getCoreLogger().severe("Can't Find matching hashKey in setNodeData.");
            }
        }
    }

    void setAuxData(SetLiveState setLiveState, int n, int n2) {
        super.setAuxData(setLiveState, n, n2);
        BranchGroupRetained[] branchGroupRetainedArray = (BranchGroupRetained[])setLiveState.branchGroupPaths.get(n);
        BranchGroupRetained[] branchGroupRetainedArray2 = new BranchGroupRetained[branchGroupRetainedArray.length + 1];
        System.arraycopy(branchGroupRetainedArray, 0, branchGroupRetainedArray2, 0, branchGroupRetainedArray.length);
        branchGroupRetainedArray2[branchGroupRetainedArray.length] = this;
        setLiveState.branchGroupPaths.set(n, branchGroupRetainedArray2);
        this.branchGroupPaths.add(n2, branchGroupRetainedArray2);
    }

    void removeNodeData(SetLiveState setLiveState) {
        if (!this.inSharedGroup || setLiveState.keys.length == this.localToVworld.length) {
            this.branchGroupPaths = new ArrayList(1);
        } else {
            for (int i = setLiveState.keys.length - 1; i >= 0; --i) {
                int n = setLiveState.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (n < 0) continue;
                this.branchGroupPaths.remove(n);
            }
        }
        super.removeNodeData(setLiveState);
    }

    void setLive(SetLiveState setLiveState) {
        super.doSetLive(setLiveState);
        super.markAsLive();
    }

    void compile() {
        if (this.source.isCompiled() || VirtualUniverse.mc.disableCompile) {
            return;
        }
        CompileState compileState = new CompileState();
        this.isRoot = true;
        this.compile(compileState);
        this.merge(compileState);
    }

    void compile(CompileState compileState) {
        if (this.mergeFlag == 2) {
            compileState.keepTG = true;
            return;
        }
        super.compile(compileState);
        this.mergeFlag = 0;
    }

    SceneGraphPath[] pickAll(PickShape pickShape) {
        PickInfo[] pickInfoArray = this.pickAll(1, 1, pickShape);
        if (pickInfoArray == null) {
            return null;
        }
        SceneGraphPath[] sceneGraphPathArray = new SceneGraphPath[pickInfoArray.length];
        for (int i = 0; i < sceneGraphPathArray.length; ++i) {
            sceneGraphPathArray[i] = pickInfoArray[i].getSceneGraphPath();
        }
        return sceneGraphPathArray;
    }

    PickInfo[] pickAll(int n, int n2, PickShape pickShape) {
        if (this.inSharedGroup) {
            throw new RestrictedAccessException(J3dI18N.getString("BranchGroup9"));
        }
        GeometryAtom[] geometryAtomArray = this.locale.universe.geometryStructure.pickAll(this.locale, pickShape);
        return PickInfo.pick(this, geometryAtomArray, n, n2, pickShape, 1);
    }

    SceneGraphPath[] pickAllSorted(PickShape pickShape) {
        PickInfo[] pickInfoArray = this.pickAllSorted(1, 1, pickShape);
        if (pickInfoArray == null) {
            return null;
        }
        SceneGraphPath[] sceneGraphPathArray = new SceneGraphPath[pickInfoArray.length];
        for (int i = 0; i < sceneGraphPathArray.length; ++i) {
            sceneGraphPathArray[i] = pickInfoArray[i].getSceneGraphPath();
        }
        return sceneGraphPathArray;
    }

    PickInfo[] pickAllSorted(int n, int n2, PickShape pickShape) {
        if (this.inSharedGroup) {
            throw new RestrictedAccessException(J3dI18N.getString("BranchGroup9"));
        }
        GeometryAtom[] geometryAtomArray = this.locale.universe.geometryStructure.pickAll(this.locale, pickShape);
        PickInfo[] pickInfoArray = null;
        if (geometryAtomArray == null || geometryAtomArray.length == 0) {
            return null;
        }
        if (n == 2) {
            pickInfoArray = PickInfo.pick(this, geometryAtomArray, n, n2 |= 0x10, pickShape, 1);
            if (pickInfoArray != null) {
                PickInfo.sortPickInfoArray(pickInfoArray);
            }
        } else {
            PickInfo.sortGeomAtoms(geometryAtomArray, pickShape);
            pickInfoArray = PickInfo.pick(this, geometryAtomArray, n, n2, pickShape, 1);
        }
        return pickInfoArray;
    }

    SceneGraphPath pickClosest(PickShape pickShape) {
        PickInfo pickInfo = this.pickClosest(1, 1, pickShape);
        if (pickInfo == null) {
            return null;
        }
        return pickInfo.getSceneGraphPath();
    }

    PickInfo pickClosest(int n, int n2, PickShape pickShape) {
        PickInfo[] pickInfoArray = null;
        pickInfoArray = this.pickAllSorted(n, n2, pickShape);
        if (pickInfoArray == null) {
            return null;
        }
        return pickInfoArray[0];
    }

    SceneGraphPath pickAny(PickShape pickShape) {
        PickInfo pickInfo = this.pickAny(1, 1, pickShape);
        if (pickInfo == null) {
            return null;
        }
        return pickInfo.getSceneGraphPath();
    }

    PickInfo pickAny(int n, int n2, PickShape pickShape) {
        if (this.inSharedGroup) {
            throw new RestrictedAccessException(J3dI18N.getString("BranchGroup9"));
        }
        GeometryAtom[] geometryAtomArray = this.locale.universe.geometryStructure.pickAll(this.locale, pickShape);
        PickInfo[] pickInfoArray = PickInfo.pick(this, geometryAtomArray, n, n2, pickShape, 2);
        if (pickInfoArray == null) {
            return null;
        }
        return pickInfoArray[0];
    }
}

