/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.wal;

import com.sun.j3d.utils.image.TextureLoader;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.media.j3d.Texture;
import org.newdawn.j3d.loaders.cio.ByteArrayBuilder;
import org.newdawn.j3d.loaders.cio.LittleEndianDataInputStream;
import org.newdawn.j3d.loaders.wal.Q2Palette;

public class WALLoader {
    private WALHeader header;
    private byte[] data;
    private BufferedImage image;

    public WALLoader(InputStream file) throws IOException {
        byte[] data = ByteArrayBuilder.fromStream(file);
        file.close();
        this.header = new WALHeader(new ByteArrayInputStream(data));
        LittleEndianDataInputStream in = new LittleEndianDataInputStream(new DataInputStream(new ByteArrayInputStream(data)));
        data = new byte[this.header.width * this.header.height];
        in.skip(this.header.offset[0]);
        in.read(data);
        in.close();
        Q2Palette pal = new Q2Palette();
        this.image = new BufferedImage(this.header.width, this.header.height, 2);
        int x = 0;
        while (x < this.header.width) {
            int y = 0;
            while (y < this.header.height) {
                this.image.setRGB(x, y, pal.getColor(data[x + y * this.header.width]));
                ++y;
            }
            ++x;
        }
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Texture getTexture() {
        return new TextureLoader(this.getImage()).getTexture();
    }

    private class WALHeader {
        public String name;
        public int width;
        public int height;
        public int[] offset = new int[4];
        public String nextName;
        public int flags;
        public int contents;
        public int value;

        public WALHeader(InputStream f) throws IOException {
            LittleEndianDataInputStream in = new LittleEndianDataInputStream(new DataInputStream(f));
            byte[] data = new byte[32];
            in.read(data);
            int i = 0;
            while (i < 32) {
                if (data[i] == 0) break;
                ++i;
            }
            this.name = new String(data, 0, i);
            this.width = in.readInt();
            this.height = in.readInt();
            i = 0;
            while (i < 4) {
                this.offset[i] = in.readInt();
                ++i;
            }
            in.close();
        }
    }
}

