/*
 * Decompiled with CFR 0.152.
 */
package org.newdawn.j3d.loaders.md2;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import org.newdawn.j3d.loaders.cio.LittleEndianDataInputStream;

public class MD2Header {
    private int magic;
    private int version;
    private int skinWidth;
    private int skinHeight;
    private int frameSize;
    private int numSkins;
    private int numVertices;
    private int numTexcoords;
    private int numTriangles;
    private int numGlCommands;
    private int numFrames;
    private int offsetSkins;
    private int offsetTexcoords;
    private int offsetTriangles;
    private int offsetFrames;
    private int offsetGlCommands;
    private int offsetEnd;

    public MD2Header(byte[] b) throws IOException {
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(b));
        this.read(in);
        in.close();
    }

    public int getGLCommandsOffset() {
        return this.offsetGlCommands;
    }

    public int getGLCommandsCount() {
        return this.numGlCommands;
    }

    public int getVertexCount() {
        return this.numVertices;
    }

    public int getFramesOffset() {
        return this.offsetFrames;
    }

    public int getFrameCount() {
        return this.numFrames;
    }

    private void read(DataInputStream tin) throws IOException {
        LittleEndianDataInputStream in = new LittleEndianDataInputStream(tin);
        this.magic = in.readInt();
        this.version = in.readInt();
        this.skinWidth = in.readInt();
        this.skinHeight = in.readInt();
        this.frameSize = in.readInt();
        this.numSkins = in.readInt();
        this.numVertices = in.readInt();
        this.numTexcoords = in.readInt();
        this.numTriangles = in.readInt();
        this.numGlCommands = in.readInt();
        this.numFrames = in.readInt();
        this.offsetSkins = in.readInt();
        this.offsetTexcoords = in.readInt();
        this.offsetTriangles = in.readInt();
        this.offsetFrames = in.readInt();
        this.offsetGlCommands = in.readInt();
        this.offsetEnd = in.readInt();
    }
}

