/*
 * Decompiled with CFR 0.152.
 */
package com.microcrowd.loader.java3d.max3ds.chunks;

import com.microcrowd.loader.java3d.max3ds.ChunkChopper;
import com.microcrowd.loader.java3d.max3ds.ChunkMap;
import com.microcrowd.loader.java3d.max3ds.chunks.Chunk;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Light;
import javax.media.j3d.Node;
import javax.media.j3d.PointLight;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Color3f;
import javax.vecmath.Point3d;
import javax.vecmath.Vector3f;

public class LightChunk
extends Chunk {
    private Vector3f currentPosition;

    public void loadData(ChunkChopper chopper) {
        this.currentPosition = chopper.getVector();
        TransformGroup group = chopper.getGroup();
        Transform3D transform = new Transform3D();
        group.getTransform(transform);
        transform.setTranslation(this.currentPosition);
        group.setTransform(transform);
        chopper.pushData(chopper.getID(), this.currentPosition);
    }

    public void initialize(ChunkChopper chopper) {
        Color3f color = (Color3f)chopper.popData(ChunkMap.COLOR);
        PointLight light = (PointLight)chopper.popData(ChunkMap.SPOTLIGHT);
        if (light == null) {
            light = new PointLight();
            chopper.addLightNode((Light)light);
        }
        light.setColor(color);
        light.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 3000.0));
        chopper.getGroup().addChild((Node)light);
    }
}

