/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3editor;

import java.net.URL;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.Node;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.vecmath.Point3d;
import javax.vecmath.Quat4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.A3InitData;
import jp.sourceforge.acerola3d.a3.A3Object;
import jp.sourceforge.acerola3d.a3.Util;

public class CenteredVRML
extends A3Object {
    Vector3d offset = new Vector3d();

    public CenteredVRML(String url) throws Exception {
        super(new A3InitData("jp.sourceforge.acerola3d.a3editor.CenteredVRML"));
        URL u = new URL(url);
        Node n = Util.loadVRML_B((URL)u);
        Bounds b = n.getBounds();
        if (b instanceof BoundingSphere) {
            BoundingSphere bs = (BoundingSphere)b;
            Point3d p = new Point3d();
            bs.getCenter(p);
            this.offset.set((Tuple3d)p);
            this.offset.scale(-1.0);
        } else {
            this.offset.set(0.0, 0.0, 0.0);
        }
        Transform3D t = new Transform3D();
        t.set(this.offset);
        TransformGroup tg = new TransformGroup(t);
        tg.addChild(n);
        this.setNode((Node)tg);
    }

    public void setLoc2(double x, double y, double z) {
        this.setLoc2(new Vector3d(x, y, z));
    }

    public void setLoc2(Vector3d v) {
        Vector3d vv = new Vector3d(this.offset);
        Quat4d q = this.getQuat();
        vv = Util.trans((Quat4d)q, (Vector3d)vv);
        vv.scale(-1.0 * this.getScale());
        vv.add((Tuple3d)v);
        this.setLoc(vv);
    }

    public Vector3d getLoc2() {
        Vector3d v = new Vector3d(this.offset);
        Quat4d q = this.getQuat();
        v = Util.trans((Quat4d)q, (Vector3d)v);
        v.scale(this.getScale());
        v.add((Tuple3d)this.getLoc());
        return v;
    }
}

