/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3editor;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.acerola3d.a3editor.A3eFileManager;
import jp.sourceforge.acerola3d.a3editor.A3eFileType;

class A3eFile {
    static final A3eFile noneFile = new A3eFile();
    A3eFileManager fileManager;
    String name;
    A3eFile parent;
    ArrayList<A3eFile> children = new ArrayList();
    A3eFileType type;
    boolean isIgnored = false;

    A3eFile() {
        this.name = "[none]";
    }

    A3eFile(A3eFileManager fileManager, A3eFile parent, String name) {
        this.fileManager = fileManager;
        this.parent = parent;
        this.name = name;
        this.type = this.autoDetectFileType();
        if (this.type == A3eFileType.UNKNOWN) {
            this.isIgnored = true;
        }
    }

    File toFile() {
        if (this.parent == null) {
            return this.fileManager.rootDir;
        }
        return new File(this.parent.toFile(), this.name);
    }

    A3eFileType autoDetectFileType() {
        File f = this.toFile();
        if (f.isDirectory()) {
            return A3eFileType.DIR;
        }
        String path = this.getPath();
        if (path.equals("CATALOG.XML")) {
            return A3eFileType.CATALOG;
        }
        if (path.equals("catalog.xml")) {
            return A3eFileType.CATALOG;
        }
        String s = this.name.toLowerCase();
        int i = s.lastIndexOf(46);
        if (i != -1) {
            s = s.substring(i);
        }
        if (s.equals(".bvh")) {
            return A3eFileType.BVH;
        }
        if (s.equals(".wrl")) {
            return A3eFileType.VRML;
        }
        if (s.equals(".jpg") || s.equals(".png") || s.equals(".gif")) {
            return A3eFileType.IMAGE;
        }
        if (s.equals(".jpeg") || s.equals(".bmp")) {
            return A3eFileType.IMAGE;
        }
        if (s.equals(".wav") || s.equals(".au") || s.equals(".aiff")) {
            return A3eFileType.SOUND;
        }
        if (s.equals(".mp3") || s.equals(".ogg")) {
            return A3eFileType.SOUND;
        }
        if (s.equals(".html") || s.equals(".htm") || s.equals(".xhtml")) {
            return A3eFileType.HTML;
        }
        return A3eFileType.UNKNOWN;
    }

    String getPath() {
        if (this.parent == null) {
            return "";
        }
        String pp = this.parent.getPath();
        if (pp.equals("")) {
            return this.name;
        }
        return pp + "/" + this.name;
    }

    String getURLString() {
        return this.fileManager.path2UrlString(this.getPath());
    }

    void setIgnored(boolean b) {
        if (b) {
            this.isIgnored = true;
            for (A3eFile f : this.children) {
                f.setIgnored(true);
            }
        } else {
            this.isIgnored = false;
            if (this.parent != null) {
                this.parent.setIgnored(false);
            }
        }
    }

    boolean isIgnored() {
        return this.isIgnored;
    }

    void setFileType(A3eFileType t) {
        this.type = t;
    }

    boolean isDirectory() {
        return this.type == A3eFileType.DIR;
    }

    public String toString() {
        return this.name;
    }
}

