/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3editor;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Quat4d;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.Util;
import jp.sourceforge.acerola3d.a3.bvh.BVH;
import jp.sourceforge.acerola3d.a3.catalog.A;
import jp.sourceforge.acerola3d.a3.catalog.P;
import jp.sourceforge.acerola3d.a3.catalog.S;
import jp.sourceforge.acerola3d.a3.catalog.SoundType;
import jp.sourceforge.acerola3d.a3editor.A3Editor;
import jp.sourceforge.acerola3d.a3editor.A3eActionEditorGUI;
import jp.sourceforge.acerola3d.a3editor.A3eFile;
import jp.sourceforge.acerola3d.a3editor.A3eFileManager;
import jp.sourceforge.acerola3d.a3editor.Catalog;
import jp.sourceforge.acerola3d.a3editor.T;

class A3eActionEditor {
    A3Editor editor;
    A3eFileManager fileManager;
    Catalog catalog;
    A3eActionEditorGUI gui;
    A currentAction;

    A3eActionEditor(A3Editor e) {
        this.editor = e;
        this.fileManager = e.fileManager;
        this.catalog = e.catalog;
        this.setCurrent(this.catalog.a3.getA().get(0));
        this.gui = new A3eActionEditorGUI(this, this.editor);
    }

    String getBVHPath() {
        return this.currentAction.getBvh();
    }

    String getBVHURL() {
        return this.fileManager.path2UrlString(this.currentAction.getBvh());
    }

    void setCurrent(A a) {
        this.currentAction = a;
    }

    void changeCurrentAction(String an) {
        A ca = null;
        for (A a : this.catalog.a3.getA()) {
            if (!a.getAn().equals(an)) continue;
            ca = a;
            break;
        }
        if (ca != null) {
            this.setCurrent(ca);
        }
    }

    A3eActionEditorGUI getGUI() {
        return this.gui;
    }

    String[] getActionNames() {
        ArrayList<String> al = new ArrayList<String>();
        for (A a : this.catalog.a3.getA()) {
            al.add(a.getAn());
        }
        return al.toArray(new String[0]);
    }

    void deleteAction(String an) {
        List<A> actions = this.catalog.a3.getA();
        if (actions.size() <= 1) {
            return;
        }
        A a = null;
        for (A aa : actions) {
            if (!aa.getAn().equals(an)) continue;
            a = aa;
            break;
        }
        if (a != null) {
            actions.remove(a);
        }
        this.setCurrent(actions.get(0));
    }

    void createNewAction(String an) {
        A a = new A();
        a.setAn(an);
        this.catalog.a3.getA().add(a);
        this.setCurrent(a);
    }

    boolean checkCompatibility(String an, A3eFile bvh) {
        if (an.equals("[none]")) {
            return true;
        }
        try {
            A baseAction = null;
            for (A a : this.catalog.a3.getA()) {
                if (!a.getAn().equals(an)) continue;
                baseAction = a;
                break;
            }
            if (baseAction == null) {
                return false;
            }
            A3eFile f = this.editor.fileManager.getA3eFileFromPath(baseAction.getBvh());
            BVH baseBvh = new BVH(f.toFile().toURI().toURL().toString());
            BVH targetBVH = new BVH(bvh.toFile().toURI().toURL().toString());
            for (String b : baseBvh.getAllBones()) {
                boolean check = false;
                for (String bb : targetBVH.getAllBones()) {
                    if (!b.equals(bb)) continue;
                    check = true;
                    break;
                }
                if (check) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    void createNewAction2(String newActionName, String baseActionName, A3eFile bvh) {
        A a;
        A baseAction = null;
        if (!baseActionName.equals("[none]")) {
            for (A a2 : this.catalog.a3.getA()) {
                if (!a2.getAn().equals(baseActionName)) continue;
                baseAction = a2;
                break;
            }
        }
        if (baseAction == null) {
            a = new A();
            a.setAn(newActionName);
            if (bvh != A3eFile.noneFile) {
                a.setBvh(bvh.getPath());
            }
            this.catalog.a3.getA().add(a);
            this.setCurrent(a);
        } else {
            a = new A();
            a.setAn(newActionName);
            if (bvh != A3eFile.noneFile) {
                a.setBvh(bvh.getPath());
            }
            for (P p : baseAction.getP()) {
                P pp = new P();
                pp.setName(p.getName());
                pp.setWrl(p.getWrl());
                pp.setScale(p.getScale());
                pp.setOffset(p.getOffset());
                pp.setRot(p.getRot());
                a.getP().add(pp);
            }
            if (baseAction.getS() != null) {
                S s = new S();
                s.setFile(baseAction.getS().getFile());
                s.setType(baseAction.getS().getType());
                s.setLoop(baseAction.getS().isLoop());
                s.setGain(baseAction.getS().getGain());
                s.setOffset(baseAction.getS().getOffset());
                s.setDirection(baseAction.getS().getDirection());
                s.setContinue(baseAction.getS().isContinue());
                a.setS(s);
            }
            a.setLoop(baseAction.isLoop());
            a.setScale(baseAction.getScale());
            a.setOffset(baseAction.getOffset());
            a.setRot(baseAction.getRot());
            a.setRightBalloonOffset(baseAction.getRightBalloonOffset());
            a.setLeftBalloonOffset(baseAction.getLeftBalloonOffset());
            a.setTopBalloonOffset(baseAction.getTopBalloonOffset());
            a.setBottomBalloonOffset(baseAction.getBottomBalloonOffset());
            a.setLabelOffset(baseAction.getLabelOffset());
            a.setSegno(baseAction.getSegno());
            a.setDalsegno(baseAction.getDalsegno());
            this.catalog.a3.getA().add(a);
            this.setCurrent(a);
        }
    }

    void setActionName(String an) {
        this.currentAction.setAn(an);
    }

    String getCurrentActionName() {
        return this.currentAction.getAn();
    }

    boolean checkActionNameDuplication(String an) {
        for (A a : this.catalog.a3.getA()) {
            if (!a.getAn().equals(an)) continue;
            return true;
        }
        return false;
    }

    String getBVH() {
        String bvhFilePath = this.currentAction.getBvh();
        String fileName = this.fileManager.path2FileName(bvhFilePath);
        return fileName;
    }

    A3eFile getBVHFile() {
        String bvhFilePath = this.currentAction.getBvh();
        if (bvhFilePath != null) {
            return this.fileManager.getA3eFileFromPath(bvhFilePath);
        }
        return A3eFile.noneFile;
    }

    void setBVH(A3eFile file) {
        String an = this.currentAction.getAn();
        int i = this.catalog.a3.getA().indexOf(this.currentAction);
        this.catalog.a3.getA().remove(this.currentAction);
        A a = new A();
        a.setAn(an);
        this.catalog.a3.getA().add(i, a);
        if (file == A3eFile.noneFile) {
            a.setBvh("[none]");
        } else {
            a.setBvh(file.getPath());
        }
        this.setCurrent(a);
    }

    boolean getLoop() {
        return this.currentAction.isLoop();
    }

    void setLoop(boolean b) {
        this.currentAction.setLoop(b);
    }

    double getSegno() {
        return this.currentAction.getSegno();
    }

    void setSegno(double d) {
        this.currentAction.setSegno(d);
    }

    double getDalsegno() {
        return this.currentAction.getDalsegno();
    }

    void setDalsegno(double d) {
        this.currentAction.setDalsegno(d);
    }

    double[] getRightBalloonOffset() {
        return this.string2vector2d(this.currentAction.getRightBalloonOffset());
    }

    void setRightBalloonOffset(double[] v) {
        this.currentAction.setRightBalloonOffset(this.vector2d2string(v));
    }

    double[] getLeftBalloonOffset() {
        return this.string2vector2d(this.currentAction.getLeftBalloonOffset());
    }

    void setLeftBalloonOffset(double[] v) {
        this.currentAction.setLeftBalloonOffset(this.vector2d2string(v));
    }

    double[] getTopBalloonOffset() {
        return this.string2vector2d(this.currentAction.getTopBalloonOffset());
    }

    void setTopBalloonOffset(double[] v) {
        this.currentAction.setTopBalloonOffset(this.vector2d2string(v));
    }

    double[] getBottomBalloonOffset() {
        return this.string2vector2d(this.currentAction.getBottomBalloonOffset());
    }

    void setBottomBalloonOffset(double[] v) {
        this.currentAction.setBottomBalloonOffset(this.vector2d2string(v));
    }

    double[] getLabelOffset() {
        return this.string2vector2d(this.currentAction.getLabelOffset());
    }

    void setLabelOffset(double[] v) {
        this.currentAction.setLabelOffset(this.vector2d2string(v));
    }

    String[] getUsedBones() {
        ArrayList<String> al = new ArrayList<String>();
        for (P p : this.currentAction.getP()) {
            al.add(p.getName());
        }
        return al.toArray(new String[0]);
    }

    A3eFile getVRMLFile(String bn) {
        String wrl = null;
        for (P p : this.currentAction.getP()) {
            if (!p.getName().equals(bn)) continue;
            wrl = p.getWrl();
        }
        if (wrl != null) {
            return this.fileManager.getA3eFileFromPath(wrl);
        }
        return A3eFile.noneFile;
    }

    void setVRML(String bn, A3eFile file) {
        P p = null;
        for (P pp : this.currentAction.getP()) {
            if (!pp.getName().equals(bn)) continue;
            p = pp;
            break;
        }
        if (p != null) {
            if (file == A3eFile.noneFile) {
                this.currentAction.getP().remove(p);
            } else {
                p.setWrl(file.getPath());
            }
        } else if (file != A3eFile.noneFile) {
            p = new P();
            p.setName(bn);
            p.setWrl(file.getPath());
            this.currentAction.getP().add(p);
        }
    }

    void removeSoundDate() {
        this.currentAction.setS(null);
    }

    A3eFile getSoundFile() {
        S s = this.currentAction.getS();
        if (s == null) {
            return A3eFile.noneFile;
        }
        String sf = this.currentAction.getS().getFile();
        A3eFile f = this.fileManager.getA3eFileFromPath(sf);
        if (f != null) {
            return f;
        }
        return A3eFile.noneFile;
    }

    void setSoundFile(A3eFile file) {
        S s = this.currentAction.getS();
        if (s == null) {
            s = new S();
            s.setFile(file.getPath());
            s.setType(SoundType.POINT_SOUND);
            this.currentAction.setS(s);
        }
        s.setFile(file.getPath());
    }

    String getSoundType() {
        SoundType st = this.currentAction.getS().getType();
        if (st == SoundType.POINT_SOUND) {
            return "PointSound";
        }
        if (st == SoundType.BACKGROUND_SOUND) {
            return "Background";
        }
        if (st == SoundType.CONE_SOUND) {
            return "ConeSound";
        }
        return null;
    }

    void setSoundType(String st) {
        if (st.equals("PointSound")) {
            this.currentAction.getS().setType(SoundType.POINT_SOUND);
        } else if (st.equals("Background")) {
            this.currentAction.getS().setType(SoundType.POINT_SOUND);
        } else if (st.equals("ConeSound")) {
            this.currentAction.getS().setType(SoundType.CONE_SOUND);
        }
    }

    boolean getSoundLoop() {
        return this.currentAction.getS().isLoop();
    }

    void setSoundLoop(boolean b) {
        this.currentAction.getS().setLoop(b);
    }

    double getSoundGain() {
        return this.currentAction.getS().getGain();
    }

    void setSoundGain(double d) {
        this.currentAction.getS().setGain(d);
    }

    boolean getSoundContinue() {
        return this.currentAction.getS().isContinue();
    }

    void setSoundContinue(boolean b) {
        this.currentAction.getS().setContinue(b);
    }

    Vector3d getSoundOffset() {
        return this.string2vector3d(this.currentAction.getS().getOffset());
    }

    void setSoundOffset(double x, double y, double z) {
        S s = this.currentAction.getS();
        if (s == null) {
            return;
        }
        String so = "" + x + " " + y + " " + z;
        s.setOffset(so);
    }

    Vector3d getSoundDirection() {
        return this.string2vector3d(this.currentAction.getS().getDirection());
    }

    void setSoundDirection(double x, double y, double z) {
        S s = this.currentAction.getS();
        if (s == null) {
            return;
        }
        String sd = "" + x + " " + y + " " + z;
        s.setDirection(sd);
    }

    Vector3d getOffset() {
        return this.string2vector3d(this.currentAction.getOffset());
    }

    void setOffset(Vector3d v) {
        this.currentAction.setOffset(this.vector3d2string(v));
    }

    Vector3d getRot() {
        return this.string2vector3d(this.currentAction.getRot());
    }

    void setRot(Vector3d v) {
        this.currentAction.setRot(this.vector3d2string(v));
    }

    Quat4d getQuat() {
        Vector3d v = this.string2vector3d(this.currentAction.getRot());
        v.scale(Math.PI / 180);
        return Util.euler2quat((Vector3d)v);
    }

    void setQuat(Quat4d quat) {
        Vector3d v = Util.quat2euler((Quat4d)quat);
        v.scale(57.29577951308232);
        this.currentAction.setRot(this.vector3d2string(v));
    }

    double getScale() {
        return this.currentAction.getScale();
    }

    void setScale(double s) {
        this.currentAction.setScale(s);
    }

    T getPartData(String bn) {
        P part = null;
        for (P p : this.currentAction.getP()) {
            if (!p.getName().equals(bn)) continue;
            part = p;
            break;
        }
        if (part == null) {
            return null;
        }
        T t = new T();
        t.offset = this.string2vector3d(part.getOffset());
        Vector3d v = this.string2vector3d(part.getRot());
        v.scale(Math.PI / 180);
        t.quat = Util.euler2quat((Vector3d)v);
        t.scale = part.getScale();
        return t;
    }

    void setPartData(String bn, T t) {
        P part = null;
        for (P p : this.currentAction.getP()) {
            if (!p.getName().equals(bn)) continue;
            part = p;
            break;
        }
        if (part == null) {
            return;
        }
        part.setOffset(this.vector3d2string(t.offset));
        Vector3d v = Util.quat2euler((Quat4d)t.quat);
        v.scale(57.29577951308232);
        part.setRot(this.vector3d2string(v));
        part.setScale(t.scale);
    }

    void saveCatalog() {
        try {
            this.editor.catalog.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    Vector3d string2vector3d(String s) {
        String[] ss = s.split("\\s+");
        double x = Double.parseDouble(ss[0]);
        double y = Double.parseDouble(ss[1]);
        double z = Double.parseDouble(ss[2]);
        return new Vector3d(x, y, z);
    }

    String vector3d2string(Vector3d v) {
        return "" + v.x + " " + v.y + " " + v.z;
    }

    double[] string2vector2d(String s) {
        String[] ss = s.split("\\s+");
        double[] ret = new double[]{Double.parseDouble(ss[0]), Double.parseDouble(ss[1])};
        return ret;
    }

    String vector2d2string(double[] v) {
        return "" + v[0] + " " + v[1];
    }
}

