/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import jp.sourceforge.acerola3d.a3editor.A3eFileManager;
import jp.sourceforge.acerola3d.a3panels.A3Panel;

class A3eA3Panel
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    A3eFileManager fileManager;
    JButton snapshotB;
    A3Panel a3panel;

    A3eA3Panel(A3eFileManager fm) {
        this.fileManager = fm;
        this.setLayout(new BorderLayout());
        this.snapshotB = new JButton("\u30b5\u30e0\u30cd\u30fc\u30eb\u753b\u50cf\u3092\u4fdd\u5b58\u3059\u308b");
        this.snapshotB.addActionListener(this);
        this.add((Component)this.snapshotB, "North");
        this.a3panel = new A3Panel(null);
        this.add((Component)this.a3panel, "Center");
    }

    void loadAction3D(File f) {
        try {
            this.a3panel.loadAction3D(f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String fileName = JOptionPane.showInputDialog(this, "Input filename", "thumbnail.jpg");
        File file = new File(this.fileManager.rootDir, fileName);
        BufferedImage orgImage = this.a3panel.snapshot();
        BufferedImage image = this.changeSize(orgImage, 64, 64);
        try {
            ImageIO.write((RenderedImage)image, "jpg", file);
            this.fileManager.refresh();
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    BufferedImage changeSize(BufferedImage image, int width, int height) {
        AreaAveragingScaleFilter filter = new AreaAveragingScaleFilter(width, height);
        FilteredImageSource ip = new FilteredImageSource(image.getSource(), filter);
        Image newImage = Toolkit.getDefaultToolkit().createImage(ip);
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
        graphics2D.drawImage(newImage, null, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    void clear() {
        this.a3panel.clear();
    }
}

