/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.loaders.lw3d;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

class ImageScaler {
    int origW;
    int origH;
    Image origImage;

    ImageScaler(Image image, int n, int n2) {
        this.origImage = image;
        this.origW = n;
        this.origH = n2;
    }

    ImageScaler(BufferedImage bufferedImage) {
        this.origImage = bufferedImage;
        this.origW = bufferedImage.getWidth();
        this.origH = bufferedImage.getHeight();
    }

    int getClosestPowerOf2(int n) {
        if (n < 1) {
            return n;
        }
        int n2 = 1;
        for (int i = 1; i < 20; ++i) {
            if (n >= (n2 *= 2)) continue;
            int n3 = n2 / 2;
            if (n2 - n > n - n3) {
                return n3;
            }
            return n2;
        }
        return 1;
    }

    Image getScaledImage() {
        int n = this.getClosestPowerOf2(this.origW);
        int n2 = this.getClosestPowerOf2(this.origH);
        if (n == this.origW && n2 == this.origH) {
            return this.origImage;
        }
        Image image = null;
        if (this.origImage instanceof BufferedImage) {
            BufferedImage bufferedImage = (BufferedImage)this.origImage;
            image = new BufferedImage(n, n2, bufferedImage.getType());
            BufferedImage bufferedImage2 = (BufferedImage)image;
            float f = (float)this.origW / (float)n;
            float f2 = (float)this.origH / (float)n2;
            int[] nArray = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
            int[] nArray2 = ((DataBufferInt)bufferedImage2.getRaster().getDataBuffer()).getData();
            for (int i = 0; i < n2; ++i) {
                for (int j = 0; j < n; ++j) {
                    int n3 = Math.min(this.origH - 1, (int)((float)i * f2 + 0.5f));
                    int n4 = Math.min(this.origW - 1, (int)((float)j * f + 0.5f));
                    nArray2[i * n + j] = nArray[n3 * this.origW + n4];
                }
            }
        } else {
            image = this.origImage.getScaledInstance(n, n2, 1);
        }
        return image;
    }
}

