/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nwn.loader;

import java.util.ArrayList;
import java.util.List;
import net.sf.nwn.loader.AnimNode;
import net.sf.nwn.loader.EmitterBehavior;
import net.sf.nwn.loader.EmitterNode;
import net.sf.nwn.loader.KeyFloat;

public final class AnimEmitterNode
extends AnimNode {
    private ArrayList birthratekey;
    private static final long serialVersionUID = 1L;

    public AnimEmitterNode(String string) {
        super(string);
    }

    public List getBirthratekeyList() {
        if (this.birthratekey == null) {
            this.birthratekey = new ArrayList();
        }
        return this.birthratekey;
    }

    private float interpolateFloat(ArrayList arrayList, float f) {
        if (arrayList.size() == 1) {
            return ((KeyFloat)arrayList.get(0)).getVal();
        }
        for (int i = 1; i < arrayList.size(); ++i) {
            KeyFloat keyFloat = (KeyFloat)arrayList.get(i);
            if (!(keyFloat.getKey() > f)) continue;
            KeyFloat keyFloat2 = (KeyFloat)arrayList.get(i - 1);
            return keyFloat2.getVal() + (keyFloat.getVal() - keyFloat2.getVal()) * ((f - keyFloat2.getKey()) / (keyFloat.getKey() - keyFloat2.getKey()));
        }
        System.err.println("Cannot interpolate orientation " + this.getName() + " " + f);
        return ((KeyFloat)arrayList.get(arrayList.size())).getVal();
    }

    public void update(EmitterBehavior emitterBehavior, float f) {
        if (this.birthratekey != null && this.birthratekey.size() > 0) {
            emitterBehavior.setBirthrate(this.interpolateFloat(this.birthratekey, f));
        }
    }

    public void fixupEmitter(EmitterNode emitterNode) {
        if (this.birthratekey != null) {
            for (int i = 0; i < this.birthratekey.size(); ++i) {
                float f = ((KeyFloat)this.birthratekey.get(i)).getVal();
                if (!(f > emitterNode.getBirthrate())) continue;
                System.out.println("WARN: Fixing up birthrate in emitter node " + this.getName());
                emitterNode.setBirthrate(f);
            }
        }
    }
}

