/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert.javalayer;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.BitstreamException;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.DecoderException;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.Obuffer;
import org.tritonus.share.TDebug;
import org.tritonus.share.sampled.TConversionTool;
import org.tritonus.share.sampled.convert.TAsynchronousFilteredAudioInputStream;
import org.tritonus.share.sampled.convert.TEncodingFormatConversionProvider;

public class MpegFormatConversionProvider
extends TEncodingFormatConversionProvider {
    public static final AudioFormat.Encoding MPEG1L1 = new AudioFormat.Encoding("MPEG1L1");
    public static final AudioFormat.Encoding MPEG1L2 = new AudioFormat.Encoding("MPEG1L2");
    public static final AudioFormat.Encoding MPEG1L3 = new AudioFormat.Encoding("MPEG1L3");
    public static final AudioFormat.Encoding MPEG2L1 = new AudioFormat.Encoding("MPEG2L1");
    public static final AudioFormat.Encoding MPEG2L2 = new AudioFormat.Encoding("MPEG2L2");
    public static final AudioFormat.Encoding MPEG2L3 = new AudioFormat.Encoding("MPEG2L3");
    public static final AudioFormat.Encoding MPEG2DOT5L1 = new AudioFormat.Encoding("MPEG2DOT5L1");
    public static final AudioFormat.Encoding MPEG2DOT5L2 = new AudioFormat.Encoding("MPEG2DOT5L2");
    public static final AudioFormat.Encoding MPEG2DOT5L3 = new AudioFormat.Encoding("MPEG2DOT5L3");
    private static final AudioFormat.Encoding PCM_SIGNED = AudioFormat.Encoding.PCM_SIGNED;
    private static final AudioFormat[] INPUT_FORMATS = new AudioFormat[]{new AudioFormat(MPEG1L1, -1.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L1, -1.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L1, -1.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L1, -1.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L2, -1.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L2, -1.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L2, -1.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L2, -1.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG1L3, -1.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG1L3, -1.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG1L3, -1.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG1L3, -1.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG2L1, -1.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L1, -1.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG2L1, -1.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L1, -1.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG2L2, -1.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L2, -1.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG2L2, -1.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L2, -1.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG2L3, -1.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2L3, -1.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG2L3, -1.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2L3, -1.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG2DOT5L1, -1.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, -1.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG2DOT5L1, -1.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L1, -1.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG2DOT5L2, -1.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, -1.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG2DOT5L2, -1.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L2, -1.0f, -1, 2, -1, -1.0f, true), new AudioFormat(MPEG2DOT5L3, -1.0f, -1, 1, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, -1.0f, -1, 1, -1, -1.0f, true), new AudioFormat(MPEG2DOT5L3, -1.0f, -1, 2, -1, -1.0f, false), new AudioFormat(MPEG2DOT5L3, -1.0f, -1, 2, -1, -1.0f, true)};
    private static final AudioFormat[] OUTPUT_FORMATS = new AudioFormat[]{new AudioFormat(PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 16, 1, 2, -1.0f, true), new AudioFormat(PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, false), new AudioFormat(PCM_SIGNED, -1.0f, 16, 2, 4, -1.0f, true)};

    public MpegFormatConversionProvider() {
        super(Arrays.asList(INPUT_FORMATS), Arrays.asList(OUTPUT_FORMATS));
        if (TDebug.TraceAudioConverter) {
            TDebug.out((String)"MpegFormatConversionProvider.<init>(): begin");
        }
        if (TDebug.TraceAudioConverter) {
            TDebug.out((String)"MpegFormatConversionProvider.<init>(): end");
        }
    }

    public AudioInputStream getAudioInputStream(AudioFormat targetFormat, AudioInputStream audioInputStream) {
        AudioFormat matchingFormat;
        if (TDebug.TraceAudioConverter) {
            TDebug.out((String)"MpegFormatConversionProvider.getAudioInputStream(AudioFormat, AudioInputStream):");
            TDebug.out((String)"trying to convert");
            TDebug.out((String)("\tfrom: " + audioInputStream.getFormat()));
            TDebug.out((String)("\tto: " + targetFormat));
        }
        if ((matchingFormat = this.getMatchingFormat(targetFormat, audioInputStream.getFormat())) != null) {
            if (TDebug.TraceAudioConverter) {
                TDebug.out((String)"MpegFormatConversionProvider.getAudioInputStream(AudioFormat, AudioInputStream):");
                TDebug.out((String)"\tisConversionSupported() accepted it; now setting up the conversion");
            }
            targetFormat = MpegFormatConversionProvider.setUnspecifiedFieldsFromProto(targetFormat, matchingFormat);
            if (TDebug.TraceAudioConverter) {
                TDebug.out((String)"MpegFormatConversionProvider.getAudioInputStream(AudioFormat, AudioInputStream):");
                TDebug.out((String)("\tcompleted target format (1. stage): " + targetFormat));
            }
            targetFormat = MpegFormatConversionProvider.setUnspecifiedFieldsFromProto(targetFormat, audioInputStream.getFormat());
            if (TDebug.TraceAudioConverter) {
                TDebug.out((String)"MpegFormatConversionProvider.getAudioInputStream(AudioFormat, AudioInputStream):");
                TDebug.out((String)("\tcompleted target format (2. stage): " + targetFormat));
            }
            return new DecodedMpegAudioInputStream(targetFormat, audioInputStream);
        }
        throw new IllegalArgumentException("conversion not supported");
    }

    private static AudioFormat setUnspecifiedFieldsFromProto(AudioFormat incomplete, AudioFormat prototype) {
        AudioFormat format = new AudioFormat(incomplete.getEncoding(), MpegFormatConversionProvider.getSpecificValue(incomplete.getSampleRate(), prototype.getSampleRate()), MpegFormatConversionProvider.getSpecificValue(incomplete.getSampleSizeInBits(), prototype.getSampleSizeInBits()), MpegFormatConversionProvider.getSpecificValue(incomplete.getChannels(), prototype.getChannels()), MpegFormatConversionProvider.getSpecificValue(incomplete.getFrameSize(), prototype.getFrameSize()), MpegFormatConversionProvider.getSpecificValue(incomplete.getFrameRate(), prototype.getFrameRate()), incomplete.isBigEndian());
        return format;
    }

    private static float getSpecificValue(float fIncomplete, float fProto) {
        return fIncomplete == -1.0f ? fProto : fIncomplete;
    }

    private static int getSpecificValue(int nIncomplete, int nProto) {
        return nIncomplete == -1 ? nProto : nIncomplete;
    }

    public static class DecodedMpegAudioInputStream
    extends TAsynchronousFilteredAudioInputStream {
        private InputStream m_encodedStream;
        private Bitstream m_bitstream;
        private Decoder m_decoder;
        private DMAISObuffer m_oBuffer;

        public DecodedMpegAudioInputStream(AudioFormat outputFormat, AudioInputStream inputStream) {
            super(outputFormat, -1L);
            this.m_encodedStream = inputStream;
            this.m_bitstream = new Bitstream((InputStream)inputStream);
            this.m_decoder = new Decoder(null);
            this.m_oBuffer = new DMAISObuffer(outputFormat.getChannels());
            this.m_decoder.setOutputBuffer((Obuffer)this.m_oBuffer);
        }

        public void execute() {
            block6: {
                try {
                    Header header = this.m_bitstream.readFrame();
                    if (header == null) {
                        if (TDebug.TraceAudioConverter) {
                            TDebug.out((String)"header is null (end of mpeg stream)");
                        }
                        this.getCircularBuffer().close();
                        return;
                    }
                    Obuffer decoderOutput = this.m_decoder.decodeFrame(header, this.m_bitstream);
                    this.m_bitstream.closeFrame();
                    this.getCircularBuffer().write(this.m_oBuffer.getBuffer(), 0, this.m_oBuffer.getCurrentBufferSize());
                    this.m_oBuffer.reset();
                }
                catch (BitstreamException e) {
                    if (TDebug.TraceAudioConverter || TDebug.TraceAllExceptions) {
                        TDebug.out((Throwable)e);
                    }
                }
                catch (DecoderException e) {
                    if (!TDebug.TraceAudioConverter && !TDebug.TraceAllExceptions) break block6;
                    TDebug.out((Throwable)e);
                }
            }
        }

        private boolean isBigEndian() {
            return this.getFormat().isBigEndian();
        }

        public void close() throws IOException {
            super.close();
            this.m_encodedStream.close();
        }

        private class DMAISObuffer
        extends Obuffer {
            private int m_nChannels;
            private byte[] m_abBuffer;
            private int[] m_anBufferPointers;
            private boolean m_bIsBigEndian;

            public DMAISObuffer(int nChannels) {
                this.m_nChannels = nChannels;
                this.m_abBuffer = new byte[2304 * nChannels];
                this.m_anBufferPointers = new int[nChannels];
                this.reset();
                this.m_bIsBigEndian = DecodedMpegAudioInputStream.this.isBigEndian();
            }

            public void append(int nChannel, short sValue) {
                TConversionTool.shortToBytes16((short)sValue, (byte[])this.m_abBuffer, (int)this.m_anBufferPointers[nChannel], (boolean)this.m_bIsBigEndian);
                int n = nChannel;
                this.m_anBufferPointers[n] = this.m_anBufferPointers[n] + this.m_nChannels * 2;
            }

            public void set_stop_flag() {
            }

            public void close() {
            }

            public void write_buffer(int nValue) {
            }

            public void clear_buffer() {
            }

            public byte[] getBuffer() {
                return this.m_abBuffer;
            }

            public int getCurrentBufferSize() {
                return this.m_anBufferPointers[0];
            }

            public void reset() {
                for (int i = 0; i < this.m_nChannels; ++i) {
                    this.m_anBufferPointers[i] = i * 2;
                }
            }
        }
    }
}

