/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.acerola3d.a3.bvh;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Stack;
import javax.media.j3d.Transform3D;
import javax.vecmath.Vector3d;
import jp.sourceforge.acerola3d.a3.bvh.analysis.DepthFirstAdapter;
import jp.sourceforge.acerola3d.a3.bvh.lexer.Lexer;
import jp.sourceforge.acerola3d.a3.bvh.node.ABvh;
import jp.sourceforge.acerola3d.a3.bvh.node.AChannelsLine;
import jp.sourceforge.acerola3d.a3.bvh.node.AEndSiteBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.AFrameTimeLine;
import jp.sourceforge.acerola3d.a3.bvh.node.AFramesLine;
import jp.sourceforge.acerola3d.a3.bvh.node.AHierarchyPart;
import jp.sourceforge.acerola3d.a3.bvh.node.AIntegerNumber;
import jp.sourceforge.acerola3d.a3.bvh.node.AJointBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.AMotionPart;
import jp.sourceforge.acerola3d.a3.bvh.node.AOffsetLine;
import jp.sourceforge.acerola3d.a3.bvh.node.ARealNumberNumber;
import jp.sourceforge.acerola3d.a3.bvh.node.ARootBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.AXPositionChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AXRotationChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AXScaleChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AYPositionChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AYRotationChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AYScaleChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AZPositionChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AZRotationChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.AZScaleChannelType;
import jp.sourceforge.acerola3d.a3.bvh.node.PNumber;
import jp.sourceforge.acerola3d.a3.bvh.node.PSuperBlock;
import jp.sourceforge.acerola3d.a3.bvh.node.Start;
import jp.sourceforge.acerola3d.a3.bvh.node.TInteger;
import jp.sourceforge.acerola3d.a3.bvh.node.TRealNumber;
import jp.sourceforge.acerola3d.a3.bvh.parser.Parser;

class ParserBVH
extends DepthFirstAdapter {
    int frameCount;
    double frameTime;
    String rootBone;
    HashMap<String, Bone> bones = new HashMap();
    Tmp t;

    public ParserBVH(URL url) throws Exception {
        InputStream is = url.openStream();
        InputStreamReader reader = new InputStreamReader(is);
        Lexer lexer = new Lexer(new PushbackReader(reader));
        Parser parser = new Parser(lexer);
        Start ast = parser.parse();
        this.t = new Tmp();
        ast.apply(this);
        this.convert();
        this.t = null;
    }

    public double getMotionLength() {
        return (double)this.frameCount * this.frameTime;
    }

    public double getDefaultFrameTime() {
        return this.frameTime;
    }

    public String getRootBone() {
        return this.rootBone;
    }

    public String getParentBone(String b) {
        Bone bone = this.bones.get(b);
        return bone.parent;
    }

    public String[] getChildBones(String b) {
        Bone bone = this.bones.get(b);
        return (String[])bone.children.clone();
    }

    public String[] getAllBones() {
        return this.bones.keySet().toArray(new String[0]);
    }

    public Transform3D getTransform3D(String bone, double time) {
        Bone b = this.bones.get(bone);
        int frame = (int)(time / this.frameTime);
        frame = frame < 0 ? 0 : frame;
        frame = frame >= this.frameCount ? this.frameCount - 1 : frame;
        return new Transform3D(b.transforms[frame]);
    }

    public Vector3d getOffset(String b) {
        Bone bone = this.bones.get(b);
        if (bone == null) {
            return null;
        }
        return new Vector3d(this.bones.get((Object)b).offset);
    }

    public ArrayList<Vector3d> getBoneTails(String b) {
        ArrayList<Vector3d> boneTails = this.bones.get((Object)b).boneTails;
        if (boneTails == null) {
            return null;
        }
        return new ArrayList<Vector3d>(boneTails);
    }

    @Override
    public void caseABvh(ABvh node) {
        node.getHierarchyPart().apply(this);
        node.getMotionPart().apply(this);
    }

    @Override
    public void caseAHierarchyPart(AHierarchyPart node) {
        node.getRootBlock().apply(this);
    }

    @Override
    public void caseARootBlock(ARootBlock node) {
        this.t.currentBlock = this.t.rootBlock = new Block();
        this.t.blockQueue.add(this.t.currentBlock);
        this.t.currentBlock.name = node.getIdentifier().getText();
        this.t.currentBlock.parent = null;
        this.t.currentBlock.children = new ArrayList();
        node.getOffsetLine().apply(this);
        node.getChannelsLine().apply(this);
        Object[] temp = node.getSuperBlock().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PSuperBlock)temp[i]).apply(this);
        }
    }

    @Override
    public void caseAOffsetLine(AOffsetLine node) {
        PNumber x_number = node.getXOffset();
        PNumber y_number = node.getYOffset();
        PNumber z_number = node.getZOffset();
        double x = this.pNumber2Double(x_number);
        double y = this.pNumber2Double(y_number);
        double z = this.pNumber2Double(z_number);
        this.t.currentBlock.offsetX = x;
        this.t.currentBlock.offsetY = y;
        this.t.currentBlock.offsetZ = z;
        if (this.t.parentBlock != null) {
            this.t.parentBlock.boneTails.add(new Vector3d(x, y, z));
        }
    }

    @Override
    public void caseAChannelsLine(AChannelsLine node) {
        Object[] temp;
        TInteger integer = node.getInteger();
        int channelsCount = Integer.parseInt(integer.getText());
        if (channelsCount != (temp = node.getChannelType().toArray()).length) {
            System.out.println("ActionGenerator.caseAChannelsBlock()");
            System.out.println("pars error!!!");
        }
        for (int i = 0; i < temp.length; ++i) {
            Channel c = new Channel();
            this.t.channelQueue.add(c);
            if (temp[i] instanceof AXPositionChannelType) {
                this.t.currentBlock.x_position = c;
                this.t.currentBlock.channelOrder.add(ChannelType.PX);
                continue;
            }
            if (temp[i] instanceof AYPositionChannelType) {
                this.t.currentBlock.y_position = c;
                this.t.currentBlock.channelOrder.add(ChannelType.PY);
                continue;
            }
            if (temp[i] instanceof AZPositionChannelType) {
                this.t.currentBlock.z_position = c;
                this.t.currentBlock.channelOrder.add(ChannelType.PZ);
                continue;
            }
            if (temp[i] instanceof AXRotationChannelType) {
                this.t.currentBlock.x_rotation = c;
                this.t.currentBlock.channelOrder.add(ChannelType.RX);
                continue;
            }
            if (temp[i] instanceof AYRotationChannelType) {
                this.t.currentBlock.y_rotation = c;
                this.t.currentBlock.channelOrder.add(ChannelType.RY);
                continue;
            }
            if (temp[i] instanceof AZRotationChannelType) {
                this.t.currentBlock.z_rotation = c;
                this.t.currentBlock.channelOrder.add(ChannelType.RZ);
                continue;
            }
            if (temp[i] instanceof AXScaleChannelType) {
                this.t.currentBlock.x_scale = c;
                this.t.currentBlock.channelOrder.add(ChannelType.SX);
                continue;
            }
            if (temp[i] instanceof AYScaleChannelType) {
                this.t.currentBlock.y_scale = c;
                this.t.currentBlock.channelOrder.add(ChannelType.SY);
                continue;
            }
            if (!(temp[i] instanceof AZScaleChannelType)) continue;
            this.t.currentBlock.z_scale = c;
            this.t.currentBlock.channelOrder.add(ChannelType.SZ);
        }
    }

    @Override
    public void caseAJointBlock(AJointBlock node) {
        this.t.blockStack.push(this.t.parentBlock);
        this.t.parentBlock = this.t.currentBlock;
        this.t.currentBlock = new Block();
        this.t.blockQueue.add(this.t.currentBlock);
        this.t.currentBlock.name = node.getIdentifier().getText();
        this.t.currentBlock.parent = this.t.parentBlock.name;
        this.t.currentBlock.children = new ArrayList();
        this.t.parentBlock.children.add(this.t.currentBlock.name);
        node.getOffsetLine().apply(this);
        node.getChannelsLine().apply(this);
        Object[] temp = node.getSuperBlock().toArray();
        for (int i = 0; i < temp.length; ++i) {
            ((PSuperBlock)temp[i]).apply(this);
        }
        this.t.currentBlock = this.t.parentBlock;
        this.t.parentBlock = this.t.blockStack.pop();
    }

    @Override
    public void caseAEndSiteBlock(AEndSiteBlock node) {
        this.t.blockStack.push(this.t.parentBlock);
        this.t.parentBlock = this.t.currentBlock;
        this.t.currentBlock = new Block();
        this.t.currentBlock.name = null;
        node.getOffsetLine().apply(this);
        this.t.currentBlock = this.t.parentBlock;
        this.t.parentBlock = this.t.blockStack.pop();
    }

    @Override
    public void caseAMotionPart(AMotionPart node) {
        node.getFramesLine().apply(this);
        node.getFrameTimeLine().apply(this);
        this.t.channelsInit();
        Object[] temp = node.getNumber().toArray();
        if (temp.length != this.t.channelQueue.size() * this.t.frameCount) {
            System.out.println("ActionGenerator.caseAMotionPart().");
            System.out.println("parse error!!!");
            System.out.print(temp.length);
            System.out.print(" and " + this.t.channelQueue.size() * this.t.frameCount);
            System.out.println(" do not match.");
            return;
        }
        int tempCount = 0;
        for (int i = 0; i < this.t.frameCount; ++i) {
            for (int j = 0; j < this.t.channelQueue.size(); ++j) {
                double d;
                PNumber pn = (PNumber)temp[tempCount++];
                this.t.channelQueue.get((int)j).data[i] = d = this.pNumber2Double(pn);
            }
        }
    }

    @Override
    public void caseAFramesLine(AFramesLine node) {
        TInteger integer = node.getInteger();
        String is = integer.getText();
        this.t.frameCount = Integer.parseInt(is);
    }

    @Override
    public void caseAFrameTimeLine(AFrameTimeLine node) {
        PNumber num = node.getNumber();
        this.t.frameTime = this.pNumber2Double(num);
    }

    protected double pNumber2Double(PNumber num) {
        if (num instanceof ARealNumberNumber) {
            TRealNumber rn = ((ARealNumberNumber)num).getRealNumber();
            String rns = rn.getText();
            return Double.parseDouble(rns);
        }
        TInteger integer = ((AIntegerNumber)num).getInteger();
        int iii = Integer.parseInt(integer.getText());
        return iii;
    }

    void convert() {
        this.frameCount = this.t.frameCount;
        this.frameTime = this.t.frameTime;
        this.rootBone = this.t.rootBlock.name;
        Transform3D t1 = new Transform3D();
        Transform3D t2 = new Transform3D();
        for (Block block : this.t.blockQueue) {
            Bone bone = new Bone();
            bone.name = block.name;
            bone.parent = block.parent;
            bone.children = block.children.toArray(new String[0]);
            bone.transforms = new Transform3D[this.frameCount];
            bone.offset = new Vector3d(block.offsetX, block.offsetY, block.offsetZ);
            bone.boneTails = block.boneTails;
            for (int j = 0; j < this.frameCount; ++j) {
                Transform3D t0 = new Transform3D();
                t0.setTranslation(new Vector3d(block.offsetX, block.offsetY, block.offsetZ));
                t1.setIdentity();
                for (ChannelType ct : block.channelOrder) {
                    t2.setIdentity();
                    if (ct == ChannelType.PX) {
                        t2.setTranslation(new Vector3d(block.x_position.data[j], 0.0, 0.0));
                    } else if (ct == ChannelType.PY) {
                        t2.setTranslation(new Vector3d(0.0, block.y_position.data[j], 0.0));
                    } else if (ct == ChannelType.PZ) {
                        t2.setTranslation(new Vector3d(0.0, 0.0, block.z_position.data[j]));
                    } else if (ct == ChannelType.RX) {
                        t2.rotX(block.x_rotation.data[j] / 360.0 * 2.0 * Math.PI);
                    } else if (ct == ChannelType.RY) {
                        t2.rotY(block.y_rotation.data[j] / 360.0 * 2.0 * Math.PI);
                    } else if (ct == ChannelType.RZ) {
                        t2.rotZ(block.z_rotation.data[j] / 360.0 * 2.0 * Math.PI);
                    } else if (ct == ChannelType.SX) {
                        t2.setScale(new Vector3d(block.x_scale.data[j], 1.0, 1.0));
                    } else if (ct == ChannelType.SY) {
                        t2.setScale(new Vector3d(1.0, block.y_scale.data[j], 1.0));
                    } else if (ct == ChannelType.SZ) {
                        t2.setScale(new Vector3d(1.0, 1.0, block.z_scale.data[j]));
                    }
                    t1.mul(t1, t2);
                }
                t0.mul(t1);
                bone.transforms[j] = t0;
            }
            this.bones.put(bone.name, bone);
        }
    }

    class Tmp {
        int frameCount;
        double frameTime;
        ArrayList<Block> blockQueue = new ArrayList();
        Stack<Block> blockStack = new Stack();
        ArrayList<Channel> channelQueue = new ArrayList();
        Block rootBlock;
        Block parentBlock;
        Block currentBlock;

        Tmp() {
        }

        void channelsInit() {
            Iterator<Channel> i = this.channelQueue.iterator();
            while (i.hasNext()) {
                i.next().data = new double[this.frameCount];
            }
        }
    }

    class Channel {
        double[] data;

        Channel() {
        }
    }

    class Block {
        String name;
        String parent;
        ArrayList<String> children;
        double offsetX;
        double offsetY;
        double offsetZ;
        Channel x_position;
        Channel y_position;
        Channel z_position;
        Channel z_rotation;
        Channel x_rotation;
        Channel y_rotation;
        Channel x_scale;
        Channel y_scale;
        Channel z_scale;
        ArrayList<ChannelType> channelOrder = new ArrayList();
        ArrayList<Vector3d> boneTails = new ArrayList();

        Block() {
        }
    }

    static enum ChannelType {
        PX,
        PY,
        PZ,
        RX,
        RY,
        RZ,
        SX,
        SY,
        SZ;

    }

    class Bone {
        String name;
        String parent;
        String[] children;
        Transform3D[] transforms;
        Vector3d offset = null;
        ArrayList<Vector3d> boneTails = null;

        Bone() {
        }
    }
}

