#!/usr/local/bin/python3.8
# -*- coding: utf-8 -*-
# Copyright 2019 Red Hat
# GNU General Public License v3.0+
# (see COPYING or https://www.gnu.org/licenses/gpl-3.0.txt)

##############################################
#                 WARNING                    #
##############################################
#
# This file is auto generated by the resource
#   module builder playbook.
#
# Do not edit this file manually.
#
# Changes to this file will be over written
#   by the resource module builder.
#
# Changes should be made in the model used to
#   generate this file or in the resource module
#   builder template.
#
##############################################

"""
The module file for eos_interfaces
"""

from __future__ import absolute_import, division, print_function

__metaclass__ = type


DOCUMENTATION = """
module: eos_interfaces
short_description: Interfaces resource module
description:
- This module manages the interface attributes of Arista EOS interfaces.
version_added: 1.0.0
author:
- Nathaniel Case (@qalthos)
notes:
- Tested against Arista EOS 4.20.10M
- This module works with connection C(network_cli). See the L(EOS Platform Options,../network/user_guide/platform_eos.html).
options:
  config:
    description: The provided configuration
    type: list
    elements: dict
    suboptions:
      name:
        description:
        - Full name of the interface, e.g. GigabitEthernet1.
        type: str
        required: True
      description:
        description:
        - Interface description
        type: str
      duplex:
        description:
        - Interface link status. Applicable for Ethernet interfaces only.
        - Values other than C(auto) must also set I(speed).
        - Ignored when I(speed) is set above C(1000).
        type: str
      enabled:
        default: true
        description:
        - Administrative state of the interface.
        - Set the value to C(true) to administratively enable the interface or C(false)
          to disable it.
        type: bool
      mtu:
        description:
        - MTU for a specific interface. Must be an even number between 576 and 9216.
          Applicable for Ethernet interfaces only.
        type: int
      speed:
        description:
        - Interface link speed. Applicable for Ethernet interfaces only.
        type: str
      mode:
        description:
        - Manage Layer2 or Layer3 state of the interface. Applicable for Ethernet
          and port channel interfaces only.
        choices:
        - layer2
        - layer3
        type: str
  running_config:
    description:
    - This option is used only with state I(parsed).
    - The value of this option should be the output received from the EOS device by
      executing the command B(show running-config | section ^interface).
    - The state I(parsed) reads the configuration from C(running_config) option and
      transforms it into Ansible structured data as per the resource module's argspec
      and the value is then returned in the I(parsed) key within the result.
    type: str
  state:
    choices:
    - merged
    - replaced
    - overridden
    - deleted
    - parsed
    - rendered
    - gathered
    default: merged
    description:
    - The state of the configuration after module completion.
    type: str

"""

EXAMPLES = """

# Using merged

# Before state:
# -------------
#
# veos#show running-config | section interface
# interface Ethernet1
#    description "Interface 1"
# !
# interface Ethernet2
# !
# interface Management1
#    description "Management interface"
#    ip address dhcp
# !

- name: Merge provided configuration with device configuration
  arista.eos.eos_interfaces:
    config:
    - name: Ethernet1
      enabled: true
      mode: layer3
    - name: Ethernet2
      description: Configured by Ansible
      enabled: false
    state: merged

# After state:
# ------------
#
# veos#show running-config | section interface
# interface Ethernet1
#    description "Interface 1"
#    no switchport
# !
# interface Ethernet2
#    description "Configured by Ansible"
#    shutdown
# !
# interface Management1
#    description "Management interface"
#    ip address dhcp
# !

# Using replaced

# Before state:
# -------------
#
# veos#show running-config | section interface
# interface Ethernet1
#    description "Interface 1"
# !
# interface Ethernet2
# !
# interface Management1
#    description "Management interface"
#    ip address dhcp
# !

- name: Replaces device configuration of listed interfaces with provided configuration
  arista.eos.eos_interfaces:
    config:
    - name: Ethernet1
      enabled: true
    - name: Ethernet2
      description: Configured by Ansible
      enabled: false
    state: replaced

# After state:
# ------------
#
# veos#show running-config | section interface
# interface Ethernet1
# !
# interface Ethernet2
#    description "Configured by Ansible"
#    shutdown
# !
# interface Management1
#    description "Management interface"
#    ip address dhcp
# !

# Using overridden

# Before state:
# -------------
#
# veos#show running-config | section interface
# interface Ethernet1
#    description "Interface 1"
# !
# interface Ethernet2
# !
# interface Management1
#    description "Management interface"
#    ip address dhcp
# !

- name: Overrides all device configuration with provided configuration
  arista.eos.eos_interfaces:
    config:
    - name: Ethernet1
      enabled: true
    - name: Ethernet2
      description: Configured by Ansible
      enabled: false
    state: overridden

# After state:
# ------------
#
# veos#show running-config | section interface
# interface Ethernet1
# !
# interface Ethernet2
#    description "Configured by Ansible"
#    shutdown
# !
# interface Management1
#    ip address dhcp
# !

# Using deleted

# Before state:
# -------------
#
# veos#show running-config | section interface
# interface Ethernet1
#    description "Interface 1"
#    no switchport
# !
# interface Ethernet2
# !
# interface Management1
#    description "Management interface"
#    ip address dhcp
# !

- name: Delete or return interface parameters to default settings
  arista.eos.eos_interfaces:
    config:
    - name: Ethernet1
    state: deleted

# After state:
# ------------
#
# veos#show running-config | section interface
# interface Ethernet1
# !
# interface Ethernet2
# !
# interface Management1
#    description "Management interface"
#    ip address dhcp
# !

# Using rendered

- name: Use Rendered to convert the structured data to native config
  arista.eos.eos_interfaces:
    config:
    - name: Ethernet1
      enabled: true
      mode: layer3
    - name: Ethernet2
      description: Configured by Ansible
      enabled: false
    state: merged

# Output:
# ------------

# - "interface Ethernet1"
# - "description "Interface 1""
# - "no swithcport"
# - "interface Ethernet2"
# - "description "Configured by Ansible""
# - "shutdown"
# - "interface Management1"
# - "description "Management interface""
# - "ip address dhcp"

# Using parsed
# parsed.cfg

# interface Ethernet1
#    description "Interface 1"
# !
# interface Ethernet2
#    description "Configured by Ansible"
#    shutdown
# !

- name: Use parsed to convert native configs to structured data
  arista.eos.interfaces:
    running_config: "{{ lookup('file', 'parsed.cfg') }}"
    state: parsed

# Output
# parsed:
#     - name: Ethernet1
#       enabled: True
#       mode: layer2
#     - name: Ethernet2
#       description: 'Configured by Ansible'
#       enabled: False
#       mode: layer2

# Using gathered:

# Existing config on the device
# -----------------------------
# interface Ethernet1
#    description "Interface 1"
# !
# interface Ethernet2
#    description "Configured by Ansible"
#    shutdown
# !

- name: Gather interfaces facts from the device
  arista.eos.interfaces:
    state: gathered

# output
# gathered:
#      - name: Ethernet1
#        enabled: True
#        mode: layer2
#      - name: Ethernet2
#        description: 'Configured by Ansible'
#        enabled: False
#        mode: layer2
"""

RETURN = """
before:
  description: The configuration as structured data prior to module invocation.
  returned: always
  type: dict
  sample: The configuration returned will always be in the same format of the parameters above.
after:
  description: The configuration as structured data after module completion.
  returned: when changed
  type: dict
  sample: The configuration returned will always be in the same format of the parameters above.
commands:
  description: The set of commands pushed to the remote device.
  returned: always
  type: list
  sample: ['interface Ethernet2', 'shutdown', 'speed 10full']
"""


from ansible.module_utils.basic import AnsibleModule
from ansible_collections.arista.eos.plugins.module_utils.network.eos.argspec.interfaces.interfaces import (
    InterfacesArgs,
)
from ansible_collections.arista.eos.plugins.module_utils.network.eos.config.interfaces.interfaces import (
    Interfaces,
)


def main():
    """
    Main entry point for module execution

    :returns: the result form module invocation
    """

    required_if = [
        ("state", "merged", ("config",)),
        ("state", "replaced", ("config",)),
        ("state", "overridden", ("config",)),
        ("state", "rendered", ("config",)),
        ("state", "parsed", ("running_config",)),
    ]
    mutually_exclusive = [("config", "running_config")]

    module = AnsibleModule(
        argument_spec=InterfacesArgs.argument_spec,
        required_if=required_if,
        supports_check_mode=True,
        mutually_exclusive=mutually_exclusive,
    )

    result = Interfaces(module).execute_module()
    module.exit_json(**result)


if __name__ == "__main__":
    main()
