/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.netbeans.modules.selenium2.webclient.ui.customizer;

import java.awt.EventQueue;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.selenium2.webclient.api.SeleniumTestingProvider;
import org.netbeans.modules.selenium2.webclient.api.SeleniumTestingProviders;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotificationLineSupport;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;

/**
 *
 * @author Theofanis Oikonomou
 */
public class SelectProviderPanel extends javax.swing.JPanel {

    // @GuardedBy("EDT")
    private DialogDescriptor dialogDescriptor;
    // @GuardedBy("EDT")
    private NotificationLineSupport notificationLineSupport;


    private SelectProviderPanel() {
        assert EventQueue.isDispatchThread();
        initComponents();
        init();
    }

    @CheckForNull
    public static SeleniumTestingProvider open() {
        return Mutex.EVENT.readAccess(new Mutex.Action<SeleniumTestingProvider>() {
            @Override
            public SeleniumTestingProvider run() {
                return openInternal();
            }
        });
    }

    @NbBundle.Messages("SelectProviderPanel.title=Select Testing Provider")
    static SeleniumTestingProvider openInternal() {
        assert EventQueue.isDispatchThread();
        final SelectProviderPanel panel = new SelectProviderPanel();
        panel.dialogDescriptor = new DialogDescriptor(
                panel,
                Bundle.SelectProviderPanel_title(),
                true,
                DialogDescriptor.OK_CANCEL_OPTION,
                DialogDescriptor.OK_OPTION,
                null);
        panel.notificationLineSupport = panel.dialogDescriptor.createNotificationLineSupport();
        panel.validateSelection();
        if (DialogDisplayer.getDefault().notify(panel.dialogDescriptor) == DialogDescriptor.OK_OPTION) {
            return panel.getSelectedProvider();
        }
        return null;
    }

    private void init() {
        for (SeleniumTestingProvider provider : SeleniumTestingProviders.getDefault().getSeleniumTestingProviders()) {
            providerComboBox.addItem(provider);
        }
        providerComboBox.setRenderer(new SeleniumTestingProviderRenderer());
    }

    private SeleniumTestingProvider getSelectedProvider() {
        assert EventQueue.isDispatchThread();
        return (SeleniumTestingProvider) providerComboBox.getSelectedItem();
    }

    @NbBundle.Messages("SelectProviderPanel.noneSelected=No provider selected.")
    void validateSelection() {
        assert EventQueue.isDispatchThread();
        assert dialogDescriptor != null;
        assert notificationLineSupport != null;

        if (getSelectedProvider() == null) {
            notificationLineSupport.setErrorMessage(Bundle.SelectProviderPanel_noneSelected());
            dialogDescriptor.setValid(false);
            return;
        }
        notificationLineSupport.clearMessages();
        dialogDescriptor.setValid(true);
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        providerLabel = new javax.swing.JLabel();
        providerComboBox = new javax.swing.JComboBox<SeleniumTestingProvider>();

        org.openide.awt.Mnemonics.setLocalizedText(providerLabel, org.openide.util.NbBundle.getMessage(SelectProviderPanel.class, "SelectProviderPanel.providerLabel.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(providerLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(providerComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(providerLabel)
                    .addComponent(providerComboBox, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
        );
    }// </editor-fold>//GEN-END:initComponents


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox<SeleniumTestingProvider> providerComboBox;
    private javax.swing.JLabel providerLabel;
    // End of variables declaration//GEN-END:variables
}
