
/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * RecordingVideoScalingMethod.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;

/**
Recording video scaling method enumeration.
Interface ID: <tt>{5576D890-48EE-449A-A81B-B776233598B7}</tt>
*/
public enum RecordingVideoScalingMethod
{

/**
No scaling performed.
*/
    None(0),

/**
Performs scaling via nearest-neighbor interpolation.
Not yet implemented.
*/
    NearestNeighbor(1),

/**
Performs scaling via bilinear interpolation.
Not yet implemented.
*/
    Bilinear(2),

/**
Performs scaling via bicubic interpolation.
Not yet implemented.
*/
    Bicubic(3);

    private final int value;

    RecordingVideoScalingMethod(int v)
    {
        value = v;
    }

    public int value()
    {
        return value;
    }

    public static RecordingVideoScalingMethod fromValue(long v)
    {
        for (RecordingVideoScalingMethod c: RecordingVideoScalingMethod.values())
        {
            if (c.value == (int)v)
            {
                return c;
            }
        }
        throw new IllegalArgumentException(Long.toString(v));
    }

    public static RecordingVideoScalingMethod fromValue(String v)
    {
        return valueOf(RecordingVideoScalingMethod.class, v);
    }
}

