
/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IGuestUserStateChangedEvent.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Notification when a guest user changed its state.

Interface ID: <tt>{39B4E759-1EC0-4C0F-857F-FBE2A737A256}</tt>
*/
public class IGuestUserStateChangedEvent extends IEvent
{

    public IGuestUserStateChangedEvent(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
Name of the guest user whose state changed.
@return String
*/
    public String getName()
    {
        try
        {
            String retVal = port.iGuestUserStateChangedEventGetName(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Name of the FQDN (fully qualified domain name) this user is bound
to. Optional.
@return String
*/
    public String getDomain()
    {
        try
        {
            String retVal = port.iGuestUserStateChangedEventGetDomain(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
What was changed for this guest user. See{@link org.virtualbox_6_1.GuestUserState}for
more information.
@return org.virtualbox_6_1.GuestUserState
*/
    public org.virtualbox_6_1.GuestUserState getState()
    {
        try
        {
            org.virtualbox_6_1.jaxws.GuestUserState retVal = port.iGuestUserStateChangedEventGetState(obj);
            return org.virtualbox_6_1.GuestUserState.fromValue(retVal.value());
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Optional state details, depending on the{@link #getState()}attribute.
@return String
*/
    public String getStateDetails()
    {
        try
        {
            String retVal = port.iGuestUserStateChangedEventGetStateDetails(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    public static IGuestUserStateChangedEvent queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IGuestUserStateChangedEvent(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
