/*
 * Decompiled with CFR 0.152.
 */
package org.virtualbox_6_1;

import java.util.List;
import org.virtualbox_6_1.Helper;
import org.virtualbox_6_1.Holder;
import org.virtualbox_6_1.IAppliance;
import org.virtualbox_6_1.ICloudNetwork;
import org.virtualbox_6_1.ICloudProviderManager;
import org.virtualbox_6_1.IDHCPServer;
import org.virtualbox_6_1.IEventSource;
import org.virtualbox_6_1.IHost;
import org.virtualbox_6_1.IMachine;
import org.virtualbox_6_1.IMedium;
import org.virtualbox_6_1.INATNetwork;
import org.virtualbox_6_1.IPerformanceCollector;
import org.virtualbox_6_1.IProgress;
import org.virtualbox_6_1.ISharedFolder;
import org.virtualbox_6_1.ISystemProperties;
import org.virtualbox_6_1.IUnattended;
import org.virtualbox_6_1.IUnknown;
import org.virtualbox_6_1.MachineState;
import org.virtualbox_6_1.ObjectRefManager;
import org.virtualbox_6_1.VBoxException;
import org.virtualbox_6_1.jaxws.AccessMode;
import org.virtualbox_6_1.jaxws.DeviceType;
import org.virtualbox_6_1.jaxws.FirmwareType;
import org.virtualbox_6_1.jaxws.IGuestOSType;
import org.virtualbox_6_1.jaxws.InvalidObjectFaultMsg;
import org.virtualbox_6_1.jaxws.RuntimeFaultMsg;
import org.virtualbox_6_1.jaxws.VboxPortType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IVirtualBox
extends IUnknown {
    public IVirtualBox(String string, ObjectRefManager objectRefManager, VboxPortType vboxPortType) {
        super(string, objectRefManager, vboxPortType);
    }

    public String getVersion() {
        try {
            String string = this.port.iVirtualBoxGetVersion(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public String getVersionNormalized() {
        try {
            String string = this.port.iVirtualBoxGetVersionNormalized(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getRevision() {
        try {
            Long l = this.port.iVirtualBoxGetRevision(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public String getPackageType() {
        try {
            String string = this.port.iVirtualBoxGetPackageType(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public String getAPIVersion() {
        try {
            String string = this.port.iVirtualBoxGetAPIVersion(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Long getAPIRevision() {
        try {
            Long l = this.port.iVirtualBoxGetAPIRevision(this.obj);
            return l;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public String getHomeFolder() {
        try {
            String string = this.port.iVirtualBoxGetHomeFolder(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public String getSettingsFilePath() {
        try {
            String string = this.port.iVirtualBoxGetSettingsFilePath(this.obj);
            return string;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public IHost getHost() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iVirtualBoxGetHost(this.obj);
            IHost iHost = string.length() > 0 ? new IHost(string, this.getObjMgr(), this.port) : null;
            return iHost;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public ISystemProperties getSystemProperties() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iVirtualBoxGetSystemProperties(this.obj);
            ISystemProperties iSystemProperties = string.length() > 0 ? new ISystemProperties(string, this.getObjMgr(), this.port) : null;
            return iSystemProperties;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<IMachine> getMachines() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iVirtualBoxGetMachines(this.obj);
            List<IMachine> list2 = Helper.wrap(IMachine.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<String> getMachineGroups() {
        try {
            List<String> list = this.port.iVirtualBoxGetMachineGroups(this.obj);
            return list;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<IMedium> getHardDisks() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iVirtualBoxGetHardDisks(this.obj);
            List<IMedium> list2 = Helper.wrap(IMedium.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<IMedium> getDVDImages() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iVirtualBoxGetDVDImages(this.obj);
            List<IMedium> list2 = Helper.wrap(IMedium.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<IMedium> getFloppyImages() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iVirtualBoxGetFloppyImages(this.obj);
            List<IMedium> list2 = Helper.wrap(IMedium.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<IProgress> getProgressOperations() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iVirtualBoxGetProgressOperations(this.obj);
            List<IProgress> list2 = Helper.wrap(IProgress.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<org.virtualbox_6_1.IGuestOSType> getGuestOSTypes() {
        this.getObjMgr().preventObjRelease();
        try {
            List<IGuestOSType> list = this.port.iVirtualBoxGetGuestOSTypes(this.obj);
            List<org.virtualbox_6_1.IGuestOSType> list2 = Helper.wrap2(org.virtualbox_6_1.IGuestOSType.class, IGuestOSType.class, this.objMgr, this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<ISharedFolder> getSharedFolders() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iVirtualBoxGetSharedFolders(this.obj);
            List<ISharedFolder> list2 = Helper.wrap(ISharedFolder.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public IPerformanceCollector getPerformanceCollector() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iVirtualBoxGetPerformanceCollector(this.obj);
            IPerformanceCollector iPerformanceCollector = string.length() > 0 ? new IPerformanceCollector(string, this.getObjMgr(), this.port) : null;
            return iPerformanceCollector;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<IDHCPServer> getDHCPServers() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iVirtualBoxGetDHCPServers(this.obj);
            List<IDHCPServer> list2 = Helper.wrap(IDHCPServer.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<INATNetwork> getNATNetworks() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iVirtualBoxGetNATNetworks(this.obj);
            List<INATNetwork> list2 = Helper.wrap(INATNetwork.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public IEventSource getEventSource() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iVirtualBoxGetEventSource(this.obj);
            IEventSource iEventSource = string.length() > 0 ? new IEventSource(string, this.getObjMgr(), this.port) : null;
            return iEventSource;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<String> getInternalNetworks() {
        try {
            List<String> list = this.port.iVirtualBoxGetInternalNetworks(this.obj);
            return list;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<String> getGenericNetworkDrivers() {
        try {
            List<String> list = this.port.iVirtualBoxGetGenericNetworkDrivers(this.obj);
            return list;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<ICloudNetwork> getCloudNetworks() {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list = this.port.iVirtualBoxGetCloudNetworks(this.obj);
            List<ICloudNetwork> list2 = Helper.wrap(ICloudNetwork.class, this.getObjMgr(), this.port, list);
            return list2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public ICloudProviderManager getCloudProviderManager() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iVirtualBoxGetCloudProviderManager(this.obj);
            ICloudProviderManager iCloudProviderManager = string.length() > 0 ? new ICloudProviderManager(string, this.getObjMgr(), this.port) : null;
            return iCloudProviderManager;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public static IVirtualBox queryInterface(IUnknown iUnknown) {
        return iUnknown == null ? null : new IVirtualBox(iUnknown.getWrapped(), iUnknown.getObjMgr(), iUnknown.getRemoteWSPort());
    }

    public String composeMachineFilename(String string, String string2, String string3, String string4) {
        try {
            String string5 = this.port.iVirtualBoxComposeMachineFilename(this.obj, string, string2, string3, string4);
            return string5;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public IMachine createMachine(String string, String string2, List<String> list, String string3, String string4) {
        this.getObjMgr().preventObjRelease();
        try {
            String string5 = this.port.iVirtualBoxCreateMachine(this.obj, string, string2, list, string3, string4);
            IMachine iMachine = string5.length() > 0 ? new IMachine(string5, this.getObjMgr(), this.port) : null;
            return iMachine;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public IMachine openMachine(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iVirtualBoxOpenMachine(this.obj, string);
            IMachine iMachine = string2.length() > 0 ? new IMachine(string2, this.getObjMgr(), this.port) : null;
            return iMachine;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public void registerMachine(IMachine iMachine) {
        try {
            this.port.iVirtualBoxRegisterMachine(this.obj, iMachine == null ? null : iMachine.getWrapped());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public IMachine findMachine(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iVirtualBoxFindMachine(this.obj, string);
            IMachine iMachine = string2.length() > 0 ? new IMachine(string2, this.getObjMgr(), this.port) : null;
            return iMachine;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<IMachine> getMachinesByGroups(List<String> list) {
        this.getObjMgr().preventObjRelease();
        try {
            List<String> list2 = this.port.iVirtualBoxGetMachinesByGroups(this.obj, list);
            List<IMachine> list3 = Helper.wrap(IMachine.class, this.getObjMgr(), this.port, list2);
            return list3;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public List<MachineState> getMachineStates(List<IMachine> list) {
        try {
            List<org.virtualbox_6_1.jaxws.MachineState> list2 = this.port.iVirtualBoxGetMachineStates(this.obj, Helper.unwrap(list));
            return Helper.convertEnums(org.virtualbox_6_1.jaxws.MachineState.class, MachineState.class, list2);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public IAppliance createAppliance() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iVirtualBoxCreateAppliance(this.obj);
            IAppliance iAppliance = string.length() > 0 ? new IAppliance(string, this.getObjMgr(), this.port) : null;
            return iAppliance;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public IUnattended createUnattendedInstaller() {
        this.getObjMgr().preventObjRelease();
        try {
            String string = this.port.iVirtualBoxCreateUnattendedInstaller(this.obj);
            IUnattended iUnattended = string.length() > 0 ? new IUnattended(string, this.getObjMgr(), this.port) : null;
            return iUnattended;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public IMedium createMedium(String string, String string2, org.virtualbox_6_1.AccessMode accessMode, org.virtualbox_6_1.DeviceType deviceType) {
        this.getObjMgr().preventObjRelease();
        try {
            String string3 = this.port.iVirtualBoxCreateMedium(this.obj, string, string2, AccessMode.fromValue(accessMode.name()), DeviceType.fromValue(deviceType.name()));
            IMedium iMedium = string3.length() > 0 ? new IMedium(string3, this.getObjMgr(), this.port) : null;
            return iMedium;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public IMedium openMedium(String string, org.virtualbox_6_1.DeviceType deviceType, org.virtualbox_6_1.AccessMode accessMode, Boolean bl) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iVirtualBoxOpenMedium(this.obj, string, DeviceType.fromValue(deviceType.name()), AccessMode.fromValue(accessMode.name()), bl);
            IMedium iMedium = string2.length() > 0 ? new IMedium(string2, this.getObjMgr(), this.port) : null;
            return iMedium;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public org.virtualbox_6_1.IGuestOSType getGuestOSType(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            IGuestOSType iGuestOSType = this.port.iVirtualBoxGetGuestOSType(this.obj, string);
            org.virtualbox_6_1.IGuestOSType iGuestOSType2 = iGuestOSType != null ? new org.virtualbox_6_1.IGuestOSType(iGuestOSType, this.getObjMgr(), this.port) : null;
            return iGuestOSType2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public void createSharedFolder(String string, String string2, Boolean bl, Boolean bl2, String string3) {
        try {
            this.port.iVirtualBoxCreateSharedFolder(this.obj, string, string2, bl, bl2, string3);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public void removeSharedFolder(String string) {
        try {
            this.port.iVirtualBoxRemoveSharedFolder(this.obj, string);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public List<String> getExtraDataKeys() {
        try {
            List<String> list = this.port.iVirtualBoxGetExtraDataKeys(this.obj);
            return list;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public String getExtraData(String string) {
        try {
            String string2 = this.port.iVirtualBoxGetExtraData(this.obj, string);
            return string2;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public void setExtraData(String string, String string2) {
        try {
            this.port.iVirtualBoxSetExtraData(this.obj, string, string2);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public void setSettingsSecret(String string) {
        try {
            this.port.iVirtualBoxSetSettingsSecret(this.obj, string);
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public IDHCPServer createDHCPServer(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iVirtualBoxCreateDHCPServer(this.obj, string);
            IDHCPServer iDHCPServer = string2.length() > 0 ? new IDHCPServer(string2, this.getObjMgr(), this.port) : null;
            return iDHCPServer;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public IDHCPServer findDHCPServerByNetworkName(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iVirtualBoxFindDHCPServerByNetworkName(this.obj, string);
            IDHCPServer iDHCPServer = string2.length() > 0 ? new IDHCPServer(string2, this.getObjMgr(), this.port) : null;
            return iDHCPServer;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public void removeDHCPServer(IDHCPServer iDHCPServer) {
        try {
            this.port.iVirtualBoxRemoveDHCPServer(this.obj, iDHCPServer == null ? null : iDHCPServer.getWrapped());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public INATNetwork createNATNetwork(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iVirtualBoxCreateNATNetwork(this.obj, string);
            INATNetwork iNATNetwork = string2.length() > 0 ? new INATNetwork(string2, this.getObjMgr(), this.port) : null;
            return iNATNetwork;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public INATNetwork findNATNetworkByName(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iVirtualBoxFindNATNetworkByName(this.obj, string);
            INATNetwork iNATNetwork = string2.length() > 0 ? new INATNetwork(string2, this.getObjMgr(), this.port) : null;
            return iNATNetwork;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public void removeNATNetwork(INATNetwork iNATNetwork) {
        try {
            this.port.iVirtualBoxRemoveNATNetwork(this.obj, iNATNetwork == null ? null : iNATNetwork.getWrapped());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public ICloudNetwork createCloudNetwork(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iVirtualBoxCreateCloudNetwork(this.obj, string);
            ICloudNetwork iCloudNetwork = string2.length() > 0 ? new ICloudNetwork(string2, this.getObjMgr(), this.port) : null;
            return iCloudNetwork;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public ICloudNetwork findCloudNetworkByName(String string) {
        this.getObjMgr().preventObjRelease();
        try {
            String string2 = this.port.iVirtualBoxFindCloudNetworkByName(this.obj, string);
            ICloudNetwork iCloudNetwork = string2.length() > 0 ? new ICloudNetwork(string2, this.getObjMgr(), this.port) : null;
            return iCloudNetwork;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
        finally {
            this.getObjMgr().allowObjRelease();
        }
    }

    public void removeCloudNetwork(ICloudNetwork iCloudNetwork) {
        try {
            this.port.iVirtualBoxRemoveCloudNetwork(this.obj, iCloudNetwork == null ? null : iCloudNetwork.getWrapped());
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }

    public Boolean checkFirmwarePresent(org.virtualbox_6_1.FirmwareType firmwareType, String string, Holder<String> holder, Holder<String> holder2) {
        try {
            javax.xml.ws.Holder holder3 = new javax.xml.ws.Holder();
            javax.xml.ws.Holder holder4 = new javax.xml.ws.Holder();
            javax.xml.ws.Holder holder5 = new javax.xml.ws.Holder();
            this.port.iVirtualBoxCheckFirmwarePresent(this.obj, FirmwareType.fromValue(firmwareType.name()), string, (javax.xml.ws.Holder<String>)holder3, (javax.xml.ws.Holder<String>)holder4, (javax.xml.ws.Holder<Boolean>)holder5);
            holder.value = holder3.value;
            holder2.value = holder4.value;
            return (Boolean)holder5.value;
        }
        catch (InvalidObjectFaultMsg invalidObjectFaultMsg) {
            throw new VBoxException(invalidObjectFaultMsg.getMessage(), (Throwable)invalidObjectFaultMsg, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg runtimeFaultMsg) {
            throw new VBoxException(runtimeFaultMsg.getMessage(), (Throwable)runtimeFaultMsg, this.getObjMgr(), this.port);
        }
    }
}

