
/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IExtraDataCanChangeEvent.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
Notification when someone tries to change extra data for
either the given machine or (if  null) global extra data.
This gives the chance to veto against changes.

Interface ID: <tt>{245D88BD-800A-40F8-87A6-170D02249A55}</tt>
*/
public class IExtraDataCanChangeEvent extends IVetoEvent
{

    public IExtraDataCanChangeEvent(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
ID of the machine this event relates to.
Null for global extra data changes.
@return String
*/
    public String getMachineId()
    {
        try
        {
            String retVal = port.iExtraDataCanChangeEventGetMachineId(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Extra data key that has changed.
@return String
*/
    public String getKey()
    {
        try
        {
            String retVal = port.iExtraDataCanChangeEventGetKey(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
Extra data value for the given key.
@return String
*/
    public String getValue()
    {
        try
        {
            String retVal = port.iExtraDataCanChangeEventGetValue(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    public static IExtraDataCanChangeEvent queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IExtraDataCanChangeEvent(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
