
/*
 * Copyright (C) 2010-2020 Oracle Corporation
 *
 * This file is part of the VirtualBox SDK, as available from
 * http://www.virtualbox.org.  This library is free software; you can
 * redistribute it and/or modify it under the terms of the GNU Lesser General
 * Public License as published by the Free Software Foundation, in version 2.1
 * as it comes in the "COPYING.LIB" file of the VirtualBox SDK distribution.
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public
 * License for more details.
 *
 * IGuestAdditionsStatusChangedEvent.java
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl (VirtualBox's interface definitions in XML)
 * Generator: src/VBox/Main/glue/glue-java.xsl
 */

package org.virtualbox_6_1;

import org.virtualbox_6_1.jaxws.*;
import javax.xml.ws.*;
import java.util.List;


/**
The guest addition status changed.

Interface ID: <tt>{A443DA5B-AA82-4720-BC84-BD097B2B13B8}</tt>
*/
public class IGuestAdditionsStatusChangedEvent extends IEvent
{

    public IGuestAdditionsStatusChangedEvent(String wrapped, ObjectRefManager objMgr, VboxPortType port)
    {
        super(wrapped, objMgr, port);
    }

/**
Facility this event relates to.
@return org.virtualbox_6_1.AdditionsFacilityType
*/
    public org.virtualbox_6_1.AdditionsFacilityType getFacility()
    {
        try
        {
            org.virtualbox_6_1.jaxws.AdditionsFacilityType retVal = port.iGuestAdditionsStatusChangedEventGetFacility(obj);
            return org.virtualbox_6_1.AdditionsFacilityType.fromValue(retVal.value());
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
The new facility status.
@return org.virtualbox_6_1.AdditionsFacilityStatus
*/
    public org.virtualbox_6_1.AdditionsFacilityStatus getStatus()
    {
        try
        {
            org.virtualbox_6_1.jaxws.AdditionsFacilityStatus retVal = port.iGuestAdditionsStatusChangedEventGetStatus(obj);
            return org.virtualbox_6_1.AdditionsFacilityStatus.fromValue(retVal.value());
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
The new run level.
@return org.virtualbox_6_1.AdditionsRunLevelType
*/
    public org.virtualbox_6_1.AdditionsRunLevelType getRunLevel()
    {
        try
        {
            org.virtualbox_6_1.jaxws.AdditionsRunLevelType retVal = port.iGuestAdditionsStatusChangedEventGetRunLevel(obj);
            return org.virtualbox_6_1.AdditionsRunLevelType.fromValue(retVal.value());
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }

/**
The millisecond timestamp associated with the event.
@return Long
*/
    public Long getTimestamp()
    {
        try
        {
            Long retVal = port.iGuestAdditionsStatusChangedEventGetTimestamp(obj);
            return retVal;
        }
        catch (InvalidObjectFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
        catch (RuntimeFaultMsg e)
        {
            throw new VBoxException(e.getMessage(), e, this.getObjMgr(), this.port);
        }
    }
    public static IGuestAdditionsStatusChangedEvent queryInterface(IUnknown obj)
    {
        return obj == null ?  null : new IGuestAdditionsStatusChangedEvent(obj.getWrapped(), obj.getObjMgr(), obj.getRemoteWSPort());
    }
}
