/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.painter;

import java.awt.Shape;
import java.awt.image.BufferedImage;
import org.jvnet.substance.color.ColorScheme;
import org.jvnet.substance.color.MixColorScheme;
import org.jvnet.substance.painter.SubstanceGradientPainter;
import org.jvnet.substance.utils.SubstanceCoreUtilities;

public abstract class BaseGradientPainter
implements SubstanceGradientPainter {
    protected BufferedImage getMixContourBackground(int width, int height, Shape contour, boolean isFocused, ColorScheme colorScheme1, ColorScheme colorScheme2, float cyclePos, boolean hasShine, boolean useCyclePosAsInterpolation) {
        if (colorScheme1 instanceof MixColorScheme) {
            MixColorScheme mixColorScheme = (MixColorScheme)colorScheme1;
            ColorScheme[] origSchemes = mixColorScheme.getOrigSchemes();
            BufferedImage[] components = new BufferedImage[origSchemes.length];
            for (int i = 0; i < origSchemes.length; ++i) {
                components[i] = this.getContourBackground(width, height, contour, isFocused, origSchemes[i], colorScheme2, cyclePos, hasShine, useCyclePosAsInterpolation);
            }
            BufferedImage current = components[0];
            for (int i = 1; i < components.length; ++i) {
                double start = ((double)i - 0.3) / (double)components.length;
                double end = ((double)i + 0.3) / (double)components.length;
                current = SubstanceCoreUtilities.blendImagesHorizontal(current, components[i], start, end);
            }
            return current;
        }
        if (colorScheme2 instanceof MixColorScheme) {
            MixColorScheme mixColorScheme = (MixColorScheme)colorScheme2;
            ColorScheme[] origSchemes = mixColorScheme.getOrigSchemes();
            BufferedImage[] components = new BufferedImage[origSchemes.length];
            for (int i = 0; i < origSchemes.length; ++i) {
                components[i] = this.getContourBackground(width, height, contour, isFocused, colorScheme1, origSchemes[i], cyclePos, hasShine, useCyclePosAsInterpolation);
            }
            BufferedImage current = components[0];
            for (int i = 1; i < components.length; ++i) {
                double start = ((double)i - 0.3) / (double)components.length;
                double end = ((double)i + 0.3) / (double)components.length;
                current = SubstanceCoreUtilities.blendImagesHorizontal(current, components[i], start, end);
            }
            return current;
        }
        return null;
    }
}

