/*
 * Decompiled with CFR 0.152.
 */
package com.sun.image.codec.jpeg;

public class JPEGHuffmanTable {
    public static final JPEGHuffmanTable StdDCLuminance;
    public static final JPEGHuffmanTable StdDCChrominance;
    public static final JPEGHuffmanTable StdACLuminance;
    public static final JPEGHuffmanTable StdACChrominance;
    private short[] lengths;
    private short[] symbols;

    public JPEGHuffmanTable(short[] lengths, short[] symbols) {
        int a;
        if (lengths == null) {
            throw new IllegalArgumentException("lengths array can not be null.");
        }
        if (symbols == null) {
            throw new IllegalArgumentException("symbols array can not be null.");
        }
        if (lengths.length > 17) {
            throw new IllegalArgumentException("lengths array can not be longer than 17.");
        }
        if (symbols.length > 256) {
            throw new IllegalArgumentException("symbols array can not be longer than 256.");
        }
        for (a = 0; a < lengths.length; ++a) {
            if (lengths[a] >= 0) continue;
            throw new IllegalArgumentException("length " + a + " is smaller than zero.");
        }
        for (a = 0; a < symbols.length; ++a) {
            if (symbols[a] >= 0) continue;
            throw new IllegalArgumentException("symbol " + a + " is smaller than zero.");
        }
        this.lengths = lengths;
        this.symbols = symbols;
    }

    public short[] getLengths() {
        return this.lengths;
    }

    public short[] getSymbols() {
        return this.symbols;
    }

    static {
        javax.imageio.plugins.jpeg.JPEGHuffmanTable temp = javax.imageio.plugins.jpeg.JPEGHuffmanTable.StdDCLuminance;
        StdDCLuminance = new JPEGHuffmanTable(temp.getLengths(), temp.getValues());
        temp = javax.imageio.plugins.jpeg.JPEGHuffmanTable.StdDCChrominance;
        StdDCChrominance = new JPEGHuffmanTable(temp.getLengths(), temp.getValues());
        temp = javax.imageio.plugins.jpeg.JPEGHuffmanTable.StdACLuminance;
        StdACLuminance = new JPEGHuffmanTable(temp.getLengths(), temp.getValues());
        temp = javax.imageio.plugins.jpeg.JPEGHuffmanTable.StdACChrominance;
        StdACChrominance = new JPEGHuffmanTable(temp.getLengths(), temp.getValues());
    }
}

