//! This file is auto-generated by tools/gen_spirv_spec.zig.

const std = @import("std");

pub const Version = packed struct(Word) {
    padding: u8 = 0,
    minor: u8,
    major: u8,
    padding0: u8 = 0,

    pub fn toWord(self: @This()) Word {
        return @bitCast(self);
    }
};

pub const Word = u32;
pub const Id = enum(Word) {
    none,
    _,

    pub fn format(self: Id, writer: *std.io.Writer) std.io.Writer.Error!void {
        switch (self) {
            .none => try writer.writeAll("(none)"),
            else => try writer.print("%{d}", .{@intFromEnum(self)}),
        }
    }
};

pub const IdRange = struct {
    base: u32,
    len: u32,

    pub fn at(range: IdRange, i: usize) Id {
        std.debug.assert(i < range.len);
        return @enumFromInt(range.base + i);
    }
};

pub const LiteralInteger = Word;
pub const LiteralFloat = Word;
pub const LiteralString = []const u8;
pub const LiteralContextDependentNumber = union(enum) {
    int32: i32,
    uint32: u32,
    int64: i64,
    uint64: u64,
    float32: f32,
    float64: f64,
};
pub const LiteralExtInstInteger = struct { inst: Word };
pub const LiteralSpecConstantOpInteger = struct { opcode: Opcode };
pub const PairLiteralIntegerIdRef = struct { value: LiteralInteger, label: Id };
pub const PairIdRefLiteralInteger = struct { target: Id, member: LiteralInteger };
pub const PairIdRefIdRef = [2]Id;

pub const Quantifier = enum {
    required,
    optional,
    variadic,
};

pub const Operand = struct {
    kind: OperandKind,
    quantifier: Quantifier,
};

pub const OperandCategory = enum {
    bit_enum,
    value_enum,
    id,
    literal,
    composite,
};

pub const Enumerant = struct {
    name: []const u8,
    value: Word,
    parameters: []const OperandKind,
};

pub const Instruction = struct {
    name: []const u8,
    opcode: Word,
    operands: []const Operand,
};

pub const zig_generator_id: Word = 41;
pub const version: Version = .{ .major = 1, .minor = 6, .patch = 4 };
pub const magic_number: Word = 0x07230203;

pub const Class = enum {
    miscellaneous,
    debug,
    extension,
    mode_setting,
    type_declaration,
    constant_creation,
    function,
    memory,
    annotation,
    composite,
    image,
    conversion,
    arithmetic,
    relational_and_logical,
    bit,
    derivative,
    primitive,
    barrier,
    atomic,
    control_flow,
    group,
    pipe,
    device_side_enqueue,
    non_uniform,
    tensor,
    graph,
    reserved,
};

pub const OperandKind = enum {
    opcode,
    image_operands,
    fp_fast_math_mode,
    selection_control,
    loop_control,
    function_control,
    memory_semantics,
    memory_access,
    kernel_profiling_info,
    ray_flags,
    fragment_shading_rate,
    raw_access_chain_operands,
    source_language,
    execution_model,
    addressing_model,
    memory_model,
    execution_mode,
    storage_class,
    dim,
    sampler_addressing_mode,
    sampler_filter_mode,
    image_format,
    image_channel_order,
    image_channel_data_type,
    fp_rounding_mode,
    fp_denorm_mode,
    quantization_modes,
    fp_operation_mode,
    overflow_modes,
    linkage_type,
    access_qualifier,
    host_access_qualifier,
    function_parameter_attribute,
    decoration,
    built_in,
    scope,
    group_operation,
    kernel_enqueue_flags,
    capability,
    ray_query_intersection,
    ray_query_committed_intersection_type,
    ray_query_candidate_intersection_type,
    packed_vector_format,
    cooperative_matrix_operands,
    cooperative_matrix_layout,
    cooperative_matrix_use,
    cooperative_matrix_reduce,
    tensor_clamp_mode,
    tensor_addressing_operands,
    initialization_mode_qualifier,
    load_cache_control,
    store_cache_control,
    named_maximum_number_of_registers,
    matrix_multiply_accumulate_operands,
    fp_encoding,
    cooperative_vector_matrix_layout,
    component_type,
    id_result_type,
    id_result,
    id_memory_semantics,
    id_scope,
    id_ref,
    literal_integer,
    literal_string,
    literal_float,
    literal_context_dependent_number,
    literal_ext_inst_integer,
    literal_spec_constant_op_integer,
    pair_literal_integer_id_ref,
    pair_id_ref_literal_integer,
    pair_id_ref_id_ref,
    tensor_operands,

    pub fn category(self: OperandKind) OperandCategory {
        return switch (self) {
            .opcode => .literal,
            .image_operands => .bit_enum,
            .fp_fast_math_mode => .bit_enum,
            .selection_control => .bit_enum,
            .loop_control => .bit_enum,
            .function_control => .bit_enum,
            .memory_semantics => .bit_enum,
            .memory_access => .bit_enum,
            .kernel_profiling_info => .bit_enum,
            .ray_flags => .bit_enum,
            .fragment_shading_rate => .bit_enum,
            .raw_access_chain_operands => .bit_enum,
            .source_language => .value_enum,
            .execution_model => .value_enum,
            .addressing_model => .value_enum,
            .memory_model => .value_enum,
            .execution_mode => .value_enum,
            .storage_class => .value_enum,
            .dim => .value_enum,
            .sampler_addressing_mode => .value_enum,
            .sampler_filter_mode => .value_enum,
            .image_format => .value_enum,
            .image_channel_order => .value_enum,
            .image_channel_data_type => .value_enum,
            .fp_rounding_mode => .value_enum,
            .fp_denorm_mode => .value_enum,
            .quantization_modes => .value_enum,
            .fp_operation_mode => .value_enum,
            .overflow_modes => .value_enum,
            .linkage_type => .value_enum,
            .access_qualifier => .value_enum,
            .host_access_qualifier => .value_enum,
            .function_parameter_attribute => .value_enum,
            .decoration => .value_enum,
            .built_in => .value_enum,
            .scope => .value_enum,
            .group_operation => .value_enum,
            .kernel_enqueue_flags => .value_enum,
            .capability => .value_enum,
            .ray_query_intersection => .value_enum,
            .ray_query_committed_intersection_type => .value_enum,
            .ray_query_candidate_intersection_type => .value_enum,
            .packed_vector_format => .value_enum,
            .cooperative_matrix_operands => .bit_enum,
            .cooperative_matrix_layout => .value_enum,
            .cooperative_matrix_use => .value_enum,
            .cooperative_matrix_reduce => .bit_enum,
            .tensor_clamp_mode => .value_enum,
            .tensor_addressing_operands => .bit_enum,
            .initialization_mode_qualifier => .value_enum,
            .load_cache_control => .value_enum,
            .store_cache_control => .value_enum,
            .named_maximum_number_of_registers => .value_enum,
            .matrix_multiply_accumulate_operands => .bit_enum,
            .fp_encoding => .value_enum,
            .cooperative_vector_matrix_layout => .value_enum,
            .component_type => .value_enum,
            .id_result_type => .id,
            .id_result => .id,
            .id_memory_semantics => .id,
            .id_scope => .id,
            .id_ref => .id,
            .literal_integer => .literal,
            .literal_string => .literal,
            .literal_float => .literal,
            .literal_context_dependent_number => .literal,
            .literal_ext_inst_integer => .literal,
            .literal_spec_constant_op_integer => .literal,
            .pair_literal_integer_id_ref => .composite,
            .pair_id_ref_literal_integer => .composite,
            .pair_id_ref_id_ref => .composite,
            .tensor_operands => .bit_enum,
        };
    }
    pub fn enumerants(self: OperandKind) []const Enumerant {
        return switch (self) {
            .opcode => unreachable,
            .image_operands => &.{
                .{ .name = "Bias", .value = 0x0001, .parameters = &.{.id_ref} },
                .{ .name = "Lod", .value = 0x0002, .parameters = &.{.id_ref} },
                .{ .name = "Grad", .value = 0x0004, .parameters = &.{ .id_ref, .id_ref } },
                .{ .name = "ConstOffset", .value = 0x0008, .parameters = &.{.id_ref} },
                .{ .name = "Offset", .value = 0x0010, .parameters = &.{.id_ref} },
                .{ .name = "ConstOffsets", .value = 0x0020, .parameters = &.{.id_ref} },
                .{ .name = "Sample", .value = 0x0040, .parameters = &.{.id_ref} },
                .{ .name = "MinLod", .value = 0x0080, .parameters = &.{.id_ref} },
                .{ .name = "MakeTexelAvailable", .value = 0x0100, .parameters = &.{.id_scope} },
                .{ .name = "MakeTexelVisible", .value = 0x0200, .parameters = &.{.id_scope} },
                .{ .name = "NonPrivateTexel", .value = 0x0400, .parameters = &.{} },
                .{ .name = "VolatileTexel", .value = 0x0800, .parameters = &.{} },
                .{ .name = "SignExtend", .value = 0x1000, .parameters = &.{} },
                .{ .name = "ZeroExtend", .value = 0x2000, .parameters = &.{} },
                .{ .name = "Nontemporal", .value = 0x4000, .parameters = &.{} },
                .{ .name = "Offsets", .value = 0x10000, .parameters = &.{.id_ref} },
            },
            .fp_fast_math_mode => &.{
                .{ .name = "NotNaN", .value = 0x0001, .parameters = &.{} },
                .{ .name = "NotInf", .value = 0x0002, .parameters = &.{} },
                .{ .name = "NSZ", .value = 0x0004, .parameters = &.{} },
                .{ .name = "AllowRecip", .value = 0x0008, .parameters = &.{} },
                .{ .name = "Fast", .value = 0x0010, .parameters = &.{} },
                .{ .name = "AllowContract", .value = 0x10000, .parameters = &.{} },
                .{ .name = "AllowReassoc", .value = 0x20000, .parameters = &.{} },
                .{ .name = "AllowTransform", .value = 0x40000, .parameters = &.{} },
            },
            .selection_control => &.{
                .{ .name = "Flatten", .value = 0x0001, .parameters = &.{} },
                .{ .name = "DontFlatten", .value = 0x0002, .parameters = &.{} },
            },
            .loop_control => &.{
                .{ .name = "Unroll", .value = 0x0001, .parameters = &.{} },
                .{ .name = "DontUnroll", .value = 0x0002, .parameters = &.{} },
                .{ .name = "DependencyInfinite", .value = 0x0004, .parameters = &.{} },
                .{ .name = "DependencyLength", .value = 0x0008, .parameters = &.{.literal_integer} },
                .{ .name = "MinIterations", .value = 0x0010, .parameters = &.{.literal_integer} },
                .{ .name = "MaxIterations", .value = 0x0020, .parameters = &.{.literal_integer} },
                .{ .name = "IterationMultiple", .value = 0x0040, .parameters = &.{.literal_integer} },
                .{ .name = "PeelCount", .value = 0x0080, .parameters = &.{.literal_integer} },
                .{ .name = "PartialCount", .value = 0x0100, .parameters = &.{.literal_integer} },
                .{ .name = "InitiationIntervalINTEL", .value = 0x10000, .parameters = &.{.literal_integer} },
                .{ .name = "MaxConcurrencyINTEL", .value = 0x20000, .parameters = &.{.literal_integer} },
                .{ .name = "DependencyArrayINTEL", .value = 0x40000, .parameters = &.{.literal_integer} },
                .{ .name = "PipelineEnableINTEL", .value = 0x80000, .parameters = &.{.literal_integer} },
                .{ .name = "LoopCoalesceINTEL", .value = 0x100000, .parameters = &.{.literal_integer} },
                .{ .name = "MaxInterleavingINTEL", .value = 0x200000, .parameters = &.{.literal_integer} },
                .{ .name = "SpeculatedIterationsINTEL", .value = 0x400000, .parameters = &.{.literal_integer} },
                .{ .name = "NoFusionINTEL", .value = 0x800000, .parameters = &.{} },
                .{ .name = "LoopCountINTEL", .value = 0x1000000, .parameters = &.{.literal_integer} },
                .{ .name = "MaxReinvocationDelayINTEL", .value = 0x2000000, .parameters = &.{.literal_integer} },
            },
            .function_control => &.{
                .{ .name = "Inline", .value = 0x0001, .parameters = &.{} },
                .{ .name = "DontInline", .value = 0x0002, .parameters = &.{} },
                .{ .name = "Pure", .value = 0x0004, .parameters = &.{} },
                .{ .name = "Const", .value = 0x0008, .parameters = &.{} },
                .{ .name = "OptNoneEXT", .value = 0x10000, .parameters = &.{} },
            },
            .memory_semantics => &.{
                .{ .name = "Relaxed", .value = 0x0000, .parameters = &.{} },
                .{ .name = "Acquire", .value = 0x0002, .parameters = &.{} },
                .{ .name = "Release", .value = 0x0004, .parameters = &.{} },
                .{ .name = "AcquireRelease", .value = 0x0008, .parameters = &.{} },
                .{ .name = "SequentiallyConsistent", .value = 0x0010, .parameters = &.{} },
                .{ .name = "UniformMemory", .value = 0x0040, .parameters = &.{} },
                .{ .name = "SubgroupMemory", .value = 0x0080, .parameters = &.{} },
                .{ .name = "WorkgroupMemory", .value = 0x0100, .parameters = &.{} },
                .{ .name = "CrossWorkgroupMemory", .value = 0x0200, .parameters = &.{} },
                .{ .name = "AtomicCounterMemory", .value = 0x0400, .parameters = &.{} },
                .{ .name = "ImageMemory", .value = 0x0800, .parameters = &.{} },
                .{ .name = "OutputMemory", .value = 0x1000, .parameters = &.{} },
                .{ .name = "MakeAvailable", .value = 0x2000, .parameters = &.{} },
                .{ .name = "MakeVisible", .value = 0x4000, .parameters = &.{} },
                .{ .name = "Volatile", .value = 0x8000, .parameters = &.{} },
            },
            .memory_access => &.{
                .{ .name = "Volatile", .value = 0x0001, .parameters = &.{} },
                .{ .name = "Aligned", .value = 0x0002, .parameters = &.{.literal_integer} },
                .{ .name = "Nontemporal", .value = 0x0004, .parameters = &.{} },
                .{ .name = "MakePointerAvailable", .value = 0x0008, .parameters = &.{.id_scope} },
                .{ .name = "MakePointerVisible", .value = 0x0010, .parameters = &.{.id_scope} },
                .{ .name = "NonPrivatePointer", .value = 0x0020, .parameters = &.{} },
                .{ .name = "AliasScopeINTELMask", .value = 0x10000, .parameters = &.{.id_ref} },
                .{ .name = "NoAliasINTELMask", .value = 0x20000, .parameters = &.{.id_ref} },
            },
            .kernel_profiling_info => &.{
                .{ .name = "CmdExecTime", .value = 0x0001, .parameters = &.{} },
            },
            .ray_flags => &.{
                .{ .name = "NoneKHR", .value = 0x0000, .parameters = &.{} },
                .{ .name = "OpaqueKHR", .value = 0x0001, .parameters = &.{} },
                .{ .name = "NoOpaqueKHR", .value = 0x0002, .parameters = &.{} },
                .{ .name = "TerminateOnFirstHitKHR", .value = 0x0004, .parameters = &.{} },
                .{ .name = "SkipClosestHitShaderKHR", .value = 0x0008, .parameters = &.{} },
                .{ .name = "CullBackFacingTrianglesKHR", .value = 0x0010, .parameters = &.{} },
                .{ .name = "CullFrontFacingTrianglesKHR", .value = 0x0020, .parameters = &.{} },
                .{ .name = "CullOpaqueKHR", .value = 0x0040, .parameters = &.{} },
                .{ .name = "CullNoOpaqueKHR", .value = 0x0080, .parameters = &.{} },
                .{ .name = "SkipTrianglesKHR", .value = 0x0100, .parameters = &.{} },
                .{ .name = "SkipAABBsKHR", .value = 0x0200, .parameters = &.{} },
                .{ .name = "ForceOpacityMicromap2StateEXT", .value = 0x0400, .parameters = &.{} },
            },
            .fragment_shading_rate => &.{
                .{ .name = "Vertical2Pixels", .value = 0x0001, .parameters = &.{} },
                .{ .name = "Vertical4Pixels", .value = 0x0002, .parameters = &.{} },
                .{ .name = "Horizontal2Pixels", .value = 0x0004, .parameters = &.{} },
                .{ .name = "Horizontal4Pixels", .value = 0x0008, .parameters = &.{} },
            },
            .raw_access_chain_operands => &.{
                .{ .name = "RobustnessPerComponentNV", .value = 0x0001, .parameters = &.{} },
                .{ .name = "RobustnessPerElementNV", .value = 0x0002, .parameters = &.{} },
            },
            .source_language => &.{
                .{ .name = "Unknown", .value = 0, .parameters = &.{} },
                .{ .name = "ESSL", .value = 1, .parameters = &.{} },
                .{ .name = "GLSL", .value = 2, .parameters = &.{} },
                .{ .name = "OpenCL_C", .value = 3, .parameters = &.{} },
                .{ .name = "OpenCL_CPP", .value = 4, .parameters = &.{} },
                .{ .name = "HLSL", .value = 5, .parameters = &.{} },
                .{ .name = "CPP_for_OpenCL", .value = 6, .parameters = &.{} },
                .{ .name = "SYCL", .value = 7, .parameters = &.{} },
                .{ .name = "HERO_C", .value = 8, .parameters = &.{} },
                .{ .name = "NZSL", .value = 9, .parameters = &.{} },
                .{ .name = "WGSL", .value = 10, .parameters = &.{} },
                .{ .name = "Slang", .value = 11, .parameters = &.{} },
                .{ .name = "Zig", .value = 12, .parameters = &.{} },
                .{ .name = "Rust", .value = 13, .parameters = &.{} },
            },
            .execution_model => &.{
                .{ .name = "Vertex", .value = 0, .parameters = &.{} },
                .{ .name = "TessellationControl", .value = 1, .parameters = &.{} },
                .{ .name = "TessellationEvaluation", .value = 2, .parameters = &.{} },
                .{ .name = "Geometry", .value = 3, .parameters = &.{} },
                .{ .name = "Fragment", .value = 4, .parameters = &.{} },
                .{ .name = "GLCompute", .value = 5, .parameters = &.{} },
                .{ .name = "Kernel", .value = 6, .parameters = &.{} },
                .{ .name = "TaskNV", .value = 5267, .parameters = &.{} },
                .{ .name = "MeshNV", .value = 5268, .parameters = &.{} },
                .{ .name = "RayGenerationKHR", .value = 5313, .parameters = &.{} },
                .{ .name = "IntersectionKHR", .value = 5314, .parameters = &.{} },
                .{ .name = "AnyHitKHR", .value = 5315, .parameters = &.{} },
                .{ .name = "ClosestHitKHR", .value = 5316, .parameters = &.{} },
                .{ .name = "MissKHR", .value = 5317, .parameters = &.{} },
                .{ .name = "CallableKHR", .value = 5318, .parameters = &.{} },
                .{ .name = "TaskEXT", .value = 5364, .parameters = &.{} },
                .{ .name = "MeshEXT", .value = 5365, .parameters = &.{} },
            },
            .addressing_model => &.{
                .{ .name = "Logical", .value = 0, .parameters = &.{} },
                .{ .name = "Physical32", .value = 1, .parameters = &.{} },
                .{ .name = "Physical64", .value = 2, .parameters = &.{} },
                .{ .name = "PhysicalStorageBuffer64", .value = 5348, .parameters = &.{} },
            },
            .memory_model => &.{
                .{ .name = "Simple", .value = 0, .parameters = &.{} },
                .{ .name = "GLSL450", .value = 1, .parameters = &.{} },
                .{ .name = "OpenCL", .value = 2, .parameters = &.{} },
                .{ .name = "Vulkan", .value = 3, .parameters = &.{} },
            },
            .execution_mode => &.{
                .{ .name = "Invocations", .value = 0, .parameters = &.{.literal_integer} },
                .{ .name = "SpacingEqual", .value = 1, .parameters = &.{} },
                .{ .name = "SpacingFractionalEven", .value = 2, .parameters = &.{} },
                .{ .name = "SpacingFractionalOdd", .value = 3, .parameters = &.{} },
                .{ .name = "VertexOrderCw", .value = 4, .parameters = &.{} },
                .{ .name = "VertexOrderCcw", .value = 5, .parameters = &.{} },
                .{ .name = "PixelCenterInteger", .value = 6, .parameters = &.{} },
                .{ .name = "OriginUpperLeft", .value = 7, .parameters = &.{} },
                .{ .name = "OriginLowerLeft", .value = 8, .parameters = &.{} },
                .{ .name = "EarlyFragmentTests", .value = 9, .parameters = &.{} },
                .{ .name = "PointMode", .value = 10, .parameters = &.{} },
                .{ .name = "Xfb", .value = 11, .parameters = &.{} },
                .{ .name = "DepthReplacing", .value = 12, .parameters = &.{} },
                .{ .name = "DepthGreater", .value = 14, .parameters = &.{} },
                .{ .name = "DepthLess", .value = 15, .parameters = &.{} },
                .{ .name = "DepthUnchanged", .value = 16, .parameters = &.{} },
                .{ .name = "LocalSize", .value = 17, .parameters = &.{ .literal_integer, .literal_integer, .literal_integer } },
                .{ .name = "LocalSizeHint", .value = 18, .parameters = &.{ .literal_integer, .literal_integer, .literal_integer } },
                .{ .name = "InputPoints", .value = 19, .parameters = &.{} },
                .{ .name = "InputLines", .value = 20, .parameters = &.{} },
                .{ .name = "InputLinesAdjacency", .value = 21, .parameters = &.{} },
                .{ .name = "Triangles", .value = 22, .parameters = &.{} },
                .{ .name = "InputTrianglesAdjacency", .value = 23, .parameters = &.{} },
                .{ .name = "Quads", .value = 24, .parameters = &.{} },
                .{ .name = "Isolines", .value = 25, .parameters = &.{} },
                .{ .name = "OutputVertices", .value = 26, .parameters = &.{.literal_integer} },
                .{ .name = "OutputPoints", .value = 27, .parameters = &.{} },
                .{ .name = "OutputLineStrip", .value = 28, .parameters = &.{} },
                .{ .name = "OutputTriangleStrip", .value = 29, .parameters = &.{} },
                .{ .name = "VecTypeHint", .value = 30, .parameters = &.{.literal_integer} },
                .{ .name = "ContractionOff", .value = 31, .parameters = &.{} },
                .{ .name = "Initializer", .value = 33, .parameters = &.{} },
                .{ .name = "Finalizer", .value = 34, .parameters = &.{} },
                .{ .name = "SubgroupSize", .value = 35, .parameters = &.{.literal_integer} },
                .{ .name = "SubgroupsPerWorkgroup", .value = 36, .parameters = &.{.literal_integer} },
                .{ .name = "SubgroupsPerWorkgroupId", .value = 37, .parameters = &.{.id_ref} },
                .{ .name = "LocalSizeId", .value = 38, .parameters = &.{ .id_ref, .id_ref, .id_ref } },
                .{ .name = "LocalSizeHintId", .value = 39, .parameters = &.{ .id_ref, .id_ref, .id_ref } },
                .{ .name = "NonCoherentColorAttachmentReadEXT", .value = 4169, .parameters = &.{} },
                .{ .name = "NonCoherentDepthAttachmentReadEXT", .value = 4170, .parameters = &.{} },
                .{ .name = "NonCoherentStencilAttachmentReadEXT", .value = 4171, .parameters = &.{} },
                .{ .name = "SubgroupUniformControlFlowKHR", .value = 4421, .parameters = &.{} },
                .{ .name = "PostDepthCoverage", .value = 4446, .parameters = &.{} },
                .{ .name = "DenormPreserve", .value = 4459, .parameters = &.{.literal_integer} },
                .{ .name = "DenormFlushToZero", .value = 4460, .parameters = &.{.literal_integer} },
                .{ .name = "SignedZeroInfNanPreserve", .value = 4461, .parameters = &.{.literal_integer} },
                .{ .name = "RoundingModeRTE", .value = 4462, .parameters = &.{.literal_integer} },
                .{ .name = "RoundingModeRTZ", .value = 4463, .parameters = &.{.literal_integer} },
                .{ .name = "NonCoherentTileAttachmentReadQCOM", .value = 4489, .parameters = &.{} },
                .{ .name = "TileShadingRateQCOM", .value = 4490, .parameters = &.{ .literal_integer, .literal_integer, .literal_integer } },
                .{ .name = "EarlyAndLateFragmentTestsAMD", .value = 5017, .parameters = &.{} },
                .{ .name = "StencilRefReplacingEXT", .value = 5027, .parameters = &.{} },
                .{ .name = "CoalescingAMDX", .value = 5069, .parameters = &.{} },
                .{ .name = "IsApiEntryAMDX", .value = 5070, .parameters = &.{.id_ref} },
                .{ .name = "MaxNodeRecursionAMDX", .value = 5071, .parameters = &.{.id_ref} },
                .{ .name = "StaticNumWorkgroupsAMDX", .value = 5072, .parameters = &.{ .id_ref, .id_ref, .id_ref } },
                .{ .name = "ShaderIndexAMDX", .value = 5073, .parameters = &.{.id_ref} },
                .{ .name = "MaxNumWorkgroupsAMDX", .value = 5077, .parameters = &.{ .id_ref, .id_ref, .id_ref } },
                .{ .name = "StencilRefUnchangedFrontAMD", .value = 5079, .parameters = &.{} },
                .{ .name = "StencilRefGreaterFrontAMD", .value = 5080, .parameters = &.{} },
                .{ .name = "StencilRefLessFrontAMD", .value = 5081, .parameters = &.{} },
                .{ .name = "StencilRefUnchangedBackAMD", .value = 5082, .parameters = &.{} },
                .{ .name = "StencilRefGreaterBackAMD", .value = 5083, .parameters = &.{} },
                .{ .name = "StencilRefLessBackAMD", .value = 5084, .parameters = &.{} },
                .{ .name = "QuadDerivativesKHR", .value = 5088, .parameters = &.{} },
                .{ .name = "RequireFullQuadsKHR", .value = 5089, .parameters = &.{} },
                .{ .name = "SharesInputWithAMDX", .value = 5102, .parameters = &.{ .id_ref, .id_ref } },
                .{ .name = "OutputLinesEXT", .value = 5269, .parameters = &.{} },
                .{ .name = "OutputPrimitivesEXT", .value = 5270, .parameters = &.{.literal_integer} },
                .{ .name = "DerivativeGroupQuadsKHR", .value = 5289, .parameters = &.{} },
                .{ .name = "DerivativeGroupLinearKHR", .value = 5290, .parameters = &.{} },
                .{ .name = "OutputTrianglesEXT", .value = 5298, .parameters = &.{} },
                .{ .name = "PixelInterlockOrderedEXT", .value = 5366, .parameters = &.{} },
                .{ .name = "PixelInterlockUnorderedEXT", .value = 5367, .parameters = &.{} },
                .{ .name = "SampleInterlockOrderedEXT", .value = 5368, .parameters = &.{} },
                .{ .name = "SampleInterlockUnorderedEXT", .value = 5369, .parameters = &.{} },
                .{ .name = "ShadingRateInterlockOrderedEXT", .value = 5370, .parameters = &.{} },
                .{ .name = "ShadingRateInterlockUnorderedEXT", .value = 5371, .parameters = &.{} },
                .{ .name = "SharedLocalMemorySizeINTEL", .value = 5618, .parameters = &.{.literal_integer} },
                .{ .name = "RoundingModeRTPINTEL", .value = 5620, .parameters = &.{.literal_integer} },
                .{ .name = "RoundingModeRTNINTEL", .value = 5621, .parameters = &.{.literal_integer} },
                .{ .name = "FloatingPointModeALTINTEL", .value = 5622, .parameters = &.{.literal_integer} },
                .{ .name = "FloatingPointModeIEEEINTEL", .value = 5623, .parameters = &.{.literal_integer} },
                .{ .name = "MaxWorkgroupSizeINTEL", .value = 5893, .parameters = &.{ .literal_integer, .literal_integer, .literal_integer } },
                .{ .name = "MaxWorkDimINTEL", .value = 5894, .parameters = &.{.literal_integer} },
                .{ .name = "NoGlobalOffsetINTEL", .value = 5895, .parameters = &.{} },
                .{ .name = "NumSIMDWorkitemsINTEL", .value = 5896, .parameters = &.{.literal_integer} },
                .{ .name = "SchedulerTargetFmaxMhzINTEL", .value = 5903, .parameters = &.{.literal_integer} },
                .{ .name = "MaximallyReconvergesKHR", .value = 6023, .parameters = &.{} },
                .{ .name = "FPFastMathDefault", .value = 6028, .parameters = &.{ .id_ref, .id_ref } },
                .{ .name = "StreamingInterfaceINTEL", .value = 6154, .parameters = &.{.literal_integer} },
                .{ .name = "RegisterMapInterfaceINTEL", .value = 6160, .parameters = &.{.literal_integer} },
                .{ .name = "NamedBarrierCountINTEL", .value = 6417, .parameters = &.{.literal_integer} },
                .{ .name = "MaximumRegistersINTEL", .value = 6461, .parameters = &.{.literal_integer} },
                .{ .name = "MaximumRegistersIdINTEL", .value = 6462, .parameters = &.{.id_ref} },
                .{ .name = "NamedMaximumRegistersINTEL", .value = 6463, .parameters = &.{.named_maximum_number_of_registers} },
            },
            .storage_class => &.{
                .{ .name = "UniformConstant", .value = 0, .parameters = &.{} },
                .{ .name = "Input", .value = 1, .parameters = &.{} },
                .{ .name = "Uniform", .value = 2, .parameters = &.{} },
                .{ .name = "Output", .value = 3, .parameters = &.{} },
                .{ .name = "Workgroup", .value = 4, .parameters = &.{} },
                .{ .name = "CrossWorkgroup", .value = 5, .parameters = &.{} },
                .{ .name = "Private", .value = 6, .parameters = &.{} },
                .{ .name = "Function", .value = 7, .parameters = &.{} },
                .{ .name = "Generic", .value = 8, .parameters = &.{} },
                .{ .name = "PushConstant", .value = 9, .parameters = &.{} },
                .{ .name = "AtomicCounter", .value = 10, .parameters = &.{} },
                .{ .name = "Image", .value = 11, .parameters = &.{} },
                .{ .name = "StorageBuffer", .value = 12, .parameters = &.{} },
                .{ .name = "TileImageEXT", .value = 4172, .parameters = &.{} },
                .{ .name = "TileAttachmentQCOM", .value = 4491, .parameters = &.{} },
                .{ .name = "NodePayloadAMDX", .value = 5068, .parameters = &.{} },
                .{ .name = "CallableDataKHR", .value = 5328, .parameters = &.{} },
                .{ .name = "IncomingCallableDataKHR", .value = 5329, .parameters = &.{} },
                .{ .name = "RayPayloadKHR", .value = 5338, .parameters = &.{} },
                .{ .name = "HitAttributeKHR", .value = 5339, .parameters = &.{} },
                .{ .name = "IncomingRayPayloadKHR", .value = 5342, .parameters = &.{} },
                .{ .name = "ShaderRecordBufferKHR", .value = 5343, .parameters = &.{} },
                .{ .name = "PhysicalStorageBuffer", .value = 5349, .parameters = &.{} },
                .{ .name = "HitObjectAttributeNV", .value = 5385, .parameters = &.{} },
                .{ .name = "TaskPayloadWorkgroupEXT", .value = 5402, .parameters = &.{} },
                .{ .name = "CodeSectionINTEL", .value = 5605, .parameters = &.{} },
                .{ .name = "DeviceOnlyINTEL", .value = 5936, .parameters = &.{} },
                .{ .name = "HostOnlyINTEL", .value = 5937, .parameters = &.{} },
            },
            .dim => &.{
                .{ .name = "1D", .value = 0, .parameters = &.{} },
                .{ .name = "2D", .value = 1, .parameters = &.{} },
                .{ .name = "3D", .value = 2, .parameters = &.{} },
                .{ .name = "Cube", .value = 3, .parameters = &.{} },
                .{ .name = "Rect", .value = 4, .parameters = &.{} },
                .{ .name = "Buffer", .value = 5, .parameters = &.{} },
                .{ .name = "SubpassData", .value = 6, .parameters = &.{} },
                .{ .name = "TileImageDataEXT", .value = 4173, .parameters = &.{} },
            },
            .sampler_addressing_mode => &.{
                .{ .name = "None", .value = 0, .parameters = &.{} },
                .{ .name = "ClampToEdge", .value = 1, .parameters = &.{} },
                .{ .name = "Clamp", .value = 2, .parameters = &.{} },
                .{ .name = "Repeat", .value = 3, .parameters = &.{} },
                .{ .name = "RepeatMirrored", .value = 4, .parameters = &.{} },
            },
            .sampler_filter_mode => &.{
                .{ .name = "Nearest", .value = 0, .parameters = &.{} },
                .{ .name = "Linear", .value = 1, .parameters = &.{} },
            },
            .image_format => &.{
                .{ .name = "Unknown", .value = 0, .parameters = &.{} },
                .{ .name = "Rgba32f", .value = 1, .parameters = &.{} },
                .{ .name = "Rgba16f", .value = 2, .parameters = &.{} },
                .{ .name = "R32f", .value = 3, .parameters = &.{} },
                .{ .name = "Rgba8", .value = 4, .parameters = &.{} },
                .{ .name = "Rgba8Snorm", .value = 5, .parameters = &.{} },
                .{ .name = "Rg32f", .value = 6, .parameters = &.{} },
                .{ .name = "Rg16f", .value = 7, .parameters = &.{} },
                .{ .name = "R11fG11fB10f", .value = 8, .parameters = &.{} },
                .{ .name = "R16f", .value = 9, .parameters = &.{} },
                .{ .name = "Rgba16", .value = 10, .parameters = &.{} },
                .{ .name = "Rgb10A2", .value = 11, .parameters = &.{} },
                .{ .name = "Rg16", .value = 12, .parameters = &.{} },
                .{ .name = "Rg8", .value = 13, .parameters = &.{} },
                .{ .name = "R16", .value = 14, .parameters = &.{} },
                .{ .name = "R8", .value = 15, .parameters = &.{} },
                .{ .name = "Rgba16Snorm", .value = 16, .parameters = &.{} },
                .{ .name = "Rg16Snorm", .value = 17, .parameters = &.{} },
                .{ .name = "Rg8Snorm", .value = 18, .parameters = &.{} },
                .{ .name = "R16Snorm", .value = 19, .parameters = &.{} },
                .{ .name = "R8Snorm", .value = 20, .parameters = &.{} },
                .{ .name = "Rgba32i", .value = 21, .parameters = &.{} },
                .{ .name = "Rgba16i", .value = 22, .parameters = &.{} },
                .{ .name = "Rgba8i", .value = 23, .parameters = &.{} },
                .{ .name = "R32i", .value = 24, .parameters = &.{} },
                .{ .name = "Rg32i", .value = 25, .parameters = &.{} },
                .{ .name = "Rg16i", .value = 26, .parameters = &.{} },
                .{ .name = "Rg8i", .value = 27, .parameters = &.{} },
                .{ .name = "R16i", .value = 28, .parameters = &.{} },
                .{ .name = "R8i", .value = 29, .parameters = &.{} },
                .{ .name = "Rgba32ui", .value = 30, .parameters = &.{} },
                .{ .name = "Rgba16ui", .value = 31, .parameters = &.{} },
                .{ .name = "Rgba8ui", .value = 32, .parameters = &.{} },
                .{ .name = "R32ui", .value = 33, .parameters = &.{} },
                .{ .name = "Rgb10a2ui", .value = 34, .parameters = &.{} },
                .{ .name = "Rg32ui", .value = 35, .parameters = &.{} },
                .{ .name = "Rg16ui", .value = 36, .parameters = &.{} },
                .{ .name = "Rg8ui", .value = 37, .parameters = &.{} },
                .{ .name = "R16ui", .value = 38, .parameters = &.{} },
                .{ .name = "R8ui", .value = 39, .parameters = &.{} },
                .{ .name = "R64ui", .value = 40, .parameters = &.{} },
                .{ .name = "R64i", .value = 41, .parameters = &.{} },
            },
            .image_channel_order => &.{
                .{ .name = "R", .value = 0, .parameters = &.{} },
                .{ .name = "A", .value = 1, .parameters = &.{} },
                .{ .name = "RG", .value = 2, .parameters = &.{} },
                .{ .name = "RA", .value = 3, .parameters = &.{} },
                .{ .name = "RGB", .value = 4, .parameters = &.{} },
                .{ .name = "RGBA", .value = 5, .parameters = &.{} },
                .{ .name = "BGRA", .value = 6, .parameters = &.{} },
                .{ .name = "ARGB", .value = 7, .parameters = &.{} },
                .{ .name = "Intensity", .value = 8, .parameters = &.{} },
                .{ .name = "Luminance", .value = 9, .parameters = &.{} },
                .{ .name = "Rx", .value = 10, .parameters = &.{} },
                .{ .name = "RGx", .value = 11, .parameters = &.{} },
                .{ .name = "RGBx", .value = 12, .parameters = &.{} },
                .{ .name = "Depth", .value = 13, .parameters = &.{} },
                .{ .name = "DepthStencil", .value = 14, .parameters = &.{} },
                .{ .name = "sRGB", .value = 15, .parameters = &.{} },
                .{ .name = "sRGBx", .value = 16, .parameters = &.{} },
                .{ .name = "sRGBA", .value = 17, .parameters = &.{} },
                .{ .name = "sBGRA", .value = 18, .parameters = &.{} },
                .{ .name = "ABGR", .value = 19, .parameters = &.{} },
            },
            .image_channel_data_type => &.{
                .{ .name = "SnormInt8", .value = 0, .parameters = &.{} },
                .{ .name = "SnormInt16", .value = 1, .parameters = &.{} },
                .{ .name = "UnormInt8", .value = 2, .parameters = &.{} },
                .{ .name = "UnormInt16", .value = 3, .parameters = &.{} },
                .{ .name = "UnormShort565", .value = 4, .parameters = &.{} },
                .{ .name = "UnormShort555", .value = 5, .parameters = &.{} },
                .{ .name = "UnormInt101010", .value = 6, .parameters = &.{} },
                .{ .name = "SignedInt8", .value = 7, .parameters = &.{} },
                .{ .name = "SignedInt16", .value = 8, .parameters = &.{} },
                .{ .name = "SignedInt32", .value = 9, .parameters = &.{} },
                .{ .name = "UnsignedInt8", .value = 10, .parameters = &.{} },
                .{ .name = "UnsignedInt16", .value = 11, .parameters = &.{} },
                .{ .name = "UnsignedInt32", .value = 12, .parameters = &.{} },
                .{ .name = "HalfFloat", .value = 13, .parameters = &.{} },
                .{ .name = "Float", .value = 14, .parameters = &.{} },
                .{ .name = "UnormInt24", .value = 15, .parameters = &.{} },
                .{ .name = "UnormInt101010_2", .value = 16, .parameters = &.{} },
                .{ .name = "UnormInt10X6EXT", .value = 17, .parameters = &.{} },
                .{ .name = "UnsignedIntRaw10EXT", .value = 19, .parameters = &.{} },
                .{ .name = "UnsignedIntRaw12EXT", .value = 20, .parameters = &.{} },
                .{ .name = "UnormInt2_101010EXT", .value = 21, .parameters = &.{} },
                .{ .name = "UnsignedInt10X6EXT", .value = 22, .parameters = &.{} },
                .{ .name = "UnsignedInt12X4EXT", .value = 23, .parameters = &.{} },
                .{ .name = "UnsignedInt14X2EXT", .value = 24, .parameters = &.{} },
                .{ .name = "UnormInt12X4EXT", .value = 25, .parameters = &.{} },
                .{ .name = "UnormInt14X2EXT", .value = 26, .parameters = &.{} },
            },
            .fp_rounding_mode => &.{
                .{ .name = "RTE", .value = 0, .parameters = &.{} },
                .{ .name = "RTZ", .value = 1, .parameters = &.{} },
                .{ .name = "RTP", .value = 2, .parameters = &.{} },
                .{ .name = "RTN", .value = 3, .parameters = &.{} },
            },
            .fp_denorm_mode => &.{
                .{ .name = "Preserve", .value = 0, .parameters = &.{} },
                .{ .name = "FlushToZero", .value = 1, .parameters = &.{} },
            },
            .quantization_modes => &.{
                .{ .name = "TRN", .value = 0, .parameters = &.{} },
                .{ .name = "TRN_ZERO", .value = 1, .parameters = &.{} },
                .{ .name = "RND", .value = 2, .parameters = &.{} },
                .{ .name = "RND_ZERO", .value = 3, .parameters = &.{} },
                .{ .name = "RND_INF", .value = 4, .parameters = &.{} },
                .{ .name = "RND_MIN_INF", .value = 5, .parameters = &.{} },
                .{ .name = "RND_CONV", .value = 6, .parameters = &.{} },
                .{ .name = "RND_CONV_ODD", .value = 7, .parameters = &.{} },
            },
            .fp_operation_mode => &.{
                .{ .name = "IEEE", .value = 0, .parameters = &.{} },
                .{ .name = "ALT", .value = 1, .parameters = &.{} },
            },
            .overflow_modes => &.{
                .{ .name = "WRAP", .value = 0, .parameters = &.{} },
                .{ .name = "SAT", .value = 1, .parameters = &.{} },
                .{ .name = "SAT_ZERO", .value = 2, .parameters = &.{} },
                .{ .name = "SAT_SYM", .value = 3, .parameters = &.{} },
            },
            .linkage_type => &.{
                .{ .name = "Export", .value = 0, .parameters = &.{} },
                .{ .name = "Import", .value = 1, .parameters = &.{} },
                .{ .name = "LinkOnceODR", .value = 2, .parameters = &.{} },
            },
            .access_qualifier => &.{
                .{ .name = "ReadOnly", .value = 0, .parameters = &.{} },
                .{ .name = "WriteOnly", .value = 1, .parameters = &.{} },
                .{ .name = "ReadWrite", .value = 2, .parameters = &.{} },
            },
            .host_access_qualifier => &.{
                .{ .name = "NoneINTEL", .value = 0, .parameters = &.{} },
                .{ .name = "ReadINTEL", .value = 1, .parameters = &.{} },
                .{ .name = "WriteINTEL", .value = 2, .parameters = &.{} },
                .{ .name = "ReadWriteINTEL", .value = 3, .parameters = &.{} },
            },
            .function_parameter_attribute => &.{
                .{ .name = "Zext", .value = 0, .parameters = &.{} },
                .{ .name = "Sext", .value = 1, .parameters = &.{} },
                .{ .name = "ByVal", .value = 2, .parameters = &.{} },
                .{ .name = "Sret", .value = 3, .parameters = &.{} },
                .{ .name = "NoAlias", .value = 4, .parameters = &.{} },
                .{ .name = "NoCapture", .value = 5, .parameters = &.{} },
                .{ .name = "NoWrite", .value = 6, .parameters = &.{} },
                .{ .name = "NoReadWrite", .value = 7, .parameters = &.{} },
                .{ .name = "RuntimeAlignedINTEL", .value = 5940, .parameters = &.{} },
            },
            .decoration => &.{
                .{ .name = "RelaxedPrecision", .value = 0, .parameters = &.{} },
                .{ .name = "SpecId", .value = 1, .parameters = &.{.literal_integer} },
                .{ .name = "Block", .value = 2, .parameters = &.{} },
                .{ .name = "BufferBlock", .value = 3, .parameters = &.{} },
                .{ .name = "RowMajor", .value = 4, .parameters = &.{} },
                .{ .name = "ColMajor", .value = 5, .parameters = &.{} },
                .{ .name = "ArrayStride", .value = 6, .parameters = &.{.literal_integer} },
                .{ .name = "MatrixStride", .value = 7, .parameters = &.{.literal_integer} },
                .{ .name = "GLSLShared", .value = 8, .parameters = &.{} },
                .{ .name = "GLSLPacked", .value = 9, .parameters = &.{} },
                .{ .name = "CPacked", .value = 10, .parameters = &.{} },
                .{ .name = "BuiltIn", .value = 11, .parameters = &.{.built_in} },
                .{ .name = "NoPerspective", .value = 13, .parameters = &.{} },
                .{ .name = "Flat", .value = 14, .parameters = &.{} },
                .{ .name = "Patch", .value = 15, .parameters = &.{} },
                .{ .name = "Centroid", .value = 16, .parameters = &.{} },
                .{ .name = "Sample", .value = 17, .parameters = &.{} },
                .{ .name = "Invariant", .value = 18, .parameters = &.{} },
                .{ .name = "Restrict", .value = 19, .parameters = &.{} },
                .{ .name = "Aliased", .value = 20, .parameters = &.{} },
                .{ .name = "Volatile", .value = 21, .parameters = &.{} },
                .{ .name = "Constant", .value = 22, .parameters = &.{} },
                .{ .name = "Coherent", .value = 23, .parameters = &.{} },
                .{ .name = "NonWritable", .value = 24, .parameters = &.{} },
                .{ .name = "NonReadable", .value = 25, .parameters = &.{} },
                .{ .name = "Uniform", .value = 26, .parameters = &.{} },
                .{ .name = "UniformId", .value = 27, .parameters = &.{.id_scope} },
                .{ .name = "SaturatedConversion", .value = 28, .parameters = &.{} },
                .{ .name = "Stream", .value = 29, .parameters = &.{.literal_integer} },
                .{ .name = "Location", .value = 30, .parameters = &.{.literal_integer} },
                .{ .name = "Component", .value = 31, .parameters = &.{.literal_integer} },
                .{ .name = "Index", .value = 32, .parameters = &.{.literal_integer} },
                .{ .name = "Binding", .value = 33, .parameters = &.{.literal_integer} },
                .{ .name = "DescriptorSet", .value = 34, .parameters = &.{.literal_integer} },
                .{ .name = "Offset", .value = 35, .parameters = &.{.literal_integer} },
                .{ .name = "XfbBuffer", .value = 36, .parameters = &.{.literal_integer} },
                .{ .name = "XfbStride", .value = 37, .parameters = &.{.literal_integer} },
                .{ .name = "FuncParamAttr", .value = 38, .parameters = &.{.function_parameter_attribute} },
                .{ .name = "FPRoundingMode", .value = 39, .parameters = &.{.fp_rounding_mode} },
                .{ .name = "FPFastMathMode", .value = 40, .parameters = &.{.fp_fast_math_mode} },
                .{ .name = "LinkageAttributes", .value = 41, .parameters = &.{ .literal_string, .linkage_type } },
                .{ .name = "NoContraction", .value = 42, .parameters = &.{} },
                .{ .name = "InputAttachmentIndex", .value = 43, .parameters = &.{.literal_integer} },
                .{ .name = "Alignment", .value = 44, .parameters = &.{.literal_integer} },
                .{ .name = "MaxByteOffset", .value = 45, .parameters = &.{.literal_integer} },
                .{ .name = "AlignmentId", .value = 46, .parameters = &.{.id_ref} },
                .{ .name = "MaxByteOffsetId", .value = 47, .parameters = &.{.id_ref} },
                .{ .name = "SaturatedToLargestFloat8NormalConversionEXT", .value = 4216, .parameters = &.{} },
                .{ .name = "NoSignedWrap", .value = 4469, .parameters = &.{} },
                .{ .name = "NoUnsignedWrap", .value = 4470, .parameters = &.{} },
                .{ .name = "WeightTextureQCOM", .value = 4487, .parameters = &.{} },
                .{ .name = "BlockMatchTextureQCOM", .value = 4488, .parameters = &.{} },
                .{ .name = "BlockMatchSamplerQCOM", .value = 4499, .parameters = &.{} },
                .{ .name = "ExplicitInterpAMD", .value = 4999, .parameters = &.{} },
                .{ .name = "NodeSharesPayloadLimitsWithAMDX", .value = 5019, .parameters = &.{.id_ref} },
                .{ .name = "NodeMaxPayloadsAMDX", .value = 5020, .parameters = &.{.id_ref} },
                .{ .name = "TrackFinishWritingAMDX", .value = 5078, .parameters = &.{} },
                .{ .name = "PayloadNodeNameAMDX", .value = 5091, .parameters = &.{.id_ref} },
                .{ .name = "PayloadNodeBaseIndexAMDX", .value = 5098, .parameters = &.{.id_ref} },
                .{ .name = "PayloadNodeSparseArrayAMDX", .value = 5099, .parameters = &.{} },
                .{ .name = "PayloadNodeArraySizeAMDX", .value = 5100, .parameters = &.{.id_ref} },
                .{ .name = "PayloadDispatchIndirectAMDX", .value = 5105, .parameters = &.{} },
                .{ .name = "OverrideCoverageNV", .value = 5248, .parameters = &.{} },
                .{ .name = "PassthroughNV", .value = 5250, .parameters = &.{} },
                .{ .name = "ViewportRelativeNV", .value = 5252, .parameters = &.{} },
                .{ .name = "SecondaryViewportRelativeNV", .value = 5256, .parameters = &.{.literal_integer} },
                .{ .name = "PerPrimitiveEXT", .value = 5271, .parameters = &.{} },
                .{ .name = "PerViewNV", .value = 5272, .parameters = &.{} },
                .{ .name = "PerTaskNV", .value = 5273, .parameters = &.{} },
                .{ .name = "PerVertexKHR", .value = 5285, .parameters = &.{} },
                .{ .name = "NonUniform", .value = 5300, .parameters = &.{} },
                .{ .name = "RestrictPointer", .value = 5355, .parameters = &.{} },
                .{ .name = "AliasedPointer", .value = 5356, .parameters = &.{} },
                .{ .name = "HitObjectShaderRecordBufferNV", .value = 5386, .parameters = &.{} },
                .{ .name = "BindlessSamplerNV", .value = 5398, .parameters = &.{} },
                .{ .name = "BindlessImageNV", .value = 5399, .parameters = &.{} },
                .{ .name = "BoundSamplerNV", .value = 5400, .parameters = &.{} },
                .{ .name = "BoundImageNV", .value = 5401, .parameters = &.{} },
                .{ .name = "SIMTCallINTEL", .value = 5599, .parameters = &.{.literal_integer} },
                .{ .name = "ReferencedIndirectlyINTEL", .value = 5602, .parameters = &.{} },
                .{ .name = "ClobberINTEL", .value = 5607, .parameters = &.{.literal_string} },
                .{ .name = "SideEffectsINTEL", .value = 5608, .parameters = &.{} },
                .{ .name = "VectorComputeVariableINTEL", .value = 5624, .parameters = &.{} },
                .{ .name = "FuncParamIOKindINTEL", .value = 5625, .parameters = &.{.literal_integer} },
                .{ .name = "VectorComputeFunctionINTEL", .value = 5626, .parameters = &.{} },
                .{ .name = "StackCallINTEL", .value = 5627, .parameters = &.{} },
                .{ .name = "GlobalVariableOffsetINTEL", .value = 5628, .parameters = &.{.literal_integer} },
                .{ .name = "CounterBuffer", .value = 5634, .parameters = &.{.id_ref} },
                .{ .name = "UserSemantic", .value = 5635, .parameters = &.{.literal_string} },
                .{ .name = "UserTypeGOOGLE", .value = 5636, .parameters = &.{.literal_string} },
                .{ .name = "FunctionRoundingModeINTEL", .value = 5822, .parameters = &.{ .literal_integer, .fp_rounding_mode } },
                .{ .name = "FunctionDenormModeINTEL", .value = 5823, .parameters = &.{ .literal_integer, .fp_denorm_mode } },
                .{ .name = "RegisterINTEL", .value = 5825, .parameters = &.{} },
                .{ .name = "MemoryINTEL", .value = 5826, .parameters = &.{.literal_string} },
                .{ .name = "NumbanksINTEL", .value = 5827, .parameters = &.{.literal_integer} },
                .{ .name = "BankwidthINTEL", .value = 5828, .parameters = &.{.literal_integer} },
                .{ .name = "MaxPrivateCopiesINTEL", .value = 5829, .parameters = &.{.literal_integer} },
                .{ .name = "SinglepumpINTEL", .value = 5830, .parameters = &.{} },
                .{ .name = "DoublepumpINTEL", .value = 5831, .parameters = &.{} },
                .{ .name = "MaxReplicatesINTEL", .value = 5832, .parameters = &.{.literal_integer} },
                .{ .name = "SimpleDualPortINTEL", .value = 5833, .parameters = &.{} },
                .{ .name = "MergeINTEL", .value = 5834, .parameters = &.{ .literal_string, .literal_string } },
                .{ .name = "BankBitsINTEL", .value = 5835, .parameters = &.{.literal_integer} },
                .{ .name = "ForcePow2DepthINTEL", .value = 5836, .parameters = &.{.literal_integer} },
                .{ .name = "StridesizeINTEL", .value = 5883, .parameters = &.{.literal_integer} },
                .{ .name = "WordsizeINTEL", .value = 5884, .parameters = &.{.literal_integer} },
                .{ .name = "TrueDualPortINTEL", .value = 5885, .parameters = &.{} },
                .{ .name = "BurstCoalesceINTEL", .value = 5899, .parameters = &.{} },
                .{ .name = "CacheSizeINTEL", .value = 5900, .parameters = &.{.literal_integer} },
                .{ .name = "DontStaticallyCoalesceINTEL", .value = 5901, .parameters = &.{} },
                .{ .name = "PrefetchINTEL", .value = 5902, .parameters = &.{.literal_integer} },
                .{ .name = "StallEnableINTEL", .value = 5905, .parameters = &.{} },
                .{ .name = "FuseLoopsInFunctionINTEL", .value = 5907, .parameters = &.{} },
                .{ .name = "MathOpDSPModeINTEL", .value = 5909, .parameters = &.{ .literal_integer, .literal_integer } },
                .{ .name = "AliasScopeINTEL", .value = 5914, .parameters = &.{.id_ref} },
                .{ .name = "NoAliasINTEL", .value = 5915, .parameters = &.{.id_ref} },
                .{ .name = "InitiationIntervalINTEL", .value = 5917, .parameters = &.{.literal_integer} },
                .{ .name = "MaxConcurrencyINTEL", .value = 5918, .parameters = &.{.literal_integer} },
                .{ .name = "PipelineEnableINTEL", .value = 5919, .parameters = &.{.literal_integer} },
                .{ .name = "BufferLocationINTEL", .value = 5921, .parameters = &.{.literal_integer} },
                .{ .name = "IOPipeStorageINTEL", .value = 5944, .parameters = &.{.literal_integer} },
                .{ .name = "FunctionFloatingPointModeINTEL", .value = 6080, .parameters = &.{ .literal_integer, .fp_operation_mode } },
                .{ .name = "SingleElementVectorINTEL", .value = 6085, .parameters = &.{} },
                .{ .name = "VectorComputeCallableFunctionINTEL", .value = 6087, .parameters = &.{} },
                .{ .name = "MediaBlockIOINTEL", .value = 6140, .parameters = &.{} },
                .{ .name = "StallFreeINTEL", .value = 6151, .parameters = &.{} },
                .{ .name = "FPMaxErrorDecorationINTEL", .value = 6170, .parameters = &.{.literal_float} },
                .{ .name = "LatencyControlLabelINTEL", .value = 6172, .parameters = &.{.literal_integer} },
                .{ .name = "LatencyControlConstraintINTEL", .value = 6173, .parameters = &.{ .literal_integer, .literal_integer, .literal_integer } },
                .{ .name = "ConduitKernelArgumentINTEL", .value = 6175, .parameters = &.{} },
                .{ .name = "RegisterMapKernelArgumentINTEL", .value = 6176, .parameters = &.{} },
                .{ .name = "MMHostInterfaceAddressWidthINTEL", .value = 6177, .parameters = &.{.literal_integer} },
                .{ .name = "MMHostInterfaceDataWidthINTEL", .value = 6178, .parameters = &.{.literal_integer} },
                .{ .name = "MMHostInterfaceLatencyINTEL", .value = 6179, .parameters = &.{.literal_integer} },
                .{ .name = "MMHostInterfaceReadWriteModeINTEL", .value = 6180, .parameters = &.{.access_qualifier} },
                .{ .name = "MMHostInterfaceMaxBurstINTEL", .value = 6181, .parameters = &.{.literal_integer} },
                .{ .name = "MMHostInterfaceWaitRequestINTEL", .value = 6182, .parameters = &.{.literal_integer} },
                .{ .name = "StableKernelArgumentINTEL", .value = 6183, .parameters = &.{} },
                .{ .name = "HostAccessINTEL", .value = 6188, .parameters = &.{ .host_access_qualifier, .literal_string } },
                .{ .name = "InitModeINTEL", .value = 6190, .parameters = &.{.initialization_mode_qualifier} },
                .{ .name = "ImplementInRegisterMapINTEL", .value = 6191, .parameters = &.{.literal_integer} },
                .{ .name = "CacheControlLoadINTEL", .value = 6442, .parameters = &.{ .literal_integer, .load_cache_control } },
                .{ .name = "CacheControlStoreINTEL", .value = 6443, .parameters = &.{ .literal_integer, .store_cache_control } },
            },
            .built_in => &.{
                .{ .name = "Position", .value = 0, .parameters = &.{} },
                .{ .name = "PointSize", .value = 1, .parameters = &.{} },
                .{ .name = "ClipDistance", .value = 3, .parameters = &.{} },
                .{ .name = "CullDistance", .value = 4, .parameters = &.{} },
                .{ .name = "VertexId", .value = 5, .parameters = &.{} },
                .{ .name = "InstanceId", .value = 6, .parameters = &.{} },
                .{ .name = "PrimitiveId", .value = 7, .parameters = &.{} },
                .{ .name = "InvocationId", .value = 8, .parameters = &.{} },
                .{ .name = "Layer", .value = 9, .parameters = &.{} },
                .{ .name = "ViewportIndex", .value = 10, .parameters = &.{} },
                .{ .name = "TessLevelOuter", .value = 11, .parameters = &.{} },
                .{ .name = "TessLevelInner", .value = 12, .parameters = &.{} },
                .{ .name = "TessCoord", .value = 13, .parameters = &.{} },
                .{ .name = "PatchVertices", .value = 14, .parameters = &.{} },
                .{ .name = "FragCoord", .value = 15, .parameters = &.{} },
                .{ .name = "PointCoord", .value = 16, .parameters = &.{} },
                .{ .name = "FrontFacing", .value = 17, .parameters = &.{} },
                .{ .name = "SampleId", .value = 18, .parameters = &.{} },
                .{ .name = "SamplePosition", .value = 19, .parameters = &.{} },
                .{ .name = "SampleMask", .value = 20, .parameters = &.{} },
                .{ .name = "FragDepth", .value = 22, .parameters = &.{} },
                .{ .name = "HelperInvocation", .value = 23, .parameters = &.{} },
                .{ .name = "NumWorkgroups", .value = 24, .parameters = &.{} },
                .{ .name = "WorkgroupSize", .value = 25, .parameters = &.{} },
                .{ .name = "WorkgroupId", .value = 26, .parameters = &.{} },
                .{ .name = "LocalInvocationId", .value = 27, .parameters = &.{} },
                .{ .name = "GlobalInvocationId", .value = 28, .parameters = &.{} },
                .{ .name = "LocalInvocationIndex", .value = 29, .parameters = &.{} },
                .{ .name = "WorkDim", .value = 30, .parameters = &.{} },
                .{ .name = "GlobalSize", .value = 31, .parameters = &.{} },
                .{ .name = "EnqueuedWorkgroupSize", .value = 32, .parameters = &.{} },
                .{ .name = "GlobalOffset", .value = 33, .parameters = &.{} },
                .{ .name = "GlobalLinearId", .value = 34, .parameters = &.{} },
                .{ .name = "SubgroupSize", .value = 36, .parameters = &.{} },
                .{ .name = "SubgroupMaxSize", .value = 37, .parameters = &.{} },
                .{ .name = "NumSubgroups", .value = 38, .parameters = &.{} },
                .{ .name = "NumEnqueuedSubgroups", .value = 39, .parameters = &.{} },
                .{ .name = "SubgroupId", .value = 40, .parameters = &.{} },
                .{ .name = "SubgroupLocalInvocationId", .value = 41, .parameters = &.{} },
                .{ .name = "VertexIndex", .value = 42, .parameters = &.{} },
                .{ .name = "InstanceIndex", .value = 43, .parameters = &.{} },
                .{ .name = "CoreIDARM", .value = 4160, .parameters = &.{} },
                .{ .name = "CoreCountARM", .value = 4161, .parameters = &.{} },
                .{ .name = "CoreMaxIDARM", .value = 4162, .parameters = &.{} },
                .{ .name = "WarpIDARM", .value = 4163, .parameters = &.{} },
                .{ .name = "WarpMaxIDARM", .value = 4164, .parameters = &.{} },
                .{ .name = "SubgroupEqMask", .value = 4416, .parameters = &.{} },
                .{ .name = "SubgroupGeMask", .value = 4417, .parameters = &.{} },
                .{ .name = "SubgroupGtMask", .value = 4418, .parameters = &.{} },
                .{ .name = "SubgroupLeMask", .value = 4419, .parameters = &.{} },
                .{ .name = "SubgroupLtMask", .value = 4420, .parameters = &.{} },
                .{ .name = "BaseVertex", .value = 4424, .parameters = &.{} },
                .{ .name = "BaseInstance", .value = 4425, .parameters = &.{} },
                .{ .name = "DrawIndex", .value = 4426, .parameters = &.{} },
                .{ .name = "PrimitiveShadingRateKHR", .value = 4432, .parameters = &.{} },
                .{ .name = "DeviceIndex", .value = 4438, .parameters = &.{} },
                .{ .name = "ViewIndex", .value = 4440, .parameters = &.{} },
                .{ .name = "ShadingRateKHR", .value = 4444, .parameters = &.{} },
                .{ .name = "TileOffsetQCOM", .value = 4492, .parameters = &.{} },
                .{ .name = "TileDimensionQCOM", .value = 4493, .parameters = &.{} },
                .{ .name = "TileApronSizeQCOM", .value = 4494, .parameters = &.{} },
                .{ .name = "BaryCoordNoPerspAMD", .value = 4992, .parameters = &.{} },
                .{ .name = "BaryCoordNoPerspCentroidAMD", .value = 4993, .parameters = &.{} },
                .{ .name = "BaryCoordNoPerspSampleAMD", .value = 4994, .parameters = &.{} },
                .{ .name = "BaryCoordSmoothAMD", .value = 4995, .parameters = &.{} },
                .{ .name = "BaryCoordSmoothCentroidAMD", .value = 4996, .parameters = &.{} },
                .{ .name = "BaryCoordSmoothSampleAMD", .value = 4997, .parameters = &.{} },
                .{ .name = "BaryCoordPullModelAMD", .value = 4998, .parameters = &.{} },
                .{ .name = "FragStencilRefEXT", .value = 5014, .parameters = &.{} },
                .{ .name = "RemainingRecursionLevelsAMDX", .value = 5021, .parameters = &.{} },
                .{ .name = "ShaderIndexAMDX", .value = 5073, .parameters = &.{} },
                .{ .name = "ViewportMaskNV", .value = 5253, .parameters = &.{} },
                .{ .name = "SecondaryPositionNV", .value = 5257, .parameters = &.{} },
                .{ .name = "SecondaryViewportMaskNV", .value = 5258, .parameters = &.{} },
                .{ .name = "PositionPerViewNV", .value = 5261, .parameters = &.{} },
                .{ .name = "ViewportMaskPerViewNV", .value = 5262, .parameters = &.{} },
                .{ .name = "FullyCoveredEXT", .value = 5264, .parameters = &.{} },
                .{ .name = "TaskCountNV", .value = 5274, .parameters = &.{} },
                .{ .name = "PrimitiveCountNV", .value = 5275, .parameters = &.{} },
                .{ .name = "PrimitiveIndicesNV", .value = 5276, .parameters = &.{} },
                .{ .name = "ClipDistancePerViewNV", .value = 5277, .parameters = &.{} },
                .{ .name = "CullDistancePerViewNV", .value = 5278, .parameters = &.{} },
                .{ .name = "LayerPerViewNV", .value = 5279, .parameters = &.{} },
                .{ .name = "MeshViewCountNV", .value = 5280, .parameters = &.{} },
                .{ .name = "MeshViewIndicesNV", .value = 5281, .parameters = &.{} },
                .{ .name = "BaryCoordKHR", .value = 5286, .parameters = &.{} },
                .{ .name = "BaryCoordNoPerspKHR", .value = 5287, .parameters = &.{} },
                .{ .name = "FragSizeEXT", .value = 5292, .parameters = &.{} },
                .{ .name = "FragInvocationCountEXT", .value = 5293, .parameters = &.{} },
                .{ .name = "PrimitivePointIndicesEXT", .value = 5294, .parameters = &.{} },
                .{ .name = "PrimitiveLineIndicesEXT", .value = 5295, .parameters = &.{} },
                .{ .name = "PrimitiveTriangleIndicesEXT", .value = 5296, .parameters = &.{} },
                .{ .name = "CullPrimitiveEXT", .value = 5299, .parameters = &.{} },
                .{ .name = "LaunchIdKHR", .value = 5319, .parameters = &.{} },
                .{ .name = "LaunchSizeKHR", .value = 5320, .parameters = &.{} },
                .{ .name = "WorldRayOriginKHR", .value = 5321, .parameters = &.{} },
                .{ .name = "WorldRayDirectionKHR", .value = 5322, .parameters = &.{} },
                .{ .name = "ObjectRayOriginKHR", .value = 5323, .parameters = &.{} },
                .{ .name = "ObjectRayDirectionKHR", .value = 5324, .parameters = &.{} },
                .{ .name = "RayTminKHR", .value = 5325, .parameters = &.{} },
                .{ .name = "RayTmaxKHR", .value = 5326, .parameters = &.{} },
                .{ .name = "InstanceCustomIndexKHR", .value = 5327, .parameters = &.{} },
                .{ .name = "ObjectToWorldKHR", .value = 5330, .parameters = &.{} },
                .{ .name = "WorldToObjectKHR", .value = 5331, .parameters = &.{} },
                .{ .name = "HitTNV", .value = 5332, .parameters = &.{} },
                .{ .name = "HitKindKHR", .value = 5333, .parameters = &.{} },
                .{ .name = "CurrentRayTimeNV", .value = 5334, .parameters = &.{} },
                .{ .name = "HitTriangleVertexPositionsKHR", .value = 5335, .parameters = &.{} },
                .{ .name = "HitMicroTriangleVertexPositionsNV", .value = 5337, .parameters = &.{} },
                .{ .name = "HitMicroTriangleVertexBarycentricsNV", .value = 5344, .parameters = &.{} },
                .{ .name = "IncomingRayFlagsKHR", .value = 5351, .parameters = &.{} },
                .{ .name = "RayGeometryIndexKHR", .value = 5352, .parameters = &.{} },
                .{ .name = "HitIsSphereNV", .value = 5359, .parameters = &.{} },
                .{ .name = "HitIsLSSNV", .value = 5360, .parameters = &.{} },
                .{ .name = "HitSpherePositionNV", .value = 5361, .parameters = &.{} },
                .{ .name = "WarpsPerSMNV", .value = 5374, .parameters = &.{} },
                .{ .name = "SMCountNV", .value = 5375, .parameters = &.{} },
                .{ .name = "WarpIDNV", .value = 5376, .parameters = &.{} },
                .{ .name = "SMIDNV", .value = 5377, .parameters = &.{} },
                .{ .name = "HitLSSPositionsNV", .value = 5396, .parameters = &.{} },
                .{ .name = "HitKindFrontFacingMicroTriangleNV", .value = 5405, .parameters = &.{} },
                .{ .name = "HitKindBackFacingMicroTriangleNV", .value = 5406, .parameters = &.{} },
                .{ .name = "HitSphereRadiusNV", .value = 5420, .parameters = &.{} },
                .{ .name = "HitLSSRadiiNV", .value = 5421, .parameters = &.{} },
                .{ .name = "ClusterIDNV", .value = 5436, .parameters = &.{} },
                .{ .name = "CullMaskKHR", .value = 6021, .parameters = &.{} },
            },
            .scope => &.{
                .{ .name = "CrossDevice", .value = 0, .parameters = &.{} },
                .{ .name = "Device", .value = 1, .parameters = &.{} },
                .{ .name = "Workgroup", .value = 2, .parameters = &.{} },
                .{ .name = "Subgroup", .value = 3, .parameters = &.{} },
                .{ .name = "Invocation", .value = 4, .parameters = &.{} },
                .{ .name = "QueueFamily", .value = 5, .parameters = &.{} },
                .{ .name = "ShaderCallKHR", .value = 6, .parameters = &.{} },
            },
            .group_operation => &.{
                .{ .name = "Reduce", .value = 0, .parameters = &.{} },
                .{ .name = "InclusiveScan", .value = 1, .parameters = &.{} },
                .{ .name = "ExclusiveScan", .value = 2, .parameters = &.{} },
                .{ .name = "ClusteredReduce", .value = 3, .parameters = &.{} },
                .{ .name = "PartitionedReduceNV", .value = 6, .parameters = &.{} },
                .{ .name = "PartitionedInclusiveScanNV", .value = 7, .parameters = &.{} },
                .{ .name = "PartitionedExclusiveScanNV", .value = 8, .parameters = &.{} },
            },
            .kernel_enqueue_flags => &.{
                .{ .name = "NoWait", .value = 0, .parameters = &.{} },
                .{ .name = "WaitKernel", .value = 1, .parameters = &.{} },
                .{ .name = "WaitWorkGroup", .value = 2, .parameters = &.{} },
            },
            .capability => &.{
                .{ .name = "Matrix", .value = 0, .parameters = &.{} },
                .{ .name = "Shader", .value = 1, .parameters = &.{} },
                .{ .name = "Geometry", .value = 2, .parameters = &.{} },
                .{ .name = "Tessellation", .value = 3, .parameters = &.{} },
                .{ .name = "Addresses", .value = 4, .parameters = &.{} },
                .{ .name = "Linkage", .value = 5, .parameters = &.{} },
                .{ .name = "Kernel", .value = 6, .parameters = &.{} },
                .{ .name = "Vector16", .value = 7, .parameters = &.{} },
                .{ .name = "Float16Buffer", .value = 8, .parameters = &.{} },
                .{ .name = "Float16", .value = 9, .parameters = &.{} },
                .{ .name = "Float64", .value = 10, .parameters = &.{} },
                .{ .name = "Int64", .value = 11, .parameters = &.{} },
                .{ .name = "Int64Atomics", .value = 12, .parameters = &.{} },
                .{ .name = "ImageBasic", .value = 13, .parameters = &.{} },
                .{ .name = "ImageReadWrite", .value = 14, .parameters = &.{} },
                .{ .name = "ImageMipmap", .value = 15, .parameters = &.{} },
                .{ .name = "Pipes", .value = 17, .parameters = &.{} },
                .{ .name = "Groups", .value = 18, .parameters = &.{} },
                .{ .name = "DeviceEnqueue", .value = 19, .parameters = &.{} },
                .{ .name = "LiteralSampler", .value = 20, .parameters = &.{} },
                .{ .name = "AtomicStorage", .value = 21, .parameters = &.{} },
                .{ .name = "Int16", .value = 22, .parameters = &.{} },
                .{ .name = "TessellationPointSize", .value = 23, .parameters = &.{} },
                .{ .name = "GeometryPointSize", .value = 24, .parameters = &.{} },
                .{ .name = "ImageGatherExtended", .value = 25, .parameters = &.{} },
                .{ .name = "StorageImageMultisample", .value = 27, .parameters = &.{} },
                .{ .name = "UniformBufferArrayDynamicIndexing", .value = 28, .parameters = &.{} },
                .{ .name = "SampledImageArrayDynamicIndexing", .value = 29, .parameters = &.{} },
                .{ .name = "StorageBufferArrayDynamicIndexing", .value = 30, .parameters = &.{} },
                .{ .name = "StorageImageArrayDynamicIndexing", .value = 31, .parameters = &.{} },
                .{ .name = "ClipDistance", .value = 32, .parameters = &.{} },
                .{ .name = "CullDistance", .value = 33, .parameters = &.{} },
                .{ .name = "ImageCubeArray", .value = 34, .parameters = &.{} },
                .{ .name = "SampleRateShading", .value = 35, .parameters = &.{} },
                .{ .name = "ImageRect", .value = 36, .parameters = &.{} },
                .{ .name = "SampledRect", .value = 37, .parameters = &.{} },
                .{ .name = "GenericPointer", .value = 38, .parameters = &.{} },
                .{ .name = "Int8", .value = 39, .parameters = &.{} },
                .{ .name = "InputAttachment", .value = 40, .parameters = &.{} },
                .{ .name = "SparseResidency", .value = 41, .parameters = &.{} },
                .{ .name = "MinLod", .value = 42, .parameters = &.{} },
                .{ .name = "Sampled1D", .value = 43, .parameters = &.{} },
                .{ .name = "Image1D", .value = 44, .parameters = &.{} },
                .{ .name = "SampledCubeArray", .value = 45, .parameters = &.{} },
                .{ .name = "SampledBuffer", .value = 46, .parameters = &.{} },
                .{ .name = "ImageBuffer", .value = 47, .parameters = &.{} },
                .{ .name = "ImageMSArray", .value = 48, .parameters = &.{} },
                .{ .name = "StorageImageExtendedFormats", .value = 49, .parameters = &.{} },
                .{ .name = "ImageQuery", .value = 50, .parameters = &.{} },
                .{ .name = "DerivativeControl", .value = 51, .parameters = &.{} },
                .{ .name = "InterpolationFunction", .value = 52, .parameters = &.{} },
                .{ .name = "TransformFeedback", .value = 53, .parameters = &.{} },
                .{ .name = "GeometryStreams", .value = 54, .parameters = &.{} },
                .{ .name = "StorageImageReadWithoutFormat", .value = 55, .parameters = &.{} },
                .{ .name = "StorageImageWriteWithoutFormat", .value = 56, .parameters = &.{} },
                .{ .name = "MultiViewport", .value = 57, .parameters = &.{} },
                .{ .name = "SubgroupDispatch", .value = 58, .parameters = &.{} },
                .{ .name = "NamedBarrier", .value = 59, .parameters = &.{} },
                .{ .name = "PipeStorage", .value = 60, .parameters = &.{} },
                .{ .name = "GroupNonUniform", .value = 61, .parameters = &.{} },
                .{ .name = "GroupNonUniformVote", .value = 62, .parameters = &.{} },
                .{ .name = "GroupNonUniformArithmetic", .value = 63, .parameters = &.{} },
                .{ .name = "GroupNonUniformBallot", .value = 64, .parameters = &.{} },
                .{ .name = "GroupNonUniformShuffle", .value = 65, .parameters = &.{} },
                .{ .name = "GroupNonUniformShuffleRelative", .value = 66, .parameters = &.{} },
                .{ .name = "GroupNonUniformClustered", .value = 67, .parameters = &.{} },
                .{ .name = "GroupNonUniformQuad", .value = 68, .parameters = &.{} },
                .{ .name = "ShaderLayer", .value = 69, .parameters = &.{} },
                .{ .name = "ShaderViewportIndex", .value = 70, .parameters = &.{} },
                .{ .name = "UniformDecoration", .value = 71, .parameters = &.{} },
                .{ .name = "CoreBuiltinsARM", .value = 4165, .parameters = &.{} },
                .{ .name = "TileImageColorReadAccessEXT", .value = 4166, .parameters = &.{} },
                .{ .name = "TileImageDepthReadAccessEXT", .value = 4167, .parameters = &.{} },
                .{ .name = "TileImageStencilReadAccessEXT", .value = 4168, .parameters = &.{} },
                .{ .name = "TensorsARM", .value = 4174, .parameters = &.{} },
                .{ .name = "StorageTensorArrayDynamicIndexingARM", .value = 4175, .parameters = &.{} },
                .{ .name = "StorageTensorArrayNonUniformIndexingARM", .value = 4176, .parameters = &.{} },
                .{ .name = "GraphARM", .value = 4191, .parameters = &.{} },
                .{ .name = "CooperativeMatrixLayoutsARM", .value = 4201, .parameters = &.{} },
                .{ .name = "Float8EXT", .value = 4212, .parameters = &.{} },
                .{ .name = "Float8CooperativeMatrixEXT", .value = 4213, .parameters = &.{} },
                .{ .name = "FragmentShadingRateKHR", .value = 4422, .parameters = &.{} },
                .{ .name = "SubgroupBallotKHR", .value = 4423, .parameters = &.{} },
                .{ .name = "DrawParameters", .value = 4427, .parameters = &.{} },
                .{ .name = "WorkgroupMemoryExplicitLayoutKHR", .value = 4428, .parameters = &.{} },
                .{ .name = "WorkgroupMemoryExplicitLayout8BitAccessKHR", .value = 4429, .parameters = &.{} },
                .{ .name = "WorkgroupMemoryExplicitLayout16BitAccessKHR", .value = 4430, .parameters = &.{} },
                .{ .name = "SubgroupVoteKHR", .value = 4431, .parameters = &.{} },
                .{ .name = "StorageBuffer16BitAccess", .value = 4433, .parameters = &.{} },
                .{ .name = "UniformAndStorageBuffer16BitAccess", .value = 4434, .parameters = &.{} },
                .{ .name = "StoragePushConstant16", .value = 4435, .parameters = &.{} },
                .{ .name = "StorageInputOutput16", .value = 4436, .parameters = &.{} },
                .{ .name = "DeviceGroup", .value = 4437, .parameters = &.{} },
                .{ .name = "MultiView", .value = 4439, .parameters = &.{} },
                .{ .name = "VariablePointersStorageBuffer", .value = 4441, .parameters = &.{} },
                .{ .name = "VariablePointers", .value = 4442, .parameters = &.{} },
                .{ .name = "AtomicStorageOps", .value = 4445, .parameters = &.{} },
                .{ .name = "SampleMaskPostDepthCoverage", .value = 4447, .parameters = &.{} },
                .{ .name = "StorageBuffer8BitAccess", .value = 4448, .parameters = &.{} },
                .{ .name = "UniformAndStorageBuffer8BitAccess", .value = 4449, .parameters = &.{} },
                .{ .name = "StoragePushConstant8", .value = 4450, .parameters = &.{} },
                .{ .name = "DenormPreserve", .value = 4464, .parameters = &.{} },
                .{ .name = "DenormFlushToZero", .value = 4465, .parameters = &.{} },
                .{ .name = "SignedZeroInfNanPreserve", .value = 4466, .parameters = &.{} },
                .{ .name = "RoundingModeRTE", .value = 4467, .parameters = &.{} },
                .{ .name = "RoundingModeRTZ", .value = 4468, .parameters = &.{} },
                .{ .name = "RayQueryProvisionalKHR", .value = 4471, .parameters = &.{} },
                .{ .name = "RayQueryKHR", .value = 4472, .parameters = &.{} },
                .{ .name = "UntypedPointersKHR", .value = 4473, .parameters = &.{} },
                .{ .name = "RayTraversalPrimitiveCullingKHR", .value = 4478, .parameters = &.{} },
                .{ .name = "RayTracingKHR", .value = 4479, .parameters = &.{} },
                .{ .name = "TextureSampleWeightedQCOM", .value = 4484, .parameters = &.{} },
                .{ .name = "TextureBoxFilterQCOM", .value = 4485, .parameters = &.{} },
                .{ .name = "TextureBlockMatchQCOM", .value = 4486, .parameters = &.{} },
                .{ .name = "TileShadingQCOM", .value = 4495, .parameters = &.{} },
                .{ .name = "TextureBlockMatch2QCOM", .value = 4498, .parameters = &.{} },
                .{ .name = "Float16ImageAMD", .value = 5008, .parameters = &.{} },
                .{ .name = "ImageGatherBiasLodAMD", .value = 5009, .parameters = &.{} },
                .{ .name = "FragmentMaskAMD", .value = 5010, .parameters = &.{} },
                .{ .name = "StencilExportEXT", .value = 5013, .parameters = &.{} },
                .{ .name = "ImageReadWriteLodAMD", .value = 5015, .parameters = &.{} },
                .{ .name = "Int64ImageEXT", .value = 5016, .parameters = &.{} },
                .{ .name = "ShaderClockKHR", .value = 5055, .parameters = &.{} },
                .{ .name = "ShaderEnqueueAMDX", .value = 5067, .parameters = &.{} },
                .{ .name = "QuadControlKHR", .value = 5087, .parameters = &.{} },
                .{ .name = "Int4TypeINTEL", .value = 5112, .parameters = &.{} },
                .{ .name = "Int4CooperativeMatrixINTEL", .value = 5114, .parameters = &.{} },
                .{ .name = "BFloat16TypeKHR", .value = 5116, .parameters = &.{} },
                .{ .name = "BFloat16DotProductKHR", .value = 5117, .parameters = &.{} },
                .{ .name = "BFloat16CooperativeMatrixKHR", .value = 5118, .parameters = &.{} },
                .{ .name = "SampleMaskOverrideCoverageNV", .value = 5249, .parameters = &.{} },
                .{ .name = "GeometryShaderPassthroughNV", .value = 5251, .parameters = &.{} },
                .{ .name = "ShaderViewportIndexLayerEXT", .value = 5254, .parameters = &.{} },
                .{ .name = "ShaderViewportMaskNV", .value = 5255, .parameters = &.{} },
                .{ .name = "ShaderStereoViewNV", .value = 5259, .parameters = &.{} },
                .{ .name = "PerViewAttributesNV", .value = 5260, .parameters = &.{} },
                .{ .name = "FragmentFullyCoveredEXT", .value = 5265, .parameters = &.{} },
                .{ .name = "MeshShadingNV", .value = 5266, .parameters = &.{} },
                .{ .name = "ImageFootprintNV", .value = 5282, .parameters = &.{} },
                .{ .name = "MeshShadingEXT", .value = 5283, .parameters = &.{} },
                .{ .name = "FragmentBarycentricKHR", .value = 5284, .parameters = &.{} },
                .{ .name = "ComputeDerivativeGroupQuadsKHR", .value = 5288, .parameters = &.{} },
                .{ .name = "FragmentDensityEXT", .value = 5291, .parameters = &.{} },
                .{ .name = "GroupNonUniformPartitionedNV", .value = 5297, .parameters = &.{} },
                .{ .name = "ShaderNonUniform", .value = 5301, .parameters = &.{} },
                .{ .name = "RuntimeDescriptorArray", .value = 5302, .parameters = &.{} },
                .{ .name = "InputAttachmentArrayDynamicIndexing", .value = 5303, .parameters = &.{} },
                .{ .name = "UniformTexelBufferArrayDynamicIndexing", .value = 5304, .parameters = &.{} },
                .{ .name = "StorageTexelBufferArrayDynamicIndexing", .value = 5305, .parameters = &.{} },
                .{ .name = "UniformBufferArrayNonUniformIndexing", .value = 5306, .parameters = &.{} },
                .{ .name = "SampledImageArrayNonUniformIndexing", .value = 5307, .parameters = &.{} },
                .{ .name = "StorageBufferArrayNonUniformIndexing", .value = 5308, .parameters = &.{} },
                .{ .name = "StorageImageArrayNonUniformIndexing", .value = 5309, .parameters = &.{} },
                .{ .name = "InputAttachmentArrayNonUniformIndexing", .value = 5310, .parameters = &.{} },
                .{ .name = "UniformTexelBufferArrayNonUniformIndexing", .value = 5311, .parameters = &.{} },
                .{ .name = "StorageTexelBufferArrayNonUniformIndexing", .value = 5312, .parameters = &.{} },
                .{ .name = "RayTracingPositionFetchKHR", .value = 5336, .parameters = &.{} },
                .{ .name = "RayTracingNV", .value = 5340, .parameters = &.{} },
                .{ .name = "RayTracingMotionBlurNV", .value = 5341, .parameters = &.{} },
                .{ .name = "VulkanMemoryModel", .value = 5345, .parameters = &.{} },
                .{ .name = "VulkanMemoryModelDeviceScope", .value = 5346, .parameters = &.{} },
                .{ .name = "PhysicalStorageBufferAddresses", .value = 5347, .parameters = &.{} },
                .{ .name = "ComputeDerivativeGroupLinearKHR", .value = 5350, .parameters = &.{} },
                .{ .name = "RayTracingProvisionalKHR", .value = 5353, .parameters = &.{} },
                .{ .name = "CooperativeMatrixNV", .value = 5357, .parameters = &.{} },
                .{ .name = "FragmentShaderSampleInterlockEXT", .value = 5363, .parameters = &.{} },
                .{ .name = "FragmentShaderShadingRateInterlockEXT", .value = 5372, .parameters = &.{} },
                .{ .name = "ShaderSMBuiltinsNV", .value = 5373, .parameters = &.{} },
                .{ .name = "FragmentShaderPixelInterlockEXT", .value = 5378, .parameters = &.{} },
                .{ .name = "DemoteToHelperInvocation", .value = 5379, .parameters = &.{} },
                .{ .name = "DisplacementMicromapNV", .value = 5380, .parameters = &.{} },
                .{ .name = "RayTracingOpacityMicromapEXT", .value = 5381, .parameters = &.{} },
                .{ .name = "ShaderInvocationReorderNV", .value = 5383, .parameters = &.{} },
                .{ .name = "BindlessTextureNV", .value = 5390, .parameters = &.{} },
                .{ .name = "RayQueryPositionFetchKHR", .value = 5391, .parameters = &.{} },
                .{ .name = "CooperativeVectorNV", .value = 5394, .parameters = &.{} },
                .{ .name = "AtomicFloat16VectorNV", .value = 5404, .parameters = &.{} },
                .{ .name = "RayTracingDisplacementMicromapNV", .value = 5409, .parameters = &.{} },
                .{ .name = "RawAccessChainsNV", .value = 5414, .parameters = &.{} },
                .{ .name = "RayTracingSpheresGeometryNV", .value = 5418, .parameters = &.{} },
                .{ .name = "RayTracingLinearSweptSpheresGeometryNV", .value = 5419, .parameters = &.{} },
                .{ .name = "CooperativeMatrixReductionsNV", .value = 5430, .parameters = &.{} },
                .{ .name = "CooperativeMatrixConversionsNV", .value = 5431, .parameters = &.{} },
                .{ .name = "CooperativeMatrixPerElementOperationsNV", .value = 5432, .parameters = &.{} },
                .{ .name = "CooperativeMatrixTensorAddressingNV", .value = 5433, .parameters = &.{} },
                .{ .name = "CooperativeMatrixBlockLoadsNV", .value = 5434, .parameters = &.{} },
                .{ .name = "CooperativeVectorTrainingNV", .value = 5435, .parameters = &.{} },
                .{ .name = "RayTracingClusterAccelerationStructureNV", .value = 5437, .parameters = &.{} },
                .{ .name = "TensorAddressingNV", .value = 5439, .parameters = &.{} },
                .{ .name = "SubgroupShuffleINTEL", .value = 5568, .parameters = &.{} },
                .{ .name = "SubgroupBufferBlockIOINTEL", .value = 5569, .parameters = &.{} },
                .{ .name = "SubgroupImageBlockIOINTEL", .value = 5570, .parameters = &.{} },
                .{ .name = "SubgroupImageMediaBlockIOINTEL", .value = 5579, .parameters = &.{} },
                .{ .name = "RoundToInfinityINTEL", .value = 5582, .parameters = &.{} },
                .{ .name = "FloatingPointModeINTEL", .value = 5583, .parameters = &.{} },
                .{ .name = "IntegerFunctions2INTEL", .value = 5584, .parameters = &.{} },
                .{ .name = "FunctionPointersINTEL", .value = 5603, .parameters = &.{} },
                .{ .name = "IndirectReferencesINTEL", .value = 5604, .parameters = &.{} },
                .{ .name = "AsmINTEL", .value = 5606, .parameters = &.{} },
                .{ .name = "AtomicFloat32MinMaxEXT", .value = 5612, .parameters = &.{} },
                .{ .name = "AtomicFloat64MinMaxEXT", .value = 5613, .parameters = &.{} },
                .{ .name = "AtomicFloat16MinMaxEXT", .value = 5616, .parameters = &.{} },
                .{ .name = "VectorComputeINTEL", .value = 5617, .parameters = &.{} },
                .{ .name = "VectorAnyINTEL", .value = 5619, .parameters = &.{} },
                .{ .name = "ExpectAssumeKHR", .value = 5629, .parameters = &.{} },
                .{ .name = "SubgroupAvcMotionEstimationINTEL", .value = 5696, .parameters = &.{} },
                .{ .name = "SubgroupAvcMotionEstimationIntraINTEL", .value = 5697, .parameters = &.{} },
                .{ .name = "SubgroupAvcMotionEstimationChromaINTEL", .value = 5698, .parameters = &.{} },
                .{ .name = "VariableLengthArrayINTEL", .value = 5817, .parameters = &.{} },
                .{ .name = "FunctionFloatControlINTEL", .value = 5821, .parameters = &.{} },
                .{ .name = "FPGAMemoryAttributesINTEL", .value = 5824, .parameters = &.{} },
                .{ .name = "FPFastMathModeINTEL", .value = 5837, .parameters = &.{} },
                .{ .name = "ArbitraryPrecisionIntegersINTEL", .value = 5844, .parameters = &.{} },
                .{ .name = "ArbitraryPrecisionFloatingPointINTEL", .value = 5845, .parameters = &.{} },
                .{ .name = "UnstructuredLoopControlsINTEL", .value = 5886, .parameters = &.{} },
                .{ .name = "FPGALoopControlsINTEL", .value = 5888, .parameters = &.{} },
                .{ .name = "KernelAttributesINTEL", .value = 5892, .parameters = &.{} },
                .{ .name = "FPGAKernelAttributesINTEL", .value = 5897, .parameters = &.{} },
                .{ .name = "FPGAMemoryAccessesINTEL", .value = 5898, .parameters = &.{} },
                .{ .name = "FPGAClusterAttributesINTEL", .value = 5904, .parameters = &.{} },
                .{ .name = "LoopFuseINTEL", .value = 5906, .parameters = &.{} },
                .{ .name = "FPGADSPControlINTEL", .value = 5908, .parameters = &.{} },
                .{ .name = "MemoryAccessAliasingINTEL", .value = 5910, .parameters = &.{} },
                .{ .name = "FPGAInvocationPipeliningAttributesINTEL", .value = 5916, .parameters = &.{} },
                .{ .name = "FPGABufferLocationINTEL", .value = 5920, .parameters = &.{} },
                .{ .name = "ArbitraryPrecisionFixedPointINTEL", .value = 5922, .parameters = &.{} },
                .{ .name = "USMStorageClassesINTEL", .value = 5935, .parameters = &.{} },
                .{ .name = "RuntimeAlignedAttributeINTEL", .value = 5939, .parameters = &.{} },
                .{ .name = "IOPipesINTEL", .value = 5943, .parameters = &.{} },
                .{ .name = "BlockingPipesINTEL", .value = 5945, .parameters = &.{} },
                .{ .name = "FPGARegINTEL", .value = 5948, .parameters = &.{} },
                .{ .name = "DotProductInputAll", .value = 6016, .parameters = &.{} },
                .{ .name = "DotProductInput4x8Bit", .value = 6017, .parameters = &.{} },
                .{ .name = "DotProductInput4x8BitPacked", .value = 6018, .parameters = &.{} },
                .{ .name = "DotProduct", .value = 6019, .parameters = &.{} },
                .{ .name = "RayCullMaskKHR", .value = 6020, .parameters = &.{} },
                .{ .name = "CooperativeMatrixKHR", .value = 6022, .parameters = &.{} },
                .{ .name = "ReplicatedCompositesEXT", .value = 6024, .parameters = &.{} },
                .{ .name = "BitInstructions", .value = 6025, .parameters = &.{} },
                .{ .name = "GroupNonUniformRotateKHR", .value = 6026, .parameters = &.{} },
                .{ .name = "FloatControls2", .value = 6029, .parameters = &.{} },
                .{ .name = "AtomicFloat32AddEXT", .value = 6033, .parameters = &.{} },
                .{ .name = "AtomicFloat64AddEXT", .value = 6034, .parameters = &.{} },
                .{ .name = "LongCompositesINTEL", .value = 6089, .parameters = &.{} },
                .{ .name = "OptNoneEXT", .value = 6094, .parameters = &.{} },
                .{ .name = "AtomicFloat16AddEXT", .value = 6095, .parameters = &.{} },
                .{ .name = "DebugInfoModuleINTEL", .value = 6114, .parameters = &.{} },
                .{ .name = "BFloat16ConversionINTEL", .value = 6115, .parameters = &.{} },
                .{ .name = "SplitBarrierINTEL", .value = 6141, .parameters = &.{} },
                .{ .name = "ArithmeticFenceEXT", .value = 6144, .parameters = &.{} },
                .{ .name = "FPGAClusterAttributesV2INTEL", .value = 6150, .parameters = &.{} },
                .{ .name = "FPGAKernelAttributesv2INTEL", .value = 6161, .parameters = &.{} },
                .{ .name = "TaskSequenceINTEL", .value = 6162, .parameters = &.{} },
                .{ .name = "FPMaxErrorINTEL", .value = 6169, .parameters = &.{} },
                .{ .name = "FPGALatencyControlINTEL", .value = 6171, .parameters = &.{} },
                .{ .name = "FPGAArgumentInterfacesINTEL", .value = 6174, .parameters = &.{} },
                .{ .name = "GlobalVariableHostAccessINTEL", .value = 6187, .parameters = &.{} },
                .{ .name = "GlobalVariableFPGADecorationsINTEL", .value = 6189, .parameters = &.{} },
                .{ .name = "SubgroupBufferPrefetchINTEL", .value = 6220, .parameters = &.{} },
                .{ .name = "Subgroup2DBlockIOINTEL", .value = 6228, .parameters = &.{} },
                .{ .name = "Subgroup2DBlockTransformINTEL", .value = 6229, .parameters = &.{} },
                .{ .name = "Subgroup2DBlockTransposeINTEL", .value = 6230, .parameters = &.{} },
                .{ .name = "SubgroupMatrixMultiplyAccumulateINTEL", .value = 6236, .parameters = &.{} },
                .{ .name = "TernaryBitwiseFunctionINTEL", .value = 6241, .parameters = &.{} },
                .{ .name = "GroupUniformArithmeticKHR", .value = 6400, .parameters = &.{} },
                .{ .name = "TensorFloat32RoundingINTEL", .value = 6425, .parameters = &.{} },
                .{ .name = "MaskedGatherScatterINTEL", .value = 6427, .parameters = &.{} },
                .{ .name = "CacheControlsINTEL", .value = 6441, .parameters = &.{} },
                .{ .name = "RegisterLimitsINTEL", .value = 6460, .parameters = &.{} },
                .{ .name = "BindlessImagesINTEL", .value = 6528, .parameters = &.{} },
            },
            .ray_query_intersection => &.{
                .{ .name = "RayQueryCandidateIntersectionKHR", .value = 0, .parameters = &.{} },
                .{ .name = "RayQueryCommittedIntersectionKHR", .value = 1, .parameters = &.{} },
            },
            .ray_query_committed_intersection_type => &.{
                .{ .name = "RayQueryCommittedIntersectionNoneKHR", .value = 0, .parameters = &.{} },
                .{ .name = "RayQueryCommittedIntersectionTriangleKHR", .value = 1, .parameters = &.{} },
                .{ .name = "RayQueryCommittedIntersectionGeneratedKHR", .value = 2, .parameters = &.{} },
            },
            .ray_query_candidate_intersection_type => &.{
                .{ .name = "RayQueryCandidateIntersectionTriangleKHR", .value = 0, .parameters = &.{} },
                .{ .name = "RayQueryCandidateIntersectionAABBKHR", .value = 1, .parameters = &.{} },
            },
            .packed_vector_format => &.{
                .{ .name = "PackedVectorFormat4x8Bit", .value = 0, .parameters = &.{} },
            },
            .cooperative_matrix_operands => &.{
                .{ .name = "NoneKHR", .value = 0x0000, .parameters = &.{} },
                .{ .name = "MatrixASignedComponentsKHR", .value = 0x0001, .parameters = &.{} },
                .{ .name = "MatrixBSignedComponentsKHR", .value = 0x0002, .parameters = &.{} },
                .{ .name = "MatrixCSignedComponentsKHR", .value = 0x0004, .parameters = &.{} },
                .{ .name = "MatrixResultSignedComponentsKHR", .value = 0x0008, .parameters = &.{} },
                .{ .name = "SaturatingAccumulationKHR", .value = 0x0010, .parameters = &.{} },
            },
            .cooperative_matrix_layout => &.{
                .{ .name = "RowMajorKHR", .value = 0, .parameters = &.{} },
                .{ .name = "ColumnMajorKHR", .value = 1, .parameters = &.{} },
                .{ .name = "RowBlockedInterleavedARM", .value = 4202, .parameters = &.{} },
                .{ .name = "ColumnBlockedInterleavedARM", .value = 4203, .parameters = &.{} },
            },
            .cooperative_matrix_use => &.{
                .{ .name = "MatrixAKHR", .value = 0, .parameters = &.{} },
                .{ .name = "MatrixBKHR", .value = 1, .parameters = &.{} },
                .{ .name = "MatrixAccumulatorKHR", .value = 2, .parameters = &.{} },
            },
            .cooperative_matrix_reduce => &.{
                .{ .name = "Row", .value = 0x0001, .parameters = &.{} },
                .{ .name = "Column", .value = 0x0002, .parameters = &.{} },
                .{ .name = "2x2", .value = 0x0004, .parameters = &.{} },
            },
            .tensor_clamp_mode => &.{
                .{ .name = "Undefined", .value = 0, .parameters = &.{} },
                .{ .name = "Constant", .value = 1, .parameters = &.{} },
                .{ .name = "ClampToEdge", .value = 2, .parameters = &.{} },
                .{ .name = "Repeat", .value = 3, .parameters = &.{} },
                .{ .name = "RepeatMirrored", .value = 4, .parameters = &.{} },
            },
            .tensor_addressing_operands => &.{
                .{ .name = "TensorView", .value = 0x0001, .parameters = &.{.id_ref} },
                .{ .name = "DecodeFunc", .value = 0x0002, .parameters = &.{.id_ref} },
            },
            .initialization_mode_qualifier => &.{
                .{ .name = "InitOnDeviceReprogramINTEL", .value = 0, .parameters = &.{} },
                .{ .name = "InitOnDeviceResetINTEL", .value = 1, .parameters = &.{} },
            },
            .load_cache_control => &.{
                .{ .name = "UncachedINTEL", .value = 0, .parameters = &.{} },
                .{ .name = "CachedINTEL", .value = 1, .parameters = &.{} },
                .{ .name = "StreamingINTEL", .value = 2, .parameters = &.{} },
                .{ .name = "InvalidateAfterReadINTEL", .value = 3, .parameters = &.{} },
                .{ .name = "ConstCachedINTEL", .value = 4, .parameters = &.{} },
            },
            .store_cache_control => &.{
                .{ .name = "UncachedINTEL", .value = 0, .parameters = &.{} },
                .{ .name = "WriteThroughINTEL", .value = 1, .parameters = &.{} },
                .{ .name = "WriteBackINTEL", .value = 2, .parameters = &.{} },
                .{ .name = "StreamingINTEL", .value = 3, .parameters = &.{} },
            },
            .named_maximum_number_of_registers => &.{
                .{ .name = "AutoINTEL", .value = 0, .parameters = &.{} },
            },
            .matrix_multiply_accumulate_operands => &.{
                .{ .name = "MatrixASignedComponentsINTEL", .value = 0x1, .parameters = &.{} },
                .{ .name = "MatrixBSignedComponentsINTEL", .value = 0x2, .parameters = &.{} },
                .{ .name = "MatrixCBFloat16INTEL", .value = 0x4, .parameters = &.{} },
                .{ .name = "MatrixResultBFloat16INTEL", .value = 0x8, .parameters = &.{} },
                .{ .name = "MatrixAPackedInt8INTEL", .value = 0x10, .parameters = &.{} },
                .{ .name = "MatrixBPackedInt8INTEL", .value = 0x20, .parameters = &.{} },
                .{ .name = "MatrixAPackedInt4INTEL", .value = 0x40, .parameters = &.{} },
                .{ .name = "MatrixBPackedInt4INTEL", .value = 0x80, .parameters = &.{} },
                .{ .name = "MatrixATF32INTEL", .value = 0x100, .parameters = &.{} },
                .{ .name = "MatrixBTF32INTEL", .value = 0x200, .parameters = &.{} },
                .{ .name = "MatrixAPackedFloat16INTEL", .value = 0x400, .parameters = &.{} },
                .{ .name = "MatrixBPackedFloat16INTEL", .value = 0x800, .parameters = &.{} },
                .{ .name = "MatrixAPackedBFloat16INTEL", .value = 0x1000, .parameters = &.{} },
                .{ .name = "MatrixBPackedBFloat16INTEL", .value = 0x2000, .parameters = &.{} },
            },
            .fp_encoding => &.{
                .{ .name = "BFloat16KHR", .value = 0, .parameters = &.{} },
                .{ .name = "Float8E4M3EXT", .value = 4214, .parameters = &.{} },
                .{ .name = "Float8E5M2EXT", .value = 4215, .parameters = &.{} },
            },
            .cooperative_vector_matrix_layout => &.{
                .{ .name = "RowMajorNV", .value = 0, .parameters = &.{} },
                .{ .name = "ColumnMajorNV", .value = 1, .parameters = &.{} },
                .{ .name = "InferencingOptimalNV", .value = 2, .parameters = &.{} },
                .{ .name = "TrainingOptimalNV", .value = 3, .parameters = &.{} },
            },
            .component_type => &.{
                .{ .name = "Float16NV", .value = 0, .parameters = &.{} },
                .{ .name = "Float32NV", .value = 1, .parameters = &.{} },
                .{ .name = "Float64NV", .value = 2, .parameters = &.{} },
                .{ .name = "SignedInt8NV", .value = 3, .parameters = &.{} },
                .{ .name = "SignedInt16NV", .value = 4, .parameters = &.{} },
                .{ .name = "SignedInt32NV", .value = 5, .parameters = &.{} },
                .{ .name = "SignedInt64NV", .value = 6, .parameters = &.{} },
                .{ .name = "UnsignedInt8NV", .value = 7, .parameters = &.{} },
                .{ .name = "UnsignedInt16NV", .value = 8, .parameters = &.{} },
                .{ .name = "UnsignedInt32NV", .value = 9, .parameters = &.{} },
                .{ .name = "UnsignedInt64NV", .value = 10, .parameters = &.{} },
                .{ .name = "SignedInt8PackedNV", .value = 1000491000, .parameters = &.{} },
                .{ .name = "UnsignedInt8PackedNV", .value = 1000491001, .parameters = &.{} },
                .{ .name = "FloatE4M3NV", .value = 1000491002, .parameters = &.{} },
                .{ .name = "FloatE5M2NV", .value = 1000491003, .parameters = &.{} },
            },
            .id_result_type => unreachable,
            .id_result => unreachable,
            .id_memory_semantics => unreachable,
            .id_scope => unreachable,
            .id_ref => unreachable,
            .literal_integer => unreachable,
            .literal_string => unreachable,
            .literal_float => unreachable,
            .literal_context_dependent_number => unreachable,
            .literal_ext_inst_integer => unreachable,
            .literal_spec_constant_op_integer => unreachable,
            .pair_literal_integer_id_ref => unreachable,
            .pair_id_ref_literal_integer => unreachable,
            .pair_id_ref_id_ref => unreachable,
            .tensor_operands => &.{
                .{ .name = "NoneARM", .value = 0x0000, .parameters = &.{} },
                .{ .name = "NontemporalARM", .value = 0x0001, .parameters = &.{} },
                .{ .name = "OutOfBoundsValueARM", .value = 0x0002, .parameters = &.{.id_ref} },
                .{ .name = "MakeElementAvailableARM", .value = 0x0004, .parameters = &.{.id_ref} },
                .{ .name = "MakeElementVisibleARM", .value = 0x0008, .parameters = &.{.id_ref} },
                .{ .name = "NonPrivateElementARM", .value = 0x0010, .parameters = &.{} },
            },
        };
    }
};

pub const Opcode = enum(u16) {
    OpNop = 0,
    OpUndef = 1,
    OpSourceContinued = 2,
    OpSource = 3,
    OpSourceExtension = 4,
    OpName = 5,
    OpMemberName = 6,
    OpString = 7,
    OpLine = 8,
    OpExtension = 10,
    OpExtInstImport = 11,
    OpExtInst = 12,
    OpMemoryModel = 14,
    OpEntryPoint = 15,
    OpExecutionMode = 16,
    OpCapability = 17,
    OpTypeVoid = 19,
    OpTypeBool = 20,
    OpTypeInt = 21,
    OpTypeFloat = 22,
    OpTypeVector = 23,
    OpTypeMatrix = 24,
    OpTypeImage = 25,
    OpTypeSampler = 26,
    OpTypeSampledImage = 27,
    OpTypeArray = 28,
    OpTypeRuntimeArray = 29,
    OpTypeStruct = 30,
    OpTypeOpaque = 31,
    OpTypePointer = 32,
    OpTypeFunction = 33,
    OpTypeEvent = 34,
    OpTypeDeviceEvent = 35,
    OpTypeReserveId = 36,
    OpTypeQueue = 37,
    OpTypePipe = 38,
    OpTypeForwardPointer = 39,
    OpConstantTrue = 41,
    OpConstantFalse = 42,
    OpConstant = 43,
    OpConstantComposite = 44,
    OpConstantSampler = 45,
    OpConstantNull = 46,
    OpSpecConstantTrue = 48,
    OpSpecConstantFalse = 49,
    OpSpecConstant = 50,
    OpSpecConstantComposite = 51,
    OpSpecConstantOp = 52,
    OpFunction = 54,
    OpFunctionParameter = 55,
    OpFunctionEnd = 56,
    OpFunctionCall = 57,
    OpVariable = 59,
    OpImageTexelPointer = 60,
    OpLoad = 61,
    OpStore = 62,
    OpCopyMemory = 63,
    OpCopyMemorySized = 64,
    OpAccessChain = 65,
    OpInBoundsAccessChain = 66,
    OpPtrAccessChain = 67,
    OpArrayLength = 68,
    OpGenericPtrMemSemantics = 69,
    OpInBoundsPtrAccessChain = 70,
    OpDecorate = 71,
    OpMemberDecorate = 72,
    OpDecorationGroup = 73,
    OpGroupDecorate = 74,
    OpGroupMemberDecorate = 75,
    OpVectorExtractDynamic = 77,
    OpVectorInsertDynamic = 78,
    OpVectorShuffle = 79,
    OpCompositeConstruct = 80,
    OpCompositeExtract = 81,
    OpCompositeInsert = 82,
    OpCopyObject = 83,
    OpTranspose = 84,
    OpSampledImage = 86,
    OpImageSampleImplicitLod = 87,
    OpImageSampleExplicitLod = 88,
    OpImageSampleDrefImplicitLod = 89,
    OpImageSampleDrefExplicitLod = 90,
    OpImageSampleProjImplicitLod = 91,
    OpImageSampleProjExplicitLod = 92,
    OpImageSampleProjDrefImplicitLod = 93,
    OpImageSampleProjDrefExplicitLod = 94,
    OpImageFetch = 95,
    OpImageGather = 96,
    OpImageDrefGather = 97,
    OpImageRead = 98,
    OpImageWrite = 99,
    OpImage = 100,
    OpImageQueryFormat = 101,
    OpImageQueryOrder = 102,
    OpImageQuerySizeLod = 103,
    OpImageQuerySize = 104,
    OpImageQueryLod = 105,
    OpImageQueryLevels = 106,
    OpImageQuerySamples = 107,
    OpConvertFToU = 109,
    OpConvertFToS = 110,
    OpConvertSToF = 111,
    OpConvertUToF = 112,
    OpUConvert = 113,
    OpSConvert = 114,
    OpFConvert = 115,
    OpQuantizeToF16 = 116,
    OpConvertPtrToU = 117,
    OpSatConvertSToU = 118,
    OpSatConvertUToS = 119,
    OpConvertUToPtr = 120,
    OpPtrCastToGeneric = 121,
    OpGenericCastToPtr = 122,
    OpGenericCastToPtrExplicit = 123,
    OpBitcast = 124,
    OpSNegate = 126,
    OpFNegate = 127,
    OpIAdd = 128,
    OpFAdd = 129,
    OpISub = 130,
    OpFSub = 131,
    OpIMul = 132,
    OpFMul = 133,
    OpUDiv = 134,
    OpSDiv = 135,
    OpFDiv = 136,
    OpUMod = 137,
    OpSRem = 138,
    OpSMod = 139,
    OpFRem = 140,
    OpFMod = 141,
    OpVectorTimesScalar = 142,
    OpMatrixTimesScalar = 143,
    OpVectorTimesMatrix = 144,
    OpMatrixTimesVector = 145,
    OpMatrixTimesMatrix = 146,
    OpOuterProduct = 147,
    OpDot = 148,
    OpIAddCarry = 149,
    OpISubBorrow = 150,
    OpUMulExtended = 151,
    OpSMulExtended = 152,
    OpAny = 154,
    OpAll = 155,
    OpIsNan = 156,
    OpIsInf = 157,
    OpIsFinite = 158,
    OpIsNormal = 159,
    OpSignBitSet = 160,
    OpLessOrGreater = 161,
    OpOrdered = 162,
    OpUnordered = 163,
    OpLogicalEqual = 164,
    OpLogicalNotEqual = 165,
    OpLogicalOr = 166,
    OpLogicalAnd = 167,
    OpLogicalNot = 168,
    OpSelect = 169,
    OpIEqual = 170,
    OpINotEqual = 171,
    OpUGreaterThan = 172,
    OpSGreaterThan = 173,
    OpUGreaterThanEqual = 174,
    OpSGreaterThanEqual = 175,
    OpULessThan = 176,
    OpSLessThan = 177,
    OpULessThanEqual = 178,
    OpSLessThanEqual = 179,
    OpFOrdEqual = 180,
    OpFUnordEqual = 181,
    OpFOrdNotEqual = 182,
    OpFUnordNotEqual = 183,
    OpFOrdLessThan = 184,
    OpFUnordLessThan = 185,
    OpFOrdGreaterThan = 186,
    OpFUnordGreaterThan = 187,
    OpFOrdLessThanEqual = 188,
    OpFUnordLessThanEqual = 189,
    OpFOrdGreaterThanEqual = 190,
    OpFUnordGreaterThanEqual = 191,
    OpShiftRightLogical = 194,
    OpShiftRightArithmetic = 195,
    OpShiftLeftLogical = 196,
    OpBitwiseOr = 197,
    OpBitwiseXor = 198,
    OpBitwiseAnd = 199,
    OpNot = 200,
    OpBitFieldInsert = 201,
    OpBitFieldSExtract = 202,
    OpBitFieldUExtract = 203,
    OpBitReverse = 204,
    OpBitCount = 205,
    OpDPdx = 207,
    OpDPdy = 208,
    OpFwidth = 209,
    OpDPdxFine = 210,
    OpDPdyFine = 211,
    OpFwidthFine = 212,
    OpDPdxCoarse = 213,
    OpDPdyCoarse = 214,
    OpFwidthCoarse = 215,
    OpEmitVertex = 218,
    OpEndPrimitive = 219,
    OpEmitStreamVertex = 220,
    OpEndStreamPrimitive = 221,
    OpControlBarrier = 224,
    OpMemoryBarrier = 225,
    OpAtomicLoad = 227,
    OpAtomicStore = 228,
    OpAtomicExchange = 229,
    OpAtomicCompareExchange = 230,
    OpAtomicCompareExchangeWeak = 231,
    OpAtomicIIncrement = 232,
    OpAtomicIDecrement = 233,
    OpAtomicIAdd = 234,
    OpAtomicISub = 235,
    OpAtomicSMin = 236,
    OpAtomicUMin = 237,
    OpAtomicSMax = 238,
    OpAtomicUMax = 239,
    OpAtomicAnd = 240,
    OpAtomicOr = 241,
    OpAtomicXor = 242,
    OpPhi = 245,
    OpLoopMerge = 246,
    OpSelectionMerge = 247,
    OpLabel = 248,
    OpBranch = 249,
    OpBranchConditional = 250,
    OpSwitch = 251,
    OpKill = 252,
    OpReturn = 253,
    OpReturnValue = 254,
    OpUnreachable = 255,
    OpLifetimeStart = 256,
    OpLifetimeStop = 257,
    OpGroupAsyncCopy = 259,
    OpGroupWaitEvents = 260,
    OpGroupAll = 261,
    OpGroupAny = 262,
    OpGroupBroadcast = 263,
    OpGroupIAdd = 264,
    OpGroupFAdd = 265,
    OpGroupFMin = 266,
    OpGroupUMin = 267,
    OpGroupSMin = 268,
    OpGroupFMax = 269,
    OpGroupUMax = 270,
    OpGroupSMax = 271,
    OpReadPipe = 274,
    OpWritePipe = 275,
    OpReservedReadPipe = 276,
    OpReservedWritePipe = 277,
    OpReserveReadPipePackets = 278,
    OpReserveWritePipePackets = 279,
    OpCommitReadPipe = 280,
    OpCommitWritePipe = 281,
    OpIsValidReserveId = 282,
    OpGetNumPipePackets = 283,
    OpGetMaxPipePackets = 284,
    OpGroupReserveReadPipePackets = 285,
    OpGroupReserveWritePipePackets = 286,
    OpGroupCommitReadPipe = 287,
    OpGroupCommitWritePipe = 288,
    OpEnqueueMarker = 291,
    OpEnqueueKernel = 292,
    OpGetKernelNDrangeSubGroupCount = 293,
    OpGetKernelNDrangeMaxSubGroupSize = 294,
    OpGetKernelWorkGroupSize = 295,
    OpGetKernelPreferredWorkGroupSizeMultiple = 296,
    OpRetainEvent = 297,
    OpReleaseEvent = 298,
    OpCreateUserEvent = 299,
    OpIsValidEvent = 300,
    OpSetUserEventStatus = 301,
    OpCaptureEventProfilingInfo = 302,
    OpGetDefaultQueue = 303,
    OpBuildNDRange = 304,
    OpImageSparseSampleImplicitLod = 305,
    OpImageSparseSampleExplicitLod = 306,
    OpImageSparseSampleDrefImplicitLod = 307,
    OpImageSparseSampleDrefExplicitLod = 308,
    OpImageSparseSampleProjImplicitLod = 309,
    OpImageSparseSampleProjExplicitLod = 310,
    OpImageSparseSampleProjDrefImplicitLod = 311,
    OpImageSparseSampleProjDrefExplicitLod = 312,
    OpImageSparseFetch = 313,
    OpImageSparseGather = 314,
    OpImageSparseDrefGather = 315,
    OpImageSparseTexelsResident = 316,
    OpNoLine = 317,
    OpAtomicFlagTestAndSet = 318,
    OpAtomicFlagClear = 319,
    OpImageSparseRead = 320,
    OpSizeOf = 321,
    OpTypePipeStorage = 322,
    OpConstantPipeStorage = 323,
    OpCreatePipeFromPipeStorage = 324,
    OpGetKernelLocalSizeForSubgroupCount = 325,
    OpGetKernelMaxNumSubgroups = 326,
    OpTypeNamedBarrier = 327,
    OpNamedBarrierInitialize = 328,
    OpMemoryNamedBarrier = 329,
    OpModuleProcessed = 330,
    OpExecutionModeId = 331,
    OpDecorateId = 332,
    OpGroupNonUniformElect = 333,
    OpGroupNonUniformAll = 334,
    OpGroupNonUniformAny = 335,
    OpGroupNonUniformAllEqual = 336,
    OpGroupNonUniformBroadcast = 337,
    OpGroupNonUniformBroadcastFirst = 338,
    OpGroupNonUniformBallot = 339,
    OpGroupNonUniformInverseBallot = 340,
    OpGroupNonUniformBallotBitExtract = 341,
    OpGroupNonUniformBallotBitCount = 342,
    OpGroupNonUniformBallotFindLSB = 343,
    OpGroupNonUniformBallotFindMSB = 344,
    OpGroupNonUniformShuffle = 345,
    OpGroupNonUniformShuffleXor = 346,
    OpGroupNonUniformShuffleUp = 347,
    OpGroupNonUniformShuffleDown = 348,
    OpGroupNonUniformIAdd = 349,
    OpGroupNonUniformFAdd = 350,
    OpGroupNonUniformIMul = 351,
    OpGroupNonUniformFMul = 352,
    OpGroupNonUniformSMin = 353,
    OpGroupNonUniformUMin = 354,
    OpGroupNonUniformFMin = 355,
    OpGroupNonUniformSMax = 356,
    OpGroupNonUniformUMax = 357,
    OpGroupNonUniformFMax = 358,
    OpGroupNonUniformBitwiseAnd = 359,
    OpGroupNonUniformBitwiseOr = 360,
    OpGroupNonUniformBitwiseXor = 361,
    OpGroupNonUniformLogicalAnd = 362,
    OpGroupNonUniformLogicalOr = 363,
    OpGroupNonUniformLogicalXor = 364,
    OpGroupNonUniformQuadBroadcast = 365,
    OpGroupNonUniformQuadSwap = 366,
    OpCopyLogical = 400,
    OpPtrEqual = 401,
    OpPtrNotEqual = 402,
    OpPtrDiff = 403,
    OpColorAttachmentReadEXT = 4160,
    OpDepthAttachmentReadEXT = 4161,
    OpStencilAttachmentReadEXT = 4162,
    OpTypeTensorARM = 4163,
    OpTensorReadARM = 4164,
    OpTensorWriteARM = 4165,
    OpTensorQuerySizeARM = 4166,
    OpGraphConstantARM = 4181,
    OpGraphEntryPointARM = 4182,
    OpGraphARM = 4183,
    OpGraphInputARM = 4184,
    OpGraphSetOutputARM = 4185,
    OpGraphEndARM = 4186,
    OpTypeGraphARM = 4190,
    OpTerminateInvocation = 4416,
    OpTypeUntypedPointerKHR = 4417,
    OpUntypedVariableKHR = 4418,
    OpUntypedAccessChainKHR = 4419,
    OpUntypedInBoundsAccessChainKHR = 4420,
    OpSubgroupBallotKHR = 4421,
    OpSubgroupFirstInvocationKHR = 4422,
    OpUntypedPtrAccessChainKHR = 4423,
    OpUntypedInBoundsPtrAccessChainKHR = 4424,
    OpUntypedArrayLengthKHR = 4425,
    OpUntypedPrefetchKHR = 4426,
    OpSubgroupAllKHR = 4428,
    OpSubgroupAnyKHR = 4429,
    OpSubgroupAllEqualKHR = 4430,
    OpGroupNonUniformRotateKHR = 4431,
    OpSubgroupReadInvocationKHR = 4432,
    OpExtInstWithForwardRefsKHR = 4433,
    OpTraceRayKHR = 4445,
    OpExecuteCallableKHR = 4446,
    OpConvertUToAccelerationStructureKHR = 4447,
    OpIgnoreIntersectionKHR = 4448,
    OpTerminateRayKHR = 4449,
    OpSDot = 4450,
    OpUDot = 4451,
    OpSUDot = 4452,
    OpSDotAccSat = 4453,
    OpUDotAccSat = 4454,
    OpSUDotAccSat = 4455,
    OpTypeCooperativeMatrixKHR = 4456,
    OpCooperativeMatrixLoadKHR = 4457,
    OpCooperativeMatrixStoreKHR = 4458,
    OpCooperativeMatrixMulAddKHR = 4459,
    OpCooperativeMatrixLengthKHR = 4460,
    OpConstantCompositeReplicateEXT = 4461,
    OpSpecConstantCompositeReplicateEXT = 4462,
    OpCompositeConstructReplicateEXT = 4463,
    OpTypeRayQueryKHR = 4472,
    OpRayQueryInitializeKHR = 4473,
    OpRayQueryTerminateKHR = 4474,
    OpRayQueryGenerateIntersectionKHR = 4475,
    OpRayQueryConfirmIntersectionKHR = 4476,
    OpRayQueryProceedKHR = 4477,
    OpRayQueryGetIntersectionTypeKHR = 4479,
    OpImageSampleWeightedQCOM = 4480,
    OpImageBoxFilterQCOM = 4481,
    OpImageBlockMatchSSDQCOM = 4482,
    OpImageBlockMatchSADQCOM = 4483,
    OpImageBlockMatchWindowSSDQCOM = 4500,
    OpImageBlockMatchWindowSADQCOM = 4501,
    OpImageBlockMatchGatherSSDQCOM = 4502,
    OpImageBlockMatchGatherSADQCOM = 4503,
    OpGroupIAddNonUniformAMD = 5000,
    OpGroupFAddNonUniformAMD = 5001,
    OpGroupFMinNonUniformAMD = 5002,
    OpGroupUMinNonUniformAMD = 5003,
    OpGroupSMinNonUniformAMD = 5004,
    OpGroupFMaxNonUniformAMD = 5005,
    OpGroupUMaxNonUniformAMD = 5006,
    OpGroupSMaxNonUniformAMD = 5007,
    OpFragmentMaskFetchAMD = 5011,
    OpFragmentFetchAMD = 5012,
    OpReadClockKHR = 5056,
    OpAllocateNodePayloadsAMDX = 5074,
    OpEnqueueNodePayloadsAMDX = 5075,
    OpTypeNodePayloadArrayAMDX = 5076,
    OpFinishWritingNodePayloadAMDX = 5078,
    OpNodePayloadArrayLengthAMDX = 5090,
    OpIsNodePayloadValidAMDX = 5101,
    OpConstantStringAMDX = 5103,
    OpSpecConstantStringAMDX = 5104,
    OpGroupNonUniformQuadAllKHR = 5110,
    OpGroupNonUniformQuadAnyKHR = 5111,
    OpHitObjectRecordHitMotionNV = 5249,
    OpHitObjectRecordHitWithIndexMotionNV = 5250,
    OpHitObjectRecordMissMotionNV = 5251,
    OpHitObjectGetWorldToObjectNV = 5252,
    OpHitObjectGetObjectToWorldNV = 5253,
    OpHitObjectGetObjectRayDirectionNV = 5254,
    OpHitObjectGetObjectRayOriginNV = 5255,
    OpHitObjectTraceRayMotionNV = 5256,
    OpHitObjectGetShaderRecordBufferHandleNV = 5257,
    OpHitObjectGetShaderBindingTableRecordIndexNV = 5258,
    OpHitObjectRecordEmptyNV = 5259,
    OpHitObjectTraceRayNV = 5260,
    OpHitObjectRecordHitNV = 5261,
    OpHitObjectRecordHitWithIndexNV = 5262,
    OpHitObjectRecordMissNV = 5263,
    OpHitObjectExecuteShaderNV = 5264,
    OpHitObjectGetCurrentTimeNV = 5265,
    OpHitObjectGetAttributesNV = 5266,
    OpHitObjectGetHitKindNV = 5267,
    OpHitObjectGetPrimitiveIndexNV = 5268,
    OpHitObjectGetGeometryIndexNV = 5269,
    OpHitObjectGetInstanceIdNV = 5270,
    OpHitObjectGetInstanceCustomIndexNV = 5271,
    OpHitObjectGetWorldRayDirectionNV = 5272,
    OpHitObjectGetWorldRayOriginNV = 5273,
    OpHitObjectGetRayTMaxNV = 5274,
    OpHitObjectGetRayTMinNV = 5275,
    OpHitObjectIsEmptyNV = 5276,
    OpHitObjectIsHitNV = 5277,
    OpHitObjectIsMissNV = 5278,
    OpReorderThreadWithHitObjectNV = 5279,
    OpReorderThreadWithHintNV = 5280,
    OpTypeHitObjectNV = 5281,
    OpImageSampleFootprintNV = 5283,
    OpTypeCooperativeVectorNV = 5288,
    OpCooperativeVectorMatrixMulNV = 5289,
    OpCooperativeVectorOuterProductAccumulateNV = 5290,
    OpCooperativeVectorReduceSumAccumulateNV = 5291,
    OpCooperativeVectorMatrixMulAddNV = 5292,
    OpCooperativeMatrixConvertNV = 5293,
    OpEmitMeshTasksEXT = 5294,
    OpSetMeshOutputsEXT = 5295,
    OpGroupNonUniformPartitionNV = 5296,
    OpWritePackedPrimitiveIndices4x8NV = 5299,
    OpFetchMicroTriangleVertexPositionNV = 5300,
    OpFetchMicroTriangleVertexBarycentricNV = 5301,
    OpCooperativeVectorLoadNV = 5302,
    OpCooperativeVectorStoreNV = 5303,
    OpReportIntersectionKHR = 5334,
    OpIgnoreIntersectionNV = 5335,
    OpTerminateRayNV = 5336,
    OpTraceNV = 5337,
    OpTraceMotionNV = 5338,
    OpTraceRayMotionNV = 5339,
    OpRayQueryGetIntersectionTriangleVertexPositionsKHR = 5340,
    OpTypeAccelerationStructureKHR = 5341,
    OpExecuteCallableNV = 5344,
    OpRayQueryGetClusterIdNV = 5345,
    OpHitObjectGetClusterIdNV = 5346,
    OpTypeCooperativeMatrixNV = 5358,
    OpCooperativeMatrixLoadNV = 5359,
    OpCooperativeMatrixStoreNV = 5360,
    OpCooperativeMatrixMulAddNV = 5361,
    OpCooperativeMatrixLengthNV = 5362,
    OpBeginInvocationInterlockEXT = 5364,
    OpEndInvocationInterlockEXT = 5365,
    OpCooperativeMatrixReduceNV = 5366,
    OpCooperativeMatrixLoadTensorNV = 5367,
    OpCooperativeMatrixStoreTensorNV = 5368,
    OpCooperativeMatrixPerElementOpNV = 5369,
    OpTypeTensorLayoutNV = 5370,
    OpTypeTensorViewNV = 5371,
    OpCreateTensorLayoutNV = 5372,
    OpTensorLayoutSetDimensionNV = 5373,
    OpTensorLayoutSetStrideNV = 5374,
    OpTensorLayoutSliceNV = 5375,
    OpTensorLayoutSetClampValueNV = 5376,
    OpCreateTensorViewNV = 5377,
    OpTensorViewSetDimensionNV = 5378,
    OpTensorViewSetStrideNV = 5379,
    OpDemoteToHelperInvocation = 5380,
    OpIsHelperInvocationEXT = 5381,
    OpTensorViewSetClipNV = 5382,
    OpTensorLayoutSetBlockSizeNV = 5384,
    OpCooperativeMatrixTransposeNV = 5390,
    OpConvertUToImageNV = 5391,
    OpConvertUToSamplerNV = 5392,
    OpConvertImageToUNV = 5393,
    OpConvertSamplerToUNV = 5394,
    OpConvertUToSampledImageNV = 5395,
    OpConvertSampledImageToUNV = 5396,
    OpSamplerImageAddressingModeNV = 5397,
    OpRawAccessChainNV = 5398,
    OpRayQueryGetIntersectionSpherePositionNV = 5427,
    OpRayQueryGetIntersectionSphereRadiusNV = 5428,
    OpRayQueryGetIntersectionLSSPositionsNV = 5429,
    OpRayQueryGetIntersectionLSSRadiiNV = 5430,
    OpRayQueryGetIntersectionLSSHitValueNV = 5431,
    OpHitObjectGetSpherePositionNV = 5432,
    OpHitObjectGetSphereRadiusNV = 5433,
    OpHitObjectGetLSSPositionsNV = 5434,
    OpHitObjectGetLSSRadiiNV = 5435,
    OpHitObjectIsSphereHitNV = 5436,
    OpHitObjectIsLSSHitNV = 5437,
    OpRayQueryIsSphereHitNV = 5438,
    OpRayQueryIsLSSHitNV = 5439,
    OpSubgroupShuffleINTEL = 5571,
    OpSubgroupShuffleDownINTEL = 5572,
    OpSubgroupShuffleUpINTEL = 5573,
    OpSubgroupShuffleXorINTEL = 5574,
    OpSubgroupBlockReadINTEL = 5575,
    OpSubgroupBlockWriteINTEL = 5576,
    OpSubgroupImageBlockReadINTEL = 5577,
    OpSubgroupImageBlockWriteINTEL = 5578,
    OpSubgroupImageMediaBlockReadINTEL = 5580,
    OpSubgroupImageMediaBlockWriteINTEL = 5581,
    OpUCountLeadingZerosINTEL = 5585,
    OpUCountTrailingZerosINTEL = 5586,
    OpAbsISubINTEL = 5587,
    OpAbsUSubINTEL = 5588,
    OpIAddSatINTEL = 5589,
    OpUAddSatINTEL = 5590,
    OpIAverageINTEL = 5591,
    OpUAverageINTEL = 5592,
    OpIAverageRoundedINTEL = 5593,
    OpUAverageRoundedINTEL = 5594,
    OpISubSatINTEL = 5595,
    OpUSubSatINTEL = 5596,
    OpIMul32x16INTEL = 5597,
    OpUMul32x16INTEL = 5598,
    OpAtomicFMinEXT = 5614,
    OpAtomicFMaxEXT = 5615,
    OpAssumeTrueKHR = 5630,
    OpExpectKHR = 5631,
    OpDecorateString = 5632,
    OpMemberDecorateString = 5633,
    OpLoopControlINTEL = 5887,
    OpReadPipeBlockingINTEL = 5946,
    OpWritePipeBlockingINTEL = 5947,
    OpFPGARegINTEL = 5949,
    OpRayQueryGetRayTMinKHR = 6016,
    OpRayQueryGetRayFlagsKHR = 6017,
    OpRayQueryGetIntersectionTKHR = 6018,
    OpRayQueryGetIntersectionInstanceCustomIndexKHR = 6019,
    OpRayQueryGetIntersectionInstanceIdKHR = 6020,
    OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR = 6021,
    OpRayQueryGetIntersectionGeometryIndexKHR = 6022,
    OpRayQueryGetIntersectionPrimitiveIndexKHR = 6023,
    OpRayQueryGetIntersectionBarycentricsKHR = 6024,
    OpRayQueryGetIntersectionFrontFaceKHR = 6025,
    OpRayQueryGetIntersectionCandidateAABBOpaqueKHR = 6026,
    OpRayQueryGetIntersectionObjectRayDirectionKHR = 6027,
    OpRayQueryGetIntersectionObjectRayOriginKHR = 6028,
    OpRayQueryGetWorldRayDirectionKHR = 6029,
    OpRayQueryGetWorldRayOriginKHR = 6030,
    OpRayQueryGetIntersectionObjectToWorldKHR = 6031,
    OpRayQueryGetIntersectionWorldToObjectKHR = 6032,
    OpAtomicFAddEXT = 6035,
    OpTypeBufferSurfaceINTEL = 6086,
    OpTypeStructContinuedINTEL = 6090,
    OpConstantCompositeContinuedINTEL = 6091,
    OpSpecConstantCompositeContinuedINTEL = 6092,
    OpCompositeConstructContinuedINTEL = 6096,
    OpConvertFToBF16INTEL = 6116,
    OpConvertBF16ToFINTEL = 6117,
    OpControlBarrierArriveINTEL = 6142,
    OpControlBarrierWaitINTEL = 6143,
    OpArithmeticFenceEXT = 6145,
    OpTaskSequenceCreateINTEL = 6163,
    OpTaskSequenceAsyncINTEL = 6164,
    OpTaskSequenceGetINTEL = 6165,
    OpTaskSequenceReleaseINTEL = 6166,
    OpTypeTaskSequenceINTEL = 6199,
    OpSubgroupBlockPrefetchINTEL = 6221,
    OpSubgroup2DBlockLoadINTEL = 6231,
    OpSubgroup2DBlockLoadTransformINTEL = 6232,
    OpSubgroup2DBlockLoadTransposeINTEL = 6233,
    OpSubgroup2DBlockPrefetchINTEL = 6234,
    OpSubgroup2DBlockStoreINTEL = 6235,
    OpSubgroupMatrixMultiplyAccumulateINTEL = 6237,
    OpBitwiseFunctionINTEL = 6242,
    OpGroupIMulKHR = 6401,
    OpGroupFMulKHR = 6402,
    OpGroupBitwiseAndKHR = 6403,
    OpGroupBitwiseOrKHR = 6404,
    OpGroupBitwiseXorKHR = 6405,
    OpGroupLogicalAndKHR = 6406,
    OpGroupLogicalOrKHR = 6407,
    OpGroupLogicalXorKHR = 6408,
    OpRoundFToTF32INTEL = 6426,
    OpMaskedGatherINTEL = 6428,
    OpMaskedScatterINTEL = 6429,
    OpConvertHandleToImageINTEL = 6529,
    OpConvertHandleToSamplerINTEL = 6530,
    OpConvertHandleToSampledImageINTEL = 6531,

    pub fn Operands(comptime self: Opcode) type {
        return switch (self) {
            .OpNop => void,
            .OpUndef => struct { id_result_type: Id, id_result: Id },
            .OpSourceContinued => struct { continued_source: LiteralString },
            .OpSource => struct { source_language: SourceLanguage, version: LiteralInteger, file: ?Id = null, source: ?LiteralString = null },
            .OpSourceExtension => struct { extension: LiteralString },
            .OpName => struct { target: Id, name: LiteralString },
            .OpMemberName => struct { type: Id, member: LiteralInteger, name: LiteralString },
            .OpString => struct { id_result: Id, string: LiteralString },
            .OpLine => struct { file: Id, line: LiteralInteger, column: LiteralInteger },
            .OpExtension => struct { name: LiteralString },
            .OpExtInstImport => struct { id_result: Id, name: LiteralString },
            .OpExtInst => struct { id_result_type: Id, id_result: Id, set: Id, instruction: LiteralExtInstInteger, id_ref_4: []const Id = &.{} },
            .OpMemoryModel => struct { addressing_model: AddressingModel, memory_model: MemoryModel },
            .OpEntryPoint => struct { execution_model: ExecutionModel, entry_point: Id, name: LiteralString, interface: []const Id = &.{} },
            .OpExecutionMode => struct { entry_point: Id, mode: ExecutionMode.Extended },
            .OpCapability => struct { capability: Capability },
            .OpTypeVoid => struct { id_result: Id },
            .OpTypeBool => struct { id_result: Id },
            .OpTypeInt => struct { id_result: Id, width: LiteralInteger, signedness: LiteralInteger },
            .OpTypeFloat => struct { id_result: Id, width: LiteralInteger, floating_point_encoding: ?FPEncoding = null },
            .OpTypeVector => struct { id_result: Id, component_type: Id, component_count: LiteralInteger },
            .OpTypeMatrix => struct { id_result: Id, column_type: Id, column_count: LiteralInteger },
            .OpTypeImage => struct { id_result: Id, sampled_type: Id, dim: Dim, depth: LiteralInteger, arrayed: LiteralInteger, ms: LiteralInteger, sampled: LiteralInteger, image_format: ImageFormat, access_qualifier: ?AccessQualifier = null },
            .OpTypeSampler => struct { id_result: Id },
            .OpTypeSampledImage => struct { id_result: Id, image_type: Id },
            .OpTypeArray => struct { id_result: Id, element_type: Id, length: Id },
            .OpTypeRuntimeArray => struct { id_result: Id, element_type: Id },
            .OpTypeStruct => struct { id_result: Id, id_ref: []const Id = &.{} },
            .OpTypeOpaque => struct { id_result: Id, literal_string: LiteralString },
            .OpTypePointer => struct { id_result: Id, storage_class: StorageClass, type: Id },
            .OpTypeFunction => struct { id_result: Id, return_type: Id, id_ref_2: []const Id = &.{} },
            .OpTypeEvent => struct { id_result: Id },
            .OpTypeDeviceEvent => struct { id_result: Id },
            .OpTypeReserveId => struct { id_result: Id },
            .OpTypeQueue => struct { id_result: Id },
            .OpTypePipe => struct { id_result: Id, qualifier: AccessQualifier },
            .OpTypeForwardPointer => struct { pointer_type: Id, storage_class: StorageClass },
            .OpConstantTrue => struct { id_result_type: Id, id_result: Id },
            .OpConstantFalse => struct { id_result_type: Id, id_result: Id },
            .OpConstant => struct { id_result_type: Id, id_result: Id, value: LiteralContextDependentNumber },
            .OpConstantComposite => struct { id_result_type: Id, id_result: Id, constituents: []const Id = &.{} },
            .OpConstantSampler => struct { id_result_type: Id, id_result: Id, sampler_addressing_mode: SamplerAddressingMode, param: LiteralInteger, sampler_filter_mode: SamplerFilterMode },
            .OpConstantNull => struct { id_result_type: Id, id_result: Id },
            .OpSpecConstantTrue => struct { id_result_type: Id, id_result: Id },
            .OpSpecConstantFalse => struct { id_result_type: Id, id_result: Id },
            .OpSpecConstant => struct { id_result_type: Id, id_result: Id, value: LiteralContextDependentNumber },
            .OpSpecConstantComposite => struct { id_result_type: Id, id_result: Id, constituents: []const Id = &.{} },
            .OpSpecConstantOp => struct { id_result_type: Id, id_result: Id, opcode: LiteralSpecConstantOpInteger },
            .OpFunction => struct { id_result_type: Id, id_result: Id, function_control: FunctionControl, function_type: Id },
            .OpFunctionParameter => struct { id_result_type: Id, id_result: Id },
            .OpFunctionEnd => void,
            .OpFunctionCall => struct { id_result_type: Id, id_result: Id, function: Id, id_ref_3: []const Id = &.{} },
            .OpVariable => struct { id_result_type: Id, id_result: Id, storage_class: StorageClass, initializer: ?Id = null },
            .OpImageTexelPointer => struct { id_result_type: Id, id_result: Id, image: Id, coordinate: Id, sample: Id },
            .OpLoad => struct { id_result_type: Id, id_result: Id, pointer: Id, memory_access: ?MemoryAccess.Extended = null },
            .OpStore => struct { pointer: Id, object: Id, memory_access: ?MemoryAccess.Extended = null },
            .OpCopyMemory => struct { target: Id, source: Id, memory_access_2: ?MemoryAccess.Extended = null, memory_access_3: ?MemoryAccess.Extended = null },
            .OpCopyMemorySized => struct { target: Id, source: Id, size: Id, memory_access_3: ?MemoryAccess.Extended = null, memory_access_4: ?MemoryAccess.Extended = null },
            .OpAccessChain => struct { id_result_type: Id, id_result: Id, base: Id, indexes: []const Id = &.{} },
            .OpInBoundsAccessChain => struct { id_result_type: Id, id_result: Id, base: Id, indexes: []const Id = &.{} },
            .OpPtrAccessChain => struct { id_result_type: Id, id_result: Id, base: Id, element: Id, indexes: []const Id = &.{} },
            .OpArrayLength => struct { id_result_type: Id, id_result: Id, structure: Id, array_member: LiteralInteger },
            .OpGenericPtrMemSemantics => struct { id_result_type: Id, id_result: Id, pointer: Id },
            .OpInBoundsPtrAccessChain => struct { id_result_type: Id, id_result: Id, base: Id, element: Id, indexes: []const Id = &.{} },
            .OpDecorate => struct { target: Id, decoration: Decoration.Extended },
            .OpMemberDecorate => struct { structure_type: Id, member: LiteralInteger, decoration: Decoration.Extended },
            .OpDecorationGroup => struct { id_result: Id },
            .OpGroupDecorate => struct { decoration_group: Id, targets: []const Id = &.{} },
            .OpGroupMemberDecorate => struct { decoration_group: Id, targets: []const PairIdRefLiteralInteger = &.{} },
            .OpVectorExtractDynamic => struct { id_result_type: Id, id_result: Id, vector: Id, index: Id },
            .OpVectorInsertDynamic => struct { id_result_type: Id, id_result: Id, vector: Id, component: Id, index: Id },
            .OpVectorShuffle => struct { id_result_type: Id, id_result: Id, vector_1: Id, vector_2: Id, components: []const LiteralInteger = &.{} },
            .OpCompositeConstruct => struct { id_result_type: Id, id_result: Id, constituents: []const Id = &.{} },
            .OpCompositeExtract => struct { id_result_type: Id, id_result: Id, composite: Id, indexes: []const LiteralInteger = &.{} },
            .OpCompositeInsert => struct { id_result_type: Id, id_result: Id, object: Id, composite: Id, indexes: []const LiteralInteger = &.{} },
            .OpCopyObject => struct { id_result_type: Id, id_result: Id, operand: Id },
            .OpTranspose => struct { id_result_type: Id, id_result: Id, matrix: Id },
            .OpSampledImage => struct { id_result_type: Id, id_result: Id, image: Id, sampler: Id },
            .OpImageSampleImplicitLod => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, image_operands: ?ImageOperands.Extended = null },
            .OpImageSampleExplicitLod => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, image_operands: ImageOperands.Extended },
            .OpImageSampleDrefImplicitLod => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, d_ref: Id, image_operands: ?ImageOperands.Extended = null },
            .OpImageSampleDrefExplicitLod => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, d_ref: Id, image_operands: ImageOperands.Extended },
            .OpImageSampleProjImplicitLod => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, image_operands: ?ImageOperands.Extended = null },
            .OpImageSampleProjExplicitLod => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, image_operands: ImageOperands.Extended },
            .OpImageSampleProjDrefImplicitLod => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, d_ref: Id, image_operands: ?ImageOperands.Extended = null },
            .OpImageSampleProjDrefExplicitLod => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, d_ref: Id, image_operands: ImageOperands.Extended },
            .OpImageFetch => struct { id_result_type: Id, id_result: Id, image: Id, coordinate: Id, image_operands: ?ImageOperands.Extended = null },
            .OpImageGather => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, component: Id, image_operands: ?ImageOperands.Extended = null },
            .OpImageDrefGather => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, d_ref: Id, image_operands: ?ImageOperands.Extended = null },
            .OpImageRead => struct { id_result_type: Id, id_result: Id, image: Id, coordinate: Id, image_operands: ?ImageOperands.Extended = null },
            .OpImageWrite => struct { image: Id, coordinate: Id, texel: Id, image_operands: ?ImageOperands.Extended = null },
            .OpImage => struct { id_result_type: Id, id_result: Id, sampled_image: Id },
            .OpImageQueryFormat => struct { id_result_type: Id, id_result: Id, image: Id },
            .OpImageQueryOrder => struct { id_result_type: Id, id_result: Id, image: Id },
            .OpImageQuerySizeLod => struct { id_result_type: Id, id_result: Id, image: Id, level_of_detail: Id },
            .OpImageQuerySize => struct { id_result_type: Id, id_result: Id, image: Id },
            .OpImageQueryLod => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id },
            .OpImageQueryLevels => struct { id_result_type: Id, id_result: Id, image: Id },
            .OpImageQuerySamples => struct { id_result_type: Id, id_result: Id, image: Id },
            .OpConvertFToU => struct { id_result_type: Id, id_result: Id, float_value: Id },
            .OpConvertFToS => struct { id_result_type: Id, id_result: Id, float_value: Id },
            .OpConvertSToF => struct { id_result_type: Id, id_result: Id, signed_value: Id },
            .OpConvertUToF => struct { id_result_type: Id, id_result: Id, unsigned_value: Id },
            .OpUConvert => struct { id_result_type: Id, id_result: Id, unsigned_value: Id },
            .OpSConvert => struct { id_result_type: Id, id_result: Id, signed_value: Id },
            .OpFConvert => struct { id_result_type: Id, id_result: Id, float_value: Id },
            .OpQuantizeToF16 => struct { id_result_type: Id, id_result: Id, value: Id },
            .OpConvertPtrToU => struct { id_result_type: Id, id_result: Id, pointer: Id },
            .OpSatConvertSToU => struct { id_result_type: Id, id_result: Id, signed_value: Id },
            .OpSatConvertUToS => struct { id_result_type: Id, id_result: Id, unsigned_value: Id },
            .OpConvertUToPtr => struct { id_result_type: Id, id_result: Id, integer_value: Id },
            .OpPtrCastToGeneric => struct { id_result_type: Id, id_result: Id, pointer: Id },
            .OpGenericCastToPtr => struct { id_result_type: Id, id_result: Id, pointer: Id },
            .OpGenericCastToPtrExplicit => struct { id_result_type: Id, id_result: Id, pointer: Id, storage: StorageClass },
            .OpBitcast => struct { id_result_type: Id, id_result: Id, operand: Id },
            .OpSNegate => struct { id_result_type: Id, id_result: Id, operand: Id },
            .OpFNegate => struct { id_result_type: Id, id_result: Id, operand: Id },
            .OpIAdd => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpFAdd => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpISub => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpFSub => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpIMul => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpFMul => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpUDiv => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpSDiv => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpFDiv => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpUMod => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpSRem => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpSMod => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpFRem => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpFMod => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpVectorTimesScalar => struct { id_result_type: Id, id_result: Id, vector: Id, scalar: Id },
            .OpMatrixTimesScalar => struct { id_result_type: Id, id_result: Id, matrix: Id, scalar: Id },
            .OpVectorTimesMatrix => struct { id_result_type: Id, id_result: Id, vector: Id, matrix: Id },
            .OpMatrixTimesVector => struct { id_result_type: Id, id_result: Id, matrix: Id, vector: Id },
            .OpMatrixTimesMatrix => struct { id_result_type: Id, id_result: Id, left_matrix: Id, right_matrix: Id },
            .OpOuterProduct => struct { id_result_type: Id, id_result: Id, vector_1: Id, vector_2: Id },
            .OpDot => struct { id_result_type: Id, id_result: Id, vector_1: Id, vector_2: Id },
            .OpIAddCarry => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpISubBorrow => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpUMulExtended => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpSMulExtended => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpAny => struct { id_result_type: Id, id_result: Id, vector: Id },
            .OpAll => struct { id_result_type: Id, id_result: Id, vector: Id },
            .OpIsNan => struct { id_result_type: Id, id_result: Id, x: Id },
            .OpIsInf => struct { id_result_type: Id, id_result: Id, x: Id },
            .OpIsFinite => struct { id_result_type: Id, id_result: Id, x: Id },
            .OpIsNormal => struct { id_result_type: Id, id_result: Id, x: Id },
            .OpSignBitSet => struct { id_result_type: Id, id_result: Id, x: Id },
            .OpLessOrGreater => struct { id_result_type: Id, id_result: Id, x: Id, y: Id },
            .OpOrdered => struct { id_result_type: Id, id_result: Id, x: Id, y: Id },
            .OpUnordered => struct { id_result_type: Id, id_result: Id, x: Id, y: Id },
            .OpLogicalEqual => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpLogicalNotEqual => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpLogicalOr => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpLogicalAnd => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpLogicalNot => struct { id_result_type: Id, id_result: Id, operand: Id },
            .OpSelect => struct { id_result_type: Id, id_result: Id, condition: Id, object_1: Id, object_2: Id },
            .OpIEqual => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpINotEqual => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpUGreaterThan => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpSGreaterThan => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpUGreaterThanEqual => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpSGreaterThanEqual => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpULessThan => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpSLessThan => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpULessThanEqual => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpSLessThanEqual => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpFOrdEqual => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpFUnordEqual => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpFOrdNotEqual => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpFUnordNotEqual => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpFOrdLessThan => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpFUnordLessThan => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpFOrdGreaterThan => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpFUnordGreaterThan => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpFOrdLessThanEqual => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpFUnordLessThanEqual => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpFOrdGreaterThanEqual => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpFUnordGreaterThanEqual => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpShiftRightLogical => struct { id_result_type: Id, id_result: Id, base: Id, shift: Id },
            .OpShiftRightArithmetic => struct { id_result_type: Id, id_result: Id, base: Id, shift: Id },
            .OpShiftLeftLogical => struct { id_result_type: Id, id_result: Id, base: Id, shift: Id },
            .OpBitwiseOr => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpBitwiseXor => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpBitwiseAnd => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpNot => struct { id_result_type: Id, id_result: Id, operand: Id },
            .OpBitFieldInsert => struct { id_result_type: Id, id_result: Id, base: Id, insert: Id, offset: Id, count: Id },
            .OpBitFieldSExtract => struct { id_result_type: Id, id_result: Id, base: Id, offset: Id, count: Id },
            .OpBitFieldUExtract => struct { id_result_type: Id, id_result: Id, base: Id, offset: Id, count: Id },
            .OpBitReverse => struct { id_result_type: Id, id_result: Id, base: Id },
            .OpBitCount => struct { id_result_type: Id, id_result: Id, base: Id },
            .OpDPdx => struct { id_result_type: Id, id_result: Id, p: Id },
            .OpDPdy => struct { id_result_type: Id, id_result: Id, p: Id },
            .OpFwidth => struct { id_result_type: Id, id_result: Id, p: Id },
            .OpDPdxFine => struct { id_result_type: Id, id_result: Id, p: Id },
            .OpDPdyFine => struct { id_result_type: Id, id_result: Id, p: Id },
            .OpFwidthFine => struct { id_result_type: Id, id_result: Id, p: Id },
            .OpDPdxCoarse => struct { id_result_type: Id, id_result: Id, p: Id },
            .OpDPdyCoarse => struct { id_result_type: Id, id_result: Id, p: Id },
            .OpFwidthCoarse => struct { id_result_type: Id, id_result: Id, p: Id },
            .OpEmitVertex => void,
            .OpEndPrimitive => void,
            .OpEmitStreamVertex => struct { stream: Id },
            .OpEndStreamPrimitive => struct { stream: Id },
            .OpControlBarrier => struct { execution: Id, memory: Id, semantics: Id },
            .OpMemoryBarrier => struct { memory: Id, semantics: Id },
            .OpAtomicLoad => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, semantics: Id },
            .OpAtomicStore => struct { pointer: Id, memory: Id, semantics: Id, value: Id },
            .OpAtomicExchange => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, semantics: Id, value: Id },
            .OpAtomicCompareExchange => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, equal: Id, unequal: Id, value: Id, comparator: Id },
            .OpAtomicCompareExchangeWeak => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, equal: Id, unequal: Id, value: Id, comparator: Id },
            .OpAtomicIIncrement => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, semantics: Id },
            .OpAtomicIDecrement => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, semantics: Id },
            .OpAtomicIAdd => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, semantics: Id, value: Id },
            .OpAtomicISub => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, semantics: Id, value: Id },
            .OpAtomicSMin => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, semantics: Id, value: Id },
            .OpAtomicUMin => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, semantics: Id, value: Id },
            .OpAtomicSMax => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, semantics: Id, value: Id },
            .OpAtomicUMax => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, semantics: Id, value: Id },
            .OpAtomicAnd => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, semantics: Id, value: Id },
            .OpAtomicOr => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, semantics: Id, value: Id },
            .OpAtomicXor => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, semantics: Id, value: Id },
            .OpPhi => struct { id_result_type: Id, id_result: Id, pair_id_ref_id_ref: []const PairIdRefIdRef = &.{} },
            .OpLoopMerge => struct { merge_block: Id, continue_target: Id, loop_control: LoopControl.Extended },
            .OpSelectionMerge => struct { merge_block: Id, selection_control: SelectionControl },
            .OpLabel => struct { id_result: Id },
            .OpBranch => struct { target_label: Id },
            .OpBranchConditional => struct { condition: Id, true_label: Id, false_label: Id, branch_weights: []const LiteralInteger = &.{} },
            .OpSwitch => struct { selector: Id, default: Id, target: []const PairLiteralIntegerIdRef = &.{} },
            .OpKill => void,
            .OpReturn => void,
            .OpReturnValue => struct { value: Id },
            .OpUnreachable => void,
            .OpLifetimeStart => struct { pointer: Id, size: LiteralInteger },
            .OpLifetimeStop => struct { pointer: Id, size: LiteralInteger },
            .OpGroupAsyncCopy => struct { id_result_type: Id, id_result: Id, execution: Id, destination: Id, source: Id, num_elements: Id, stride: Id, event: Id },
            .OpGroupWaitEvents => struct { execution: Id, num_events: Id, events_list: Id },
            .OpGroupAll => struct { id_result_type: Id, id_result: Id, execution: Id, predicate: Id },
            .OpGroupAny => struct { id_result_type: Id, id_result: Id, execution: Id, predicate: Id },
            .OpGroupBroadcast => struct { id_result_type: Id, id_result: Id, execution: Id, value: Id, local_id: Id },
            .OpGroupIAdd => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupFAdd => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupFMin => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupUMin => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupSMin => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupFMax => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupUMax => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupSMax => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpReadPipe => struct { id_result_type: Id, id_result: Id, pipe: Id, pointer: Id, packet_size: Id, packet_alignment: Id },
            .OpWritePipe => struct { id_result_type: Id, id_result: Id, pipe: Id, pointer: Id, packet_size: Id, packet_alignment: Id },
            .OpReservedReadPipe => struct { id_result_type: Id, id_result: Id, pipe: Id, reserve_id: Id, index: Id, pointer: Id, packet_size: Id, packet_alignment: Id },
            .OpReservedWritePipe => struct { id_result_type: Id, id_result: Id, pipe: Id, reserve_id: Id, index: Id, pointer: Id, packet_size: Id, packet_alignment: Id },
            .OpReserveReadPipePackets => struct { id_result_type: Id, id_result: Id, pipe: Id, num_packets: Id, packet_size: Id, packet_alignment: Id },
            .OpReserveWritePipePackets => struct { id_result_type: Id, id_result: Id, pipe: Id, num_packets: Id, packet_size: Id, packet_alignment: Id },
            .OpCommitReadPipe => struct { pipe: Id, reserve_id: Id, packet_size: Id, packet_alignment: Id },
            .OpCommitWritePipe => struct { pipe: Id, reserve_id: Id, packet_size: Id, packet_alignment: Id },
            .OpIsValidReserveId => struct { id_result_type: Id, id_result: Id, reserve_id: Id },
            .OpGetNumPipePackets => struct { id_result_type: Id, id_result: Id, pipe: Id, packet_size: Id, packet_alignment: Id },
            .OpGetMaxPipePackets => struct { id_result_type: Id, id_result: Id, pipe: Id, packet_size: Id, packet_alignment: Id },
            .OpGroupReserveReadPipePackets => struct { id_result_type: Id, id_result: Id, execution: Id, pipe: Id, num_packets: Id, packet_size: Id, packet_alignment: Id },
            .OpGroupReserveWritePipePackets => struct { id_result_type: Id, id_result: Id, execution: Id, pipe: Id, num_packets: Id, packet_size: Id, packet_alignment: Id },
            .OpGroupCommitReadPipe => struct { execution: Id, pipe: Id, reserve_id: Id, packet_size: Id, packet_alignment: Id },
            .OpGroupCommitWritePipe => struct { execution: Id, pipe: Id, reserve_id: Id, packet_size: Id, packet_alignment: Id },
            .OpEnqueueMarker => struct { id_result_type: Id, id_result: Id, queue: Id, num_events: Id, wait_events: Id, ret_event: Id },
            .OpEnqueueKernel => struct { id_result_type: Id, id_result: Id, queue: Id, flags: Id, nd_range: Id, num_events: Id, wait_events: Id, ret_event: Id, invoke: Id, param: Id, param_size: Id, param_align: Id, local_size: []const Id = &.{} },
            .OpGetKernelNDrangeSubGroupCount => struct { id_result_type: Id, id_result: Id, nd_range: Id, invoke: Id, param: Id, param_size: Id, param_align: Id },
            .OpGetKernelNDrangeMaxSubGroupSize => struct { id_result_type: Id, id_result: Id, nd_range: Id, invoke: Id, param: Id, param_size: Id, param_align: Id },
            .OpGetKernelWorkGroupSize => struct { id_result_type: Id, id_result: Id, invoke: Id, param: Id, param_size: Id, param_align: Id },
            .OpGetKernelPreferredWorkGroupSizeMultiple => struct { id_result_type: Id, id_result: Id, invoke: Id, param: Id, param_size: Id, param_align: Id },
            .OpRetainEvent => struct { event: Id },
            .OpReleaseEvent => struct { event: Id },
            .OpCreateUserEvent => struct { id_result_type: Id, id_result: Id },
            .OpIsValidEvent => struct { id_result_type: Id, id_result: Id, event: Id },
            .OpSetUserEventStatus => struct { event: Id, status: Id },
            .OpCaptureEventProfilingInfo => struct { event: Id, profiling_info: Id, value: Id },
            .OpGetDefaultQueue => struct { id_result_type: Id, id_result: Id },
            .OpBuildNDRange => struct { id_result_type: Id, id_result: Id, global_work_size: Id, local_work_size: Id, global_work_offset: Id },
            .OpImageSparseSampleImplicitLod => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseSampleExplicitLod => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, image_operands: ImageOperands.Extended },
            .OpImageSparseSampleDrefImplicitLod => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, d_ref: Id, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseSampleDrefExplicitLod => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, d_ref: Id, image_operands: ImageOperands.Extended },
            .OpImageSparseSampleProjImplicitLod => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseSampleProjExplicitLod => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, image_operands: ImageOperands.Extended },
            .OpImageSparseSampleProjDrefImplicitLod => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, d_ref: Id, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseSampleProjDrefExplicitLod => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, d_ref: Id, image_operands: ImageOperands.Extended },
            .OpImageSparseFetch => struct { id_result_type: Id, id_result: Id, image: Id, coordinate: Id, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseGather => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, component: Id, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseDrefGather => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, d_ref: Id, image_operands: ?ImageOperands.Extended = null },
            .OpImageSparseTexelsResident => struct { id_result_type: Id, id_result: Id, resident_code: Id },
            .OpNoLine => void,
            .OpAtomicFlagTestAndSet => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, semantics: Id },
            .OpAtomicFlagClear => struct { pointer: Id, memory: Id, semantics: Id },
            .OpImageSparseRead => struct { id_result_type: Id, id_result: Id, image: Id, coordinate: Id, image_operands: ?ImageOperands.Extended = null },
            .OpSizeOf => struct { id_result_type: Id, id_result: Id, pointer: Id },
            .OpTypePipeStorage => struct { id_result: Id },
            .OpConstantPipeStorage => struct { id_result_type: Id, id_result: Id, packet_size: LiteralInteger, packet_alignment: LiteralInteger, capacity: LiteralInteger },
            .OpCreatePipeFromPipeStorage => struct { id_result_type: Id, id_result: Id, pipe_storage: Id },
            .OpGetKernelLocalSizeForSubgroupCount => struct { id_result_type: Id, id_result: Id, subgroup_count: Id, invoke: Id, param: Id, param_size: Id, param_align: Id },
            .OpGetKernelMaxNumSubgroups => struct { id_result_type: Id, id_result: Id, invoke: Id, param: Id, param_size: Id, param_align: Id },
            .OpTypeNamedBarrier => struct { id_result: Id },
            .OpNamedBarrierInitialize => struct { id_result_type: Id, id_result: Id, subgroup_count: Id },
            .OpMemoryNamedBarrier => struct { named_barrier: Id, memory: Id, semantics: Id },
            .OpModuleProcessed => struct { process: LiteralString },
            .OpExecutionModeId => struct { entry_point: Id, mode: ExecutionMode.Extended },
            .OpDecorateId => struct { target: Id, decoration: Decoration.Extended },
            .OpGroupNonUniformElect => struct { id_result_type: Id, id_result: Id, execution: Id },
            .OpGroupNonUniformAll => struct { id_result_type: Id, id_result: Id, execution: Id, predicate: Id },
            .OpGroupNonUniformAny => struct { id_result_type: Id, id_result: Id, execution: Id, predicate: Id },
            .OpGroupNonUniformAllEqual => struct { id_result_type: Id, id_result: Id, execution: Id, value: Id },
            .OpGroupNonUniformBroadcast => struct { id_result_type: Id, id_result: Id, execution: Id, value: Id, id: Id },
            .OpGroupNonUniformBroadcastFirst => struct { id_result_type: Id, id_result: Id, execution: Id, value: Id },
            .OpGroupNonUniformBallot => struct { id_result_type: Id, id_result: Id, execution: Id, predicate: Id },
            .OpGroupNonUniformInverseBallot => struct { id_result_type: Id, id_result: Id, execution: Id, value: Id },
            .OpGroupNonUniformBallotBitExtract => struct { id_result_type: Id, id_result: Id, execution: Id, value: Id, index: Id },
            .OpGroupNonUniformBallotBitCount => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, value: Id },
            .OpGroupNonUniformBallotFindLSB => struct { id_result_type: Id, id_result: Id, execution: Id, value: Id },
            .OpGroupNonUniformBallotFindMSB => struct { id_result_type: Id, id_result: Id, execution: Id, value: Id },
            .OpGroupNonUniformShuffle => struct { id_result_type: Id, id_result: Id, execution: Id, value: Id, id: Id },
            .OpGroupNonUniformShuffleXor => struct { id_result_type: Id, id_result: Id, execution: Id, value: Id, mask: Id },
            .OpGroupNonUniformShuffleUp => struct { id_result_type: Id, id_result: Id, execution: Id, value: Id, delta: Id },
            .OpGroupNonUniformShuffleDown => struct { id_result_type: Id, id_result: Id, execution: Id, value: Id, delta: Id },
            .OpGroupNonUniformIAdd => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, value: Id, cluster_size: ?Id = null },
            .OpGroupNonUniformFAdd => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, value: Id, cluster_size: ?Id = null },
            .OpGroupNonUniformIMul => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, value: Id, cluster_size: ?Id = null },
            .OpGroupNonUniformFMul => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, value: Id, cluster_size: ?Id = null },
            .OpGroupNonUniformSMin => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, value: Id, cluster_size: ?Id = null },
            .OpGroupNonUniformUMin => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, value: Id, cluster_size: ?Id = null },
            .OpGroupNonUniformFMin => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, value: Id, cluster_size: ?Id = null },
            .OpGroupNonUniformSMax => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, value: Id, cluster_size: ?Id = null },
            .OpGroupNonUniformUMax => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, value: Id, cluster_size: ?Id = null },
            .OpGroupNonUniformFMax => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, value: Id, cluster_size: ?Id = null },
            .OpGroupNonUniformBitwiseAnd => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, value: Id, cluster_size: ?Id = null },
            .OpGroupNonUniformBitwiseOr => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, value: Id, cluster_size: ?Id = null },
            .OpGroupNonUniformBitwiseXor => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, value: Id, cluster_size: ?Id = null },
            .OpGroupNonUniformLogicalAnd => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, value: Id, cluster_size: ?Id = null },
            .OpGroupNonUniformLogicalOr => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, value: Id, cluster_size: ?Id = null },
            .OpGroupNonUniformLogicalXor => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, value: Id, cluster_size: ?Id = null },
            .OpGroupNonUniformQuadBroadcast => struct { id_result_type: Id, id_result: Id, execution: Id, value: Id, index: Id },
            .OpGroupNonUniformQuadSwap => struct { id_result_type: Id, id_result: Id, execution: Id, value: Id, direction: Id },
            .OpCopyLogical => struct { id_result_type: Id, id_result: Id, operand: Id },
            .OpPtrEqual => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpPtrNotEqual => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpPtrDiff => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpColorAttachmentReadEXT => struct { id_result_type: Id, id_result: Id, attachment: Id, sample: ?Id = null },
            .OpDepthAttachmentReadEXT => struct { id_result_type: Id, id_result: Id, sample: ?Id = null },
            .OpStencilAttachmentReadEXT => struct { id_result_type: Id, id_result: Id, sample: ?Id = null },
            .OpTypeTensorARM => struct { id_result: Id, element_type: Id, rank: ?Id = null, shape: ?Id = null },
            .OpTensorReadARM => struct { id_result_type: Id, id_result: Id, tensor: Id, coordinates: Id, tensor_operands: ?TensorOperands.Extended = null },
            .OpTensorWriteARM => struct { tensor: Id, coordinates: Id, object: Id, tensor_operands: ?TensorOperands.Extended = null },
            .OpTensorQuerySizeARM => struct { id_result_type: Id, id_result: Id, tensor: Id, dimension: Id },
            .OpGraphConstantARM => struct { id_result_type: Id, id_result: Id, graph_constant_id: LiteralInteger },
            .OpGraphEntryPointARM => struct { graph: Id, name: LiteralString, interface: []const Id = &.{} },
            .OpGraphARM => struct { id_result_type: Id, id_result: Id },
            .OpGraphInputARM => struct { id_result_type: Id, id_result: Id, input_index: Id, element_index: []const Id = &.{} },
            .OpGraphSetOutputARM => struct { value: Id, output_index: Id, element_index: []const Id = &.{} },
            .OpGraphEndARM => void,
            .OpTypeGraphARM => struct { id_result: Id, num_inputs: LiteralInteger, in_out_types: []const Id = &.{} },
            .OpTerminateInvocation => void,
            .OpTypeUntypedPointerKHR => struct { id_result: Id, storage_class: StorageClass },
            .OpUntypedVariableKHR => struct { id_result_type: Id, id_result: Id, storage_class: StorageClass, data_type: ?Id = null, initializer: ?Id = null },
            .OpUntypedAccessChainKHR => struct { id_result_type: Id, id_result: Id, base_type: Id, base: Id, indexes: []const Id = &.{} },
            .OpUntypedInBoundsAccessChainKHR => struct { id_result_type: Id, id_result: Id, base_type: Id, base: Id, indexes: []const Id = &.{} },
            .OpSubgroupBallotKHR => struct { id_result_type: Id, id_result: Id, predicate: Id },
            .OpSubgroupFirstInvocationKHR => struct { id_result_type: Id, id_result: Id, value: Id },
            .OpUntypedPtrAccessChainKHR => struct { id_result_type: Id, id_result: Id, base_type: Id, base: Id, element: Id, indexes: []const Id = &.{} },
            .OpUntypedInBoundsPtrAccessChainKHR => struct { id_result_type: Id, id_result: Id, base_type: Id, base: Id, element: Id, indexes: []const Id = &.{} },
            .OpUntypedArrayLengthKHR => struct { id_result_type: Id, id_result: Id, structure: Id, pointer: Id, array_member: LiteralInteger },
            .OpUntypedPrefetchKHR => struct { pointer_type: Id, num_bytes: Id, rw: ?Id = null, locality: ?Id = null, cache_type: ?Id = null },
            .OpSubgroupAllKHR => struct { id_result_type: Id, id_result: Id, predicate: Id },
            .OpSubgroupAnyKHR => struct { id_result_type: Id, id_result: Id, predicate: Id },
            .OpSubgroupAllEqualKHR => struct { id_result_type: Id, id_result: Id, predicate: Id },
            .OpGroupNonUniformRotateKHR => struct { id_result_type: Id, id_result: Id, execution: Id, value: Id, delta: Id, cluster_size: ?Id = null },
            .OpSubgroupReadInvocationKHR => struct { id_result_type: Id, id_result: Id, value: Id, index: Id },
            .OpExtInstWithForwardRefsKHR => struct { id_result_type: Id, id_result: Id, set: Id, instruction: LiteralExtInstInteger, id_ref_4: []const Id = &.{} },
            .OpTraceRayKHR => struct { accel: Id, ray_flags: Id, cull_mask: Id, sbt_offset: Id, sbt_stride: Id, miss_index: Id, ray_origin: Id, ray_tmin: Id, ray_direction: Id, ray_tmax: Id, payload: Id },
            .OpExecuteCallableKHR => struct { sbt_index: Id, callable_data: Id },
            .OpConvertUToAccelerationStructureKHR => struct { id_result_type: Id, id_result: Id, accel: Id },
            .OpIgnoreIntersectionKHR => void,
            .OpTerminateRayKHR => void,
            .OpSDot => struct { id_result_type: Id, id_result: Id, vector_1: Id, vector_2: Id, packed_vector_format: ?PackedVectorFormat = null },
            .OpUDot => struct { id_result_type: Id, id_result: Id, vector_1: Id, vector_2: Id, packed_vector_format: ?PackedVectorFormat = null },
            .OpSUDot => struct { id_result_type: Id, id_result: Id, vector_1: Id, vector_2: Id, packed_vector_format: ?PackedVectorFormat = null },
            .OpSDotAccSat => struct { id_result_type: Id, id_result: Id, vector_1: Id, vector_2: Id, accumulator: Id, packed_vector_format: ?PackedVectorFormat = null },
            .OpUDotAccSat => struct { id_result_type: Id, id_result: Id, vector_1: Id, vector_2: Id, accumulator: Id, packed_vector_format: ?PackedVectorFormat = null },
            .OpSUDotAccSat => struct { id_result_type: Id, id_result: Id, vector_1: Id, vector_2: Id, accumulator: Id, packed_vector_format: ?PackedVectorFormat = null },
            .OpTypeCooperativeMatrixKHR => struct { id_result: Id, component_type: Id, scope: Id, rows: Id, columns: Id, use: Id },
            .OpCooperativeMatrixLoadKHR => struct { id_result_type: Id, id_result: Id, pointer: Id, memory_layout: Id, stride: ?Id = null, memory_operand: ?MemoryAccess.Extended = null },
            .OpCooperativeMatrixStoreKHR => struct { pointer: Id, object: Id, memory_layout: Id, stride: ?Id = null, memory_operand: ?MemoryAccess.Extended = null },
            .OpCooperativeMatrixMulAddKHR => struct { id_result_type: Id, id_result: Id, a: Id, b: Id, c: Id, cooperative_matrix_operands: ?CooperativeMatrixOperands = null },
            .OpCooperativeMatrixLengthKHR => struct { id_result_type: Id, id_result: Id, type: Id },
            .OpConstantCompositeReplicateEXT => struct { id_result_type: Id, id_result: Id, value: Id },
            .OpSpecConstantCompositeReplicateEXT => struct { id_result_type: Id, id_result: Id, value: Id },
            .OpCompositeConstructReplicateEXT => struct { id_result_type: Id, id_result: Id, value: Id },
            .OpTypeRayQueryKHR => struct { id_result: Id },
            .OpRayQueryInitializeKHR => struct { ray_query: Id, accel: Id, ray_flags: Id, cull_mask: Id, ray_origin: Id, ray_t_min: Id, ray_direction: Id, ray_t_max: Id },
            .OpRayQueryTerminateKHR => struct { ray_query: Id },
            .OpRayQueryGenerateIntersectionKHR => struct { ray_query: Id, hit_t: Id },
            .OpRayQueryConfirmIntersectionKHR => struct { ray_query: Id },
            .OpRayQueryProceedKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id },
            .OpRayQueryGetIntersectionTypeKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpImageSampleWeightedQCOM => struct { id_result_type: Id, id_result: Id, texture: Id, coordinates: Id, weights: Id },
            .OpImageBoxFilterQCOM => struct { id_result_type: Id, id_result: Id, texture: Id, coordinates: Id, box_size: Id },
            .OpImageBlockMatchSSDQCOM => struct { id_result_type: Id, id_result: Id, target: Id, target_coordinates: Id, reference: Id, reference_coordinates: Id, block_size: Id },
            .OpImageBlockMatchSADQCOM => struct { id_result_type: Id, id_result: Id, target: Id, target_coordinates: Id, reference: Id, reference_coordinates: Id, block_size: Id },
            .OpImageBlockMatchWindowSSDQCOM => struct { id_result_type: Id, id_result: Id, target_sampled_image: Id, target_coordinates: Id, reference_sampled_image: Id, reference_coordinates: Id, block_size: Id },
            .OpImageBlockMatchWindowSADQCOM => struct { id_result_type: Id, id_result: Id, target_sampled_image: Id, target_coordinates: Id, reference_sampled_image: Id, reference_coordinates: Id, block_size: Id },
            .OpImageBlockMatchGatherSSDQCOM => struct { id_result_type: Id, id_result: Id, target_sampled_image: Id, target_coordinates: Id, reference_sampled_image: Id, reference_coordinates: Id, block_size: Id },
            .OpImageBlockMatchGatherSADQCOM => struct { id_result_type: Id, id_result: Id, target_sampled_image: Id, target_coordinates: Id, reference_sampled_image: Id, reference_coordinates: Id, block_size: Id },
            .OpGroupIAddNonUniformAMD => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupFAddNonUniformAMD => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupFMinNonUniformAMD => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupUMinNonUniformAMD => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupSMinNonUniformAMD => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupFMaxNonUniformAMD => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupUMaxNonUniformAMD => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupSMaxNonUniformAMD => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpFragmentMaskFetchAMD => struct { id_result_type: Id, id_result: Id, image: Id, coordinate: Id },
            .OpFragmentFetchAMD => struct { id_result_type: Id, id_result: Id, image: Id, coordinate: Id, fragment_index: Id },
            .OpReadClockKHR => struct { id_result_type: Id, id_result: Id, scope: Id },
            .OpAllocateNodePayloadsAMDX => struct { id_result_type: Id, id_result: Id, visibility: Id, payload_count: Id, node_index: Id },
            .OpEnqueueNodePayloadsAMDX => struct { payload_array: Id },
            .OpTypeNodePayloadArrayAMDX => struct { id_result: Id, payload_type: Id },
            .OpFinishWritingNodePayloadAMDX => struct { id_result_type: Id, id_result: Id, payload: Id },
            .OpNodePayloadArrayLengthAMDX => struct { id_result_type: Id, id_result: Id, payload_array: Id },
            .OpIsNodePayloadValidAMDX => struct { id_result_type: Id, id_result: Id, payload_type: Id, node_index: Id },
            .OpConstantStringAMDX => struct { id_result: Id, literal_string: LiteralString },
            .OpSpecConstantStringAMDX => struct { id_result: Id, literal_string: LiteralString },
            .OpGroupNonUniformQuadAllKHR => struct { id_result_type: Id, id_result: Id, predicate: Id },
            .OpGroupNonUniformQuadAnyKHR => struct { id_result_type: Id, id_result: Id, predicate: Id },
            .OpHitObjectRecordHitMotionNV => struct { hit_object: Id, acceleration_structure: Id, instance_id: Id, primitive_id: Id, geometry_index: Id, hit_kind: Id, sbt_record_offset: Id, sbt_record_stride: Id, origin: Id, t_min: Id, direction: Id, t_max: Id, current_time: Id, hit_object_attributes: Id },
            .OpHitObjectRecordHitWithIndexMotionNV => struct { hit_object: Id, acceleration_structure: Id, instance_id: Id, primitive_id: Id, geometry_index: Id, hit_kind: Id, sbt_record_index: Id, origin: Id, t_min: Id, direction: Id, t_max: Id, current_time: Id, hit_object_attributes: Id },
            .OpHitObjectRecordMissMotionNV => struct { hit_object: Id, sbt_index: Id, origin: Id, t_min: Id, direction: Id, t_max: Id, current_time: Id },
            .OpHitObjectGetWorldToObjectNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectGetObjectToWorldNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectGetObjectRayDirectionNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectGetObjectRayOriginNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectTraceRayMotionNV => struct { hit_object: Id, acceleration_structure: Id, ray_flags: Id, cullmask: Id, sbt_record_offset: Id, sbt_record_stride: Id, miss_index: Id, origin: Id, t_min: Id, direction: Id, t_max: Id, time: Id, payload: Id },
            .OpHitObjectGetShaderRecordBufferHandleNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectGetShaderBindingTableRecordIndexNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectRecordEmptyNV => struct { hit_object: Id },
            .OpHitObjectTraceRayNV => struct { hit_object: Id, acceleration_structure: Id, ray_flags: Id, cullmask: Id, sbt_record_offset: Id, sbt_record_stride: Id, miss_index: Id, origin: Id, t_min: Id, direction: Id, t_max: Id, payload: Id },
            .OpHitObjectRecordHitNV => struct { hit_object: Id, acceleration_structure: Id, instance_id: Id, primitive_id: Id, geometry_index: Id, hit_kind: Id, sbt_record_offset: Id, sbt_record_stride: Id, origin: Id, t_min: Id, direction: Id, t_max: Id, hit_object_attributes: Id },
            .OpHitObjectRecordHitWithIndexNV => struct { hit_object: Id, acceleration_structure: Id, instance_id: Id, primitive_id: Id, geometry_index: Id, hit_kind: Id, sbt_record_index: Id, origin: Id, t_min: Id, direction: Id, t_max: Id, hit_object_attributes: Id },
            .OpHitObjectRecordMissNV => struct { hit_object: Id, sbt_index: Id, origin: Id, t_min: Id, direction: Id, t_max: Id },
            .OpHitObjectExecuteShaderNV => struct { hit_object: Id, payload: Id },
            .OpHitObjectGetCurrentTimeNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectGetAttributesNV => struct { hit_object: Id, hit_object_attribute: Id },
            .OpHitObjectGetHitKindNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectGetPrimitiveIndexNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectGetGeometryIndexNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectGetInstanceIdNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectGetInstanceCustomIndexNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectGetWorldRayDirectionNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectGetWorldRayOriginNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectGetRayTMaxNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectGetRayTMinNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectIsEmptyNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectIsHitNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectIsMissNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpReorderThreadWithHitObjectNV => struct { hit_object: Id, hint: ?Id = null, bits: ?Id = null },
            .OpReorderThreadWithHintNV => struct { hint: Id, bits: Id },
            .OpTypeHitObjectNV => struct { id_result: Id },
            .OpImageSampleFootprintNV => struct { id_result_type: Id, id_result: Id, sampled_image: Id, coordinate: Id, granularity: Id, coarse: Id, image_operands: ?ImageOperands.Extended = null },
            .OpTypeCooperativeVectorNV => struct { id_result: Id, component_type: Id, component_count: Id },
            .OpCooperativeVectorMatrixMulNV => struct { id_result_type: Id, id_result: Id, input: Id, input_interpretation: Id, matrix: Id, matrix_offset: Id, matrix_interpretation: Id, m: Id, k: Id, memory_layout: Id, transpose: Id, matrix_stride: ?Id = null, cooperative_matrix_operands: ?CooperativeMatrixOperands = null },
            .OpCooperativeVectorOuterProductAccumulateNV => struct { pointer: Id, offset: Id, a: Id, b: Id, memory_layout: Id, matrix_interpretation: Id, matrix_stride: ?Id = null },
            .OpCooperativeVectorReduceSumAccumulateNV => struct { pointer: Id, offset: Id, v: Id },
            .OpCooperativeVectorMatrixMulAddNV => struct { id_result_type: Id, id_result: Id, input: Id, input_interpretation: Id, matrix: Id, matrix_offset: Id, matrix_interpretation: Id, bias: Id, bias_offset: Id, bias_interpretation: Id, m: Id, k: Id, memory_layout: Id, transpose: Id, matrix_stride: ?Id = null, cooperative_matrix_operands: ?CooperativeMatrixOperands = null },
            .OpCooperativeMatrixConvertNV => struct { id_result_type: Id, id_result: Id, matrix: Id },
            .OpEmitMeshTasksEXT => struct { group_count_x: Id, group_count_y: Id, group_count_z: Id, payload: ?Id = null },
            .OpSetMeshOutputsEXT => struct { vertex_count: Id, primitive_count: Id },
            .OpGroupNonUniformPartitionNV => struct { id_result_type: Id, id_result: Id, value: Id },
            .OpWritePackedPrimitiveIndices4x8NV => struct { index_offset: Id, packed_indices: Id },
            .OpFetchMicroTriangleVertexPositionNV => struct { id_result_type: Id, id_result: Id, accel: Id, instance_id: Id, geometry_index: Id, primitive_index: Id, barycentric: Id },
            .OpFetchMicroTriangleVertexBarycentricNV => struct { id_result_type: Id, id_result: Id, accel: Id, instance_id: Id, geometry_index: Id, primitive_index: Id, barycentric: Id },
            .OpCooperativeVectorLoadNV => struct { id_result_type: Id, id_result: Id, pointer: Id, offset: Id, memory_access: ?MemoryAccess.Extended = null },
            .OpCooperativeVectorStoreNV => struct { pointer: Id, offset: Id, object: Id, memory_access: ?MemoryAccess.Extended = null },
            .OpReportIntersectionKHR => struct { id_result_type: Id, id_result: Id, hit: Id, hit_kind: Id },
            .OpIgnoreIntersectionNV => void,
            .OpTerminateRayNV => void,
            .OpTraceNV => struct { accel: Id, ray_flags: Id, cull_mask: Id, sbt_offset: Id, sbt_stride: Id, miss_index: Id, ray_origin: Id, ray_tmin: Id, ray_direction: Id, ray_tmax: Id, payload_id: Id },
            .OpTraceMotionNV => struct { accel: Id, ray_flags: Id, cull_mask: Id, sbt_offset: Id, sbt_stride: Id, miss_index: Id, ray_origin: Id, ray_tmin: Id, ray_direction: Id, ray_tmax: Id, time: Id, payload_id: Id },
            .OpTraceRayMotionNV => struct { accel: Id, ray_flags: Id, cull_mask: Id, sbt_offset: Id, sbt_stride: Id, miss_index: Id, ray_origin: Id, ray_tmin: Id, ray_direction: Id, ray_tmax: Id, time: Id, payload: Id },
            .OpRayQueryGetIntersectionTriangleVertexPositionsKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpTypeAccelerationStructureKHR => struct { id_result: Id },
            .OpExecuteCallableNV => struct { sbt_index: Id, callable_data_id: Id },
            .OpRayQueryGetClusterIdNV => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpHitObjectGetClusterIdNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpTypeCooperativeMatrixNV => struct { id_result: Id, component_type: Id, execution: Id, rows: Id, columns: Id },
            .OpCooperativeMatrixLoadNV => struct { id_result_type: Id, id_result: Id, pointer: Id, stride: Id, column_major: Id, memory_access: ?MemoryAccess.Extended = null },
            .OpCooperativeMatrixStoreNV => struct { pointer: Id, object: Id, stride: Id, column_major: Id, memory_access: ?MemoryAccess.Extended = null },
            .OpCooperativeMatrixMulAddNV => struct { id_result_type: Id, id_result: Id, a: Id, b: Id, c: Id },
            .OpCooperativeMatrixLengthNV => struct { id_result_type: Id, id_result: Id, type: Id },
            .OpBeginInvocationInterlockEXT => void,
            .OpEndInvocationInterlockEXT => void,
            .OpCooperativeMatrixReduceNV => struct { id_result_type: Id, id_result: Id, matrix: Id, reduce: CooperativeMatrixReduce, combine_func: Id },
            .OpCooperativeMatrixLoadTensorNV => struct { id_result_type: Id, id_result: Id, pointer: Id, object: Id, tensor_layout: Id, memory_operand: MemoryAccess.Extended, tensor_addressing_operands: TensorAddressingOperands.Extended },
            .OpCooperativeMatrixStoreTensorNV => struct { pointer: Id, object: Id, tensor_layout: Id, memory_operand: MemoryAccess.Extended, tensor_addressing_operands: TensorAddressingOperands.Extended },
            .OpCooperativeMatrixPerElementOpNV => struct { id_result_type: Id, id_result: Id, matrix: Id, func: Id, operands: []const Id = &.{} },
            .OpTypeTensorLayoutNV => struct { id_result: Id, dim: Id, clamp_mode: Id },
            .OpTypeTensorViewNV => struct { id_result: Id, dim: Id, has_dimensions: Id, p: []const Id = &.{} },
            .OpCreateTensorLayoutNV => struct { id_result_type: Id, id_result: Id },
            .OpTensorLayoutSetDimensionNV => struct { id_result_type: Id, id_result: Id, tensor_layout: Id, dim: []const Id = &.{} },
            .OpTensorLayoutSetStrideNV => struct { id_result_type: Id, id_result: Id, tensor_layout: Id, stride: []const Id = &.{} },
            .OpTensorLayoutSliceNV => struct { id_result_type: Id, id_result: Id, tensor_layout: Id, operands: []const Id = &.{} },
            .OpTensorLayoutSetClampValueNV => struct { id_result_type: Id, id_result: Id, tensor_layout: Id, value: Id },
            .OpCreateTensorViewNV => struct { id_result_type: Id, id_result: Id },
            .OpTensorViewSetDimensionNV => struct { id_result_type: Id, id_result: Id, tensor_view: Id, dim: []const Id = &.{} },
            .OpTensorViewSetStrideNV => struct { id_result_type: Id, id_result: Id, tensor_view: Id, stride: []const Id = &.{} },
            .OpDemoteToHelperInvocation => void,
            .OpIsHelperInvocationEXT => struct { id_result_type: Id, id_result: Id },
            .OpTensorViewSetClipNV => struct { id_result_type: Id, id_result: Id, tensor_view: Id, clip_row_offset: Id, clip_row_span: Id, clip_col_offset: Id, clip_col_span: Id },
            .OpTensorLayoutSetBlockSizeNV => struct { id_result_type: Id, id_result: Id, tensor_layout: Id, block_size: []const Id = &.{} },
            .OpCooperativeMatrixTransposeNV => struct { id_result_type: Id, id_result: Id, matrix: Id },
            .OpConvertUToImageNV => struct { id_result_type: Id, id_result: Id, operand: Id },
            .OpConvertUToSamplerNV => struct { id_result_type: Id, id_result: Id, operand: Id },
            .OpConvertImageToUNV => struct { id_result_type: Id, id_result: Id, operand: Id },
            .OpConvertSamplerToUNV => struct { id_result_type: Id, id_result: Id, operand: Id },
            .OpConvertUToSampledImageNV => struct { id_result_type: Id, id_result: Id, operand: Id },
            .OpConvertSampledImageToUNV => struct { id_result_type: Id, id_result: Id, operand: Id },
            .OpSamplerImageAddressingModeNV => struct { bit_width: LiteralInteger },
            .OpRawAccessChainNV => struct { id_result_type: Id, id_result: Id, base: Id, byte_stride: Id, element_index: Id, byte_offset: Id, raw_access_chain_operands: ?RawAccessChainOperands = null },
            .OpRayQueryGetIntersectionSpherePositionNV => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpRayQueryGetIntersectionSphereRadiusNV => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpRayQueryGetIntersectionLSSPositionsNV => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpRayQueryGetIntersectionLSSRadiiNV => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpRayQueryGetIntersectionLSSHitValueNV => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpHitObjectGetSpherePositionNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectGetSphereRadiusNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectGetLSSPositionsNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectGetLSSRadiiNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectIsSphereHitNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpHitObjectIsLSSHitNV => struct { id_result_type: Id, id_result: Id, hit_object: Id },
            .OpRayQueryIsSphereHitNV => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpRayQueryIsLSSHitNV => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpSubgroupShuffleINTEL => struct { id_result_type: Id, id_result: Id, data: Id, invocation_id: Id },
            .OpSubgroupShuffleDownINTEL => struct { id_result_type: Id, id_result: Id, current: Id, next: Id, delta: Id },
            .OpSubgroupShuffleUpINTEL => struct { id_result_type: Id, id_result: Id, previous: Id, current: Id, delta: Id },
            .OpSubgroupShuffleXorINTEL => struct { id_result_type: Id, id_result: Id, data: Id, value: Id },
            .OpSubgroupBlockReadINTEL => struct { id_result_type: Id, id_result: Id, ptr: Id },
            .OpSubgroupBlockWriteINTEL => struct { ptr: Id, data: Id },
            .OpSubgroupImageBlockReadINTEL => struct { id_result_type: Id, id_result: Id, image: Id, coordinate: Id },
            .OpSubgroupImageBlockWriteINTEL => struct { image: Id, coordinate: Id, data: Id },
            .OpSubgroupImageMediaBlockReadINTEL => struct { id_result_type: Id, id_result: Id, image: Id, coordinate: Id, width: Id, height: Id },
            .OpSubgroupImageMediaBlockWriteINTEL => struct { image: Id, coordinate: Id, width: Id, height: Id, data: Id },
            .OpUCountLeadingZerosINTEL => struct { id_result_type: Id, id_result: Id, operand: Id },
            .OpUCountTrailingZerosINTEL => struct { id_result_type: Id, id_result: Id, operand: Id },
            .OpAbsISubINTEL => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpAbsUSubINTEL => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpIAddSatINTEL => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpUAddSatINTEL => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpIAverageINTEL => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpUAverageINTEL => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpIAverageRoundedINTEL => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpUAverageRoundedINTEL => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpISubSatINTEL => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpUSubSatINTEL => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpIMul32x16INTEL => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpUMul32x16INTEL => struct { id_result_type: Id, id_result: Id, operand_1: Id, operand_2: Id },
            .OpAtomicFMinEXT => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, semantics: Id, value: Id },
            .OpAtomicFMaxEXT => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, semantics: Id, value: Id },
            .OpAssumeTrueKHR => struct { condition: Id },
            .OpExpectKHR => struct { id_result_type: Id, id_result: Id, value: Id, expected_value: Id },
            .OpDecorateString => struct { target: Id, decoration: Decoration.Extended },
            .OpMemberDecorateString => struct { struct_type: Id, member: LiteralInteger, decoration: Decoration.Extended },
            .OpLoopControlINTEL => struct { loop_control_parameters: []const LiteralInteger = &.{} },
            .OpReadPipeBlockingINTEL => struct { id_result_type: Id, id_result: Id, packet_size: Id, packet_alignment: Id },
            .OpWritePipeBlockingINTEL => struct { id_result_type: Id, id_result: Id, packet_size: Id, packet_alignment: Id },
            .OpFPGARegINTEL => struct { id_result_type: Id, id_result: Id, input: Id },
            .OpRayQueryGetRayTMinKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id },
            .OpRayQueryGetRayFlagsKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id },
            .OpRayQueryGetIntersectionTKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpRayQueryGetIntersectionInstanceCustomIndexKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpRayQueryGetIntersectionInstanceIdKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpRayQueryGetIntersectionGeometryIndexKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpRayQueryGetIntersectionPrimitiveIndexKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpRayQueryGetIntersectionBarycentricsKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpRayQueryGetIntersectionFrontFaceKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpRayQueryGetIntersectionCandidateAABBOpaqueKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id },
            .OpRayQueryGetIntersectionObjectRayDirectionKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpRayQueryGetIntersectionObjectRayOriginKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpRayQueryGetWorldRayDirectionKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id },
            .OpRayQueryGetWorldRayOriginKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id },
            .OpRayQueryGetIntersectionObjectToWorldKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpRayQueryGetIntersectionWorldToObjectKHR => struct { id_result_type: Id, id_result: Id, ray_query: Id, intersection: Id },
            .OpAtomicFAddEXT => struct { id_result_type: Id, id_result: Id, pointer: Id, memory: Id, semantics: Id, value: Id },
            .OpTypeBufferSurfaceINTEL => struct { id_result: Id, access_qualifier: AccessQualifier },
            .OpTypeStructContinuedINTEL => struct { id_ref: []const Id = &.{} },
            .OpConstantCompositeContinuedINTEL => struct { constituents: []const Id = &.{} },
            .OpSpecConstantCompositeContinuedINTEL => struct { constituents: []const Id = &.{} },
            .OpCompositeConstructContinuedINTEL => struct { id_result_type: Id, id_result: Id, constituents: []const Id = &.{} },
            .OpConvertFToBF16INTEL => struct { id_result_type: Id, id_result: Id, float_value: Id },
            .OpConvertBF16ToFINTEL => struct { id_result_type: Id, id_result: Id, b_float16_value: Id },
            .OpControlBarrierArriveINTEL => struct { execution: Id, memory: Id, semantics: Id },
            .OpControlBarrierWaitINTEL => struct { execution: Id, memory: Id, semantics: Id },
            .OpArithmeticFenceEXT => struct { id_result_type: Id, id_result: Id, target: Id },
            .OpTaskSequenceCreateINTEL => struct { id_result_type: Id, id_result: Id, function: Id, pipelined: LiteralInteger, use_stall_enable_clusters: LiteralInteger, get_capacity: LiteralInteger, async_capacity: LiteralInteger },
            .OpTaskSequenceAsyncINTEL => struct { sequence: Id, arguments: []const Id = &.{} },
            .OpTaskSequenceGetINTEL => struct { id_result_type: Id, id_result: Id, sequence: Id },
            .OpTaskSequenceReleaseINTEL => struct { sequence: Id },
            .OpTypeTaskSequenceINTEL => struct { id_result: Id },
            .OpSubgroupBlockPrefetchINTEL => struct { ptr: Id, num_bytes: Id, memory_access: ?MemoryAccess.Extended = null },
            .OpSubgroup2DBlockLoadINTEL => struct { element_size: Id, block_width: Id, block_height: Id, block_count: Id, src_base_pointer: Id, memory_width: Id, memory_height: Id, memory_pitch: Id, coordinate: Id, dst_pointer: Id },
            .OpSubgroup2DBlockLoadTransformINTEL => struct { element_size: Id, block_width: Id, block_height: Id, block_count: Id, src_base_pointer: Id, memory_width: Id, memory_height: Id, memory_pitch: Id, coordinate: Id, dst_pointer: Id },
            .OpSubgroup2DBlockLoadTransposeINTEL => struct { element_size: Id, block_width: Id, block_height: Id, block_count: Id, src_base_pointer: Id, memory_width: Id, memory_height: Id, memory_pitch: Id, coordinate: Id, dst_pointer: Id },
            .OpSubgroup2DBlockPrefetchINTEL => struct { element_size: Id, block_width: Id, block_height: Id, block_count: Id, src_base_pointer: Id, memory_width: Id, memory_height: Id, memory_pitch: Id, coordinate: Id },
            .OpSubgroup2DBlockStoreINTEL => struct { element_size: Id, block_width: Id, block_height: Id, block_count: Id, src_pointer: Id, dst_base_pointer: Id, memory_width: Id, memory_height: Id, memory_pitch: Id, coordinate: Id },
            .OpSubgroupMatrixMultiplyAccumulateINTEL => struct { id_result_type: Id, id_result: Id, k_dim: Id, matrix_a: Id, matrix_b: Id, matrix_c: Id, matrix_multiply_accumulate_operands: ?MatrixMultiplyAccumulateOperands = null },
            .OpBitwiseFunctionINTEL => struct { id_result_type: Id, id_result: Id, a: Id, b: Id, c: Id, lut_index: Id },
            .OpGroupIMulKHR => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupFMulKHR => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupBitwiseAndKHR => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupBitwiseOrKHR => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupBitwiseXorKHR => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupLogicalAndKHR => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupLogicalOrKHR => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpGroupLogicalXorKHR => struct { id_result_type: Id, id_result: Id, execution: Id, operation: GroupOperation, x: Id },
            .OpRoundFToTF32INTEL => struct { id_result_type: Id, id_result: Id, float_value: Id },
            .OpMaskedGatherINTEL => struct { id_result_type: Id, id_result: Id, ptr_vector: Id, alignment: LiteralInteger, mask: Id, fill_empty: Id },
            .OpMaskedScatterINTEL => struct { input_vector: Id, ptr_vector: Id, alignment: LiteralInteger, mask: Id },
            .OpConvertHandleToImageINTEL => struct { id_result_type: Id, id_result: Id, operand: Id },
            .OpConvertHandleToSamplerINTEL => struct { id_result_type: Id, id_result: Id, operand: Id },
            .OpConvertHandleToSampledImageINTEL => struct { id_result_type: Id, id_result: Id, operand: Id },
        };
    }
    pub fn class(self: Opcode) Class {
        return switch (self) {
            .OpNop => .miscellaneous,
            .OpUndef => .miscellaneous,
            .OpSourceContinued => .debug,
            .OpSource => .debug,
            .OpSourceExtension => .debug,
            .OpName => .debug,
            .OpMemberName => .debug,
            .OpString => .debug,
            .OpLine => .debug,
            .OpExtension => .extension,
            .OpExtInstImport => .extension,
            .OpExtInst => .extension,
            .OpMemoryModel => .mode_setting,
            .OpEntryPoint => .mode_setting,
            .OpExecutionMode => .mode_setting,
            .OpCapability => .mode_setting,
            .OpTypeVoid => .type_declaration,
            .OpTypeBool => .type_declaration,
            .OpTypeInt => .type_declaration,
            .OpTypeFloat => .type_declaration,
            .OpTypeVector => .type_declaration,
            .OpTypeMatrix => .type_declaration,
            .OpTypeImage => .type_declaration,
            .OpTypeSampler => .type_declaration,
            .OpTypeSampledImage => .type_declaration,
            .OpTypeArray => .type_declaration,
            .OpTypeRuntimeArray => .type_declaration,
            .OpTypeStruct => .type_declaration,
            .OpTypeOpaque => .type_declaration,
            .OpTypePointer => .type_declaration,
            .OpTypeFunction => .type_declaration,
            .OpTypeEvent => .type_declaration,
            .OpTypeDeviceEvent => .type_declaration,
            .OpTypeReserveId => .type_declaration,
            .OpTypeQueue => .type_declaration,
            .OpTypePipe => .type_declaration,
            .OpTypeForwardPointer => .type_declaration,
            .OpConstantTrue => .constant_creation,
            .OpConstantFalse => .constant_creation,
            .OpConstant => .constant_creation,
            .OpConstantComposite => .constant_creation,
            .OpConstantSampler => .constant_creation,
            .OpConstantNull => .constant_creation,
            .OpSpecConstantTrue => .constant_creation,
            .OpSpecConstantFalse => .constant_creation,
            .OpSpecConstant => .constant_creation,
            .OpSpecConstantComposite => .constant_creation,
            .OpSpecConstantOp => .constant_creation,
            .OpFunction => .function,
            .OpFunctionParameter => .function,
            .OpFunctionEnd => .function,
            .OpFunctionCall => .function,
            .OpVariable => .memory,
            .OpImageTexelPointer => .memory,
            .OpLoad => .memory,
            .OpStore => .memory,
            .OpCopyMemory => .memory,
            .OpCopyMemorySized => .memory,
            .OpAccessChain => .memory,
            .OpInBoundsAccessChain => .memory,
            .OpPtrAccessChain => .memory,
            .OpArrayLength => .memory,
            .OpGenericPtrMemSemantics => .memory,
            .OpInBoundsPtrAccessChain => .memory,
            .OpDecorate => .annotation,
            .OpMemberDecorate => .annotation,
            .OpDecorationGroup => .annotation,
            .OpGroupDecorate => .annotation,
            .OpGroupMemberDecorate => .annotation,
            .OpVectorExtractDynamic => .composite,
            .OpVectorInsertDynamic => .composite,
            .OpVectorShuffle => .composite,
            .OpCompositeConstruct => .composite,
            .OpCompositeExtract => .composite,
            .OpCompositeInsert => .composite,
            .OpCopyObject => .composite,
            .OpTranspose => .composite,
            .OpSampledImage => .image,
            .OpImageSampleImplicitLod => .image,
            .OpImageSampleExplicitLod => .image,
            .OpImageSampleDrefImplicitLod => .image,
            .OpImageSampleDrefExplicitLod => .image,
            .OpImageSampleProjImplicitLod => .image,
            .OpImageSampleProjExplicitLod => .image,
            .OpImageSampleProjDrefImplicitLod => .image,
            .OpImageSampleProjDrefExplicitLod => .image,
            .OpImageFetch => .image,
            .OpImageGather => .image,
            .OpImageDrefGather => .image,
            .OpImageRead => .image,
            .OpImageWrite => .image,
            .OpImage => .image,
            .OpImageQueryFormat => .image,
            .OpImageQueryOrder => .image,
            .OpImageQuerySizeLod => .image,
            .OpImageQuerySize => .image,
            .OpImageQueryLod => .image,
            .OpImageQueryLevels => .image,
            .OpImageQuerySamples => .image,
            .OpConvertFToU => .conversion,
            .OpConvertFToS => .conversion,
            .OpConvertSToF => .conversion,
            .OpConvertUToF => .conversion,
            .OpUConvert => .conversion,
            .OpSConvert => .conversion,
            .OpFConvert => .conversion,
            .OpQuantizeToF16 => .conversion,
            .OpConvertPtrToU => .conversion,
            .OpSatConvertSToU => .conversion,
            .OpSatConvertUToS => .conversion,
            .OpConvertUToPtr => .conversion,
            .OpPtrCastToGeneric => .conversion,
            .OpGenericCastToPtr => .conversion,
            .OpGenericCastToPtrExplicit => .conversion,
            .OpBitcast => .conversion,
            .OpSNegate => .arithmetic,
            .OpFNegate => .arithmetic,
            .OpIAdd => .arithmetic,
            .OpFAdd => .arithmetic,
            .OpISub => .arithmetic,
            .OpFSub => .arithmetic,
            .OpIMul => .arithmetic,
            .OpFMul => .arithmetic,
            .OpUDiv => .arithmetic,
            .OpSDiv => .arithmetic,
            .OpFDiv => .arithmetic,
            .OpUMod => .arithmetic,
            .OpSRem => .arithmetic,
            .OpSMod => .arithmetic,
            .OpFRem => .arithmetic,
            .OpFMod => .arithmetic,
            .OpVectorTimesScalar => .arithmetic,
            .OpMatrixTimesScalar => .arithmetic,
            .OpVectorTimesMatrix => .arithmetic,
            .OpMatrixTimesVector => .arithmetic,
            .OpMatrixTimesMatrix => .arithmetic,
            .OpOuterProduct => .arithmetic,
            .OpDot => .arithmetic,
            .OpIAddCarry => .arithmetic,
            .OpISubBorrow => .arithmetic,
            .OpUMulExtended => .arithmetic,
            .OpSMulExtended => .arithmetic,
            .OpAny => .relational_and_logical,
            .OpAll => .relational_and_logical,
            .OpIsNan => .relational_and_logical,
            .OpIsInf => .relational_and_logical,
            .OpIsFinite => .relational_and_logical,
            .OpIsNormal => .relational_and_logical,
            .OpSignBitSet => .relational_and_logical,
            .OpLessOrGreater => .relational_and_logical,
            .OpOrdered => .relational_and_logical,
            .OpUnordered => .relational_and_logical,
            .OpLogicalEqual => .relational_and_logical,
            .OpLogicalNotEqual => .relational_and_logical,
            .OpLogicalOr => .relational_and_logical,
            .OpLogicalAnd => .relational_and_logical,
            .OpLogicalNot => .relational_and_logical,
            .OpSelect => .relational_and_logical,
            .OpIEqual => .relational_and_logical,
            .OpINotEqual => .relational_and_logical,
            .OpUGreaterThan => .relational_and_logical,
            .OpSGreaterThan => .relational_and_logical,
            .OpUGreaterThanEqual => .relational_and_logical,
            .OpSGreaterThanEqual => .relational_and_logical,
            .OpULessThan => .relational_and_logical,
            .OpSLessThan => .relational_and_logical,
            .OpULessThanEqual => .relational_and_logical,
            .OpSLessThanEqual => .relational_and_logical,
            .OpFOrdEqual => .relational_and_logical,
            .OpFUnordEqual => .relational_and_logical,
            .OpFOrdNotEqual => .relational_and_logical,
            .OpFUnordNotEqual => .relational_and_logical,
            .OpFOrdLessThan => .relational_and_logical,
            .OpFUnordLessThan => .relational_and_logical,
            .OpFOrdGreaterThan => .relational_and_logical,
            .OpFUnordGreaterThan => .relational_and_logical,
            .OpFOrdLessThanEqual => .relational_and_logical,
            .OpFUnordLessThanEqual => .relational_and_logical,
            .OpFOrdGreaterThanEqual => .relational_and_logical,
            .OpFUnordGreaterThanEqual => .relational_and_logical,
            .OpShiftRightLogical => .bit,
            .OpShiftRightArithmetic => .bit,
            .OpShiftLeftLogical => .bit,
            .OpBitwiseOr => .bit,
            .OpBitwiseXor => .bit,
            .OpBitwiseAnd => .bit,
            .OpNot => .bit,
            .OpBitFieldInsert => .bit,
            .OpBitFieldSExtract => .bit,
            .OpBitFieldUExtract => .bit,
            .OpBitReverse => .bit,
            .OpBitCount => .bit,
            .OpDPdx => .derivative,
            .OpDPdy => .derivative,
            .OpFwidth => .derivative,
            .OpDPdxFine => .derivative,
            .OpDPdyFine => .derivative,
            .OpFwidthFine => .derivative,
            .OpDPdxCoarse => .derivative,
            .OpDPdyCoarse => .derivative,
            .OpFwidthCoarse => .derivative,
            .OpEmitVertex => .primitive,
            .OpEndPrimitive => .primitive,
            .OpEmitStreamVertex => .primitive,
            .OpEndStreamPrimitive => .primitive,
            .OpControlBarrier => .barrier,
            .OpMemoryBarrier => .barrier,
            .OpAtomicLoad => .atomic,
            .OpAtomicStore => .atomic,
            .OpAtomicExchange => .atomic,
            .OpAtomicCompareExchange => .atomic,
            .OpAtomicCompareExchangeWeak => .atomic,
            .OpAtomicIIncrement => .atomic,
            .OpAtomicIDecrement => .atomic,
            .OpAtomicIAdd => .atomic,
            .OpAtomicISub => .atomic,
            .OpAtomicSMin => .atomic,
            .OpAtomicUMin => .atomic,
            .OpAtomicSMax => .atomic,
            .OpAtomicUMax => .atomic,
            .OpAtomicAnd => .atomic,
            .OpAtomicOr => .atomic,
            .OpAtomicXor => .atomic,
            .OpPhi => .control_flow,
            .OpLoopMerge => .control_flow,
            .OpSelectionMerge => .control_flow,
            .OpLabel => .control_flow,
            .OpBranch => .control_flow,
            .OpBranchConditional => .control_flow,
            .OpSwitch => .control_flow,
            .OpKill => .control_flow,
            .OpReturn => .control_flow,
            .OpReturnValue => .control_flow,
            .OpUnreachable => .control_flow,
            .OpLifetimeStart => .control_flow,
            .OpLifetimeStop => .control_flow,
            .OpGroupAsyncCopy => .group,
            .OpGroupWaitEvents => .group,
            .OpGroupAll => .group,
            .OpGroupAny => .group,
            .OpGroupBroadcast => .group,
            .OpGroupIAdd => .group,
            .OpGroupFAdd => .group,
            .OpGroupFMin => .group,
            .OpGroupUMin => .group,
            .OpGroupSMin => .group,
            .OpGroupFMax => .group,
            .OpGroupUMax => .group,
            .OpGroupSMax => .group,
            .OpReadPipe => .pipe,
            .OpWritePipe => .pipe,
            .OpReservedReadPipe => .pipe,
            .OpReservedWritePipe => .pipe,
            .OpReserveReadPipePackets => .pipe,
            .OpReserveWritePipePackets => .pipe,
            .OpCommitReadPipe => .pipe,
            .OpCommitWritePipe => .pipe,
            .OpIsValidReserveId => .pipe,
            .OpGetNumPipePackets => .pipe,
            .OpGetMaxPipePackets => .pipe,
            .OpGroupReserveReadPipePackets => .pipe,
            .OpGroupReserveWritePipePackets => .pipe,
            .OpGroupCommitReadPipe => .pipe,
            .OpGroupCommitWritePipe => .pipe,
            .OpEnqueueMarker => .device_side_enqueue,
            .OpEnqueueKernel => .device_side_enqueue,
            .OpGetKernelNDrangeSubGroupCount => .device_side_enqueue,
            .OpGetKernelNDrangeMaxSubGroupSize => .device_side_enqueue,
            .OpGetKernelWorkGroupSize => .device_side_enqueue,
            .OpGetKernelPreferredWorkGroupSizeMultiple => .device_side_enqueue,
            .OpRetainEvent => .device_side_enqueue,
            .OpReleaseEvent => .device_side_enqueue,
            .OpCreateUserEvent => .device_side_enqueue,
            .OpIsValidEvent => .device_side_enqueue,
            .OpSetUserEventStatus => .device_side_enqueue,
            .OpCaptureEventProfilingInfo => .device_side_enqueue,
            .OpGetDefaultQueue => .device_side_enqueue,
            .OpBuildNDRange => .device_side_enqueue,
            .OpImageSparseSampleImplicitLod => .image,
            .OpImageSparseSampleExplicitLod => .image,
            .OpImageSparseSampleDrefImplicitLod => .image,
            .OpImageSparseSampleDrefExplicitLod => .image,
            .OpImageSparseSampleProjImplicitLod => .image,
            .OpImageSparseSampleProjExplicitLod => .image,
            .OpImageSparseSampleProjDrefImplicitLod => .image,
            .OpImageSparseSampleProjDrefExplicitLod => .image,
            .OpImageSparseFetch => .image,
            .OpImageSparseGather => .image,
            .OpImageSparseDrefGather => .image,
            .OpImageSparseTexelsResident => .image,
            .OpNoLine => .debug,
            .OpAtomicFlagTestAndSet => .atomic,
            .OpAtomicFlagClear => .atomic,
            .OpImageSparseRead => .image,
            .OpSizeOf => .miscellaneous,
            .OpTypePipeStorage => .type_declaration,
            .OpConstantPipeStorage => .pipe,
            .OpCreatePipeFromPipeStorage => .pipe,
            .OpGetKernelLocalSizeForSubgroupCount => .device_side_enqueue,
            .OpGetKernelMaxNumSubgroups => .device_side_enqueue,
            .OpTypeNamedBarrier => .type_declaration,
            .OpNamedBarrierInitialize => .barrier,
            .OpMemoryNamedBarrier => .barrier,
            .OpModuleProcessed => .debug,
            .OpExecutionModeId => .mode_setting,
            .OpDecorateId => .annotation,
            .OpGroupNonUniformElect => .non_uniform,
            .OpGroupNonUniformAll => .non_uniform,
            .OpGroupNonUniformAny => .non_uniform,
            .OpGroupNonUniformAllEqual => .non_uniform,
            .OpGroupNonUniformBroadcast => .non_uniform,
            .OpGroupNonUniformBroadcastFirst => .non_uniform,
            .OpGroupNonUniformBallot => .non_uniform,
            .OpGroupNonUniformInverseBallot => .non_uniform,
            .OpGroupNonUniformBallotBitExtract => .non_uniform,
            .OpGroupNonUniformBallotBitCount => .non_uniform,
            .OpGroupNonUniformBallotFindLSB => .non_uniform,
            .OpGroupNonUniformBallotFindMSB => .non_uniform,
            .OpGroupNonUniformShuffle => .non_uniform,
            .OpGroupNonUniformShuffleXor => .non_uniform,
            .OpGroupNonUniformShuffleUp => .non_uniform,
            .OpGroupNonUniformShuffleDown => .non_uniform,
            .OpGroupNonUniformIAdd => .non_uniform,
            .OpGroupNonUniformFAdd => .non_uniform,
            .OpGroupNonUniformIMul => .non_uniform,
            .OpGroupNonUniformFMul => .non_uniform,
            .OpGroupNonUniformSMin => .non_uniform,
            .OpGroupNonUniformUMin => .non_uniform,
            .OpGroupNonUniformFMin => .non_uniform,
            .OpGroupNonUniformSMax => .non_uniform,
            .OpGroupNonUniformUMax => .non_uniform,
            .OpGroupNonUniformFMax => .non_uniform,
            .OpGroupNonUniformBitwiseAnd => .non_uniform,
            .OpGroupNonUniformBitwiseOr => .non_uniform,
            .OpGroupNonUniformBitwiseXor => .non_uniform,
            .OpGroupNonUniformLogicalAnd => .non_uniform,
            .OpGroupNonUniformLogicalOr => .non_uniform,
            .OpGroupNonUniformLogicalXor => .non_uniform,
            .OpGroupNonUniformQuadBroadcast => .non_uniform,
            .OpGroupNonUniformQuadSwap => .non_uniform,
            .OpCopyLogical => .composite,
            .OpPtrEqual => .memory,
            .OpPtrNotEqual => .memory,
            .OpPtrDiff => .memory,
            .OpColorAttachmentReadEXT => .image,
            .OpDepthAttachmentReadEXT => .image,
            .OpStencilAttachmentReadEXT => .image,
            .OpTypeTensorARM => .type_declaration,
            .OpTensorReadARM => .tensor,
            .OpTensorWriteARM => .tensor,
            .OpTensorQuerySizeARM => .tensor,
            .OpGraphConstantARM => .graph,
            .OpGraphEntryPointARM => .graph,
            .OpGraphARM => .graph,
            .OpGraphInputARM => .graph,
            .OpGraphSetOutputARM => .graph,
            .OpGraphEndARM => .graph,
            .OpTypeGraphARM => .type_declaration,
            .OpTerminateInvocation => .control_flow,
            .OpTypeUntypedPointerKHR => .type_declaration,
            .OpUntypedVariableKHR => .memory,
            .OpUntypedAccessChainKHR => .memory,
            .OpUntypedInBoundsAccessChainKHR => .memory,
            .OpSubgroupBallotKHR => .group,
            .OpSubgroupFirstInvocationKHR => .group,
            .OpUntypedPtrAccessChainKHR => .memory,
            .OpUntypedInBoundsPtrAccessChainKHR => .memory,
            .OpUntypedArrayLengthKHR => .memory,
            .OpUntypedPrefetchKHR => .memory,
            .OpSubgroupAllKHR => .group,
            .OpSubgroupAnyKHR => .group,
            .OpSubgroupAllEqualKHR => .group,
            .OpGroupNonUniformRotateKHR => .group,
            .OpSubgroupReadInvocationKHR => .group,
            .OpExtInstWithForwardRefsKHR => .extension,
            .OpTraceRayKHR => .reserved,
            .OpExecuteCallableKHR => .reserved,
            .OpConvertUToAccelerationStructureKHR => .reserved,
            .OpIgnoreIntersectionKHR => .reserved,
            .OpTerminateRayKHR => .reserved,
            .OpSDot => .arithmetic,
            .OpUDot => .arithmetic,
            .OpSUDot => .arithmetic,
            .OpSDotAccSat => .arithmetic,
            .OpUDotAccSat => .arithmetic,
            .OpSUDotAccSat => .arithmetic,
            .OpTypeCooperativeMatrixKHR => .type_declaration,
            .OpCooperativeMatrixLoadKHR => .memory,
            .OpCooperativeMatrixStoreKHR => .memory,
            .OpCooperativeMatrixMulAddKHR => .arithmetic,
            .OpCooperativeMatrixLengthKHR => .miscellaneous,
            .OpConstantCompositeReplicateEXT => .constant_creation,
            .OpSpecConstantCompositeReplicateEXT => .constant_creation,
            .OpCompositeConstructReplicateEXT => .composite,
            .OpTypeRayQueryKHR => .type_declaration,
            .OpRayQueryInitializeKHR => .reserved,
            .OpRayQueryTerminateKHR => .reserved,
            .OpRayQueryGenerateIntersectionKHR => .reserved,
            .OpRayQueryConfirmIntersectionKHR => .reserved,
            .OpRayQueryProceedKHR => .reserved,
            .OpRayQueryGetIntersectionTypeKHR => .reserved,
            .OpImageSampleWeightedQCOM => .image,
            .OpImageBoxFilterQCOM => .image,
            .OpImageBlockMatchSSDQCOM => .image,
            .OpImageBlockMatchSADQCOM => .image,
            .OpImageBlockMatchWindowSSDQCOM => .image,
            .OpImageBlockMatchWindowSADQCOM => .image,
            .OpImageBlockMatchGatherSSDQCOM => .image,
            .OpImageBlockMatchGatherSADQCOM => .image,
            .OpGroupIAddNonUniformAMD => .group,
            .OpGroupFAddNonUniformAMD => .group,
            .OpGroupFMinNonUniformAMD => .group,
            .OpGroupUMinNonUniformAMD => .group,
            .OpGroupSMinNonUniformAMD => .group,
            .OpGroupFMaxNonUniformAMD => .group,
            .OpGroupUMaxNonUniformAMD => .group,
            .OpGroupSMaxNonUniformAMD => .group,
            .OpFragmentMaskFetchAMD => .reserved,
            .OpFragmentFetchAMD => .reserved,
            .OpReadClockKHR => .reserved,
            .OpAllocateNodePayloadsAMDX => .reserved,
            .OpEnqueueNodePayloadsAMDX => .reserved,
            .OpTypeNodePayloadArrayAMDX => .reserved,
            .OpFinishWritingNodePayloadAMDX => .reserved,
            .OpNodePayloadArrayLengthAMDX => .reserved,
            .OpIsNodePayloadValidAMDX => .reserved,
            .OpConstantStringAMDX => .reserved,
            .OpSpecConstantStringAMDX => .reserved,
            .OpGroupNonUniformQuadAllKHR => .non_uniform,
            .OpGroupNonUniformQuadAnyKHR => .non_uniform,
            .OpHitObjectRecordHitMotionNV => .reserved,
            .OpHitObjectRecordHitWithIndexMotionNV => .reserved,
            .OpHitObjectRecordMissMotionNV => .reserved,
            .OpHitObjectGetWorldToObjectNV => .reserved,
            .OpHitObjectGetObjectToWorldNV => .reserved,
            .OpHitObjectGetObjectRayDirectionNV => .reserved,
            .OpHitObjectGetObjectRayOriginNV => .reserved,
            .OpHitObjectTraceRayMotionNV => .reserved,
            .OpHitObjectGetShaderRecordBufferHandleNV => .reserved,
            .OpHitObjectGetShaderBindingTableRecordIndexNV => .reserved,
            .OpHitObjectRecordEmptyNV => .reserved,
            .OpHitObjectTraceRayNV => .reserved,
            .OpHitObjectRecordHitNV => .reserved,
            .OpHitObjectRecordHitWithIndexNV => .reserved,
            .OpHitObjectRecordMissNV => .reserved,
            .OpHitObjectExecuteShaderNV => .reserved,
            .OpHitObjectGetCurrentTimeNV => .reserved,
            .OpHitObjectGetAttributesNV => .reserved,
            .OpHitObjectGetHitKindNV => .reserved,
            .OpHitObjectGetPrimitiveIndexNV => .reserved,
            .OpHitObjectGetGeometryIndexNV => .reserved,
            .OpHitObjectGetInstanceIdNV => .reserved,
            .OpHitObjectGetInstanceCustomIndexNV => .reserved,
            .OpHitObjectGetWorldRayDirectionNV => .reserved,
            .OpHitObjectGetWorldRayOriginNV => .reserved,
            .OpHitObjectGetRayTMaxNV => .reserved,
            .OpHitObjectGetRayTMinNV => .reserved,
            .OpHitObjectIsEmptyNV => .reserved,
            .OpHitObjectIsHitNV => .reserved,
            .OpHitObjectIsMissNV => .reserved,
            .OpReorderThreadWithHitObjectNV => .reserved,
            .OpReorderThreadWithHintNV => .reserved,
            .OpTypeHitObjectNV => .type_declaration,
            .OpImageSampleFootprintNV => .image,
            .OpTypeCooperativeVectorNV => .type_declaration,
            .OpCooperativeVectorMatrixMulNV => .reserved,
            .OpCooperativeVectorOuterProductAccumulateNV => .reserved,
            .OpCooperativeVectorReduceSumAccumulateNV => .reserved,
            .OpCooperativeVectorMatrixMulAddNV => .reserved,
            .OpCooperativeMatrixConvertNV => .conversion,
            .OpEmitMeshTasksEXT => .reserved,
            .OpSetMeshOutputsEXT => .reserved,
            .OpGroupNonUniformPartitionNV => .non_uniform,
            .OpWritePackedPrimitiveIndices4x8NV => .reserved,
            .OpFetchMicroTriangleVertexPositionNV => .reserved,
            .OpFetchMicroTriangleVertexBarycentricNV => .reserved,
            .OpCooperativeVectorLoadNV => .memory,
            .OpCooperativeVectorStoreNV => .memory,
            .OpReportIntersectionKHR => .reserved,
            .OpIgnoreIntersectionNV => .reserved,
            .OpTerminateRayNV => .reserved,
            .OpTraceNV => .reserved,
            .OpTraceMotionNV => .reserved,
            .OpTraceRayMotionNV => .reserved,
            .OpRayQueryGetIntersectionTriangleVertexPositionsKHR => .reserved,
            .OpTypeAccelerationStructureKHR => .type_declaration,
            .OpExecuteCallableNV => .reserved,
            .OpRayQueryGetClusterIdNV => .reserved,
            .OpHitObjectGetClusterIdNV => .reserved,
            .OpTypeCooperativeMatrixNV => .type_declaration,
            .OpCooperativeMatrixLoadNV => .reserved,
            .OpCooperativeMatrixStoreNV => .reserved,
            .OpCooperativeMatrixMulAddNV => .reserved,
            .OpCooperativeMatrixLengthNV => .reserved,
            .OpBeginInvocationInterlockEXT => .reserved,
            .OpEndInvocationInterlockEXT => .reserved,
            .OpCooperativeMatrixReduceNV => .arithmetic,
            .OpCooperativeMatrixLoadTensorNV => .memory,
            .OpCooperativeMatrixStoreTensorNV => .memory,
            .OpCooperativeMatrixPerElementOpNV => .function,
            .OpTypeTensorLayoutNV => .type_declaration,
            .OpTypeTensorViewNV => .type_declaration,
            .OpCreateTensorLayoutNV => .reserved,
            .OpTensorLayoutSetDimensionNV => .reserved,
            .OpTensorLayoutSetStrideNV => .reserved,
            .OpTensorLayoutSliceNV => .reserved,
            .OpTensorLayoutSetClampValueNV => .reserved,
            .OpCreateTensorViewNV => .reserved,
            .OpTensorViewSetDimensionNV => .reserved,
            .OpTensorViewSetStrideNV => .reserved,
            .OpDemoteToHelperInvocation => .control_flow,
            .OpIsHelperInvocationEXT => .reserved,
            .OpTensorViewSetClipNV => .reserved,
            .OpTensorLayoutSetBlockSizeNV => .reserved,
            .OpCooperativeMatrixTransposeNV => .conversion,
            .OpConvertUToImageNV => .reserved,
            .OpConvertUToSamplerNV => .reserved,
            .OpConvertImageToUNV => .reserved,
            .OpConvertSamplerToUNV => .reserved,
            .OpConvertUToSampledImageNV => .reserved,
            .OpConvertSampledImageToUNV => .reserved,
            .OpSamplerImageAddressingModeNV => .reserved,
            .OpRawAccessChainNV => .memory,
            .OpRayQueryGetIntersectionSpherePositionNV => .reserved,
            .OpRayQueryGetIntersectionSphereRadiusNV => .reserved,
            .OpRayQueryGetIntersectionLSSPositionsNV => .reserved,
            .OpRayQueryGetIntersectionLSSRadiiNV => .reserved,
            .OpRayQueryGetIntersectionLSSHitValueNV => .reserved,
            .OpHitObjectGetSpherePositionNV => .reserved,
            .OpHitObjectGetSphereRadiusNV => .reserved,
            .OpHitObjectGetLSSPositionsNV => .reserved,
            .OpHitObjectGetLSSRadiiNV => .reserved,
            .OpHitObjectIsSphereHitNV => .reserved,
            .OpHitObjectIsLSSHitNV => .reserved,
            .OpRayQueryIsSphereHitNV => .reserved,
            .OpRayQueryIsLSSHitNV => .reserved,
            .OpSubgroupShuffleINTEL => .group,
            .OpSubgroupShuffleDownINTEL => .group,
            .OpSubgroupShuffleUpINTEL => .group,
            .OpSubgroupShuffleXorINTEL => .group,
            .OpSubgroupBlockReadINTEL => .group,
            .OpSubgroupBlockWriteINTEL => .group,
            .OpSubgroupImageBlockReadINTEL => .group,
            .OpSubgroupImageBlockWriteINTEL => .group,
            .OpSubgroupImageMediaBlockReadINTEL => .group,
            .OpSubgroupImageMediaBlockWriteINTEL => .group,
            .OpUCountLeadingZerosINTEL => .reserved,
            .OpUCountTrailingZerosINTEL => .reserved,
            .OpAbsISubINTEL => .reserved,
            .OpAbsUSubINTEL => .reserved,
            .OpIAddSatINTEL => .reserved,
            .OpUAddSatINTEL => .reserved,
            .OpIAverageINTEL => .reserved,
            .OpUAverageINTEL => .reserved,
            .OpIAverageRoundedINTEL => .reserved,
            .OpUAverageRoundedINTEL => .reserved,
            .OpISubSatINTEL => .reserved,
            .OpUSubSatINTEL => .reserved,
            .OpIMul32x16INTEL => .reserved,
            .OpUMul32x16INTEL => .reserved,
            .OpAtomicFMinEXT => .atomic,
            .OpAtomicFMaxEXT => .atomic,
            .OpAssumeTrueKHR => .miscellaneous,
            .OpExpectKHR => .miscellaneous,
            .OpDecorateString => .annotation,
            .OpMemberDecorateString => .annotation,
            .OpLoopControlINTEL => .reserved,
            .OpReadPipeBlockingINTEL => .pipe,
            .OpWritePipeBlockingINTEL => .pipe,
            .OpFPGARegINTEL => .reserved,
            .OpRayQueryGetRayTMinKHR => .reserved,
            .OpRayQueryGetRayFlagsKHR => .reserved,
            .OpRayQueryGetIntersectionTKHR => .reserved,
            .OpRayQueryGetIntersectionInstanceCustomIndexKHR => .reserved,
            .OpRayQueryGetIntersectionInstanceIdKHR => .reserved,
            .OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR => .reserved,
            .OpRayQueryGetIntersectionGeometryIndexKHR => .reserved,
            .OpRayQueryGetIntersectionPrimitiveIndexKHR => .reserved,
            .OpRayQueryGetIntersectionBarycentricsKHR => .reserved,
            .OpRayQueryGetIntersectionFrontFaceKHR => .reserved,
            .OpRayQueryGetIntersectionCandidateAABBOpaqueKHR => .reserved,
            .OpRayQueryGetIntersectionObjectRayDirectionKHR => .reserved,
            .OpRayQueryGetIntersectionObjectRayOriginKHR => .reserved,
            .OpRayQueryGetWorldRayDirectionKHR => .reserved,
            .OpRayQueryGetWorldRayOriginKHR => .reserved,
            .OpRayQueryGetIntersectionObjectToWorldKHR => .reserved,
            .OpRayQueryGetIntersectionWorldToObjectKHR => .reserved,
            .OpAtomicFAddEXT => .atomic,
            .OpTypeBufferSurfaceINTEL => .type_declaration,
            .OpTypeStructContinuedINTEL => .type_declaration,
            .OpConstantCompositeContinuedINTEL => .constant_creation,
            .OpSpecConstantCompositeContinuedINTEL => .constant_creation,
            .OpCompositeConstructContinuedINTEL => .composite,
            .OpConvertFToBF16INTEL => .conversion,
            .OpConvertBF16ToFINTEL => .conversion,
            .OpControlBarrierArriveINTEL => .barrier,
            .OpControlBarrierWaitINTEL => .barrier,
            .OpArithmeticFenceEXT => .miscellaneous,
            .OpTaskSequenceCreateINTEL => .reserved,
            .OpTaskSequenceAsyncINTEL => .reserved,
            .OpTaskSequenceGetINTEL => .reserved,
            .OpTaskSequenceReleaseINTEL => .reserved,
            .OpTypeTaskSequenceINTEL => .type_declaration,
            .OpSubgroupBlockPrefetchINTEL => .group,
            .OpSubgroup2DBlockLoadINTEL => .group,
            .OpSubgroup2DBlockLoadTransformINTEL => .group,
            .OpSubgroup2DBlockLoadTransposeINTEL => .group,
            .OpSubgroup2DBlockPrefetchINTEL => .group,
            .OpSubgroup2DBlockStoreINTEL => .group,
            .OpSubgroupMatrixMultiplyAccumulateINTEL => .group,
            .OpBitwiseFunctionINTEL => .bit,
            .OpGroupIMulKHR => .group,
            .OpGroupFMulKHR => .group,
            .OpGroupBitwiseAndKHR => .group,
            .OpGroupBitwiseOrKHR => .group,
            .OpGroupBitwiseXorKHR => .group,
            .OpGroupLogicalAndKHR => .group,
            .OpGroupLogicalOrKHR => .group,
            .OpGroupLogicalXorKHR => .group,
            .OpRoundFToTF32INTEL => .conversion,
            .OpMaskedGatherINTEL => .memory,
            .OpMaskedScatterINTEL => .memory,
            .OpConvertHandleToImageINTEL => .image,
            .OpConvertHandleToSamplerINTEL => .image,
            .OpConvertHandleToSampledImageINTEL => .image,
        };
    }
};

pub const GlslOpcode = enum(u16) {
    Round = 1,
    RoundEven = 2,
    Trunc = 3,
    FAbs = 4,
    SAbs = 5,
    FSign = 6,
    SSign = 7,
    Floor = 8,
    Ceil = 9,
    Fract = 10,
    Radians = 11,
    Degrees = 12,
    Sin = 13,
    Cos = 14,
    Tan = 15,
    Asin = 16,
    Acos = 17,
    Atan = 18,
    Sinh = 19,
    Cosh = 20,
    Tanh = 21,
    Asinh = 22,
    Acosh = 23,
    Atanh = 24,
    Atan2 = 25,
    Pow = 26,
    Exp = 27,
    Log = 28,
    Exp2 = 29,
    Log2 = 30,
    Sqrt = 31,
    InverseSqrt = 32,
    Determinant = 33,
    MatrixInverse = 34,
    Modf = 35,
    ModfStruct = 36,
    FMin = 37,
    UMin = 38,
    SMin = 39,
    FMax = 40,
    UMax = 41,
    SMax = 42,
    FClamp = 43,
    UClamp = 44,
    SClamp = 45,
    FMix = 46,
    IMix = 47,
    Step = 48,
    SmoothStep = 49,
    Fma = 50,
    Frexp = 51,
    FrexpStruct = 52,
    Ldexp = 53,
    PackSnorm4x8 = 54,
    PackUnorm4x8 = 55,
    PackSnorm2x16 = 56,
    PackUnorm2x16 = 57,
    PackHalf2x16 = 58,
    PackDouble2x32 = 59,
    UnpackSnorm2x16 = 60,
    UnpackUnorm2x16 = 61,
    UnpackHalf2x16 = 62,
    UnpackSnorm4x8 = 63,
    UnpackUnorm4x8 = 64,
    UnpackDouble2x32 = 65,
    Length = 66,
    Distance = 67,
    Cross = 68,
    Normalize = 69,
    FaceForward = 70,
    Reflect = 71,
    Refract = 72,
    FindILsb = 73,
    FindSMsb = 74,
    FindUMsb = 75,
    InterpolateAtCentroid = 76,
    InterpolateAtSample = 77,
    InterpolateAtOffset = 78,
    NMin = 79,
    NMax = 80,
    NClamp = 81,
};

pub const OpenClOpcode = enum(u16) {
    acos = 0,
    acosh = 1,
    acospi = 2,
    asin = 3,
    asinh = 4,
    asinpi = 5,
    atan = 6,
    atan2 = 7,
    atanh = 8,
    atanpi = 9,
    atan2pi = 10,
    cbrt = 11,
    ceil = 12,
    copysign = 13,
    cos = 14,
    cosh = 15,
    cospi = 16,
    erfc = 17,
    erf = 18,
    exp = 19,
    exp2 = 20,
    exp10 = 21,
    expm1 = 22,
    fabs = 23,
    fdim = 24,
    floor = 25,
    fma = 26,
    fmax = 27,
    fmin = 28,
    fmod = 29,
    fract = 30,
    frexp = 31,
    hypot = 32,
    ilogb = 33,
    ldexp = 34,
    lgamma = 35,
    lgamma_r = 36,
    log = 37,
    log2 = 38,
    log10 = 39,
    log1p = 40,
    logb = 41,
    mad = 42,
    maxmag = 43,
    minmag = 44,
    modf = 45,
    nan = 46,
    nextafter = 47,
    pow = 48,
    pown = 49,
    powr = 50,
    remainder = 51,
    remquo = 52,
    rint = 53,
    rootn = 54,
    round = 55,
    rsqrt = 56,
    sin = 57,
    sincos = 58,
    sinh = 59,
    sinpi = 60,
    sqrt = 61,
    tan = 62,
    tanh = 63,
    tanpi = 64,
    tgamma = 65,
    trunc = 66,
    half_cos = 67,
    half_divide = 68,
    half_exp = 69,
    half_exp2 = 70,
    half_exp10 = 71,
    half_log = 72,
    half_log2 = 73,
    half_log10 = 74,
    half_powr = 75,
    half_recip = 76,
    half_rsqrt = 77,
    half_sin = 78,
    half_sqrt = 79,
    half_tan = 80,
    native_cos = 81,
    native_divide = 82,
    native_exp = 83,
    native_exp2 = 84,
    native_exp10 = 85,
    native_log = 86,
    native_log2 = 87,
    native_log10 = 88,
    native_powr = 89,
    native_recip = 90,
    native_rsqrt = 91,
    native_sin = 92,
    native_sqrt = 93,
    native_tan = 94,
    fclamp = 95,
    degrees = 96,
    fmax_common = 97,
    fmin_common = 98,
    mix = 99,
    radians = 100,
    step = 101,
    smoothstep = 102,
    sign = 103,
    cross = 104,
    distance = 105,
    length = 106,
    normalize = 107,
    fast_distance = 108,
    fast_length = 109,
    fast_normalize = 110,
    s_abs = 141,
    s_abs_diff = 142,
    s_add_sat = 143,
    u_add_sat = 144,
    s_hadd = 145,
    u_hadd = 146,
    s_rhadd = 147,
    u_rhadd = 148,
    s_clamp = 149,
    u_clamp = 150,
    clz = 151,
    ctz = 152,
    s_mad_hi = 153,
    u_mad_sat = 154,
    s_mad_sat = 155,
    s_max = 156,
    u_max = 157,
    s_min = 158,
    u_min = 159,
    s_mul_hi = 160,
    rotate = 161,
    s_sub_sat = 162,
    u_sub_sat = 163,
    u_upsample = 164,
    s_upsample = 165,
    popcount = 166,
    s_mad24 = 167,
    u_mad24 = 168,
    s_mul24 = 169,
    u_mul24 = 170,
    vloadn = 171,
    vstoren = 172,
    vload_half = 173,
    vload_halfn = 174,
    vstore_half = 175,
    vstore_half_r = 176,
    vstore_halfn = 177,
    vstore_halfn_r = 178,
    vloada_halfn = 179,
    vstorea_halfn = 180,
    vstorea_halfn_r = 181,
    shuffle = 182,
    shuffle2 = 183,
    printf = 184,
    prefetch = 185,
    bitselect = 186,
    select = 187,
    u_abs = 201,
    u_abs_diff = 202,
    u_mul_hi = 203,
    u_mad_hi = 204,
};

pub const Zig = enum(u16) {
    InvocationGlobal = 0,
};
pub const ImageOperands = packed struct {
    bias: bool = false,
    lod: bool = false,
    grad: bool = false,
    const_offset: bool = false,
    offset: bool = false,
    const_offsets: bool = false,
    sample: bool = false,
    min_lod: bool = false,
    make_texel_available: bool = false,
    make_texel_visible: bool = false,
    non_private_texel: bool = false,
    volatile_texel: bool = false,
    sign_extend: bool = false,
    zero_extend: bool = false,
    nontemporal: bool = false,
    _reserved_bit_15: bool = false,
    offsets: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,

    pub const Extended = struct {
        bias: ?struct { id_ref: Id } = null,
        lod: ?struct { id_ref: Id } = null,
        grad: ?struct { id_ref_0: Id, id_ref_1: Id } = null,
        const_offset: ?struct { id_ref: Id } = null,
        offset: ?struct { id_ref: Id } = null,
        const_offsets: ?struct { id_ref: Id } = null,
        sample: ?struct { id_ref: Id } = null,
        min_lod: ?struct { id_ref: Id } = null,
        make_texel_available: ?struct { id_scope: Id } = null,
        make_texel_visible: ?struct { id_scope: Id } = null,
        non_private_texel: bool = false,
        volatile_texel: bool = false,
        sign_extend: bool = false,
        zero_extend: bool = false,
        nontemporal: bool = false,
        _reserved_bit_15: bool = false,
        offsets: ?struct { id_ref: Id } = null,
        _reserved_bit_17: bool = false,
        _reserved_bit_18: bool = false,
        _reserved_bit_19: bool = false,
        _reserved_bit_20: bool = false,
        _reserved_bit_21: bool = false,
        _reserved_bit_22: bool = false,
        _reserved_bit_23: bool = false,
        _reserved_bit_24: bool = false,
        _reserved_bit_25: bool = false,
        _reserved_bit_26: bool = false,
        _reserved_bit_27: bool = false,
        _reserved_bit_28: bool = false,
        _reserved_bit_29: bool = false,
        _reserved_bit_30: bool = false,
        _reserved_bit_31: bool = false,
    };
};
pub const FPFastMathMode = packed struct {
    not_na_n: bool = false,
    not_inf: bool = false,
    nsz: bool = false,
    allow_recip: bool = false,
    fast: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    allow_contract: bool = false,
    allow_reassoc: bool = false,
    allow_transform: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const SelectionControl = packed struct {
    flatten: bool = false,
    dont_flatten: bool = false,
    _reserved_bit_2: bool = false,
    _reserved_bit_3: bool = false,
    _reserved_bit_4: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const LoopControl = packed struct {
    unroll: bool = false,
    dont_unroll: bool = false,
    dependency_infinite: bool = false,
    dependency_length: bool = false,
    min_iterations: bool = false,
    max_iterations: bool = false,
    iteration_multiple: bool = false,
    peel_count: bool = false,
    partial_count: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    initiation_interval_intel: bool = false,
    max_concurrency_intel: bool = false,
    dependency_array_intel: bool = false,
    pipeline_enable_intel: bool = false,
    loop_coalesce_intel: bool = false,
    max_interleaving_intel: bool = false,
    speculated_iterations_intel: bool = false,
    no_fusion_intel: bool = false,
    loop_count_intel: bool = false,
    max_reinvocation_delay_intel: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,

    pub const Extended = struct {
        unroll: bool = false,
        dont_unroll: bool = false,
        dependency_infinite: bool = false,
        dependency_length: ?struct { literal_integer: LiteralInteger } = null,
        min_iterations: ?struct { literal_integer: LiteralInteger } = null,
        max_iterations: ?struct { literal_integer: LiteralInteger } = null,
        iteration_multiple: ?struct { literal_integer: LiteralInteger } = null,
        peel_count: ?struct { literal_integer: LiteralInteger } = null,
        partial_count: ?struct { literal_integer: LiteralInteger } = null,
        _reserved_bit_9: bool = false,
        _reserved_bit_10: bool = false,
        _reserved_bit_11: bool = false,
        _reserved_bit_12: bool = false,
        _reserved_bit_13: bool = false,
        _reserved_bit_14: bool = false,
        _reserved_bit_15: bool = false,
        initiation_interval_intel: ?struct { literal_integer: LiteralInteger } = null,
        max_concurrency_intel: ?struct { literal_integer: LiteralInteger } = null,
        dependency_array_intel: ?struct { literal_integer: LiteralInteger } = null,
        pipeline_enable_intel: ?struct { literal_integer: LiteralInteger } = null,
        loop_coalesce_intel: ?struct { literal_integer: LiteralInteger } = null,
        max_interleaving_intel: ?struct { literal_integer: LiteralInteger } = null,
        speculated_iterations_intel: ?struct { literal_integer: LiteralInteger } = null,
        no_fusion_intel: bool = false,
        loop_count_intel: ?struct { literal_integer: LiteralInteger } = null,
        max_reinvocation_delay_intel: ?struct { literal_integer: LiteralInteger } = null,
        _reserved_bit_26: bool = false,
        _reserved_bit_27: bool = false,
        _reserved_bit_28: bool = false,
        _reserved_bit_29: bool = false,
        _reserved_bit_30: bool = false,
        _reserved_bit_31: bool = false,
    };
};
pub const FunctionControl = packed struct {
    @"inline": bool = false,
    dont_inline: bool = false,
    pure: bool = false,
    @"const": bool = false,
    _reserved_bit_4: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    opt_none_ext: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const MemorySemantics = packed struct {
    _reserved_bit_0: bool = false,
    acquire: bool = false,
    release: bool = false,
    acquire_release: bool = false,
    sequentially_consistent: bool = false,
    _reserved_bit_5: bool = false,
    uniform_memory: bool = false,
    subgroup_memory: bool = false,
    workgroup_memory: bool = false,
    cross_workgroup_memory: bool = false,
    atomic_counter_memory: bool = false,
    image_memory: bool = false,
    output_memory: bool = false,
    make_available: bool = false,
    make_visible: bool = false,
    @"volatile": bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const MemoryAccess = packed struct {
    @"volatile": bool = false,
    aligned: bool = false,
    nontemporal: bool = false,
    make_pointer_available: bool = false,
    make_pointer_visible: bool = false,
    non_private_pointer: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    alias_scope_intel_mask: bool = false,
    no_alias_intel_mask: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,

    pub const Extended = struct {
        @"volatile": bool = false,
        aligned: ?struct { literal_integer: LiteralInteger } = null,
        nontemporal: bool = false,
        make_pointer_available: ?struct { id_scope: Id } = null,
        make_pointer_visible: ?struct { id_scope: Id } = null,
        non_private_pointer: bool = false,
        _reserved_bit_6: bool = false,
        _reserved_bit_7: bool = false,
        _reserved_bit_8: bool = false,
        _reserved_bit_9: bool = false,
        _reserved_bit_10: bool = false,
        _reserved_bit_11: bool = false,
        _reserved_bit_12: bool = false,
        _reserved_bit_13: bool = false,
        _reserved_bit_14: bool = false,
        _reserved_bit_15: bool = false,
        alias_scope_intel_mask: ?struct { id_ref: Id } = null,
        no_alias_intel_mask: ?struct { id_ref: Id } = null,
        _reserved_bit_18: bool = false,
        _reserved_bit_19: bool = false,
        _reserved_bit_20: bool = false,
        _reserved_bit_21: bool = false,
        _reserved_bit_22: bool = false,
        _reserved_bit_23: bool = false,
        _reserved_bit_24: bool = false,
        _reserved_bit_25: bool = false,
        _reserved_bit_26: bool = false,
        _reserved_bit_27: bool = false,
        _reserved_bit_28: bool = false,
        _reserved_bit_29: bool = false,
        _reserved_bit_30: bool = false,
        _reserved_bit_31: bool = false,
    };
};
pub const KernelProfilingInfo = packed struct {
    cmd_exec_time: bool = false,
    _reserved_bit_1: bool = false,
    _reserved_bit_2: bool = false,
    _reserved_bit_3: bool = false,
    _reserved_bit_4: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const RayFlags = packed struct {
    opaque_khr: bool = false,
    no_opaque_khr: bool = false,
    terminate_on_first_hit_khr: bool = false,
    skip_closest_hit_shader_khr: bool = false,
    cull_back_facing_triangles_khr: bool = false,
    cull_front_facing_triangles_khr: bool = false,
    cull_opaque_khr: bool = false,
    cull_no_opaque_khr: bool = false,
    skip_triangles_khr: bool = false,
    skip_aab_bs_khr: bool = false,
    force_opacity_micromap2state_ext: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const FragmentShadingRate = packed struct {
    vertical2pixels: bool = false,
    vertical4pixels: bool = false,
    horizontal2pixels: bool = false,
    horizontal4pixels: bool = false,
    _reserved_bit_4: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const RawAccessChainOperands = packed struct {
    robustness_per_component_nv: bool = false,
    robustness_per_element_nv: bool = false,
    _reserved_bit_2: bool = false,
    _reserved_bit_3: bool = false,
    _reserved_bit_4: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const SourceLanguage = enum(u32) {
    unknown = 0,
    essl = 1,
    glsl = 2,
    open_cl_c = 3,
    open_cl_cpp = 4,
    hlsl = 5,
    cpp_for_open_cl = 6,
    sycl = 7,
    hero_c = 8,
    nzsl = 9,
    wgsl = 10,
    slang = 11,
    zig = 12,
    rust = 13,
};
pub const ExecutionModel = enum(u32) {
    vertex = 0,
    tessellation_control = 1,
    tessellation_evaluation = 2,
    geometry = 3,
    fragment = 4,
    gl_compute = 5,
    kernel = 6,
    task_nv = 5267,
    mesh_nv = 5268,
    ray_generation_khr = 5313,
    intersection_khr = 5314,
    any_hit_khr = 5315,
    closest_hit_khr = 5316,
    miss_khr = 5317,
    callable_khr = 5318,
    task_ext = 5364,
    mesh_ext = 5365,
};
pub const AddressingModel = enum(u32) {
    logical = 0,
    physical32 = 1,
    physical64 = 2,
    physical_storage_buffer64 = 5348,
};
pub const MemoryModel = enum(u32) {
    simple = 0,
    glsl450 = 1,
    open_cl = 2,
    vulkan = 3,
};
pub const ExecutionMode = enum(u32) {
    invocations = 0,
    spacing_equal = 1,
    spacing_fractional_even = 2,
    spacing_fractional_odd = 3,
    vertex_order_cw = 4,
    vertex_order_ccw = 5,
    pixel_center_integer = 6,
    origin_upper_left = 7,
    origin_lower_left = 8,
    early_fragment_tests = 9,
    point_mode = 10,
    xfb = 11,
    depth_replacing = 12,
    depth_greater = 14,
    depth_less = 15,
    depth_unchanged = 16,
    local_size = 17,
    local_size_hint = 18,
    input_points = 19,
    input_lines = 20,
    input_lines_adjacency = 21,
    triangles = 22,
    input_triangles_adjacency = 23,
    quads = 24,
    isolines = 25,
    output_vertices = 26,
    output_points = 27,
    output_line_strip = 28,
    output_triangle_strip = 29,
    vec_type_hint = 30,
    contraction_off = 31,
    initializer = 33,
    finalizer = 34,
    subgroup_size = 35,
    subgroups_per_workgroup = 36,
    subgroups_per_workgroup_id = 37,
    local_size_id = 38,
    local_size_hint_id = 39,
    non_coherent_color_attachment_read_ext = 4169,
    non_coherent_depth_attachment_read_ext = 4170,
    non_coherent_stencil_attachment_read_ext = 4171,
    subgroup_uniform_control_flow_khr = 4421,
    post_depth_coverage = 4446,
    denorm_preserve = 4459,
    denorm_flush_to_zero = 4460,
    signed_zero_inf_nan_preserve = 4461,
    rounding_mode_rte = 4462,
    rounding_mode_rtz = 4463,
    non_coherent_tile_attachment_read_qcom = 4489,
    tile_shading_rate_qcom = 4490,
    early_and_late_fragment_tests_amd = 5017,
    stencil_ref_replacing_ext = 5027,
    coalescing_amdx = 5069,
    is_api_entry_amdx = 5070,
    max_node_recursion_amdx = 5071,
    static_num_workgroups_amdx = 5072,
    shader_index_amdx = 5073,
    max_num_workgroups_amdx = 5077,
    stencil_ref_unchanged_front_amd = 5079,
    stencil_ref_greater_front_amd = 5080,
    stencil_ref_less_front_amd = 5081,
    stencil_ref_unchanged_back_amd = 5082,
    stencil_ref_greater_back_amd = 5083,
    stencil_ref_less_back_amd = 5084,
    quad_derivatives_khr = 5088,
    require_full_quads_khr = 5089,
    shares_input_with_amdx = 5102,
    output_lines_ext = 5269,
    output_primitives_ext = 5270,
    derivative_group_quads_khr = 5289,
    derivative_group_linear_khr = 5290,
    output_triangles_ext = 5298,
    pixel_interlock_ordered_ext = 5366,
    pixel_interlock_unordered_ext = 5367,
    sample_interlock_ordered_ext = 5368,
    sample_interlock_unordered_ext = 5369,
    shading_rate_interlock_ordered_ext = 5370,
    shading_rate_interlock_unordered_ext = 5371,
    shared_local_memory_size_intel = 5618,
    rounding_mode_rtpintel = 5620,
    rounding_mode_rtnintel = 5621,
    floating_point_mode_altintel = 5622,
    floating_point_mode_ieeeintel = 5623,
    max_workgroup_size_intel = 5893,
    max_work_dim_intel = 5894,
    no_global_offset_intel = 5895,
    num_simd_workitems_intel = 5896,
    scheduler_target_fmax_mhz_intel = 5903,
    maximally_reconverges_khr = 6023,
    fp_fast_math_default = 6028,
    streaming_interface_intel = 6154,
    register_map_interface_intel = 6160,
    named_barrier_count_intel = 6417,
    maximum_registers_intel = 6461,
    maximum_registers_id_intel = 6462,
    named_maximum_registers_intel = 6463,

    pub const Extended = union(ExecutionMode) {
        invocations: struct { literal_integer: LiteralInteger },
        spacing_equal,
        spacing_fractional_even,
        spacing_fractional_odd,
        vertex_order_cw,
        vertex_order_ccw,
        pixel_center_integer,
        origin_upper_left,
        origin_lower_left,
        early_fragment_tests,
        point_mode,
        xfb,
        depth_replacing,
        depth_greater,
        depth_less,
        depth_unchanged,
        local_size: struct { x_size: LiteralInteger, y_size: LiteralInteger, z_size: LiteralInteger },
        local_size_hint: struct { x_size: LiteralInteger, y_size: LiteralInteger, z_size: LiteralInteger },
        input_points,
        input_lines,
        input_lines_adjacency,
        triangles,
        input_triangles_adjacency,
        quads,
        isolines,
        output_vertices: struct { vertex_count: LiteralInteger },
        output_points,
        output_line_strip,
        output_triangle_strip,
        vec_type_hint: struct { vector_type: LiteralInteger },
        contraction_off,
        initializer,
        finalizer,
        subgroup_size: struct { subgroup_size: LiteralInteger },
        subgroups_per_workgroup: struct { subgroups_per_workgroup: LiteralInteger },
        subgroups_per_workgroup_id: struct { subgroups_per_workgroup: Id },
        local_size_id: struct { x_size: Id, y_size: Id, z_size: Id },
        local_size_hint_id: struct { x_size_hint: Id, y_size_hint: Id, z_size_hint: Id },
        non_coherent_color_attachment_read_ext,
        non_coherent_depth_attachment_read_ext,
        non_coherent_stencil_attachment_read_ext,
        subgroup_uniform_control_flow_khr,
        post_depth_coverage,
        denorm_preserve: struct { target_width: LiteralInteger },
        denorm_flush_to_zero: struct { target_width: LiteralInteger },
        signed_zero_inf_nan_preserve: struct { target_width: LiteralInteger },
        rounding_mode_rte: struct { target_width: LiteralInteger },
        rounding_mode_rtz: struct { target_width: LiteralInteger },
        non_coherent_tile_attachment_read_qcom,
        tile_shading_rate_qcom: struct { x_rate: LiteralInteger, y_rate: LiteralInteger, z_rate: LiteralInteger },
        early_and_late_fragment_tests_amd,
        stencil_ref_replacing_ext,
        coalescing_amdx,
        is_api_entry_amdx: struct { is_entry: Id },
        max_node_recursion_amdx: struct { number_of_recursions: Id },
        static_num_workgroups_amdx: struct { x_size: Id, y_size: Id, z_size: Id },
        shader_index_amdx: struct { shader_index: Id },
        max_num_workgroups_amdx: struct { x_size: Id, y_size: Id, z_size: Id },
        stencil_ref_unchanged_front_amd,
        stencil_ref_greater_front_amd,
        stencil_ref_less_front_amd,
        stencil_ref_unchanged_back_amd,
        stencil_ref_greater_back_amd,
        stencil_ref_less_back_amd,
        quad_derivatives_khr,
        require_full_quads_khr,
        shares_input_with_amdx: struct { node_name: Id, shader_index: Id },
        output_lines_ext,
        output_primitives_ext: struct { primitive_count: LiteralInteger },
        derivative_group_quads_khr,
        derivative_group_linear_khr,
        output_triangles_ext,
        pixel_interlock_ordered_ext,
        pixel_interlock_unordered_ext,
        sample_interlock_ordered_ext,
        sample_interlock_unordered_ext,
        shading_rate_interlock_ordered_ext,
        shading_rate_interlock_unordered_ext,
        shared_local_memory_size_intel: struct { size: LiteralInteger },
        rounding_mode_rtpintel: struct { target_width: LiteralInteger },
        rounding_mode_rtnintel: struct { target_width: LiteralInteger },
        floating_point_mode_altintel: struct { target_width: LiteralInteger },
        floating_point_mode_ieeeintel: struct { target_width: LiteralInteger },
        max_workgroup_size_intel: struct { literal_integer_0: LiteralInteger, literal_integer_1: LiteralInteger, literal_integer_2: LiteralInteger },
        max_work_dim_intel: struct { literal_integer: LiteralInteger },
        no_global_offset_intel,
        num_simd_workitems_intel: struct { literal_integer: LiteralInteger },
        scheduler_target_fmax_mhz_intel: struct { literal_integer: LiteralInteger },
        maximally_reconverges_khr,
        fp_fast_math_default: struct { target_type: Id, id_ref_1: Id },
        streaming_interface_intel: struct { stall_free_return: LiteralInteger },
        register_map_interface_intel: struct { wait_for_done_write: LiteralInteger },
        named_barrier_count_intel: struct { barrier_count: LiteralInteger },
        maximum_registers_intel: struct { number_of_registers: LiteralInteger },
        maximum_registers_id_intel: struct { number_of_registers: Id },
        named_maximum_registers_intel: struct { named_maximum_number_of_registers: NamedMaximumNumberOfRegisters },
    };
};
pub const StorageClass = enum(u32) {
    uniform_constant = 0,
    input = 1,
    uniform = 2,
    output = 3,
    workgroup = 4,
    cross_workgroup = 5,
    private = 6,
    function = 7,
    generic = 8,
    push_constant = 9,
    atomic_counter = 10,
    image = 11,
    storage_buffer = 12,
    tile_image_ext = 4172,
    tile_attachment_qcom = 4491,
    node_payload_amdx = 5068,
    callable_data_khr = 5328,
    incoming_callable_data_khr = 5329,
    ray_payload_khr = 5338,
    hit_attribute_khr = 5339,
    incoming_ray_payload_khr = 5342,
    shader_record_buffer_khr = 5343,
    physical_storage_buffer = 5349,
    hit_object_attribute_nv = 5385,
    task_payload_workgroup_ext = 5402,
    code_section_intel = 5605,
    device_only_intel = 5936,
    host_only_intel = 5937,
};
pub const Dim = enum(u32) {
    @"1d" = 0,
    @"2d" = 1,
    @"3d" = 2,
    cube = 3,
    rect = 4,
    buffer = 5,
    subpass_data = 6,
    tile_image_data_ext = 4173,
};
pub const SamplerAddressingMode = enum(u32) {
    none = 0,
    clamp_to_edge = 1,
    clamp = 2,
    repeat = 3,
    repeat_mirrored = 4,
};
pub const SamplerFilterMode = enum(u32) {
    nearest = 0,
    linear = 1,
};
pub const ImageFormat = enum(u32) {
    unknown = 0,
    rgba32f = 1,
    rgba16f = 2,
    r32f = 3,
    rgba8 = 4,
    rgba8snorm = 5,
    rg32f = 6,
    rg16f = 7,
    r11f_g11f_b10f = 8,
    r16f = 9,
    rgba16 = 10,
    rgb10a2 = 11,
    rg16 = 12,
    rg8 = 13,
    r16 = 14,
    r8 = 15,
    rgba16snorm = 16,
    rg16snorm = 17,
    rg8snorm = 18,
    r16snorm = 19,
    r8snorm = 20,
    rgba32i = 21,
    rgba16i = 22,
    rgba8i = 23,
    r32i = 24,
    rg32i = 25,
    rg16i = 26,
    rg8i = 27,
    r16i = 28,
    r8i = 29,
    rgba32ui = 30,
    rgba16ui = 31,
    rgba8ui = 32,
    r32ui = 33,
    rgb10a2ui = 34,
    rg32ui = 35,
    rg16ui = 36,
    rg8ui = 37,
    r16ui = 38,
    r8ui = 39,
    r64ui = 40,
    r64i = 41,
};
pub const ImageChannelOrder = enum(u32) {
    r = 0,
    a = 1,
    rg = 2,
    ra = 3,
    rgb = 4,
    rgba = 5,
    bgra = 6,
    argb = 7,
    intensity = 8,
    luminance = 9,
    rx = 10,
    r_gx = 11,
    rg_bx = 12,
    depth = 13,
    depth_stencil = 14,
    s_rgb = 15,
    s_rg_bx = 16,
    s_rgba = 17,
    s_bgra = 18,
    abgr = 19,
};
pub const ImageChannelDataType = enum(u32) {
    snorm_int8 = 0,
    snorm_int16 = 1,
    unorm_int8 = 2,
    unorm_int16 = 3,
    unorm_short565 = 4,
    unorm_short555 = 5,
    unorm_int101010 = 6,
    signed_int8 = 7,
    signed_int16 = 8,
    signed_int32 = 9,
    unsigned_int8 = 10,
    unsigned_int16 = 11,
    unsigned_int32 = 12,
    half_float = 13,
    float = 14,
    unorm_int24 = 15,
    unorm_int101010_2 = 16,
    unorm_int10x6ext = 17,
    unsigned_int_raw10ext = 19,
    unsigned_int_raw12ext = 20,
    unorm_int2_101010ext = 21,
    unsigned_int10x6ext = 22,
    unsigned_int12x4ext = 23,
    unsigned_int14x2ext = 24,
    unorm_int12x4ext = 25,
    unorm_int14x2ext = 26,
};
pub const FPRoundingMode = enum(u32) {
    rte = 0,
    rtz = 1,
    rtp = 2,
    rtn = 3,
};
pub const FPDenormMode = enum(u32) {
    preserve = 0,
    flush_to_zero = 1,
};
pub const QuantizationModes = enum(u32) {
    trn = 0,
    trn_zero = 1,
    rnd = 2,
    rnd_zero = 3,
    rnd_inf = 4,
    rnd_min_inf = 5,
    rnd_conv = 6,
    rnd_conv_odd = 7,
};
pub const FPOperationMode = enum(u32) {
    ieee = 0,
    alt = 1,
};
pub const OverflowModes = enum(u32) {
    wrap = 0,
    sat = 1,
    sat_zero = 2,
    sat_sym = 3,
};
pub const LinkageType = enum(u32) {
    @"export" = 0,
    import = 1,
    link_once_odr = 2,
};
pub const AccessQualifier = enum(u32) {
    read_only = 0,
    write_only = 1,
    read_write = 2,
};
pub const HostAccessQualifier = enum(u32) {
    none_intel = 0,
    read_intel = 1,
    write_intel = 2,
    read_write_intel = 3,
};
pub const FunctionParameterAttribute = enum(u32) {
    zext = 0,
    sext = 1,
    by_val = 2,
    sret = 3,
    no_alias = 4,
    no_capture = 5,
    no_write = 6,
    no_read_write = 7,
    runtime_aligned_intel = 5940,
};
pub const Decoration = enum(u32) {
    relaxed_precision = 0,
    spec_id = 1,
    block = 2,
    buffer_block = 3,
    row_major = 4,
    col_major = 5,
    array_stride = 6,
    matrix_stride = 7,
    glsl_shared = 8,
    glsl_packed = 9,
    c_packed = 10,
    built_in = 11,
    no_perspective = 13,
    flat = 14,
    patch = 15,
    centroid = 16,
    sample = 17,
    invariant = 18,
    restrict = 19,
    aliased = 20,
    @"volatile" = 21,
    constant = 22,
    coherent = 23,
    non_writable = 24,
    non_readable = 25,
    uniform = 26,
    uniform_id = 27,
    saturated_conversion = 28,
    stream = 29,
    location = 30,
    component = 31,
    index = 32,
    binding = 33,
    descriptor_set = 34,
    offset = 35,
    xfb_buffer = 36,
    xfb_stride = 37,
    func_param_attr = 38,
    fp_rounding_mode = 39,
    fp_fast_math_mode = 40,
    linkage_attributes = 41,
    no_contraction = 42,
    input_attachment_index = 43,
    alignment = 44,
    max_byte_offset = 45,
    alignment_id = 46,
    max_byte_offset_id = 47,
    saturated_to_largest_float8normal_conversion_ext = 4216,
    no_signed_wrap = 4469,
    no_unsigned_wrap = 4470,
    weight_texture_qcom = 4487,
    block_match_texture_qcom = 4488,
    block_match_sampler_qcom = 4499,
    explicit_interp_amd = 4999,
    node_shares_payload_limits_with_amdx = 5019,
    node_max_payloads_amdx = 5020,
    track_finish_writing_amdx = 5078,
    payload_node_name_amdx = 5091,
    payload_node_base_index_amdx = 5098,
    payload_node_sparse_array_amdx = 5099,
    payload_node_array_size_amdx = 5100,
    payload_dispatch_indirect_amdx = 5105,
    override_coverage_nv = 5248,
    passthrough_nv = 5250,
    viewport_relative_nv = 5252,
    secondary_viewport_relative_nv = 5256,
    per_primitive_ext = 5271,
    per_view_nv = 5272,
    per_task_nv = 5273,
    per_vertex_khr = 5285,
    non_uniform = 5300,
    restrict_pointer = 5355,
    aliased_pointer = 5356,
    hit_object_shader_record_buffer_nv = 5386,
    bindless_sampler_nv = 5398,
    bindless_image_nv = 5399,
    bound_sampler_nv = 5400,
    bound_image_nv = 5401,
    simt_call_intel = 5599,
    referenced_indirectly_intel = 5602,
    clobber_intel = 5607,
    side_effects_intel = 5608,
    vector_compute_variable_intel = 5624,
    func_param_io_kind_intel = 5625,
    vector_compute_function_intel = 5626,
    stack_call_intel = 5627,
    global_variable_offset_intel = 5628,
    counter_buffer = 5634,
    user_semantic = 5635,
    user_type_google = 5636,
    function_rounding_mode_intel = 5822,
    function_denorm_mode_intel = 5823,
    register_intel = 5825,
    memory_intel = 5826,
    numbanks_intel = 5827,
    bankwidth_intel = 5828,
    max_private_copies_intel = 5829,
    singlepump_intel = 5830,
    doublepump_intel = 5831,
    max_replicates_intel = 5832,
    simple_dual_port_intel = 5833,
    merge_intel = 5834,
    bank_bits_intel = 5835,
    force_pow2depth_intel = 5836,
    stridesize_intel = 5883,
    wordsize_intel = 5884,
    true_dual_port_intel = 5885,
    burst_coalesce_intel = 5899,
    cache_size_intel = 5900,
    dont_statically_coalesce_intel = 5901,
    prefetch_intel = 5902,
    stall_enable_intel = 5905,
    fuse_loops_in_function_intel = 5907,
    math_op_dsp_mode_intel = 5909,
    alias_scope_intel = 5914,
    no_alias_intel = 5915,
    initiation_interval_intel = 5917,
    max_concurrency_intel = 5918,
    pipeline_enable_intel = 5919,
    buffer_location_intel = 5921,
    io_pipe_storage_intel = 5944,
    function_floating_point_mode_intel = 6080,
    single_element_vector_intel = 6085,
    vector_compute_callable_function_intel = 6087,
    media_block_iointel = 6140,
    stall_free_intel = 6151,
    fp_max_error_decoration_intel = 6170,
    latency_control_label_intel = 6172,
    latency_control_constraint_intel = 6173,
    conduit_kernel_argument_intel = 6175,
    register_map_kernel_argument_intel = 6176,
    mm_host_interface_address_width_intel = 6177,
    mm_host_interface_data_width_intel = 6178,
    mm_host_interface_latency_intel = 6179,
    mm_host_interface_read_write_mode_intel = 6180,
    mm_host_interface_max_burst_intel = 6181,
    mm_host_interface_wait_request_intel = 6182,
    stable_kernel_argument_intel = 6183,
    host_access_intel = 6188,
    init_mode_intel = 6190,
    implement_in_register_map_intel = 6191,
    cache_control_load_intel = 6442,
    cache_control_store_intel = 6443,

    pub const Extended = union(Decoration) {
        relaxed_precision,
        spec_id: struct { specialization_constant_id: LiteralInteger },
        block,
        buffer_block,
        row_major,
        col_major,
        array_stride: struct { array_stride: LiteralInteger },
        matrix_stride: struct { matrix_stride: LiteralInteger },
        glsl_shared,
        glsl_packed,
        c_packed,
        built_in: struct { built_in: BuiltIn },
        no_perspective,
        flat,
        patch,
        centroid,
        sample,
        invariant,
        restrict,
        aliased,
        @"volatile",
        constant,
        coherent,
        non_writable,
        non_readable,
        uniform,
        uniform_id: struct { execution: Id },
        saturated_conversion,
        stream: struct { stream_number: LiteralInteger },
        location: struct { location: LiteralInteger },
        component: struct { component: LiteralInteger },
        index: struct { index: LiteralInteger },
        binding: struct { binding_point: LiteralInteger },
        descriptor_set: struct { descriptor_set: LiteralInteger },
        offset: struct { byte_offset: LiteralInteger },
        xfb_buffer: struct { xfb_buffer_number: LiteralInteger },
        xfb_stride: struct { xfb_stride: LiteralInteger },
        func_param_attr: struct { function_parameter_attribute: FunctionParameterAttribute },
        fp_rounding_mode: struct { fp_rounding_mode: FPRoundingMode },
        fp_fast_math_mode: struct { fp_fast_math_mode: FPFastMathMode },
        linkage_attributes: struct { name: LiteralString, linkage_type: LinkageType },
        no_contraction,
        input_attachment_index: struct { attachment_index: LiteralInteger },
        alignment: struct { alignment: LiteralInteger },
        max_byte_offset: struct { max_byte_offset: LiteralInteger },
        alignment_id: struct { alignment: Id },
        max_byte_offset_id: struct { max_byte_offset: Id },
        saturated_to_largest_float8normal_conversion_ext,
        no_signed_wrap,
        no_unsigned_wrap,
        weight_texture_qcom,
        block_match_texture_qcom,
        block_match_sampler_qcom,
        explicit_interp_amd,
        node_shares_payload_limits_with_amdx: struct { payload_type: Id },
        node_max_payloads_amdx: struct { max_number_of_payloads: Id },
        track_finish_writing_amdx,
        payload_node_name_amdx: struct { node_name: Id },
        payload_node_base_index_amdx: struct { base_index: Id },
        payload_node_sparse_array_amdx,
        payload_node_array_size_amdx: struct { array_size: Id },
        payload_dispatch_indirect_amdx,
        override_coverage_nv,
        passthrough_nv,
        viewport_relative_nv,
        secondary_viewport_relative_nv: struct { offset: LiteralInteger },
        per_primitive_ext,
        per_view_nv,
        per_task_nv,
        per_vertex_khr,
        non_uniform,
        restrict_pointer,
        aliased_pointer,
        hit_object_shader_record_buffer_nv,
        bindless_sampler_nv,
        bindless_image_nv,
        bound_sampler_nv,
        bound_image_nv,
        simt_call_intel: struct { n: LiteralInteger },
        referenced_indirectly_intel,
        clobber_intel: struct { register: LiteralString },
        side_effects_intel,
        vector_compute_variable_intel,
        func_param_io_kind_intel: struct { kind: LiteralInteger },
        vector_compute_function_intel,
        stack_call_intel,
        global_variable_offset_intel: struct { offset: LiteralInteger },
        counter_buffer: struct { counter_buffer: Id },
        user_semantic: struct { semantic: LiteralString },
        user_type_google: struct { user_type: LiteralString },
        function_rounding_mode_intel: struct { target_width: LiteralInteger, fp_rounding_mode: FPRoundingMode },
        function_denorm_mode_intel: struct { target_width: LiteralInteger, fp_denorm_mode: FPDenormMode },
        register_intel,
        memory_intel: struct { memory_type: LiteralString },
        numbanks_intel: struct { banks: LiteralInteger },
        bankwidth_intel: struct { bank_width: LiteralInteger },
        max_private_copies_intel: struct { maximum_copies: LiteralInteger },
        singlepump_intel,
        doublepump_intel,
        max_replicates_intel: struct { maximum_replicates: LiteralInteger },
        simple_dual_port_intel,
        merge_intel: struct { merge_key: LiteralString, merge_type: LiteralString },
        bank_bits_intel: struct { bank_bits: []const LiteralInteger = &.{} },
        force_pow2depth_intel: struct { force_key: LiteralInteger },
        stridesize_intel: struct { stride_size: LiteralInteger },
        wordsize_intel: struct { word_size: LiteralInteger },
        true_dual_port_intel,
        burst_coalesce_intel,
        cache_size_intel: struct { cache_size_in_bytes: LiteralInteger },
        dont_statically_coalesce_intel,
        prefetch_intel: struct { prefetcher_size_in_bytes: LiteralInteger },
        stall_enable_intel,
        fuse_loops_in_function_intel,
        math_op_dsp_mode_intel: struct { mode: LiteralInteger, propagate: LiteralInteger },
        alias_scope_intel: struct { aliasing_scopes_list: Id },
        no_alias_intel: struct { aliasing_scopes_list: Id },
        initiation_interval_intel: struct { cycles: LiteralInteger },
        max_concurrency_intel: struct { invocations: LiteralInteger },
        pipeline_enable_intel: struct { enable: LiteralInteger },
        buffer_location_intel: struct { buffer_location_id: LiteralInteger },
        io_pipe_storage_intel: struct { io_pipe_id: LiteralInteger },
        function_floating_point_mode_intel: struct { target_width: LiteralInteger, fp_operation_mode: FPOperationMode },
        single_element_vector_intel,
        vector_compute_callable_function_intel,
        media_block_iointel,
        stall_free_intel,
        fp_max_error_decoration_intel: struct { max_error: LiteralFloat },
        latency_control_label_intel: struct { latency_label: LiteralInteger },
        latency_control_constraint_intel: struct { relative_to: LiteralInteger, control_type: LiteralInteger, relative_cycle: LiteralInteger },
        conduit_kernel_argument_intel,
        register_map_kernel_argument_intel,
        mm_host_interface_address_width_intel: struct { address_width: LiteralInteger },
        mm_host_interface_data_width_intel: struct { data_width: LiteralInteger },
        mm_host_interface_latency_intel: struct { latency: LiteralInteger },
        mm_host_interface_read_write_mode_intel: struct { read_write_mode: AccessQualifier },
        mm_host_interface_max_burst_intel: struct { max_burst_count: LiteralInteger },
        mm_host_interface_wait_request_intel: struct { waitrequest: LiteralInteger },
        stable_kernel_argument_intel,
        host_access_intel: struct { access: HostAccessQualifier, name: LiteralString },
        init_mode_intel: struct { trigger: InitializationModeQualifier },
        implement_in_register_map_intel: struct { value: LiteralInteger },
        cache_control_load_intel: struct { cache_level: LiteralInteger, cache_control: LoadCacheControl },
        cache_control_store_intel: struct { cache_level: LiteralInteger, cache_control: StoreCacheControl },
    };
};
pub const BuiltIn = enum(u32) {
    position = 0,
    point_size = 1,
    clip_distance = 3,
    cull_distance = 4,
    vertex_id = 5,
    instance_id = 6,
    primitive_id = 7,
    invocation_id = 8,
    layer = 9,
    viewport_index = 10,
    tess_level_outer = 11,
    tess_level_inner = 12,
    tess_coord = 13,
    patch_vertices = 14,
    frag_coord = 15,
    point_coord = 16,
    front_facing = 17,
    sample_id = 18,
    sample_position = 19,
    sample_mask = 20,
    frag_depth = 22,
    helper_invocation = 23,
    num_workgroups = 24,
    workgroup_size = 25,
    workgroup_id = 26,
    local_invocation_id = 27,
    global_invocation_id = 28,
    local_invocation_index = 29,
    work_dim = 30,
    global_size = 31,
    enqueued_workgroup_size = 32,
    global_offset = 33,
    global_linear_id = 34,
    subgroup_size = 36,
    subgroup_max_size = 37,
    num_subgroups = 38,
    num_enqueued_subgroups = 39,
    subgroup_id = 40,
    subgroup_local_invocation_id = 41,
    vertex_index = 42,
    instance_index = 43,
    core_idarm = 4160,
    core_count_arm = 4161,
    core_max_idarm = 4162,
    warp_idarm = 4163,
    warp_max_idarm = 4164,
    subgroup_eq_mask = 4416,
    subgroup_ge_mask = 4417,
    subgroup_gt_mask = 4418,
    subgroup_le_mask = 4419,
    subgroup_lt_mask = 4420,
    base_vertex = 4424,
    base_instance = 4425,
    draw_index = 4426,
    primitive_shading_rate_khr = 4432,
    device_index = 4438,
    view_index = 4440,
    shading_rate_khr = 4444,
    tile_offset_qcom = 4492,
    tile_dimension_qcom = 4493,
    tile_apron_size_qcom = 4494,
    bary_coord_no_persp_amd = 4992,
    bary_coord_no_persp_centroid_amd = 4993,
    bary_coord_no_persp_sample_amd = 4994,
    bary_coord_smooth_amd = 4995,
    bary_coord_smooth_centroid_amd = 4996,
    bary_coord_smooth_sample_amd = 4997,
    bary_coord_pull_model_amd = 4998,
    frag_stencil_ref_ext = 5014,
    remaining_recursion_levels_amdx = 5021,
    shader_index_amdx = 5073,
    viewport_mask_nv = 5253,
    secondary_position_nv = 5257,
    secondary_viewport_mask_nv = 5258,
    position_per_view_nv = 5261,
    viewport_mask_per_view_nv = 5262,
    fully_covered_ext = 5264,
    task_count_nv = 5274,
    primitive_count_nv = 5275,
    primitive_indices_nv = 5276,
    clip_distance_per_view_nv = 5277,
    cull_distance_per_view_nv = 5278,
    layer_per_view_nv = 5279,
    mesh_view_count_nv = 5280,
    mesh_view_indices_nv = 5281,
    bary_coord_khr = 5286,
    bary_coord_no_persp_khr = 5287,
    frag_size_ext = 5292,
    frag_invocation_count_ext = 5293,
    primitive_point_indices_ext = 5294,
    primitive_line_indices_ext = 5295,
    primitive_triangle_indices_ext = 5296,
    cull_primitive_ext = 5299,
    launch_id_khr = 5319,
    launch_size_khr = 5320,
    world_ray_origin_khr = 5321,
    world_ray_direction_khr = 5322,
    object_ray_origin_khr = 5323,
    object_ray_direction_khr = 5324,
    ray_tmin_khr = 5325,
    ray_tmax_khr = 5326,
    instance_custom_index_khr = 5327,
    object_to_world_khr = 5330,
    world_to_object_khr = 5331,
    hit_tnv = 5332,
    hit_kind_khr = 5333,
    current_ray_time_nv = 5334,
    hit_triangle_vertex_positions_khr = 5335,
    hit_micro_triangle_vertex_positions_nv = 5337,
    hit_micro_triangle_vertex_barycentrics_nv = 5344,
    incoming_ray_flags_khr = 5351,
    ray_geometry_index_khr = 5352,
    hit_is_sphere_nv = 5359,
    hit_is_lssnv = 5360,
    hit_sphere_position_nv = 5361,
    warps_per_smnv = 5374,
    sm_count_nv = 5375,
    warp_idnv = 5376,
    smidnv = 5377,
    hit_lss_positions_nv = 5396,
    hit_kind_front_facing_micro_triangle_nv = 5405,
    hit_kind_back_facing_micro_triangle_nv = 5406,
    hit_sphere_radius_nv = 5420,
    hit_lss_radii_nv = 5421,
    cluster_idnv = 5436,
    cull_mask_khr = 6021,
};
pub const Scope = enum(u32) {
    cross_device = 0,
    device = 1,
    workgroup = 2,
    subgroup = 3,
    invocation = 4,
    queue_family = 5,
    shader_call_khr = 6,
};
pub const GroupOperation = enum(u32) {
    reduce = 0,
    inclusive_scan = 1,
    exclusive_scan = 2,
    clustered_reduce = 3,
    partitioned_reduce_nv = 6,
    partitioned_inclusive_scan_nv = 7,
    partitioned_exclusive_scan_nv = 8,
};
pub const KernelEnqueueFlags = enum(u32) {
    no_wait = 0,
    wait_kernel = 1,
    wait_work_group = 2,
};
pub const Capability = enum(u32) {
    matrix = 0,
    shader = 1,
    geometry = 2,
    tessellation = 3,
    addresses = 4,
    linkage = 5,
    kernel = 6,
    vector16 = 7,
    float16buffer = 8,
    float16 = 9,
    float64 = 10,
    int64 = 11,
    int64atomics = 12,
    image_basic = 13,
    image_read_write = 14,
    image_mipmap = 15,
    pipes = 17,
    groups = 18,
    device_enqueue = 19,
    literal_sampler = 20,
    atomic_storage = 21,
    int16 = 22,
    tessellation_point_size = 23,
    geometry_point_size = 24,
    image_gather_extended = 25,
    storage_image_multisample = 27,
    uniform_buffer_array_dynamic_indexing = 28,
    sampled_image_array_dynamic_indexing = 29,
    storage_buffer_array_dynamic_indexing = 30,
    storage_image_array_dynamic_indexing = 31,
    clip_distance = 32,
    cull_distance = 33,
    image_cube_array = 34,
    sample_rate_shading = 35,
    image_rect = 36,
    sampled_rect = 37,
    generic_pointer = 38,
    int8 = 39,
    input_attachment = 40,
    sparse_residency = 41,
    min_lod = 42,
    sampled1d = 43,
    image1d = 44,
    sampled_cube_array = 45,
    sampled_buffer = 46,
    image_buffer = 47,
    image_ms_array = 48,
    storage_image_extended_formats = 49,
    image_query = 50,
    derivative_control = 51,
    interpolation_function = 52,
    transform_feedback = 53,
    geometry_streams = 54,
    storage_image_read_without_format = 55,
    storage_image_write_without_format = 56,
    multi_viewport = 57,
    subgroup_dispatch = 58,
    named_barrier = 59,
    pipe_storage = 60,
    group_non_uniform = 61,
    group_non_uniform_vote = 62,
    group_non_uniform_arithmetic = 63,
    group_non_uniform_ballot = 64,
    group_non_uniform_shuffle = 65,
    group_non_uniform_shuffle_relative = 66,
    group_non_uniform_clustered = 67,
    group_non_uniform_quad = 68,
    shader_layer = 69,
    shader_viewport_index = 70,
    uniform_decoration = 71,
    core_builtins_arm = 4165,
    tile_image_color_read_access_ext = 4166,
    tile_image_depth_read_access_ext = 4167,
    tile_image_stencil_read_access_ext = 4168,
    tensors_arm = 4174,
    storage_tensor_array_dynamic_indexing_arm = 4175,
    storage_tensor_array_non_uniform_indexing_arm = 4176,
    graph_arm = 4191,
    cooperative_matrix_layouts_arm = 4201,
    float8ext = 4212,
    float8cooperative_matrix_ext = 4213,
    fragment_shading_rate_khr = 4422,
    subgroup_ballot_khr = 4423,
    draw_parameters = 4427,
    workgroup_memory_explicit_layout_khr = 4428,
    workgroup_memory_explicit_layout8bit_access_khr = 4429,
    workgroup_memory_explicit_layout16bit_access_khr = 4430,
    subgroup_vote_khr = 4431,
    storage_buffer16bit_access = 4433,
    uniform_and_storage_buffer16bit_access = 4434,
    storage_push_constant16 = 4435,
    storage_input_output16 = 4436,
    device_group = 4437,
    multi_view = 4439,
    variable_pointers_storage_buffer = 4441,
    variable_pointers = 4442,
    atomic_storage_ops = 4445,
    sample_mask_post_depth_coverage = 4447,
    storage_buffer8bit_access = 4448,
    uniform_and_storage_buffer8bit_access = 4449,
    storage_push_constant8 = 4450,
    denorm_preserve = 4464,
    denorm_flush_to_zero = 4465,
    signed_zero_inf_nan_preserve = 4466,
    rounding_mode_rte = 4467,
    rounding_mode_rtz = 4468,
    ray_query_provisional_khr = 4471,
    ray_query_khr = 4472,
    untyped_pointers_khr = 4473,
    ray_traversal_primitive_culling_khr = 4478,
    ray_tracing_khr = 4479,
    texture_sample_weighted_qcom = 4484,
    texture_box_filter_qcom = 4485,
    texture_block_match_qcom = 4486,
    tile_shading_qcom = 4495,
    texture_block_match2qcom = 4498,
    float16image_amd = 5008,
    image_gather_bias_lod_amd = 5009,
    fragment_mask_amd = 5010,
    stencil_export_ext = 5013,
    image_read_write_lod_amd = 5015,
    int64image_ext = 5016,
    shader_clock_khr = 5055,
    shader_enqueue_amdx = 5067,
    quad_control_khr = 5087,
    int4type_intel = 5112,
    int4cooperative_matrix_intel = 5114,
    b_float16type_khr = 5116,
    b_float16dot_product_khr = 5117,
    b_float16cooperative_matrix_khr = 5118,
    sample_mask_override_coverage_nv = 5249,
    geometry_shader_passthrough_nv = 5251,
    shader_viewport_index_layer_ext = 5254,
    shader_viewport_mask_nv = 5255,
    shader_stereo_view_nv = 5259,
    per_view_attributes_nv = 5260,
    fragment_fully_covered_ext = 5265,
    mesh_shading_nv = 5266,
    image_footprint_nv = 5282,
    mesh_shading_ext = 5283,
    fragment_barycentric_khr = 5284,
    compute_derivative_group_quads_khr = 5288,
    fragment_density_ext = 5291,
    group_non_uniform_partitioned_nv = 5297,
    shader_non_uniform = 5301,
    runtime_descriptor_array = 5302,
    input_attachment_array_dynamic_indexing = 5303,
    uniform_texel_buffer_array_dynamic_indexing = 5304,
    storage_texel_buffer_array_dynamic_indexing = 5305,
    uniform_buffer_array_non_uniform_indexing = 5306,
    sampled_image_array_non_uniform_indexing = 5307,
    storage_buffer_array_non_uniform_indexing = 5308,
    storage_image_array_non_uniform_indexing = 5309,
    input_attachment_array_non_uniform_indexing = 5310,
    uniform_texel_buffer_array_non_uniform_indexing = 5311,
    storage_texel_buffer_array_non_uniform_indexing = 5312,
    ray_tracing_position_fetch_khr = 5336,
    ray_tracing_nv = 5340,
    ray_tracing_motion_blur_nv = 5341,
    vulkan_memory_model = 5345,
    vulkan_memory_model_device_scope = 5346,
    physical_storage_buffer_addresses = 5347,
    compute_derivative_group_linear_khr = 5350,
    ray_tracing_provisional_khr = 5353,
    cooperative_matrix_nv = 5357,
    fragment_shader_sample_interlock_ext = 5363,
    fragment_shader_shading_rate_interlock_ext = 5372,
    shader_sm_builtins_nv = 5373,
    fragment_shader_pixel_interlock_ext = 5378,
    demote_to_helper_invocation = 5379,
    displacement_micromap_nv = 5380,
    ray_tracing_opacity_micromap_ext = 5381,
    shader_invocation_reorder_nv = 5383,
    bindless_texture_nv = 5390,
    ray_query_position_fetch_khr = 5391,
    cooperative_vector_nv = 5394,
    atomic_float16vector_nv = 5404,
    ray_tracing_displacement_micromap_nv = 5409,
    raw_access_chains_nv = 5414,
    ray_tracing_spheres_geometry_nv = 5418,
    ray_tracing_linear_swept_spheres_geometry_nv = 5419,
    cooperative_matrix_reductions_nv = 5430,
    cooperative_matrix_conversions_nv = 5431,
    cooperative_matrix_per_element_operations_nv = 5432,
    cooperative_matrix_tensor_addressing_nv = 5433,
    cooperative_matrix_block_loads_nv = 5434,
    cooperative_vector_training_nv = 5435,
    ray_tracing_cluster_acceleration_structure_nv = 5437,
    tensor_addressing_nv = 5439,
    subgroup_shuffle_intel = 5568,
    subgroup_buffer_block_iointel = 5569,
    subgroup_image_block_iointel = 5570,
    subgroup_image_media_block_iointel = 5579,
    round_to_infinity_intel = 5582,
    floating_point_mode_intel = 5583,
    integer_functions2intel = 5584,
    function_pointers_intel = 5603,
    indirect_references_intel = 5604,
    asm_intel = 5606,
    atomic_float32min_max_ext = 5612,
    atomic_float64min_max_ext = 5613,
    atomic_float16min_max_ext = 5616,
    vector_compute_intel = 5617,
    vector_any_intel = 5619,
    expect_assume_khr = 5629,
    subgroup_avc_motion_estimation_intel = 5696,
    subgroup_avc_motion_estimation_intra_intel = 5697,
    subgroup_avc_motion_estimation_chroma_intel = 5698,
    variable_length_array_intel = 5817,
    function_float_control_intel = 5821,
    fpga_memory_attributes_intel = 5824,
    fp_fast_math_mode_intel = 5837,
    arbitrary_precision_integers_intel = 5844,
    arbitrary_precision_floating_point_intel = 5845,
    unstructured_loop_controls_intel = 5886,
    fpga_loop_controls_intel = 5888,
    kernel_attributes_intel = 5892,
    fpga_kernel_attributes_intel = 5897,
    fpga_memory_accesses_intel = 5898,
    fpga_cluster_attributes_intel = 5904,
    loop_fuse_intel = 5906,
    fpgadsp_control_intel = 5908,
    memory_access_aliasing_intel = 5910,
    fpga_invocation_pipelining_attributes_intel = 5916,
    fpga_buffer_location_intel = 5920,
    arbitrary_precision_fixed_point_intel = 5922,
    usm_storage_classes_intel = 5935,
    runtime_aligned_attribute_intel = 5939,
    io_pipes_intel = 5943,
    blocking_pipes_intel = 5945,
    fpga_reg_intel = 5948,
    dot_product_input_all = 6016,
    dot_product_input4x8bit = 6017,
    dot_product_input4x8bit_packed = 6018,
    dot_product = 6019,
    ray_cull_mask_khr = 6020,
    cooperative_matrix_khr = 6022,
    replicated_composites_ext = 6024,
    bit_instructions = 6025,
    group_non_uniform_rotate_khr = 6026,
    float_controls2 = 6029,
    atomic_float32add_ext = 6033,
    atomic_float64add_ext = 6034,
    long_composites_intel = 6089,
    opt_none_ext = 6094,
    atomic_float16add_ext = 6095,
    debug_info_module_intel = 6114,
    b_float16conversion_intel = 6115,
    split_barrier_intel = 6141,
    arithmetic_fence_ext = 6144,
    fpga_cluster_attributes_v2intel = 6150,
    fpga_kernel_attributesv2intel = 6161,
    task_sequence_intel = 6162,
    fp_max_error_intel = 6169,
    fpga_latency_control_intel = 6171,
    fpga_argument_interfaces_intel = 6174,
    global_variable_host_access_intel = 6187,
    global_variable_fpga_decorations_intel = 6189,
    subgroup_buffer_prefetch_intel = 6220,
    subgroup2d_block_iointel = 6228,
    subgroup2d_block_transform_intel = 6229,
    subgroup2d_block_transpose_intel = 6230,
    subgroup_matrix_multiply_accumulate_intel = 6236,
    ternary_bitwise_function_intel = 6241,
    group_uniform_arithmetic_khr = 6400,
    tensor_float32rounding_intel = 6425,
    masked_gather_scatter_intel = 6427,
    cache_controls_intel = 6441,
    register_limits_intel = 6460,
    bindless_images_intel = 6528,
};
pub const RayQueryIntersection = enum(u32) {
    ray_query_candidate_intersection_khr = 0,
    ray_query_committed_intersection_khr = 1,
};
pub const RayQueryCommittedIntersectionType = enum(u32) {
    ray_query_committed_intersection_none_khr = 0,
    ray_query_committed_intersection_triangle_khr = 1,
    ray_query_committed_intersection_generated_khr = 2,
};
pub const RayQueryCandidateIntersectionType = enum(u32) {
    ray_query_candidate_intersection_triangle_khr = 0,
    ray_query_candidate_intersection_aabbkhr = 1,
};
pub const PackedVectorFormat = enum(u32) {
    packed_vector_format4x8bit = 0,
};
pub const CooperativeMatrixOperands = packed struct {
    matrix_a_signed_components_khr: bool = false,
    matrix_b_signed_components_khr: bool = false,
    matrix_c_signed_components_khr: bool = false,
    matrix_result_signed_components_khr: bool = false,
    saturating_accumulation_khr: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const CooperativeMatrixLayout = enum(u32) {
    row_major_khr = 0,
    column_major_khr = 1,
    row_blocked_interleaved_arm = 4202,
    column_blocked_interleaved_arm = 4203,
};
pub const CooperativeMatrixUse = enum(u32) {
    matrix_akhr = 0,
    matrix_bkhr = 1,
    matrix_accumulator_khr = 2,
};
pub const CooperativeMatrixReduce = packed struct {
    row: bool = false,
    column: bool = false,
    @"2x2": bool = false,
    _reserved_bit_3: bool = false,
    _reserved_bit_4: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const TensorClampMode = enum(u32) {
    undefined = 0,
    constant = 1,
    clamp_to_edge = 2,
    repeat = 3,
    repeat_mirrored = 4,
};
pub const TensorAddressingOperands = packed struct {
    tensor_view: bool = false,
    decode_func: bool = false,
    _reserved_bit_2: bool = false,
    _reserved_bit_3: bool = false,
    _reserved_bit_4: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,

    pub const Extended = struct {
        tensor_view: ?struct { id_ref: Id } = null,
        decode_func: ?struct { id_ref: Id } = null,
        _reserved_bit_2: bool = false,
        _reserved_bit_3: bool = false,
        _reserved_bit_4: bool = false,
        _reserved_bit_5: bool = false,
        _reserved_bit_6: bool = false,
        _reserved_bit_7: bool = false,
        _reserved_bit_8: bool = false,
        _reserved_bit_9: bool = false,
        _reserved_bit_10: bool = false,
        _reserved_bit_11: bool = false,
        _reserved_bit_12: bool = false,
        _reserved_bit_13: bool = false,
        _reserved_bit_14: bool = false,
        _reserved_bit_15: bool = false,
        _reserved_bit_16: bool = false,
        _reserved_bit_17: bool = false,
        _reserved_bit_18: bool = false,
        _reserved_bit_19: bool = false,
        _reserved_bit_20: bool = false,
        _reserved_bit_21: bool = false,
        _reserved_bit_22: bool = false,
        _reserved_bit_23: bool = false,
        _reserved_bit_24: bool = false,
        _reserved_bit_25: bool = false,
        _reserved_bit_26: bool = false,
        _reserved_bit_27: bool = false,
        _reserved_bit_28: bool = false,
        _reserved_bit_29: bool = false,
        _reserved_bit_30: bool = false,
        _reserved_bit_31: bool = false,
    };
};
pub const InitializationModeQualifier = enum(u32) {
    init_on_device_reprogram_intel = 0,
    init_on_device_reset_intel = 1,
};
pub const LoadCacheControl = enum(u32) {
    uncached_intel = 0,
    cached_intel = 1,
    streaming_intel = 2,
    invalidate_after_read_intel = 3,
    const_cached_intel = 4,
};
pub const StoreCacheControl = enum(u32) {
    uncached_intel = 0,
    write_through_intel = 1,
    write_back_intel = 2,
    streaming_intel = 3,
};
pub const NamedMaximumNumberOfRegisters = enum(u32) {
    auto_intel = 0,
};
pub const MatrixMultiplyAccumulateOperands = packed struct {
    matrix_a_signed_components_intel: bool = false,
    matrix_b_signed_components_intel: bool = false,
    matrix_cb_float16intel: bool = false,
    matrix_result_b_float16intel: bool = false,
    matrix_a_packed_int8intel: bool = false,
    matrix_b_packed_int8intel: bool = false,
    matrix_a_packed_int4intel: bool = false,
    matrix_b_packed_int4intel: bool = false,
    matrix_atf32intel: bool = false,
    matrix_btf32intel: bool = false,
    matrix_a_packed_float16intel: bool = false,
    matrix_b_packed_float16intel: bool = false,
    matrix_a_packed_b_float16intel: bool = false,
    matrix_b_packed_b_float16intel: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,
};
pub const FPEncoding = enum(u32) {
    b_float16khr = 0,
    float8e4m3ext = 4214,
    float8e5m2ext = 4215,
};
pub const CooperativeVectorMatrixLayout = enum(u32) {
    row_major_nv = 0,
    column_major_nv = 1,
    inferencing_optimal_nv = 2,
    training_optimal_nv = 3,
};
pub const ComponentType = enum(u32) {
    float16nv = 0,
    float32nv = 1,
    float64nv = 2,
    signed_int8nv = 3,
    signed_int16nv = 4,
    signed_int32nv = 5,
    signed_int64nv = 6,
    unsigned_int8nv = 7,
    unsigned_int16nv = 8,
    unsigned_int32nv = 9,
    unsigned_int64nv = 10,
    signed_int8packed_nv = 1000491000,
    unsigned_int8packed_nv = 1000491001,
    float_e4m3nv = 1000491002,
    float_e5m2nv = 1000491003,
};
pub const TensorOperands = packed struct {
    nontemporal_arm: bool = false,
    out_of_bounds_value_arm: bool = false,
    make_element_available_arm: bool = false,
    make_element_visible_arm: bool = false,
    non_private_element_arm: bool = false,
    _reserved_bit_5: bool = false,
    _reserved_bit_6: bool = false,
    _reserved_bit_7: bool = false,
    _reserved_bit_8: bool = false,
    _reserved_bit_9: bool = false,
    _reserved_bit_10: bool = false,
    _reserved_bit_11: bool = false,
    _reserved_bit_12: bool = false,
    _reserved_bit_13: bool = false,
    _reserved_bit_14: bool = false,
    _reserved_bit_15: bool = false,
    _reserved_bit_16: bool = false,
    _reserved_bit_17: bool = false,
    _reserved_bit_18: bool = false,
    _reserved_bit_19: bool = false,
    _reserved_bit_20: bool = false,
    _reserved_bit_21: bool = false,
    _reserved_bit_22: bool = false,
    _reserved_bit_23: bool = false,
    _reserved_bit_24: bool = false,
    _reserved_bit_25: bool = false,
    _reserved_bit_26: bool = false,
    _reserved_bit_27: bool = false,
    _reserved_bit_28: bool = false,
    _reserved_bit_29: bool = false,
    _reserved_bit_30: bool = false,
    _reserved_bit_31: bool = false,

    pub const Extended = struct {
        nontemporal_arm: bool = false,
        out_of_bounds_value_arm: ?struct { id_ref: Id } = null,
        make_element_available_arm: ?struct { id_ref: Id } = null,
        make_element_visible_arm: ?struct { id_ref: Id } = null,
        non_private_element_arm: bool = false,
        _reserved_bit_5: bool = false,
        _reserved_bit_6: bool = false,
        _reserved_bit_7: bool = false,
        _reserved_bit_8: bool = false,
        _reserved_bit_9: bool = false,
        _reserved_bit_10: bool = false,
        _reserved_bit_11: bool = false,
        _reserved_bit_12: bool = false,
        _reserved_bit_13: bool = false,
        _reserved_bit_14: bool = false,
        _reserved_bit_15: bool = false,
        _reserved_bit_16: bool = false,
        _reserved_bit_17: bool = false,
        _reserved_bit_18: bool = false,
        _reserved_bit_19: bool = false,
        _reserved_bit_20: bool = false,
        _reserved_bit_21: bool = false,
        _reserved_bit_22: bool = false,
        _reserved_bit_23: bool = false,
        _reserved_bit_24: bool = false,
        _reserved_bit_25: bool = false,
        _reserved_bit_26: bool = false,
        _reserved_bit_27: bool = false,
        _reserved_bit_28: bool = false,
        _reserved_bit_29: bool = false,
        _reserved_bit_30: bool = false,
        _reserved_bit_31: bool = false,
    };
};
pub const InstructionSet = enum {
    core,
    @"GLSL.std.450",
    @"OpenCL.std",
    zig,

    pub fn instructions(self: InstructionSet) []const Instruction {
        return switch (self) {
            .core => &.{
                .{
                    .name = "OpNop",
                    .opcode = 0,
                    .operands = &.{},
                },
                .{
                    .name = "OpUndef",
                    .opcode = 1,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSourceContinued",
                    .opcode = 2,
                    .operands = &.{
                        .{ .kind = .literal_string, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSource",
                    .opcode = 3,
                    .operands = &.{
                        .{ .kind = .source_language, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                        .{ .kind = .literal_string, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSourceExtension",
                    .opcode = 4,
                    .operands = &.{
                        .{ .kind = .literal_string, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpName",
                    .opcode = 5,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_string, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMemberName",
                    .opcode = 6,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_string, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpString",
                    .opcode = 7,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .literal_string, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLine",
                    .opcode = 8,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpExtension",
                    .opcode = 10,
                    .operands = &.{
                        .{ .kind = .literal_string, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpExtInstImport",
                    .opcode = 11,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .literal_string, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpExtInst",
                    .opcode = 12,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_ext_inst_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpMemoryModel",
                    .opcode = 14,
                    .operands = &.{
                        .{ .kind = .addressing_model, .quantifier = .required },
                        .{ .kind = .memory_model, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpEntryPoint",
                    .opcode = 15,
                    .operands = &.{
                        .{ .kind = .execution_model, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_string, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpExecutionMode",
                    .opcode = 16,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .execution_mode, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCapability",
                    .opcode = 17,
                    .operands = &.{
                        .{ .kind = .capability, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeVoid",
                    .opcode = 19,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeBool",
                    .opcode = 20,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeInt",
                    .opcode = 21,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeFloat",
                    .opcode = 22,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .fp_encoding, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpTypeVector",
                    .opcode = 23,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeMatrix",
                    .opcode = 24,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeImage",
                    .opcode = 25,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .dim, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .image_format, .quantifier = .required },
                        .{ .kind = .access_qualifier, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpTypeSampler",
                    .opcode = 26,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeSampledImage",
                    .opcode = 27,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeArray",
                    .opcode = 28,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeRuntimeArray",
                    .opcode = 29,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeStruct",
                    .opcode = 30,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpTypeOpaque",
                    .opcode = 31,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .literal_string, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypePointer",
                    .opcode = 32,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .storage_class, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeFunction",
                    .opcode = 33,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpTypeEvent",
                    .opcode = 34,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeDeviceEvent",
                    .opcode = 35,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeReserveId",
                    .opcode = 36,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeQueue",
                    .opcode = 37,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypePipe",
                    .opcode = 38,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .access_qualifier, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeForwardPointer",
                    .opcode = 39,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .storage_class, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConstantTrue",
                    .opcode = 41,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConstantFalse",
                    .opcode = 42,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConstant",
                    .opcode = 43,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .literal_context_dependent_number, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConstantComposite",
                    .opcode = 44,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpConstantSampler",
                    .opcode = 45,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .sampler_addressing_mode, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .sampler_filter_mode, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConstantNull",
                    .opcode = 46,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSpecConstantTrue",
                    .opcode = 48,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSpecConstantFalse",
                    .opcode = 49,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSpecConstant",
                    .opcode = 50,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .literal_context_dependent_number, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSpecConstantComposite",
                    .opcode = 51,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpSpecConstantOp",
                    .opcode = 52,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .literal_spec_constant_op_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFunction",
                    .opcode = 54,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .function_control, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFunctionParameter",
                    .opcode = 55,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFunctionEnd",
                    .opcode = 56,
                    .operands = &.{},
                },
                .{
                    .name = "OpFunctionCall",
                    .opcode = 57,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpVariable",
                    .opcode = 59,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .storage_class, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageTexelPointer",
                    .opcode = 60,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLoad",
                    .opcode = 61,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .memory_access, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpStore",
                    .opcode = 62,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .memory_access, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpCopyMemory",
                    .opcode = 63,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .memory_access, .quantifier = .optional },
                        .{ .kind = .memory_access, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpCopyMemorySized",
                    .opcode = 64,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .memory_access, .quantifier = .optional },
                        .{ .kind = .memory_access, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpAccessChain",
                    .opcode = 65,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpInBoundsAccessChain",
                    .opcode = 66,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpPtrAccessChain",
                    .opcode = 67,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpArrayLength",
                    .opcode = 68,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGenericPtrMemSemantics",
                    .opcode = 69,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpInBoundsPtrAccessChain",
                    .opcode = 70,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpDecorate",
                    .opcode = 71,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .decoration, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMemberDecorate",
                    .opcode = 72,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .decoration, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDecorationGroup",
                    .opcode = 73,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupDecorate",
                    .opcode = 74,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpGroupMemberDecorate",
                    .opcode = 75,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .pair_id_ref_literal_integer, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpVectorExtractDynamic",
                    .opcode = 77,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpVectorInsertDynamic",
                    .opcode = 78,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpVectorShuffle",
                    .opcode = 79,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpCompositeConstruct",
                    .opcode = 80,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpCompositeExtract",
                    .opcode = 81,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpCompositeInsert",
                    .opcode = 82,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpCopyObject",
                    .opcode = 83,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTranspose",
                    .opcode = 84,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSampledImage",
                    .opcode = 86,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSampleImplicitLod",
                    .opcode = 87,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSampleExplicitLod",
                    .opcode = 88,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSampleDrefImplicitLod",
                    .opcode = 89,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSampleDrefExplicitLod",
                    .opcode = 90,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSampleProjImplicitLod",
                    .opcode = 91,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSampleProjExplicitLod",
                    .opcode = 92,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSampleProjDrefImplicitLod",
                    .opcode = 93,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSampleProjDrefExplicitLod",
                    .opcode = 94,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageFetch",
                    .opcode = 95,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageGather",
                    .opcode = 96,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageDrefGather",
                    .opcode = 97,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageRead",
                    .opcode = 98,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageWrite",
                    .opcode = 99,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImage",
                    .opcode = 100,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageQueryFormat",
                    .opcode = 101,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageQueryOrder",
                    .opcode = 102,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageQuerySizeLod",
                    .opcode = 103,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageQuerySize",
                    .opcode = 104,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageQueryLod",
                    .opcode = 105,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageQueryLevels",
                    .opcode = 106,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageQuerySamples",
                    .opcode = 107,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertFToU",
                    .opcode = 109,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertFToS",
                    .opcode = 110,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertSToF",
                    .opcode = 111,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertUToF",
                    .opcode = 112,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUConvert",
                    .opcode = 113,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSConvert",
                    .opcode = 114,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFConvert",
                    .opcode = 115,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpQuantizeToF16",
                    .opcode = 116,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertPtrToU",
                    .opcode = 117,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSatConvertSToU",
                    .opcode = 118,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSatConvertUToS",
                    .opcode = 119,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertUToPtr",
                    .opcode = 120,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpPtrCastToGeneric",
                    .opcode = 121,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGenericCastToPtr",
                    .opcode = 122,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGenericCastToPtrExplicit",
                    .opcode = 123,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .storage_class, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBitcast",
                    .opcode = 124,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSNegate",
                    .opcode = 126,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFNegate",
                    .opcode = 127,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIAdd",
                    .opcode = 128,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFAdd",
                    .opcode = 129,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpISub",
                    .opcode = 130,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFSub",
                    .opcode = 131,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIMul",
                    .opcode = 132,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFMul",
                    .opcode = 133,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUDiv",
                    .opcode = 134,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSDiv",
                    .opcode = 135,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFDiv",
                    .opcode = 136,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUMod",
                    .opcode = 137,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSRem",
                    .opcode = 138,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSMod",
                    .opcode = 139,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFRem",
                    .opcode = 140,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFMod",
                    .opcode = 141,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpVectorTimesScalar",
                    .opcode = 142,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMatrixTimesScalar",
                    .opcode = 143,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpVectorTimesMatrix",
                    .opcode = 144,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMatrixTimesVector",
                    .opcode = 145,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMatrixTimesMatrix",
                    .opcode = 146,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpOuterProduct",
                    .opcode = 147,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDot",
                    .opcode = 148,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIAddCarry",
                    .opcode = 149,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpISubBorrow",
                    .opcode = 150,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUMulExtended",
                    .opcode = 151,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSMulExtended",
                    .opcode = 152,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAny",
                    .opcode = 154,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAll",
                    .opcode = 155,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIsNan",
                    .opcode = 156,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIsInf",
                    .opcode = 157,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIsFinite",
                    .opcode = 158,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIsNormal",
                    .opcode = 159,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSignBitSet",
                    .opcode = 160,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLessOrGreater",
                    .opcode = 161,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpOrdered",
                    .opcode = 162,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUnordered",
                    .opcode = 163,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLogicalEqual",
                    .opcode = 164,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLogicalNotEqual",
                    .opcode = 165,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLogicalOr",
                    .opcode = 166,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLogicalAnd",
                    .opcode = 167,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLogicalNot",
                    .opcode = 168,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSelect",
                    .opcode = 169,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIEqual",
                    .opcode = 170,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpINotEqual",
                    .opcode = 171,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUGreaterThan",
                    .opcode = 172,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSGreaterThan",
                    .opcode = 173,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUGreaterThanEqual",
                    .opcode = 174,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSGreaterThanEqual",
                    .opcode = 175,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpULessThan",
                    .opcode = 176,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSLessThan",
                    .opcode = 177,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpULessThanEqual",
                    .opcode = 178,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSLessThanEqual",
                    .opcode = 179,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFOrdEqual",
                    .opcode = 180,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFUnordEqual",
                    .opcode = 181,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFOrdNotEqual",
                    .opcode = 182,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFUnordNotEqual",
                    .opcode = 183,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFOrdLessThan",
                    .opcode = 184,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFUnordLessThan",
                    .opcode = 185,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFOrdGreaterThan",
                    .opcode = 186,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFUnordGreaterThan",
                    .opcode = 187,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFOrdLessThanEqual",
                    .opcode = 188,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFUnordLessThanEqual",
                    .opcode = 189,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFOrdGreaterThanEqual",
                    .opcode = 190,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFUnordGreaterThanEqual",
                    .opcode = 191,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpShiftRightLogical",
                    .opcode = 194,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpShiftRightArithmetic",
                    .opcode = 195,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpShiftLeftLogical",
                    .opcode = 196,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBitwiseOr",
                    .opcode = 197,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBitwiseXor",
                    .opcode = 198,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBitwiseAnd",
                    .opcode = 199,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpNot",
                    .opcode = 200,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBitFieldInsert",
                    .opcode = 201,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBitFieldSExtract",
                    .opcode = 202,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBitFieldUExtract",
                    .opcode = 203,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBitReverse",
                    .opcode = 204,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBitCount",
                    .opcode = 205,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDPdx",
                    .opcode = 207,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDPdy",
                    .opcode = 208,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFwidth",
                    .opcode = 209,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDPdxFine",
                    .opcode = 210,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDPdyFine",
                    .opcode = 211,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFwidthFine",
                    .opcode = 212,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDPdxCoarse",
                    .opcode = 213,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDPdyCoarse",
                    .opcode = 214,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFwidthCoarse",
                    .opcode = 215,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpEmitVertex",
                    .opcode = 218,
                    .operands = &.{},
                },
                .{
                    .name = "OpEndPrimitive",
                    .opcode = 219,
                    .operands = &.{},
                },
                .{
                    .name = "OpEmitStreamVertex",
                    .opcode = 220,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpEndStreamPrimitive",
                    .opcode = 221,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpControlBarrier",
                    .opcode = 224,
                    .operands = &.{
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMemoryBarrier",
                    .opcode = 225,
                    .operands = &.{
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicLoad",
                    .opcode = 227,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicStore",
                    .opcode = 228,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicExchange",
                    .opcode = 229,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicCompareExchange",
                    .opcode = 230,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicCompareExchangeWeak",
                    .opcode = 231,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicIIncrement",
                    .opcode = 232,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicIDecrement",
                    .opcode = 233,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicIAdd",
                    .opcode = 234,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicISub",
                    .opcode = 235,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicSMin",
                    .opcode = 236,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicUMin",
                    .opcode = 237,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicSMax",
                    .opcode = 238,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicUMax",
                    .opcode = 239,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicAnd",
                    .opcode = 240,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicOr",
                    .opcode = 241,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicXor",
                    .opcode = 242,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpPhi",
                    .opcode = 245,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .pair_id_ref_id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpLoopMerge",
                    .opcode = 246,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .loop_control, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSelectionMerge",
                    .opcode = 247,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .selection_control, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLabel",
                    .opcode = 248,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBranch",
                    .opcode = 249,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBranchConditional",
                    .opcode = 250,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpSwitch",
                    .opcode = 251,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .pair_literal_integer_id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpKill",
                    .opcode = 252,
                    .operands = &.{},
                },
                .{
                    .name = "OpReturn",
                    .opcode = 253,
                    .operands = &.{},
                },
                .{
                    .name = "OpReturnValue",
                    .opcode = 254,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUnreachable",
                    .opcode = 255,
                    .operands = &.{},
                },
                .{
                    .name = "OpLifetimeStart",
                    .opcode = 256,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLifetimeStop",
                    .opcode = 257,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupAsyncCopy",
                    .opcode = 259,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupWaitEvents",
                    .opcode = 260,
                    .operands = &.{
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupAll",
                    .opcode = 261,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupAny",
                    .opcode = 262,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupBroadcast",
                    .opcode = 263,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupIAdd",
                    .opcode = 264,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupFAdd",
                    .opcode = 265,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupFMin",
                    .opcode = 266,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupUMin",
                    .opcode = 267,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupSMin",
                    .opcode = 268,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupFMax",
                    .opcode = 269,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupUMax",
                    .opcode = 270,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupSMax",
                    .opcode = 271,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReadPipe",
                    .opcode = 274,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpWritePipe",
                    .opcode = 275,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReservedReadPipe",
                    .opcode = 276,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReservedWritePipe",
                    .opcode = 277,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReserveReadPipePackets",
                    .opcode = 278,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReserveWritePipePackets",
                    .opcode = 279,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCommitReadPipe",
                    .opcode = 280,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCommitWritePipe",
                    .opcode = 281,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIsValidReserveId",
                    .opcode = 282,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGetNumPipePackets",
                    .opcode = 283,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGetMaxPipePackets",
                    .opcode = 284,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupReserveReadPipePackets",
                    .opcode = 285,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupReserveWritePipePackets",
                    .opcode = 286,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupCommitReadPipe",
                    .opcode = 287,
                    .operands = &.{
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupCommitWritePipe",
                    .opcode = 288,
                    .operands = &.{
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpEnqueueMarker",
                    .opcode = 291,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpEnqueueKernel",
                    .opcode = 292,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpGetKernelNDrangeSubGroupCount",
                    .opcode = 293,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGetKernelNDrangeMaxSubGroupSize",
                    .opcode = 294,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGetKernelWorkGroupSize",
                    .opcode = 295,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGetKernelPreferredWorkGroupSizeMultiple",
                    .opcode = 296,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRetainEvent",
                    .opcode = 297,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReleaseEvent",
                    .opcode = 298,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCreateUserEvent",
                    .opcode = 299,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIsValidEvent",
                    .opcode = 300,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSetUserEventStatus",
                    .opcode = 301,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCaptureEventProfilingInfo",
                    .opcode = 302,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGetDefaultQueue",
                    .opcode = 303,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBuildNDRange",
                    .opcode = 304,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSparseSampleImplicitLod",
                    .opcode = 305,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSparseSampleExplicitLod",
                    .opcode = 306,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSparseSampleDrefImplicitLod",
                    .opcode = 307,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSparseSampleDrefExplicitLod",
                    .opcode = 308,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSparseSampleProjImplicitLod",
                    .opcode = 309,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSparseSampleProjExplicitLod",
                    .opcode = 310,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSparseSampleProjDrefImplicitLod",
                    .opcode = 311,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSparseSampleProjDrefExplicitLod",
                    .opcode = 312,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSparseFetch",
                    .opcode = 313,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSparseGather",
                    .opcode = 314,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSparseDrefGather",
                    .opcode = 315,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpImageSparseTexelsResident",
                    .opcode = 316,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpNoLine",
                    .opcode = 317,
                    .operands = &.{},
                },
                .{
                    .name = "OpAtomicFlagTestAndSet",
                    .opcode = 318,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicFlagClear",
                    .opcode = 319,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSparseRead",
                    .opcode = 320,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSizeOf",
                    .opcode = 321,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypePipeStorage",
                    .opcode = 322,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConstantPipeStorage",
                    .opcode = 323,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCreatePipeFromPipeStorage",
                    .opcode = 324,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGetKernelLocalSizeForSubgroupCount",
                    .opcode = 325,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGetKernelMaxNumSubgroups",
                    .opcode = 326,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeNamedBarrier",
                    .opcode = 327,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpNamedBarrierInitialize",
                    .opcode = 328,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMemoryNamedBarrier",
                    .opcode = 329,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpModuleProcessed",
                    .opcode = 330,
                    .operands = &.{
                        .{ .kind = .literal_string, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpExecutionModeId",
                    .opcode = 331,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .execution_mode, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDecorateId",
                    .opcode = 332,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .decoration, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformElect",
                    .opcode = 333,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformAll",
                    .opcode = 334,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformAny",
                    .opcode = 335,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformAllEqual",
                    .opcode = 336,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBroadcast",
                    .opcode = 337,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBroadcastFirst",
                    .opcode = 338,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBallot",
                    .opcode = 339,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformInverseBallot",
                    .opcode = 340,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBallotBitExtract",
                    .opcode = 341,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBallotBitCount",
                    .opcode = 342,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBallotFindLSB",
                    .opcode = 343,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBallotFindMSB",
                    .opcode = 344,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformShuffle",
                    .opcode = 345,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformShuffleXor",
                    .opcode = 346,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformShuffleUp",
                    .opcode = 347,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformShuffleDown",
                    .opcode = 348,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformIAdd",
                    .opcode = 349,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformFAdd",
                    .opcode = 350,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformIMul",
                    .opcode = 351,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformFMul",
                    .opcode = 352,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformSMin",
                    .opcode = 353,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformUMin",
                    .opcode = 354,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformFMin",
                    .opcode = 355,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformSMax",
                    .opcode = 356,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformUMax",
                    .opcode = 357,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformFMax",
                    .opcode = 358,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBitwiseAnd",
                    .opcode = 359,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBitwiseOr",
                    .opcode = 360,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformBitwiseXor",
                    .opcode = 361,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformLogicalAnd",
                    .opcode = 362,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformLogicalOr",
                    .opcode = 363,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformLogicalXor",
                    .opcode = 364,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpGroupNonUniformQuadBroadcast",
                    .opcode = 365,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformQuadSwap",
                    .opcode = 366,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCopyLogical",
                    .opcode = 400,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpPtrEqual",
                    .opcode = 401,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpPtrNotEqual",
                    .opcode = 402,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpPtrDiff",
                    .opcode = 403,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpColorAttachmentReadEXT",
                    .opcode = 4160,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpDepthAttachmentReadEXT",
                    .opcode = 4161,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpStencilAttachmentReadEXT",
                    .opcode = 4162,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpTypeTensorARM",
                    .opcode = 4163,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpTensorReadARM",
                    .opcode = 4164,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .tensor_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpTensorWriteARM",
                    .opcode = 4165,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .tensor_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpTensorQuerySizeARM",
                    .opcode = 4166,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGraphConstantARM",
                    .opcode = 4181,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGraphEntryPointARM",
                    .opcode = 4182,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_string, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpGraphARM",
                    .opcode = 4183,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGraphInputARM",
                    .opcode = 4184,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpGraphSetOutputARM",
                    .opcode = 4185,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpGraphEndARM",
                    .opcode = 4186,
                    .operands = &.{},
                },
                .{
                    .name = "OpTypeGraphARM",
                    .opcode = 4190,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpTerminateInvocation",
                    .opcode = 4416,
                    .operands = &.{},
                },
                .{
                    .name = "OpTypeUntypedPointerKHR",
                    .opcode = 4417,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .storage_class, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUntypedVariableKHR",
                    .opcode = 4418,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .storage_class, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpUntypedAccessChainKHR",
                    .opcode = 4419,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpUntypedInBoundsAccessChainKHR",
                    .opcode = 4420,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpSubgroupBallotKHR",
                    .opcode = 4421,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupFirstInvocationKHR",
                    .opcode = 4422,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUntypedPtrAccessChainKHR",
                    .opcode = 4423,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpUntypedInBoundsPtrAccessChainKHR",
                    .opcode = 4424,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpUntypedArrayLengthKHR",
                    .opcode = 4425,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUntypedPrefetchKHR",
                    .opcode = 4426,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                        .{ .kind = .id_ref, .quantifier = .optional },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSubgroupAllKHR",
                    .opcode = 4428,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAnyKHR",
                    .opcode = 4429,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAllEqualKHR",
                    .opcode = 4430,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformRotateKHR",
                    .opcode = 4431,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSubgroupReadInvocationKHR",
                    .opcode = 4432,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpExtInstWithForwardRefsKHR",
                    .opcode = 4433,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_ext_inst_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpTraceRayKHR",
                    .opcode = 4445,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpExecuteCallableKHR",
                    .opcode = 4446,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertUToAccelerationStructureKHR",
                    .opcode = 4447,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIgnoreIntersectionKHR",
                    .opcode = 4448,
                    .operands = &.{},
                },
                .{
                    .name = "OpTerminateRayKHR",
                    .opcode = 4449,
                    .operands = &.{},
                },
                .{
                    .name = "OpSDot",
                    .opcode = 4450,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .packed_vector_format, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpUDot",
                    .opcode = 4451,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .packed_vector_format, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSUDot",
                    .opcode = 4452,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .packed_vector_format, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSDotAccSat",
                    .opcode = 4453,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .packed_vector_format, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpUDotAccSat",
                    .opcode = 4454,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .packed_vector_format, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSUDotAccSat",
                    .opcode = 4455,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .packed_vector_format, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpTypeCooperativeMatrixKHR",
                    .opcode = 4456,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixLoadKHR",
                    .opcode = 4457,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                        .{ .kind = .memory_access, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixStoreKHR",
                    .opcode = 4458,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                        .{ .kind = .memory_access, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixMulAddKHR",
                    .opcode = 4459,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .cooperative_matrix_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixLengthKHR",
                    .opcode = 4460,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConstantCompositeReplicateEXT",
                    .opcode = 4461,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSpecConstantCompositeReplicateEXT",
                    .opcode = 4462,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCompositeConstructReplicateEXT",
                    .opcode = 4463,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeRayQueryKHR",
                    .opcode = 4472,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryInitializeKHR",
                    .opcode = 4473,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryTerminateKHR",
                    .opcode = 4474,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGenerateIntersectionKHR",
                    .opcode = 4475,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryConfirmIntersectionKHR",
                    .opcode = 4476,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryProceedKHR",
                    .opcode = 4477,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionTypeKHR",
                    .opcode = 4479,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSampleWeightedQCOM",
                    .opcode = 4480,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageBoxFilterQCOM",
                    .opcode = 4481,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageBlockMatchSSDQCOM",
                    .opcode = 4482,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageBlockMatchSADQCOM",
                    .opcode = 4483,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageBlockMatchWindowSSDQCOM",
                    .opcode = 4500,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageBlockMatchWindowSADQCOM",
                    .opcode = 4501,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageBlockMatchGatherSSDQCOM",
                    .opcode = 4502,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageBlockMatchGatherSADQCOM",
                    .opcode = 4503,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupIAddNonUniformAMD",
                    .opcode = 5000,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupFAddNonUniformAMD",
                    .opcode = 5001,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupFMinNonUniformAMD",
                    .opcode = 5002,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupUMinNonUniformAMD",
                    .opcode = 5003,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupSMinNonUniformAMD",
                    .opcode = 5004,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupFMaxNonUniformAMD",
                    .opcode = 5005,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupUMaxNonUniformAMD",
                    .opcode = 5006,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupSMaxNonUniformAMD",
                    .opcode = 5007,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFragmentMaskFetchAMD",
                    .opcode = 5011,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFragmentFetchAMD",
                    .opcode = 5012,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReadClockKHR",
                    .opcode = 5056,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAllocateNodePayloadsAMDX",
                    .opcode = 5074,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpEnqueueNodePayloadsAMDX",
                    .opcode = 5075,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeNodePayloadArrayAMDX",
                    .opcode = 5076,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFinishWritingNodePayloadAMDX",
                    .opcode = 5078,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpNodePayloadArrayLengthAMDX",
                    .opcode = 5090,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIsNodePayloadValidAMDX",
                    .opcode = 5101,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConstantStringAMDX",
                    .opcode = 5103,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .literal_string, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSpecConstantStringAMDX",
                    .opcode = 5104,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .literal_string, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformQuadAllKHR",
                    .opcode = 5110,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformQuadAnyKHR",
                    .opcode = 5111,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectRecordHitMotionNV",
                    .opcode = 5249,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectRecordHitWithIndexMotionNV",
                    .opcode = 5250,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectRecordMissMotionNV",
                    .opcode = 5251,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetWorldToObjectNV",
                    .opcode = 5252,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetObjectToWorldNV",
                    .opcode = 5253,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetObjectRayDirectionNV",
                    .opcode = 5254,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetObjectRayOriginNV",
                    .opcode = 5255,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectTraceRayMotionNV",
                    .opcode = 5256,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetShaderRecordBufferHandleNV",
                    .opcode = 5257,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetShaderBindingTableRecordIndexNV",
                    .opcode = 5258,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectRecordEmptyNV",
                    .opcode = 5259,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectTraceRayNV",
                    .opcode = 5260,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectRecordHitNV",
                    .opcode = 5261,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectRecordHitWithIndexNV",
                    .opcode = 5262,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectRecordMissNV",
                    .opcode = 5263,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectExecuteShaderNV",
                    .opcode = 5264,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetCurrentTimeNV",
                    .opcode = 5265,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetAttributesNV",
                    .opcode = 5266,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetHitKindNV",
                    .opcode = 5267,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetPrimitiveIndexNV",
                    .opcode = 5268,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetGeometryIndexNV",
                    .opcode = 5269,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetInstanceIdNV",
                    .opcode = 5270,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetInstanceCustomIndexNV",
                    .opcode = 5271,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetWorldRayDirectionNV",
                    .opcode = 5272,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetWorldRayOriginNV",
                    .opcode = 5273,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetRayTMaxNV",
                    .opcode = 5274,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetRayTMinNV",
                    .opcode = 5275,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectIsEmptyNV",
                    .opcode = 5276,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectIsHitNV",
                    .opcode = 5277,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectIsMissNV",
                    .opcode = 5278,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReorderThreadWithHitObjectNV",
                    .opcode = 5279,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpReorderThreadWithHintNV",
                    .opcode = 5280,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeHitObjectNV",
                    .opcode = 5281,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpImageSampleFootprintNV",
                    .opcode = 5283,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .image_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpTypeCooperativeVectorNV",
                    .opcode = 5288,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCooperativeVectorMatrixMulNV",
                    .opcode = 5289,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                        .{ .kind = .cooperative_matrix_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpCooperativeVectorOuterProductAccumulateNV",
                    .opcode = 5290,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpCooperativeVectorReduceSumAccumulateNV",
                    .opcode = 5291,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCooperativeVectorMatrixMulAddNV",
                    .opcode = 5292,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                        .{ .kind = .cooperative_matrix_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixConvertNV",
                    .opcode = 5293,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpEmitMeshTasksEXT",
                    .opcode = 5294,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSetMeshOutputsEXT",
                    .opcode = 5295,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupNonUniformPartitionNV",
                    .opcode = 5296,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpWritePackedPrimitiveIndices4x8NV",
                    .opcode = 5299,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFetchMicroTriangleVertexPositionNV",
                    .opcode = 5300,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFetchMicroTriangleVertexBarycentricNV",
                    .opcode = 5301,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCooperativeVectorLoadNV",
                    .opcode = 5302,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .memory_access, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpCooperativeVectorStoreNV",
                    .opcode = 5303,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .memory_access, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpReportIntersectionKHR",
                    .opcode = 5334,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIgnoreIntersectionNV",
                    .opcode = 5335,
                    .operands = &.{},
                },
                .{
                    .name = "OpTerminateRayNV",
                    .opcode = 5336,
                    .operands = &.{},
                },
                .{
                    .name = "OpTraceNV",
                    .opcode = 5337,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTraceMotionNV",
                    .opcode = 5338,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTraceRayMotionNV",
                    .opcode = 5339,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionTriangleVertexPositionsKHR",
                    .opcode = 5340,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAccelerationStructureKHR",
                    .opcode = 5341,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpExecuteCallableNV",
                    .opcode = 5344,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetClusterIdNV",
                    .opcode = 5345,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetClusterIdNV",
                    .opcode = 5346,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeCooperativeMatrixNV",
                    .opcode = 5358,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixLoadNV",
                    .opcode = 5359,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .memory_access, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixStoreNV",
                    .opcode = 5360,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .memory_access, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixMulAddNV",
                    .opcode = 5361,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixLengthNV",
                    .opcode = 5362,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpBeginInvocationInterlockEXT",
                    .opcode = 5364,
                    .operands = &.{},
                },
                .{
                    .name = "OpEndInvocationInterlockEXT",
                    .opcode = 5365,
                    .operands = &.{},
                },
                .{
                    .name = "OpCooperativeMatrixReduceNV",
                    .opcode = 5366,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .cooperative_matrix_reduce, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixLoadTensorNV",
                    .opcode = 5367,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .memory_access, .quantifier = .required },
                        .{ .kind = .tensor_addressing_operands, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixStoreTensorNV",
                    .opcode = 5368,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .memory_access, .quantifier = .required },
                        .{ .kind = .tensor_addressing_operands, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixPerElementOpNV",
                    .opcode = 5369,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpTypeTensorLayoutNV",
                    .opcode = 5370,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeTensorViewNV",
                    .opcode = 5371,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpCreateTensorLayoutNV",
                    .opcode = 5372,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTensorLayoutSetDimensionNV",
                    .opcode = 5373,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpTensorLayoutSetStrideNV",
                    .opcode = 5374,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpTensorLayoutSliceNV",
                    .opcode = 5375,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpTensorLayoutSetClampValueNV",
                    .opcode = 5376,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCreateTensorViewNV",
                    .opcode = 5377,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTensorViewSetDimensionNV",
                    .opcode = 5378,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpTensorViewSetStrideNV",
                    .opcode = 5379,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpDemoteToHelperInvocation",
                    .opcode = 5380,
                    .operands = &.{},
                },
                .{
                    .name = "OpIsHelperInvocationEXT",
                    .opcode = 5381,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTensorViewSetClipNV",
                    .opcode = 5382,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTensorLayoutSetBlockSizeNV",
                    .opcode = 5384,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpCooperativeMatrixTransposeNV",
                    .opcode = 5390,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertUToImageNV",
                    .opcode = 5391,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertUToSamplerNV",
                    .opcode = 5392,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertImageToUNV",
                    .opcode = 5393,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertSamplerToUNV",
                    .opcode = 5394,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertUToSampledImageNV",
                    .opcode = 5395,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertSampledImageToUNV",
                    .opcode = 5396,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSamplerImageAddressingModeNV",
                    .opcode = 5397,
                    .operands = &.{
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRawAccessChainNV",
                    .opcode = 5398,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .raw_access_chain_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionSpherePositionNV",
                    .opcode = 5427,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionSphereRadiusNV",
                    .opcode = 5428,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionLSSPositionsNV",
                    .opcode = 5429,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionLSSRadiiNV",
                    .opcode = 5430,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionLSSHitValueNV",
                    .opcode = 5431,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetSpherePositionNV",
                    .opcode = 5432,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetSphereRadiusNV",
                    .opcode = 5433,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetLSSPositionsNV",
                    .opcode = 5434,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectGetLSSRadiiNV",
                    .opcode = 5435,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectIsSphereHitNV",
                    .opcode = 5436,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpHitObjectIsLSSHitNV",
                    .opcode = 5437,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryIsSphereHitNV",
                    .opcode = 5438,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryIsLSSHitNV",
                    .opcode = 5439,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupShuffleINTEL",
                    .opcode = 5571,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupShuffleDownINTEL",
                    .opcode = 5572,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupShuffleUpINTEL",
                    .opcode = 5573,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupShuffleXorINTEL",
                    .opcode = 5574,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupBlockReadINTEL",
                    .opcode = 5575,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupBlockWriteINTEL",
                    .opcode = 5576,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupImageBlockReadINTEL",
                    .opcode = 5577,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupImageBlockWriteINTEL",
                    .opcode = 5578,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupImageMediaBlockReadINTEL",
                    .opcode = 5580,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupImageMediaBlockWriteINTEL",
                    .opcode = 5581,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUCountLeadingZerosINTEL",
                    .opcode = 5585,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUCountTrailingZerosINTEL",
                    .opcode = 5586,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAbsISubINTEL",
                    .opcode = 5587,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAbsUSubINTEL",
                    .opcode = 5588,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIAddSatINTEL",
                    .opcode = 5589,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUAddSatINTEL",
                    .opcode = 5590,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIAverageINTEL",
                    .opcode = 5591,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUAverageINTEL",
                    .opcode = 5592,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIAverageRoundedINTEL",
                    .opcode = 5593,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUAverageRoundedINTEL",
                    .opcode = 5594,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpISubSatINTEL",
                    .opcode = 5595,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUSubSatINTEL",
                    .opcode = 5596,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpIMul32x16INTEL",
                    .opcode = 5597,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpUMul32x16INTEL",
                    .opcode = 5598,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConstantFunctionPointerINTEL",
                    .opcode = 5600,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFunctionPointerCallINTEL",
                    .opcode = 5601,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpAsmTargetINTEL",
                    .opcode = 5609,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .literal_string, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAsmINTEL",
                    .opcode = 5610,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_string, .quantifier = .required },
                        .{ .kind = .literal_string, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAsmCallINTEL",
                    .opcode = 5611,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpAtomicFMinEXT",
                    .opcode = 5614,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicFMaxEXT",
                    .opcode = 5615,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAssumeTrueKHR",
                    .opcode = 5630,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpExpectKHR",
                    .opcode = 5631,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpDecorateString",
                    .opcode = 5632,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .decoration, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMemberDecorateString",
                    .opcode = 5633,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .decoration, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpVmeImageINTEL",
                    .opcode = 5699,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeVmeImageINTEL",
                    .opcode = 5700,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcImePayloadINTEL",
                    .opcode = 5701,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcRefPayloadINTEL",
                    .opcode = 5702,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcSicPayloadINTEL",
                    .opcode = 5703,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcMcePayloadINTEL",
                    .opcode = 5704,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcMceResultINTEL",
                    .opcode = 5705,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcImeResultINTEL",
                    .opcode = 5706,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcImeResultSingleReferenceStreamoutINTEL",
                    .opcode = 5707,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcImeResultDualReferenceStreamoutINTEL",
                    .opcode = 5708,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcImeSingleReferenceStreaminINTEL",
                    .opcode = 5709,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcImeDualReferenceStreaminINTEL",
                    .opcode = 5710,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcRefResultINTEL",
                    .opcode = 5711,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeAvcSicResultINTEL",
                    .opcode = 5712,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultInterBaseMultiReferencePenaltyINTEL",
                    .opcode = 5713,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceSetInterBaseMultiReferencePenaltyINTEL",
                    .opcode = 5714,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultInterShapePenaltyINTEL",
                    .opcode = 5715,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceSetInterShapePenaltyINTEL",
                    .opcode = 5716,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultInterDirectionPenaltyINTEL",
                    .opcode = 5717,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceSetInterDirectionPenaltyINTEL",
                    .opcode = 5718,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultIntraLumaShapePenaltyINTEL",
                    .opcode = 5719,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultInterMotionVectorCostTableINTEL",
                    .opcode = 5720,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultHighPenaltyCostTableINTEL",
                    .opcode = 5721,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultMediumPenaltyCostTableINTEL",
                    .opcode = 5722,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultLowPenaltyCostTableINTEL",
                    .opcode = 5723,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceSetMotionVectorCostFunctionINTEL",
                    .opcode = 5724,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultIntraLumaModePenaltyINTEL",
                    .opcode = 5725,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultNonDcLumaIntraPenaltyINTEL",
                    .opcode = 5726,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetDefaultIntraChromaModeBasePenaltyINTEL",
                    .opcode = 5727,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceSetAcOnlyHaarINTEL",
                    .opcode = 5728,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceSetSourceInterlacedFieldPolarityINTEL",
                    .opcode = 5729,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceSetSingleReferenceInterlacedFieldPolarityINTEL",
                    .opcode = 5730,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceSetDualReferenceInterlacedFieldPolaritiesINTEL",
                    .opcode = 5731,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceConvertToImePayloadINTEL",
                    .opcode = 5732,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceConvertToImeResultINTEL",
                    .opcode = 5733,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceConvertToRefPayloadINTEL",
                    .opcode = 5734,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceConvertToRefResultINTEL",
                    .opcode = 5735,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceConvertToSicPayloadINTEL",
                    .opcode = 5736,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceConvertToSicResultINTEL",
                    .opcode = 5737,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetMotionVectorsINTEL",
                    .opcode = 5738,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetInterDistortionsINTEL",
                    .opcode = 5739,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetBestInterDistortionsINTEL",
                    .opcode = 5740,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetInterMajorShapeINTEL",
                    .opcode = 5741,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetInterMinorShapeINTEL",
                    .opcode = 5742,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetInterDirectionsINTEL",
                    .opcode = 5743,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetInterMotionVectorCountINTEL",
                    .opcode = 5744,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetInterReferenceIdsINTEL",
                    .opcode = 5745,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcMceGetInterReferenceInterlacedFieldPolaritiesINTEL",
                    .opcode = 5746,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeInitializeINTEL",
                    .opcode = 5747,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeSetSingleReferenceINTEL",
                    .opcode = 5748,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeSetDualReferenceINTEL",
                    .opcode = 5749,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeRefWindowSizeINTEL",
                    .opcode = 5750,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeAdjustRefOffsetINTEL",
                    .opcode = 5751,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeConvertToMcePayloadINTEL",
                    .opcode = 5752,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeSetMaxMotionVectorCountINTEL",
                    .opcode = 5753,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeSetUnidirectionalMixDisableINTEL",
                    .opcode = 5754,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeSetEarlySearchTerminationThresholdINTEL",
                    .opcode = 5755,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeSetWeightedSadINTEL",
                    .opcode = 5756,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeEvaluateWithSingleReferenceINTEL",
                    .opcode = 5757,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeEvaluateWithDualReferenceINTEL",
                    .opcode = 5758,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminINTEL",
                    .opcode = 5759,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeEvaluateWithDualReferenceStreaminINTEL",
                    .opcode = 5760,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeEvaluateWithSingleReferenceStreamoutINTEL",
                    .opcode = 5761,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeEvaluateWithDualReferenceStreamoutINTEL",
                    .opcode = 5762,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeEvaluateWithSingleReferenceStreaminoutINTEL",
                    .opcode = 5763,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeEvaluateWithDualReferenceStreaminoutINTEL",
                    .opcode = 5764,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeConvertToMceResultINTEL",
                    .opcode = 5765,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetSingleReferenceStreaminINTEL",
                    .opcode = 5766,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetDualReferenceStreaminINTEL",
                    .opcode = 5767,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeStripSingleReferenceStreamoutINTEL",
                    .opcode = 5768,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeStripDualReferenceStreamoutINTEL",
                    .opcode = 5769,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeMotionVectorsINTEL",
                    .opcode = 5770,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeDistortionsINTEL",
                    .opcode = 5771,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetStreamoutSingleReferenceMajorShapeReferenceIdsINTEL",
                    .opcode = 5772,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeMotionVectorsINTEL",
                    .opcode = 5773,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeDistortionsINTEL",
                    .opcode = 5774,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetStreamoutDualReferenceMajorShapeReferenceIdsINTEL",
                    .opcode = 5775,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetBorderReachedINTEL",
                    .opcode = 5776,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetTruncatedSearchIndicationINTEL",
                    .opcode = 5777,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetUnidirectionalEarlySearchTerminationINTEL",
                    .opcode = 5778,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetWeightingPatternMinimumMotionVectorINTEL",
                    .opcode = 5779,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcImeGetWeightingPatternMinimumDistortionINTEL",
                    .opcode = 5780,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcFmeInitializeINTEL",
                    .opcode = 5781,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcBmeInitializeINTEL",
                    .opcode = 5782,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcRefConvertToMcePayloadINTEL",
                    .opcode = 5783,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcRefSetBidirectionalMixDisableINTEL",
                    .opcode = 5784,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcRefSetBilinearFilterEnableINTEL",
                    .opcode = 5785,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcRefEvaluateWithSingleReferenceINTEL",
                    .opcode = 5786,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcRefEvaluateWithDualReferenceINTEL",
                    .opcode = 5787,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcRefEvaluateWithMultiReferenceINTEL",
                    .opcode = 5788,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcRefEvaluateWithMultiReferenceInterlacedINTEL",
                    .opcode = 5789,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcRefConvertToMceResultINTEL",
                    .opcode = 5790,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicInitializeINTEL",
                    .opcode = 5791,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicConfigureSkcINTEL",
                    .opcode = 5792,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicConfigureIpeLumaINTEL",
                    .opcode = 5793,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicConfigureIpeLumaChromaINTEL",
                    .opcode = 5794,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicGetMotionVectorMaskINTEL",
                    .opcode = 5795,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicConvertToMcePayloadINTEL",
                    .opcode = 5796,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicSetIntraLumaShapePenaltyINTEL",
                    .opcode = 5797,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicSetIntraLumaModeCostFunctionINTEL",
                    .opcode = 5798,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicSetIntraChromaModeCostFunctionINTEL",
                    .opcode = 5799,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicSetBilinearFilterEnableINTEL",
                    .opcode = 5800,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicSetSkcForwardTransformEnableINTEL",
                    .opcode = 5801,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicSetBlockBasedRawSkipSadINTEL",
                    .opcode = 5802,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicEvaluateIpeINTEL",
                    .opcode = 5803,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicEvaluateWithSingleReferenceINTEL",
                    .opcode = 5804,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicEvaluateWithDualReferenceINTEL",
                    .opcode = 5805,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicEvaluateWithMultiReferenceINTEL",
                    .opcode = 5806,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicEvaluateWithMultiReferenceInterlacedINTEL",
                    .opcode = 5807,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicConvertToMceResultINTEL",
                    .opcode = 5808,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicGetIpeLumaShapeINTEL",
                    .opcode = 5809,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicGetBestIpeLumaDistortionINTEL",
                    .opcode = 5810,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicGetBestIpeChromaDistortionINTEL",
                    .opcode = 5811,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicGetPackedIpeLumaModesINTEL",
                    .opcode = 5812,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicGetIpeChromaModeINTEL",
                    .opcode = 5813,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicGetPackedSkcLumaCountThresholdINTEL",
                    .opcode = 5814,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicGetPackedSkcLumaSumThresholdINTEL",
                    .opcode = 5815,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupAvcSicGetInterRawSadsINTEL",
                    .opcode = 5816,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpVariableLengthArrayINTEL",
                    .opcode = 5818,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSaveMemoryINTEL",
                    .opcode = 5819,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRestoreMemoryINTEL",
                    .opcode = 5820,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatSinCosPiINTEL",
                    .opcode = 5840,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatCastINTEL",
                    .opcode = 5841,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatCastFromIntINTEL",
                    .opcode = 5842,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatCastToIntINTEL",
                    .opcode = 5843,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatAddINTEL",
                    .opcode = 5846,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatSubINTEL",
                    .opcode = 5847,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatMulINTEL",
                    .opcode = 5848,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatDivINTEL",
                    .opcode = 5849,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatGTINTEL",
                    .opcode = 5850,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatGEINTEL",
                    .opcode = 5851,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatLTINTEL",
                    .opcode = 5852,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatLEINTEL",
                    .opcode = 5853,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatEQINTEL",
                    .opcode = 5854,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatRecipINTEL",
                    .opcode = 5855,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatRSqrtINTEL",
                    .opcode = 5856,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatCbrtINTEL",
                    .opcode = 5857,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatHypotINTEL",
                    .opcode = 5858,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatSqrtINTEL",
                    .opcode = 5859,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatLogINTEL",
                    .opcode = 5860,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatLog2INTEL",
                    .opcode = 5861,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatLog10INTEL",
                    .opcode = 5862,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatLog1pINTEL",
                    .opcode = 5863,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatExpINTEL",
                    .opcode = 5864,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatExp2INTEL",
                    .opcode = 5865,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatExp10INTEL",
                    .opcode = 5866,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatExpm1INTEL",
                    .opcode = 5867,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatSinINTEL",
                    .opcode = 5868,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatCosINTEL",
                    .opcode = 5869,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatSinCosINTEL",
                    .opcode = 5870,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatSinPiINTEL",
                    .opcode = 5871,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatCosPiINTEL",
                    .opcode = 5872,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatASinINTEL",
                    .opcode = 5873,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatASinPiINTEL",
                    .opcode = 5874,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatACosINTEL",
                    .opcode = 5875,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatACosPiINTEL",
                    .opcode = 5876,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatATanINTEL",
                    .opcode = 5877,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatATanPiINTEL",
                    .opcode = 5878,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatATan2INTEL",
                    .opcode = 5879,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatPowINTEL",
                    .opcode = 5880,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatPowRINTEL",
                    .opcode = 5881,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArbitraryFloatPowNINTEL",
                    .opcode = 5882,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpLoopControlINTEL",
                    .opcode = 5887,
                    .operands = &.{
                        .{ .kind = .literal_integer, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpAliasDomainDeclINTEL",
                    .opcode = 5911,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpAliasScopeDeclINTEL",
                    .opcode = 5912,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpAliasScopeListDeclINTEL",
                    .opcode = 5913,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpFixedSqrtINTEL",
                    .opcode = 5923,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedRecipINTEL",
                    .opcode = 5924,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedRsqrtINTEL",
                    .opcode = 5925,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedSinINTEL",
                    .opcode = 5926,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedCosINTEL",
                    .opcode = 5927,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedSinCosINTEL",
                    .opcode = 5928,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedSinPiINTEL",
                    .opcode = 5929,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedCosPiINTEL",
                    .opcode = 5930,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedSinCosPiINTEL",
                    .opcode = 5931,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedLogINTEL",
                    .opcode = 5932,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFixedExpINTEL",
                    .opcode = 5933,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpPtrCastToCrossWorkgroupINTEL",
                    .opcode = 5934,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpCrossWorkgroupCastToPtrINTEL",
                    .opcode = 5938,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpReadPipeBlockingINTEL",
                    .opcode = 5946,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpWritePipeBlockingINTEL",
                    .opcode = 5947,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpFPGARegINTEL",
                    .opcode = 5949,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetRayTMinKHR",
                    .opcode = 6016,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetRayFlagsKHR",
                    .opcode = 6017,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionTKHR",
                    .opcode = 6018,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionInstanceCustomIndexKHR",
                    .opcode = 6019,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionInstanceIdKHR",
                    .opcode = 6020,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionInstanceShaderBindingTableRecordOffsetKHR",
                    .opcode = 6021,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionGeometryIndexKHR",
                    .opcode = 6022,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionPrimitiveIndexKHR",
                    .opcode = 6023,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionBarycentricsKHR",
                    .opcode = 6024,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionFrontFaceKHR",
                    .opcode = 6025,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionCandidateAABBOpaqueKHR",
                    .opcode = 6026,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionObjectRayDirectionKHR",
                    .opcode = 6027,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionObjectRayOriginKHR",
                    .opcode = 6028,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetWorldRayDirectionKHR",
                    .opcode = 6029,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetWorldRayOriginKHR",
                    .opcode = 6030,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionObjectToWorldKHR",
                    .opcode = 6031,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRayQueryGetIntersectionWorldToObjectKHR",
                    .opcode = 6032,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpAtomicFAddEXT",
                    .opcode = 6035,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeBufferSurfaceINTEL",
                    .opcode = 6086,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .access_qualifier, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeStructContinuedINTEL",
                    .opcode = 6090,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpConstantCompositeContinuedINTEL",
                    .opcode = 6091,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpSpecConstantCompositeContinuedINTEL",
                    .opcode = 6092,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpCompositeConstructContinuedINTEL",
                    .opcode = 6096,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpConvertFToBF16INTEL",
                    .opcode = 6116,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertBF16ToFINTEL",
                    .opcode = 6117,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpControlBarrierArriveINTEL",
                    .opcode = 6142,
                    .operands = &.{
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpControlBarrierWaitINTEL",
                    .opcode = 6143,
                    .operands = &.{
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .id_memory_semantics, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpArithmeticFenceEXT",
                    .opcode = 6145,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTaskSequenceCreateINTEL",
                    .opcode = 6163,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTaskSequenceAsyncINTEL",
                    .opcode = 6164,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "OpTaskSequenceGetINTEL",
                    .opcode = 6165,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTaskSequenceReleaseINTEL",
                    .opcode = 6166,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpTypeTaskSequenceINTEL",
                    .opcode = 6199,
                    .operands = &.{
                        .{ .kind = .id_result, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupBlockPrefetchINTEL",
                    .opcode = 6221,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .memory_access, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpSubgroup2DBlockLoadINTEL",
                    .opcode = 6231,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroup2DBlockLoadTransformINTEL",
                    .opcode = 6232,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroup2DBlockLoadTransposeINTEL",
                    .opcode = 6233,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroup2DBlockPrefetchINTEL",
                    .opcode = 6234,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroup2DBlockStoreINTEL",
                    .opcode = 6235,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpSubgroupMatrixMultiplyAccumulateINTEL",
                    .opcode = 6237,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .matrix_multiply_accumulate_operands, .quantifier = .optional },
                    },
                },
                .{
                    .name = "OpBitwiseFunctionINTEL",
                    .opcode = 6242,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupIMulKHR",
                    .opcode = 6401,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupFMulKHR",
                    .opcode = 6402,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupBitwiseAndKHR",
                    .opcode = 6403,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupBitwiseOrKHR",
                    .opcode = 6404,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupBitwiseXorKHR",
                    .opcode = 6405,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupLogicalAndKHR",
                    .opcode = 6406,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupLogicalOrKHR",
                    .opcode = 6407,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpGroupLogicalXorKHR",
                    .opcode = 6408,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_scope, .quantifier = .required },
                        .{ .kind = .group_operation, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpRoundFToTF32INTEL",
                    .opcode = 6426,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMaskedGatherINTEL",
                    .opcode = 6428,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpMaskedScatterINTEL",
                    .opcode = 6429,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertHandleToImageINTEL",
                    .opcode = 6529,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertHandleToSamplerINTEL",
                    .opcode = 6530,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "OpConvertHandleToSampledImageINTEL",
                    .opcode = 6531,
                    .operands = &.{
                        .{ .kind = .id_result_type, .quantifier = .required },
                        .{ .kind = .id_result, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
            },
            .@"GLSL.std.450" => &.{
                .{
                    .name = "Round",
                    .opcode = 1,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "RoundEven",
                    .opcode = 2,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Trunc",
                    .opcode = 3,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "FAbs",
                    .opcode = 4,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "SAbs",
                    .opcode = 5,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "FSign",
                    .opcode = 6,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "SSign",
                    .opcode = 7,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Floor",
                    .opcode = 8,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Ceil",
                    .opcode = 9,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Fract",
                    .opcode = 10,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Radians",
                    .opcode = 11,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Degrees",
                    .opcode = 12,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Sin",
                    .opcode = 13,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Cos",
                    .opcode = 14,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Tan",
                    .opcode = 15,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Asin",
                    .opcode = 16,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Acos",
                    .opcode = 17,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Atan",
                    .opcode = 18,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Sinh",
                    .opcode = 19,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Cosh",
                    .opcode = 20,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Tanh",
                    .opcode = 21,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Asinh",
                    .opcode = 22,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Acosh",
                    .opcode = 23,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Atanh",
                    .opcode = 24,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Atan2",
                    .opcode = 25,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Pow",
                    .opcode = 26,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Exp",
                    .opcode = 27,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Log",
                    .opcode = 28,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Exp2",
                    .opcode = 29,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Log2",
                    .opcode = 30,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Sqrt",
                    .opcode = 31,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "InverseSqrt",
                    .opcode = 32,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Determinant",
                    .opcode = 33,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "MatrixInverse",
                    .opcode = 34,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Modf",
                    .opcode = 35,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "ModfStruct",
                    .opcode = 36,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "FMin",
                    .opcode = 37,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "UMin",
                    .opcode = 38,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "SMin",
                    .opcode = 39,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "FMax",
                    .opcode = 40,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "UMax",
                    .opcode = 41,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "SMax",
                    .opcode = 42,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "FClamp",
                    .opcode = 43,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "UClamp",
                    .opcode = 44,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "SClamp",
                    .opcode = 45,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "FMix",
                    .opcode = 46,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "IMix",
                    .opcode = 47,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Step",
                    .opcode = 48,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "SmoothStep",
                    .opcode = 49,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Fma",
                    .opcode = 50,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Frexp",
                    .opcode = 51,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "FrexpStruct",
                    .opcode = 52,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Ldexp",
                    .opcode = 53,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "PackSnorm4x8",
                    .opcode = 54,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "PackUnorm4x8",
                    .opcode = 55,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "PackSnorm2x16",
                    .opcode = 56,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "PackUnorm2x16",
                    .opcode = 57,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "PackHalf2x16",
                    .opcode = 58,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "PackDouble2x32",
                    .opcode = 59,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "UnpackSnorm2x16",
                    .opcode = 60,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "UnpackUnorm2x16",
                    .opcode = 61,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "UnpackHalf2x16",
                    .opcode = 62,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "UnpackSnorm4x8",
                    .opcode = 63,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "UnpackUnorm4x8",
                    .opcode = 64,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "UnpackDouble2x32",
                    .opcode = 65,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Length",
                    .opcode = 66,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Distance",
                    .opcode = 67,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Cross",
                    .opcode = 68,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Normalize",
                    .opcode = 69,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "FaceForward",
                    .opcode = 70,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Reflect",
                    .opcode = 71,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "Refract",
                    .opcode = 72,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "FindILsb",
                    .opcode = 73,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "FindSMsb",
                    .opcode = 74,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "FindUMsb",
                    .opcode = 75,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "InterpolateAtCentroid",
                    .opcode = 76,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "InterpolateAtSample",
                    .opcode = 77,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "InterpolateAtOffset",
                    .opcode = 78,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "NMin",
                    .opcode = 79,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "NMax",
                    .opcode = 80,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "NClamp",
                    .opcode = 81,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
            },
            .@"OpenCL.std" => &.{
                .{
                    .name = "acos",
                    .opcode = 0,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "acosh",
                    .opcode = 1,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "acospi",
                    .opcode = 2,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "asin",
                    .opcode = 3,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "asinh",
                    .opcode = 4,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "asinpi",
                    .opcode = 5,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "atan",
                    .opcode = 6,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "atan2",
                    .opcode = 7,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "atanh",
                    .opcode = 8,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "atanpi",
                    .opcode = 9,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "atan2pi",
                    .opcode = 10,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "cbrt",
                    .opcode = 11,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "ceil",
                    .opcode = 12,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "copysign",
                    .opcode = 13,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "cos",
                    .opcode = 14,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "cosh",
                    .opcode = 15,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "cospi",
                    .opcode = 16,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "erfc",
                    .opcode = 17,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "erf",
                    .opcode = 18,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "exp",
                    .opcode = 19,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "exp2",
                    .opcode = 20,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "exp10",
                    .opcode = 21,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "expm1",
                    .opcode = 22,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "fabs",
                    .opcode = 23,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "fdim",
                    .opcode = 24,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "floor",
                    .opcode = 25,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "fma",
                    .opcode = 26,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "fmax",
                    .opcode = 27,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "fmin",
                    .opcode = 28,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "fmod",
                    .opcode = 29,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "fract",
                    .opcode = 30,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "frexp",
                    .opcode = 31,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "hypot",
                    .opcode = 32,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "ilogb",
                    .opcode = 33,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "ldexp",
                    .opcode = 34,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "lgamma",
                    .opcode = 35,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "lgamma_r",
                    .opcode = 36,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "log",
                    .opcode = 37,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "log2",
                    .opcode = 38,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "log10",
                    .opcode = 39,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "log1p",
                    .opcode = 40,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "logb",
                    .opcode = 41,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "mad",
                    .opcode = 42,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "maxmag",
                    .opcode = 43,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "minmag",
                    .opcode = 44,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "modf",
                    .opcode = 45,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "nan",
                    .opcode = 46,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "nextafter",
                    .opcode = 47,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "pow",
                    .opcode = 48,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "pown",
                    .opcode = 49,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "powr",
                    .opcode = 50,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "remainder",
                    .opcode = 51,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "remquo",
                    .opcode = 52,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "rint",
                    .opcode = 53,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "rootn",
                    .opcode = 54,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "round",
                    .opcode = 55,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "rsqrt",
                    .opcode = 56,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "sin",
                    .opcode = 57,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "sincos",
                    .opcode = 58,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "sinh",
                    .opcode = 59,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "sinpi",
                    .opcode = 60,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "sqrt",
                    .opcode = 61,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "tan",
                    .opcode = 62,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "tanh",
                    .opcode = 63,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "tanpi",
                    .opcode = 64,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "tgamma",
                    .opcode = 65,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "trunc",
                    .opcode = 66,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_cos",
                    .opcode = 67,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_divide",
                    .opcode = 68,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_exp",
                    .opcode = 69,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_exp2",
                    .opcode = 70,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_exp10",
                    .opcode = 71,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_log",
                    .opcode = 72,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_log2",
                    .opcode = 73,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_log10",
                    .opcode = 74,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_powr",
                    .opcode = 75,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_recip",
                    .opcode = 76,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_rsqrt",
                    .opcode = 77,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_sin",
                    .opcode = 78,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_sqrt",
                    .opcode = 79,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "half_tan",
                    .opcode = 80,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_cos",
                    .opcode = 81,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_divide",
                    .opcode = 82,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_exp",
                    .opcode = 83,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_exp2",
                    .opcode = 84,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_exp10",
                    .opcode = 85,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_log",
                    .opcode = 86,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_log2",
                    .opcode = 87,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_log10",
                    .opcode = 88,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_powr",
                    .opcode = 89,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_recip",
                    .opcode = 90,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_rsqrt",
                    .opcode = 91,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_sin",
                    .opcode = 92,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_sqrt",
                    .opcode = 93,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "native_tan",
                    .opcode = 94,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "fclamp",
                    .opcode = 95,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "degrees",
                    .opcode = 96,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "fmax_common",
                    .opcode = 97,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "fmin_common",
                    .opcode = 98,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "mix",
                    .opcode = 99,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "radians",
                    .opcode = 100,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "step",
                    .opcode = 101,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "smoothstep",
                    .opcode = 102,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "sign",
                    .opcode = 103,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "cross",
                    .opcode = 104,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "distance",
                    .opcode = 105,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "length",
                    .opcode = 106,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "normalize",
                    .opcode = 107,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "fast_distance",
                    .opcode = 108,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "fast_length",
                    .opcode = 109,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "fast_normalize",
                    .opcode = 110,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_abs",
                    .opcode = 141,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_abs_diff",
                    .opcode = 142,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_add_sat",
                    .opcode = 143,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_add_sat",
                    .opcode = 144,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_hadd",
                    .opcode = 145,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_hadd",
                    .opcode = 146,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_rhadd",
                    .opcode = 147,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_rhadd",
                    .opcode = 148,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_clamp",
                    .opcode = 149,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_clamp",
                    .opcode = 150,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "clz",
                    .opcode = 151,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "ctz",
                    .opcode = 152,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_mad_hi",
                    .opcode = 153,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_mad_sat",
                    .opcode = 154,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_mad_sat",
                    .opcode = 155,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_max",
                    .opcode = 156,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_max",
                    .opcode = 157,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_min",
                    .opcode = 158,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_min",
                    .opcode = 159,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_mul_hi",
                    .opcode = 160,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "rotate",
                    .opcode = 161,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_sub_sat",
                    .opcode = 162,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_sub_sat",
                    .opcode = 163,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_upsample",
                    .opcode = 164,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_upsample",
                    .opcode = 165,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "popcount",
                    .opcode = 166,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_mad24",
                    .opcode = 167,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_mad24",
                    .opcode = 168,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "s_mul24",
                    .opcode = 169,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_mul24",
                    .opcode = 170,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "vloadn",
                    .opcode = 171,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "vstoren",
                    .opcode = 172,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "vload_half",
                    .opcode = 173,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "vload_halfn",
                    .opcode = 174,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "vstore_half",
                    .opcode = 175,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "vstore_half_r",
                    .opcode = 176,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .fp_rounding_mode, .quantifier = .required },
                    },
                },
                .{
                    .name = "vstore_halfn",
                    .opcode = 177,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "vstore_halfn_r",
                    .opcode = 178,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .fp_rounding_mode, .quantifier = .required },
                    },
                },
                .{
                    .name = "vloada_halfn",
                    .opcode = 179,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .literal_integer, .quantifier = .required },
                    },
                },
                .{
                    .name = "vstorea_halfn",
                    .opcode = 180,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "vstorea_halfn_r",
                    .opcode = 181,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .fp_rounding_mode, .quantifier = .required },
                    },
                },
                .{
                    .name = "shuffle",
                    .opcode = 182,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "shuffle2",
                    .opcode = 183,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "printf",
                    .opcode = 184,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .variadic },
                    },
                },
                .{
                    .name = "prefetch",
                    .opcode = 185,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "bitselect",
                    .opcode = 186,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "select",
                    .opcode = 187,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_abs",
                    .opcode = 201,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_abs_diff",
                    .opcode = 202,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_mul_hi",
                    .opcode = 203,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
                .{
                    .name = "u_mad_hi",
                    .opcode = 204,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
            },
            .zig => &.{
                .{
                    .name = "InvocationGlobal",
                    .opcode = 0,
                    .operands = &.{
                        .{ .kind = .id_ref, .quantifier = .required },
                    },
                },
            },
        };
    }
};
