/*
 * Interface wrapper code.
 *
 * Generated by SIP 6.15.1
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_core.h"
        #include <wx/region.h>
        #include <wx/gdicmn.h>
        #include <wx/gdicmn.h>
        #include <wx/bitmap.h>
        #include <wx/colour.h>
        #include <wx/object.h>
        #include <wx/object.h>
        #include <wx/object.h>
        // Convert a Python sequence of wxPoint objects, or items that can be converted
        // to wxPoint into a C array of wxPoint instances.
        static
        wxPoint* wxPoint_array_helper(PyObject* source, size_t *count)
        {
            wxPoint* array;
            Py_ssize_t idx, len;
            wxPyThreadBlocker blocker;
        
            // ensure that it is a sequence
            if (! PySequence_Check(source))
                goto error0;
            // ensure it is not a string or unicode object (they are sequences too)
            else if (PyBytes_Check(source) || PyUnicode_Check(source))
                goto error0;
            // ensure each item can be converted to wxPoint
            else {
                len = PySequence_Length(source);
                for (idx=0; idx<len; idx++) {
                    PyObject* item = PySequence_ITEM(source, idx);
                    if (!sipCanConvertToType(item, sipType_wxPoint, SIP_NOT_NONE)) {
                        Py_DECREF(item);
                        goto error0;
                    }
                    Py_DECREF(item);
                }
            }
        
            // The length of the sequence is returned in count.
            *count = len;
            array = new wxPoint[*count];
            if (!array) {
                PyErr_SetString(PyExc_MemoryError, "Unable to allocate temporary array");
                return NULL;
            }
            for (idx=0; idx<len; idx++) {
                PyObject* obj = PySequence_ITEM(source, idx);
                int state = 0;
                int err = 0;
                wxPoint* item = reinterpret_cast<wxPoint*>(
                                sipConvertToType(obj, sipType_wxPoint, NULL, 0, &state, &err));
                array[idx] = *item;
                sipReleaseType((void*)item, sipType_wxPoint, state); // delete temporary instances
                Py_DECREF(obj);
            }
            return array;
        
        error0:
            PyErr_SetString(PyExc_TypeError, "Expected a sequence of length-2 sequences or wx.Point objects.");
            return NULL;
        }


PyDoc_STRVAR(doc_wxRegion_GetBox, "GetBox() -> Rect\n"
"\n"
"Returns the outer bounds of the region.");

extern "C" {static PyObject *meth_wxRegion_GetBox(PyObject *, PyObject *);}
static PyObject *meth_wxRegion_GetBox(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRegion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRegion, &sipCpp))
        {
            ::wxRect*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxRect(sipCpp->GetBox());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxRect, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Region, sipName_GetBox, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRegion_Offset, "Offset(x, y) -> bool\n"
"Offset(pt) -> bool\n"
"\n"
"Moves the region by the specified offsets in horizontal and vertical\n"
"directions.\n"
"");

extern "C" {static PyObject *meth_wxRegion_Offset(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRegion_Offset(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxRegion, &sipCpp, &x, &y))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Offset(x, y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Offset(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Region, sipName_Offset, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRegion_Clear, "Clear() -> None\n"
"\n"
"Clears the current region.");

extern "C" {static PyObject *meth_wxRegion_Clear(PyObject *, PyObject *);}
static PyObject *meth_wxRegion_Clear(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxRegion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRegion, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Clear();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_Region, sipName_Clear, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRegion_Contains, "Contains(x, y) -> RegionContain\n"
"Contains(pt) -> RegionContain\n"
"Contains(x, y, width, height) -> RegionContain\n"
"Contains(rect) -> RegionContain\n"
"\n"
"Returns a value indicating whether the given point is contained within\n"
"the region.\n"
"\n"
"\n"
"");

extern "C" {static PyObject *meth_wxRegion_Contains(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRegion_Contains(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        const ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Bii", &sipSelf, sipType_wxRegion, &sipCpp, &x, &y))
        {
            ::wxRegionContain sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Contains(x, y);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxRegionContain);
        }
    }

    {
        const ::wxPoint* pt;
        int ptState = 0;
        const ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_pt,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxPoint, &pt, &ptState))
        {
            ::wxRegionContain sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Contains(*pt);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pt), sipType_wxPoint, ptState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxRegionContain);
        }
    }

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord width;
        ::wxCoord height;
        const ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiii", &sipSelf, sipType_wxRegion, &sipCpp, &x, &y, &width, &height))
        {
            ::wxRegionContain sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Contains(x, y, width, height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxRegionContain);
        }
    }

    {
        const ::wxRect* rect;
        int rectState = 0;
        const ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            ::wxRegionContain sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Contains(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromEnum(static_cast<int>(sipRes), sipType_wxRegionContain);
        }
    }

    sipNoMethod(sipParseErr, sipName_Region, sipName_Contains, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRegion_ConvertToBitmap, "ConvertToBitmap() -> Bitmap\n"
"\n"
"Convert the region to a black and white bitmap with the white pixels\n"
"being inside the region.");

extern "C" {static PyObject *meth_wxRegion_ConvertToBitmap(PyObject *, PyObject *);}
static PyObject *meth_wxRegion_ConvertToBitmap(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRegion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRegion, &sipCpp))
        {
            ::wxBitmap*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new ::wxBitmap(sipCpp->ConvertToBitmap());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes, sipType_wxBitmap, SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_Region, sipName_ConvertToBitmap, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRegion_Intersect, "Intersect(x, y, width, height) -> bool\n"
"Intersect(rect) -> bool\n"
"Intersect(region) -> bool\n"
"\n"
"Finds the intersection of this region and another, rectangular region,\n"
"specified using position and size.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxRegion_Intersect(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRegion_Intersect(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord width;
        ::wxCoord height;
        ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiii", &sipSelf, sipType_wxRegion, &sipCpp, &x, &y, &width, &height))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Intersect(x, y, width, height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::wxRect* rect;
        int rectState = 0;
        ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Intersect(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::wxRegion* region;
        ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_region,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRegion, &region))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Intersect(*region);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Region, sipName_Intersect, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRegion_IsEmpty, "IsEmpty() -> bool\n"
"\n"
"Returns true if the region is empty, false otherwise.");

extern "C" {static PyObject *meth_wxRegion_IsEmpty(PyObject *, PyObject *);}
static PyObject *meth_wxRegion_IsEmpty(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRegion *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRegion, &sipCpp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEmpty();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Region, sipName_IsEmpty, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRegion_IsEqual, "IsEqual(region) -> bool\n"
"\n"
"Returns true if the region is equal to, i.e. covers the same area as,\n"
"another one.");

extern "C" {static PyObject *meth_wxRegion_IsEqual(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRegion_IsEqual(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRegion* region;
        const ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_region,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRegion, &region))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->IsEqual(*region);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Region, sipName_IsEqual, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRegion_Subtract, "Subtract(rect) -> bool\n"
"Subtract(region) -> bool\n"
"\n"
"Subtracts a rectangular region from this region.\n"
"");

extern "C" {static PyObject *meth_wxRegion_Subtract(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRegion_Subtract(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const ::wxRect* rect;
        int rectState = 0;
        ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Subtract(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::wxRegion* region;
        ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_region,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRegion, &region))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Subtract(*region);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Region, sipName_Subtract, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRegion_Union, "Union(x, y, width, height) -> bool\n"
"Union(rect) -> bool\n"
"Union(region) -> bool\n"
"Union(bmp) -> bool\n"
"Union(bmp, transColour, tolerance=0) -> bool\n"
"\n"
"Finds the union of this region and another, rectangular region,\n"
"specified using position and size.\n"
"\n"
"\n"
"\n"
"");

extern "C" {static PyObject *meth_wxRegion_Union(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRegion_Union(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord width;
        ::wxCoord height;
        ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiii", &sipSelf, sipType_wxRegion, &sipCpp, &x, &y, &width, &height))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Union(x, y, width, height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::wxRect* rect;
        int rectState = 0;
        ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Union(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::wxRegion* region;
        ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_region,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRegion, &region))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Union(*region);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::wxBitmap* bmp;
        ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmp,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxBitmap, &bmp))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Union(*bmp);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::wxBitmap* bmp;
        const ::wxColour* transColour;
        int transColourState = 0;
        int tolerance = 0;
        ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmp,
            sipName_transColour,
            sipName_tolerance,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9J1|i", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxBitmap, &bmp, sipType_wxColour, &transColour, &transColourState, &tolerance))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Union(*bmp, *transColour, tolerance);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(transColour), sipType_wxColour, transColourState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Region, sipName_Union, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRegion_Xor, "Xor(x, y, width, height) -> bool\n"
"Xor(rect) -> bool\n"
"Xor(region) -> bool\n"
"\n"
"Finds the Xor of this region and another, rectangular region,\n"
"specified using position and size.\n"
"\n"
"");

extern "C" {static PyObject *meth_wxRegion_Xor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRegion_Xor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord width;
        ::wxCoord height;
        ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "Biiii", &sipSelf, sipType_wxRegion, &sipCpp, &x, &y, &width, &height))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Xor(x, y, width, height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::wxRect* rect;
        int rectState = 0;
        ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRect, &rect, &rectState))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Xor(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    {
        const ::wxRegion* region;
        ::wxRegion *sipCpp;

        static const char *sipKwdList[] = {
            sipName_region,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxRegion, &sipCpp, sipType_wxRegion, &region))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Xor(*region);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_Region, sipName_Xor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Cast a pointer to a type somewhere in its inheritance hierarchy. */
extern "C" {static void *cast_wxRegion(void *, const sipTypeDef *);}
static void *cast_wxRegion(void *sipCppV, const sipTypeDef *targetType)
{
    ::wxRegion *sipCpp = reinterpret_cast< ::wxRegion *>(sipCppV);

    if (targetType == sipType_wxRegion)
        return sipCppV;

    sipCppV = ((const sipClassTypeDef *)sipType_wxGDIObject)->ctd_cast(static_cast< ::wxGDIObject *>(sipCpp), targetType);
    if (sipCppV)
        return sipCppV;

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRegion(void *, int);}
static void release_wxRegion(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxRegion *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxRegion(Py_ssize_t);}
static void *array_wxRegion(Py_ssize_t sipNrElem)
{
    return new ::wxRegion[sipNrElem];
}


extern "C" {static void array_delete_wxRegion(void *);}
static void array_delete_wxRegion(void *sipCpp)
{
    delete[] reinterpret_cast< ::wxRegion *>(sipCpp);
}


extern "C" {static void assign_wxRegion(void *, Py_ssize_t, void *);}
static void assign_wxRegion(void *sipDst, Py_ssize_t sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxRegion *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxRegion *>(sipSrc);
}


extern "C" {static void *copy_wxRegion(const void *, Py_ssize_t);}
static void *copy_wxRegion(const void *sipSrc, Py_ssize_t sipSrcIdx)
{
    return new ::wxRegion(reinterpret_cast<const ::wxRegion *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxRegion(sipSimpleWrapper *);}
static void dealloc_wxRegion(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRegion(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxRegion(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRegion(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    ::wxRegion *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxRegion();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        ::wxCoord x;
        ::wxCoord y;
        ::wxCoord width;
        ::wxCoord height;

        static const char *sipKwdList[] = {
            sipName_x,
            sipName_y,
            sipName_width,
            sipName_height,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "iiii", &x, &y, &width, &height))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxRegion(x, y, width, height);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxPoint* topLeft;
        int topLeftState = 0;
        const ::wxPoint* bottomRight;
        int bottomRightState = 0;

        static const char *sipKwdList[] = {
            sipName_topLeft,
            sipName_bottomRight,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1J1", sipType_wxPoint, &topLeft, &topLeftState, sipType_wxPoint, &bottomRight, &bottomRightState))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxRegion(*topLeft, *bottomRight);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(topLeft), sipType_wxPoint, topLeftState);
            sipReleaseType(const_cast< ::wxPoint *>(bottomRight), sipType_wxPoint, bottomRightState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxRect* rect;
        int rectState = 0;

        static const char *sipKwdList[] = {
            sipName_rect,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J1", sipType_wxRect, &rect, &rectState))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxRegion(*rect);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxRect *>(rect), sipType_wxRect, rectState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxRegion* region;

        static const char *sipKwdList[] = {
            sipName_region,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxRegion, &region))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxRegion(*region);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxBitmap* bmp;

        static const char *sipKwdList[] = {
            sipName_bmp,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxBitmap, &bmp))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxRegion(*bmp);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const ::wxBitmap* bmp;
        const ::wxColour* transColour;
        int transColourState = 0;
        int tolerance = 0;

        static const char *sipKwdList[] = {
            sipName_bmp,
            sipName_transColour,
            sipName_tolerance,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9J1|i", sipType_wxBitmap, &bmp, sipType_wxColour, &transColour, &transColourState, &tolerance))
        {
        if (!wxPyCheckForApp()) return NULL;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new ::wxRegion(*bmp, *transColour, tolerance);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(transColour), sipType_wxColour, transColourState);

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        PyObject * points;
        ::wxPolygonFillMode fillStyle = wxODDEVEN_RULE;

        static const char *sipKwdList[] = {
            sipName_points,
            sipName_fillStyle,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "P0|E", &points, sipType_wxPolygonFillMode, &fillStyle))
        {
            int sipIsErr = 0;
        size_t count;
        wxPoint* array = wxPoint_array_helper(points, &count);
        if ( array != NULL ) {
            sipCpp = new wxRegion(count, array, fillStyle);
            delete [] array;
        }
        if (PyErr_Occurred()) sipIsErr = 1;

            if (sipIsErr)
            {
                if (sipUnused)
                {
                    Py_XDECREF(*sipUnused);
                }

                sipAddException(sipErrorFail, sipParseErr);
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


/* Define this type's super-types. */
static sipEncodedTypeDef supers_wxRegion[] = {{226, 255, 1}};


static PyMethodDef methods_wxRegion[] = {
    {sipName_Clear, meth_wxRegion_Clear, METH_VARARGS, doc_wxRegion_Clear},
    {sipName_Contains, SIP_MLMETH_CAST(meth_wxRegion_Contains), METH_VARARGS|METH_KEYWORDS, doc_wxRegion_Contains},
    {sipName_ConvertToBitmap, meth_wxRegion_ConvertToBitmap, METH_VARARGS, doc_wxRegion_ConvertToBitmap},
    {sipName_GetBox, meth_wxRegion_GetBox, METH_VARARGS, doc_wxRegion_GetBox},
    {sipName_Intersect, SIP_MLMETH_CAST(meth_wxRegion_Intersect), METH_VARARGS|METH_KEYWORDS, doc_wxRegion_Intersect},
    {sipName_IsEmpty, meth_wxRegion_IsEmpty, METH_VARARGS, doc_wxRegion_IsEmpty},
    {sipName_IsEqual, SIP_MLMETH_CAST(meth_wxRegion_IsEqual), METH_VARARGS|METH_KEYWORDS, doc_wxRegion_IsEqual},
    {sipName_Offset, SIP_MLMETH_CAST(meth_wxRegion_Offset), METH_VARARGS|METH_KEYWORDS, doc_wxRegion_Offset},
    {sipName_Subtract, SIP_MLMETH_CAST(meth_wxRegion_Subtract), METH_VARARGS|METH_KEYWORDS, doc_wxRegion_Subtract},
    {sipName_Union, SIP_MLMETH_CAST(meth_wxRegion_Union), METH_VARARGS|METH_KEYWORDS, doc_wxRegion_Union},
    {sipName_Xor, SIP_MLMETH_CAST(meth_wxRegion_Xor), METH_VARARGS|METH_KEYWORDS, doc_wxRegion_Xor}
};

sipVariableDef variables_wxRegion[] = {
    {PropertyVariable, sipName_Box, &methods_wxRegion[3], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxRegion, "Region() -> None\n"
"Region(x, y, width, height) -> None\n"
"Region(topLeft, bottomRight) -> None\n"
"Region(rect) -> None\n"
"Region(region) -> None\n"
"Region(bmp) -> None\n"
"Region(bmp, transColour, tolerance=0) -> None\n"
"Region(points, fillStyle=ODDEVEN_RULE) -> None\n"
"\n"
"A wxRegion represents a simple or complex region on a device context\n"
"or window.");


sipClassTypeDef sipTypeDef__core_wxRegion = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_SCC|SIP_TYPE_CLASS,
        sipNameNr_wxRegion,
        SIP_NULLPTR,
        SIP_NULLPTR,
    },
    {
        sipNameNr_Region,
        {0, 0, 1},
        11, methods_wxRegion,
        0, SIP_NULLPTR,
        1, variables_wxRegion,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxRegion,
    -1,
    -1,
    supers_wxRegion,
    SIP_NULLPTR,
    init_type_wxRegion,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    dealloc_wxRegion,
    assign_wxRegion,
    array_wxRegion,
    copy_wxRegion,
    release_wxRegion,
    cast_wxRegion,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    array_delete_wxRegion,
    sizeof (::wxRegion),
};
