# zgrep

> 압축 파일 내에서 텍스트 패턴을 검색하는 도구 (`grep -Z`와 동등).
> 더 많은 정보: <https://manned.org/zgrep>.

- 압축 파일에서 패턴 검색 (대소문자 구분):

`zgrep {{패턴}} {{경로/대상/압축/파일}}`

- 압축 파일에서 패턴 검색 (대소문자 구분 안 함):

`zgrep -i {{패턴}} {{경로/대상/압축/파일}}`

- 일치하는 패턴이 포함된 행의 개수를 출력:

`zgrep -c {{패턴}} {{경로/대상/압축/파일}}`

- 패턴이 없는 행을 표시 (검색 기능 반전):

`zgrep -v {{패턴}} {{경로/대상/압축/파일}}`

- 여러 패턴으로 압축 파일 검색:

`zgrep -e "{{패턴_1}}" -e "{{패턴_2}}" {{경로/대상/압축/파일}}`

- 확장 정규 표현식 사용 (`?`, `+`, `{}`, `()` 및 `|` 지원):

`zgrep -E {{정규_표현식}} {{경로/대상/파일}}`

- 각 일치 항목 전후로 3줄의 [C]ontext, [B]efore, 또는 [A]fter 출력:

`zgrep -{{C|B|A}} {{3}} {{패턴}} {{경로/대상/압축/파일}}`
