# git checkout

> Перемикає на гілку чи шлях до робочої директорії.
> Більше інформації: <https://git-scm.com/docs/git-checkout>.

- Створює та перемикає на нову гілку:

`git checkout -b {{назва_гілки}}`

- Створює та перемикає на нову гілку спираючись на певне посилання (приклади посилань: гілка, віддалена/гілка, тег):

`git checkout -b {{назва_гілки}} {{посилання}}`

- Перемикає на локальну гілку, що вже існує:

`git checkout {{назва_гілки}}`

- Перемикає на попередню гілку:

`git checkout -`

- Перемикає на віддалену гілку, що вже існує:

`git checkout {{[-t|--track]}} {{назва_віддаленого_сховища}}/{{назва_гілки}}`

- Відкидає усі неіндексовані зміни у поточній директорії (дізнайтесь більше про команди, як скасування, ознайомившись із `git reset`):

`git checkout .`

- Скасовує неіндексовані зміну у файлі:

`git checkout {{ім'я_файлу}}`

- Замінює файл у поточній директорії на його версію, яку було закомічено до вказаної гілки:

`git checkout {{назва_гілки}} -- {{ім'я_файлу}}`
