# tar

> Утилита архивирования.
> Обычно используется в сочетании с методом сжатия, таким как `gzip` или `bzip2`.
> Больше информации: <https://www.gnu.org/software/tar/manual/tar.html>.

- Создать ([c]reate) архив и записать его в файл ([f]ile):

`tar cf {{путь/к/целевому.tar}} {{путь/к/файлу1 путь/к/файлу2 ...}}`

- Создать ([c]reate) сжатый в g[z]ip архив и записать его в файл ([f]ile):

`tar czf {{путь/к/целевому.tar.gz}} {{путь/к/файлу1 путь/к/файлу2 ...}}`

- Создать ([c]reate) сжатый в g[z]ip архив из каталога, используя относительные пути:

`tar czf {{путь/к/целевому.tar.gz}} {{[-C|--directory]}} {{путь/к/каталогу}} .`

- Извлечь (e[x]tract) (сжатый) файл ([f]ile) архива в текущий каталог с подробным ([v]erbosely) выводом:

`tar xvf {{путь/к/исходному.tar[.gz|.bz2|.xz]}}`

- Извлечь (e[x]tract) (сжатый) файл ([f]ile) архива в указанный каталог:

`tar xf {{путь/к/исходному.tar[.gz|.bz2|.xz]}} {{[-C|--directory]}} {{путь/к/каталогу}}`

- Создать ([c]reate) сжатый архив и записать его в файл ([f]ile), используя расширение файла для автоматического ([a]utomatically) определения программы сжатия:

`tar caf {{путь/к/целевому.tar.xz}} {{путь/к/файлу1 путь/к/файлу2 ...}}`

- Вывести список (lis[t]) содержимого tar-файла ([f]ile) с подробным ([v]erbosely) выводом:

`tar tvf {{путь/к/исходному.tar}}`

- Извлечь (e[x]tract) файлы, соответствующие шаблону, из файла ([f]ile) архива:

`tar xf {{путь/к/исходному.tar}} --wildcards "{{*.html}}"`
