<!-- This file is generated by scripts/link-docs.mjs. Do not edit manually. -->
# Tinymist Helix Support for Typst

Run and configure tinymist in helix for Typst.

## Features

See [Tinymist Features](https://github.com/Myriad-Dreamin/tinymist#features) for a list of features.

## Finding Executable

To enable LSP, you must install `tinymist`. You can find `tinymist` by:

- Night versions available at [GitHub Actions](https://github.com/Myriad-Dreamin/tinymist/actions).

- Stable versions available at [GitHub Releases](https://github.com/Myriad-Dreamin/tinymist/releases).
  \
  If you are using the latest version of [typst-ts-mode](https://codeberg.org/meow_king/typst-ts-mode), then you can use command `typst-ts-lsp-download-binary` to download the latest stable binary of `tinymist` at `typst-ts-lsp-download-path`.

- Build from source by cargo. You can also compile and install **latest** `tinymist` by [Cargo](https://www.rust-lang.org/tools/install).
  ```bash
  cargo install --git https://github.com/Myriad-Dreamin/tinymist --locked tinymist-cli
  ```

## Setup Server

Update `.config/helix/languages.toml` to use tinymist.

```toml
[language-server.tinymist]
command = "tinymist"

[[language]]
name = "typst"
language-servers = ["tinymist"]
```

## Tips

### Getting Preview Feature

[Default Preview Feature](https://myriad-dreamin.github.io/tinymist/feature/preview.html) and [Background Preview Feature](https://myriad-dreamin.github.io/tinymist/feature/preview.html) are suitable in helix.

### Working under Power-Saving Mode or with Resource-consumed Projects

When working under power-saving mode or with resource-consumed projects, typst compilations costs too much CPU and memory resources. You can configure the extension to run in syntax only mode, i.e. only performing elementary tasks, like syntax checking, syntax-only code analysis and formatting by setting the `tinymist.syntaxOnly` to `enable` or `onPowerSaving` in the configuration.

For more information about power-saving mode, see [Syntax-Only Mode](https://myriad-dreamin.github.io/tinymist/feature/syntax-only-mode.html).

### Working with Multiple-File Projects

There is a way in [Neovim](/editors/neovim/README.md#working-with-multiple-files-projects), but you cannot invoke related commands with arguments by [:lsp-workspace-command](https://docs.helix-editor.com/commands.html) in helix. As a candidate solution, assuming your having following directory layout:

```plain
├── .helix
│   └── languages.toml
└── main.typ
```

You could create .helix/languages.toml in the project folder with the following contents:

```toml
[language-server.tinymist.config]
typstExtraArgs = ["main.typ"]
```

Then all diagnostics and autocompletion will be computed according to the `main.typ`.

Note: With that configuration, if you’re seeing a file that is not reachable by `main.typ`, you will not get diagnostics and autocompletion correctly in that file.

## Extra Settings

To configure the language server, edit the `language-server.tinymist` section. For example, if you want to export PDF on typing and output files in `$root_dir/target` directory:

```toml
[language-server.tinymist]
command = "tinymist"
config = { exportPdf = "onType", outputPath = "$root/target/$dir/$name" }
```

To enable a live preview you can use the `preview.background`:

```toml
[language-server.tinymist]
command = "tinymist"
config = { preview.background.enabled = true, preview.background.args = ["--data-plane-host=127.0.0.1:23635", "--invert-colors=never", "--open"] }
```

See [Tinymist Server Configuration](/editors/neovim/Configuration.md) for references.
