from multiprocessing import context, reduction as reducer
from multiprocessing.context import (
    AuthenticationError as AuthenticationError,
    BufferTooShort as BufferTooShort,
    Process as Process,
    ProcessError as ProcessError,
    TimeoutError as TimeoutError,
)
from multiprocessing.process import (
    active_children as active_children,
    current_process as current_process,
    parent_process as parent_process,
)

# These are technically functions that return instances of these Queue classes.
# The stub here doesn't reflect reality exactly --
# while e.g. `multiprocessing.queues.Queue` is a class,
# `multiprocessing.Queue` is actually a function at runtime.
# Avoid using `multiprocessing.Queue` as a type annotation;
# use imports from multiprocessing.queues instead.
# See #4266 and #8450 for discussion.
from multiprocessing.queues import JoinableQueue as JoinableQueue, Queue as Queue, SimpleQueue as SimpleQueue
from multiprocessing.spawn import freeze_support as freeze_support

__all__ = [
    "Array",
    "AuthenticationError",
    "Barrier",
    "BoundedSemaphore",
    "BufferTooShort",
    "Condition",
    "Event",
    "JoinableQueue",
    "Lock",
    "Manager",
    "Pipe",
    "Pool",
    "Process",
    "ProcessError",
    "Queue",
    "RLock",
    "RawArray",
    "RawValue",
    "Semaphore",
    "SimpleQueue",
    "TimeoutError",
    "Value",
    "active_children",
    "allow_connection_pickling",
    "cpu_count",
    "current_process",
    "freeze_support",
    "get_all_start_methods",
    "get_context",
    "get_logger",
    "get_start_method",
    "log_to_stderr",
    "parent_process",
    "reducer",
    "set_executable",
    "set_forkserver_preload",
    "set_start_method",
]

# These functions (really bound methods)
# are all autogenerated at runtime here: https://github.com/python/cpython/blob/600c65c094b0b48704d8ec2416930648052ba715/Lib/multiprocessing/__init__.py#L23
RawValue = context._default_context.RawValue
"""Returns a shared object"""

RawArray = context._default_context.RawArray
"""Returns a shared array"""

Value = context._default_context.Value
"""Returns a synchronized shared object"""

Array = context._default_context.Array
"""Returns a synchronized shared array"""

Barrier = context._default_context.Barrier
"""Returns a barrier object"""

BoundedSemaphore = context._default_context.BoundedSemaphore
"""Returns a bounded semaphore object"""

Condition = context._default_context.Condition
"""Returns a condition object"""

Event = context._default_context.Event
"""Returns an event object"""

Lock = context._default_context.Lock
"""Returns a non-recursive lock object"""

RLock = context._default_context.RLock
"""Returns a recursive lock object"""

Semaphore = context._default_context.Semaphore
"""Returns a semaphore object"""

Pipe = context._default_context.Pipe
"""Returns two connection object connected by a pipe"""

Pool = context._default_context.Pool
"""Returns a process pool object"""

allow_connection_pickling = context._default_context.allow_connection_pickling
"""Install support for sending connections and sockets
between processes
"""

cpu_count = context._default_context.cpu_count
"""Returns the number of CPUs in the system"""

get_logger = context._default_context.get_logger
"""Return package logger -- if it does not already exist then
it is created.
"""

log_to_stderr = context._default_context.log_to_stderr
"""Turn on logging and add a handler which prints to stderr"""

Manager = context._default_context.Manager
"""Returns a manager associated with a running server process

The managers methods such as `Lock()`, `Condition()` and `Queue()`
can be used to create shared objects.
"""

set_executable = context._default_context.set_executable
"""Sets the path to a python.exe or pythonw.exe binary used to run
child processes instead of sys.executable when using the 'spawn'
start method.  Useful for people embedding Python.
"""

set_forkserver_preload = context._default_context.set_forkserver_preload
"""Set list of module names to try to load in forkserver process.
This is really just a hint.
"""

get_all_start_methods = context._default_context.get_all_start_methods
"""Returns a list of the supported start methods, default first."""

get_start_method = context._default_context.get_start_method
set_start_method = context._default_context.set_start_method
get_context = context._default_context.get_context
