#!/usr/bin/env python

# Copyright (c) Twisted Matrix Laboratories.
# See LICENSE for details.


from twisted.internet import reactor
from twisted.spread import pb


class Two(pb.Referenceable):
    def remote_print(self, arg):
        print("Two.print() called with", arg)


def main():
    two = Two()
    factory = pb.PBClientFactory()
    reactor.connectTCP("localhost", 8800, factory)
    def1 = factory.getRootObject()
    def1.addCallback(got_obj, two)  # hands our 'two' to the callback
    reactor.run()


def got_obj(obj, two):
    print("got One:", obj)
    print("giving it our two")
    obj.callRemote("takeTwo", two)


main()
