# Polars security policy

Please disclose security vulnerabilities to security@polars.tech. This address forwards to a small
security team who will decide the next steps. Our goal is to respond within 1-2 business days
acknowledging your email and explaining our next steps.

## Scope

We consider security-sensitive bugs any bug which:

- could potentially lead to arbitrary code execution on the machine running Polars, or
- leaks data to a remote machine not explicitly asked.

Note that segfaults are typically an indicator there is a vector for arbitrary code execution, but
we do not consider segfaults caused by a stack which grew too large to be security vulnerabilities.
If you do encounter a segfault please verify (if you are able to) whether this is caused by overly
deep recursion before reporting a potential security vulnerability.

Not in scope are:

- malicious Polars plugins, or
- any form of Python object serialization (which utilizes pickle).

Both of these are assumed to be trusted, and may execute arbitrary code.

Data analytics software typically does not trust the data itself (e.g. strings inside a data set),
but does trust the data source (whoever produced the database, Parquet file, etc). Polars is similar
in this. While we do of course fix bugs which can occur when reading invalid file formats, and
strive to be perfectly secure, the attack surface is huge. We therefore do not recommend reading
files generated by malicious actors.

Malicious data inside files generated by trusted actors should always be read and processed
correctly. We thus consider exploits which can occur purely from malicious (user-generated) data in
files generated by trustworthy actors to be the highest priority.

## Fix and disclosure policy

We will assess the risk and ease of exploitation in accordance with the above scope. If sufficiently
high we will create a fix and immediately publish a new point release of Polars after publication,
with a security notice in the release notes. We currently do not have the resources to backport
fixes to previous versions of Polars, or to facilitate privileged embargoes with distributors.
