% Copyright (c) Jupyter Development Team.

% Distributed under the terms of the Modified BSD License.

% JupyterLab Tutorial documentation master file, created by
% sphinx-quickstart on Tue Jun 21 16:30:09 2016.
% You can adapt this file completely to your liking, but it should at least
% contain the root `toctree` directive.

# JupyterLab Documentation

Welcome to the **JupyterLab** documentation site. JupyterLab is a highly
extensible, feature-rich notebook authoring application and editing environment,
and is a part of [Project Jupyter](https://docs.jupyter.org/en/latest/), a
large umbrella project centered around the goal of providing tools (and [standards](https://docs.jupyter.org/en/latest/#sub-project-documentation)) for interactive
computing with [computational notebooks](https://docs.jupyter.org/en/latest/#what-is-a-notebook).

A [computational notebook](https://docs.jupyter.org/en/latest/#what-is-a-notebook)
is a shareable document that combines computer code, plain language descriptions,
data, rich visualizations like 3D models, charts, graphs and figures, and interactive
controls. A notebook, along with an editor like JupyterLab, provides a fast interactive
environment for prototyping and explaining code, exploring and visualizing data, and sharing
ideas with others.

JupyterLab is a sibling to other notebook authoring applications under
the [Project Jupyter](https://docs.jupyter.org/en/latest/) umbrella, like
[Jupyter Notebook](https://jupyter-notebook.readthedocs.io/en/latest/) and
[Jupyter Desktop](https://github.com/jupyterlab/jupyterlab-desktop). JupyterLab
offers a more advanced, feature rich, customizable experience compared to
Jupyter Notebook.

[Try JupyterLab on Binder](https://mybinder.org/v2/gh/jupyterlab/jupyterlab-demo/HEAD?urlpath=lab/tree/demo). JupyterLab follows the Jupyter [Community Guides](https://jupyter.readthedocs.io/en/latest/community/content-community.html).

```{image} ./images/jupyterlab.png
:align: center
:alt: true
:class: jp-screenshot shadow
```

:::{only} comment
Alt text is intentionally left blank because the image content is decorative.
:::

See the sections below (and the top-level links above) for more information about using, extending, and contributing to JupyterLab.

```{toctree}
:maxdepth: 2

getting_started/overview
user/index
extension/extension_dev
developer/contributing
API Reference <developer/api>
```
