import { Alignment } from "./alignment";
import { Elevation } from "./elevation";
import { Intent } from "./intent";
import { Position } from "./position";
export declare const ACTIVE: string;
export declare const ALIGN_LEFT: string;
export declare const ALIGN_RIGHT: string;
export declare const DARK: string;
export declare const DISABLED: string;
export declare const FILL: string;
export declare const FIXED: string;
export declare const FIXED_TOP: string;
export declare const INLINE: string;
export declare const INTERACTIVE: string;
export declare const LARGE: string;
export declare const LOADING: string;
export declare const MINIMAL: string;
export declare const OUTLINED: string;
export declare const MULTILINE: string;
export declare const ROUND: string;
export declare const SMALL: string;
export declare const VERTICAL: string;
export declare const POSITION_TOP: string;
export declare const POSITION_BOTTOM: string;
export declare const POSITION_LEFT: string;
export declare const POSITION_RIGHT: string;
export declare const ELEVATION_0: string;
export declare const ELEVATION_1: string;
export declare const ELEVATION_2: string;
export declare const ELEVATION_3: string;
export declare const ELEVATION_4: string;
export declare const INTENT_PRIMARY: string;
export declare const INTENT_SUCCESS: string;
export declare const INTENT_WARNING: string;
export declare const INTENT_DANGER: string;
export declare const FOCUS_DISABLED: string;
export declare const UI_TEXT: string;
export declare const RUNNING_TEXT: string;
export declare const MONOSPACE_TEXT: string;
export declare const TEXT_LARGE: string;
export declare const TEXT_SMALL: string;
export declare const TEXT_MUTED: string;
export declare const TEXT_DISABLED: string;
export declare const TEXT_OVERFLOW_ELLIPSIS: string;
export declare const BLOCKQUOTE: string;
export declare const CODE: string;
export declare const CODE_BLOCK: string;
export declare const HEADING: string;
export declare const LIST: string;
export declare const LIST_UNSTYLED: string;
export declare const RTL: string;
/**
 * @see https://developer.mozilla.org/en-US/docs/Web/CSS/Containing_block#identifying_the_containing_block
 * @deprecated this is no longer needed for ContextMenu2, will be removed in v4.0
 */
export declare const FIXED_POSITIONING_CONTAINING_BLOCK: string;
export declare const ALERT: string;
export declare const ALERT_BODY: string;
export declare const ALERT_CONTENTS: string;
export declare const ALERT_FOOTER: string;
export declare const BREADCRUMB: string;
export declare const BREADCRUMB_CURRENT: string;
export declare const BREADCRUMBS: string;
export declare const BREADCRUMBS_COLLAPSED: string;
export declare const BUTTON: string;
export declare const BUTTON_GROUP: string;
export declare const BUTTON_SPINNER: string;
export declare const BUTTON_TEXT: string;
export declare const CALLOUT: string;
export declare const CALLOUT_ICON: string;
export declare const CARD: string;
export declare const COLLAPSE: string;
export declare const COLLAPSE_BODY: string;
export declare const COLLAPSIBLE_LIST: string;
export declare const CONTEXT_MENU: string;
export declare const CONTEXT_MENU_POPOVER_TARGET: string;
export declare const CONTROL_GROUP: string;
export declare const DIALOG: string;
export declare const DIALOG_CONTAINER: string;
export declare const DIALOG_BODY: string;
export declare const DIALOG_CLOSE_BUTTON: string;
export declare const DIALOG_FOOTER: string;
export declare const DIALOG_FOOTER_ACTIONS: string;
export declare const DIALOG_HEADER: string;
export declare const DIALOG_STEP: string;
export declare const DIALOG_STEP_CONTAINER: string;
export declare const DIALOG_STEP_TITLE: string;
export declare const DIALOG_STEP_ICON: string;
export declare const DIALOG_STEP_VIEWED: string;
export declare const DIVIDER: string;
export declare const DRAWER: string;
export declare const DRAWER_BODY: string;
export declare const DRAWER_FOOTER: string;
export declare const DRAWER_HEADER: string;
export declare const EDITABLE_TEXT: string;
export declare const EDITABLE_TEXT_CONTENT: string;
export declare const EDITABLE_TEXT_EDITING: string;
export declare const EDITABLE_TEXT_INPUT: string;
export declare const EDITABLE_TEXT_PLACEHOLDER: string;
export declare const FLEX_EXPANDER: string;
export declare const HTML_SELECT: string;
/** @deprecated prefer `<HTMLSelect>` component */
export declare const SELECT: string;
export declare const HTML_TABLE: string;
export declare const HTML_TABLE_BORDERED: string;
export declare const HTML_TABLE_CONDENSED: string;
export declare const HTML_TABLE_STRIPED: string;
export declare const INPUT: string;
export declare const INPUT_GHOST: string;
export declare const INPUT_GROUP: string;
export declare const INPUT_LEFT_CONTAINER: string;
export declare const INPUT_ACTION: string;
export declare const CONTROL: string;
export declare const CONTROL_INDICATOR: string;
export declare const CONTROL_INDICATOR_CHILD: string;
export declare const CHECKBOX: string;
export declare const RADIO: string;
export declare const SWITCH: string;
export declare const SWITCH_INNER_TEXT: string;
export declare const FILE_INPUT: string;
export declare const FILE_INPUT_HAS_SELECTION: string;
export declare const FILE_UPLOAD_INPUT: string;
export declare const FILE_UPLOAD_INPUT_CUSTOM_TEXT: string;
export declare const KEY: string;
export declare const KEY_COMBO: string;
export declare const MODIFIER_KEY: string;
export declare const HOTKEY: string;
export declare const HOTKEY_LABEL: string;
export declare const HOTKEY_COLUMN: string;
export declare const HOTKEY_DIALOG: string;
export declare const LABEL: string;
export declare const FORM_GROUP: string;
export declare const FORM_CONTENT: string;
export declare const FORM_HELPER_TEXT: string;
export declare const FORM_GROUP_SUB_LABEL: string;
export declare const MENU: string;
export declare const MENU_ITEM: string;
export declare const MENU_ITEM_LABEL: string;
export declare const MENU_SUBMENU: string;
export declare const MENU_DIVIDER: string;
export declare const MENU_HEADER: string;
export declare const MULTISTEP_DIALOG: string;
export declare const MULTISTEP_DIALOG_PANELS: string;
export declare const MULTISTEP_DIALOG_LEFT_PANEL: string;
export declare const MULTISTEP_DIALOG_RIGHT_PANEL: string;
export declare const MULTISTEP_DIALOG_FOOTER: string;
export declare const NAVBAR: string;
export declare const NAVBAR_GROUP: string;
export declare const NAVBAR_HEADING: string;
export declare const NAVBAR_DIVIDER: string;
export declare const NON_IDEAL_STATE: string;
export declare const NON_IDEAL_STATE_VISUAL: string;
export declare const NUMERIC_INPUT: string;
export declare const OVERFLOW_LIST: string;
export declare const OVERFLOW_LIST_SPACER: string;
export declare const OVERLAY: string;
export declare const OVERLAY_BACKDROP: string;
export declare const OVERLAY_CONTAINER: string;
export declare const OVERLAY_CONTENT: string;
export declare const OVERLAY_INLINE: string;
export declare const OVERLAY_OPEN: string;
export declare const OVERLAY_SCROLL_CONTAINER: string;
export declare const OVERLAY_START_FOCUS_TRAP: string;
export declare const OVERLAY_END_FOCUS_TRAP: string;
export declare const PANEL_STACK: string;
export declare const PANEL_STACK_HEADER: string;
export declare const PANEL_STACK_HEADER_BACK: string;
export declare const PANEL_STACK_VIEW: string;
export declare const PANEL_STACK2: string;
export declare const PANEL_STACK2_HEADER: string;
export declare const PANEL_STACK2_HEADER_BACK: string;
export declare const PANEL_STACK2_VIEW: string;
export declare const POPOVER: string;
export declare const POPOVER_ARROW: string;
export declare const POPOVER_BACKDROP: string;
export declare const POPOVER_CAPTURING_DISMISS: string;
export declare const POPOVER_CONTENT: string;
export declare const POPOVER_CONTENT_SIZING: string;
export declare const POPOVER_DISMISS: string;
export declare const POPOVER_DISMISS_OVERRIDE: string;
export declare const POPOVER_OPEN: string;
export declare const POPOVER_OUT_OF_BOUNDARIES: string;
export declare const POPOVER_TARGET: string;
export declare const POPOVER_WRAPPER: string;
export declare const TRANSITION_CONTAINER: string;
export declare const PROGRESS_BAR: string;
export declare const PROGRESS_METER: string;
export declare const PROGRESS_NO_STRIPES: string;
export declare const PROGRESS_NO_ANIMATION: string;
export declare const PORTAL: string;
export declare const SKELETON: string;
export declare const SLIDER: string;
export declare const SLIDER_AXIS: string;
export declare const SLIDER_HANDLE: string;
export declare const SLIDER_LABEL: string;
export declare const SLIDER_TRACK: string;
export declare const SLIDER_PROGRESS: string;
export declare const START: string;
export declare const END: string;
export declare const SPINNER: string;
export declare const SPINNER_ANIMATION: string;
export declare const SPINNER_HEAD: string;
export declare const SPINNER_NO_SPIN: string;
export declare const SPINNER_TRACK: string;
export declare const TAB: string;
export declare const TAB_INDICATOR: string;
export declare const TAB_INDICATOR_WRAPPER: string;
export declare const TAB_LIST: string;
export declare const TAB_PANEL: string;
export declare const TABS: string;
export declare const TAG: string;
export declare const TAG_REMOVE: string;
export declare const TAG_INPUT: string;
export declare const TAG_INPUT_ICON: string;
export declare const TAG_INPUT_VALUES: string;
export declare const TOAST: string;
export declare const TOAST_CONTAINER: string;
export declare const TOAST_MESSAGE: string;
export declare const TOOLTIP: string;
export declare const TOOLTIP_INDICATOR: string;
export declare const TREE: string;
export declare const TREE_NODE: string;
export declare const TREE_NODE_CARET: string;
export declare const TREE_NODE_CARET_CLOSED: string;
export declare const TREE_NODE_CARET_NONE: string;
export declare const TREE_NODE_CARET_OPEN: string;
export declare const TREE_NODE_CONTENT: string;
export declare const TREE_NODE_EXPANDED: string;
export declare const TREE_NODE_ICON: string;
export declare const TREE_NODE_LABEL: string;
export declare const TREE_NODE_LIST: string;
export declare const TREE_NODE_SECONDARY_LABEL: string;
export declare const TREE_NODE_SELECTED: string;
export declare const TREE_ROOT: string;
export declare const ICON: string;
/** @deprecated use <Icon> components and iconName prop APIs instead */
export declare const ICON_STANDARD: string;
/** @deprecated use <Icon> components and iconName prop APIs instead */
export declare const ICON_LARGE: string;
/**
 * Returns the namespace prefix for all Blueprint CSS classes.
 * Customize this namespace at build time with the `process.env.BLUEPRINT_NAMESPACE` environment variable.
 */
export declare function getClassNamespace(): string;
/** Return CSS class for alignment. */
export declare function alignmentClass(alignment: Alignment | undefined): string | undefined;
export declare function elevationClass(elevation: Elevation): string;
export declare function elevationClass(elevation: undefined): undefined;
export declare function elevationClass(elevation: Elevation | undefined): string | undefined;
/**
 * Returns CSS class for icon name.
 */
export declare function iconClass(iconName: string): string;
export declare function iconClass(iconName: undefined): undefined;
export declare function iconClass(iconName: string | undefined): string | undefined;
/** Return CSS class for intent. */
export declare function intentClass(intent: Intent): string;
export declare function intentClass(intent: typeof Intent.NONE | undefined): undefined;
export declare function intentClass(intent: Intent | undefined): Intent | undefined;
export declare function positionClass(position: Position): string;
export declare function positionClass(position: undefined): undefined;
export declare function positionClass(position: Position | undefined): string | undefined;
