# Статические Файлы { #static-files }

Вы можете предоставлять статические файлы автоматически из директории, используя `StaticFiles`.

## Использование `StaticFiles` { #use-staticfiles }

* Импортируйте `StaticFiles`.
* "Примонтируйте" экземпляр `StaticFiles()` к определённому пути.

{* ../../docs_src/static_files/tutorial001_py310.py hl[2,6] *}

/// note | Технические детали

Вы также можете использовать `from starlette.staticfiles import StaticFiles`.

**FastAPI** предоставляет `starlette.staticfiles` под псевдонимом `fastapi.staticfiles`, просто для вашего удобства, как разработчика. Но на самом деле это берётся напрямую из библиотеки Starlette.

///

### Что такое "Монтирование" { #what-is-mounting }

"Монтирование" означает добавление полноценного "независимого" приложения на определённый путь, которое затем обрабатывает все подпути.

Это отличается от использования `APIRouter`, так как примонтированное приложение является полностью независимым.
OpenAPI и документация из вашего главного приложения не будут содержать ничего из примонтированного приложения, и т.д.

Вы можете прочитать больше об этом в [Расширенном руководстве пользователя](../advanced/index.md){.internal-link target=_blank}.

## Детали { #details }

Первый параметр `"/static"` относится к подпути, по которому это "подприложение" будет "примонтировано". Таким образом, любой путь начинающийся со `"/static"` будет обработан этим приложением.

Параметр `directory="static"` относится к имени директории, которая содержит ваши статические файлы.

`name="static"` даёт имя маршруту, которое может быть использовано внутри **FastAPI**.

Все эти параметры могут отличаться от "`static`", настройте их в соответствии с вашими нуждами и конкретными деталями вашего собственного приложения.

## Больше информации { #more-info }

Для получения дополнительной информации о деталях и настройках ознакомьтесь с <a href="https://www.starlette.dev/staticfiles/" class="external-link" target="_blank">Документацией Starlette о статических файлах</a>.
