# ベンチマーク { #benchmarks }

TechEmpowerの独立したベンチマークでは、Uvicornの下で動作する**FastAPI**アプリケーションは、<a href="https://www.techempower.com/benchmarks/#section=test&runid=7464e520-0dc2-473d-bd34-dbdfd7e85911&hw=ph&test=query&l=zijzen-7" class="external-link" target="_blank">利用可能な最速のPythonフレームワークの1つ</a>であり、下回っているのはStarletteとUvicorn自体（FastAPIによって内部で使用される）のみだと示されています。

ただし、ベンチマークを確認し、比較する際には下記の内容に気を付けてください。

## ベンチマークと速度 { #benchmarks-and-speed }

ベンチマークを確認する時、異なるタイプの複数のツールが同等のものとして比較されているのを目にするのが一般的です。

具体的には、Uvicorn、Starlette、FastAPIを（他の多くのツールの中で）まとめて比較しているのを目にすることがあります。

ツールで解決する問題がシンプルなほど、パフォーマンスが向上します。また、ほとんどのベンチマークは、ツールから提供される追加機能をテストしていません。

階層関係はこのようになります。

* **Uvicorn**: ASGIサーバー
    * **Starlette**: （Uvicornを使用）webマイクロフレームワーク
        * **FastAPI**: （Starletteを使用）データバリデーションなど、APIを構築するためのいくつかの追加機能を備えたAPIマイクロフレームワーク

* **Uvicorn**:
    * サーバー自体以外に余分なコードがあまりないため、最高のパフォーマンスになります。
    * Uvicornにアプリケーションを直接書くことはないでしょう。それは、あなたのコードに、Starlette（または**FastAPI**）が提供するコードを、少なくとも多かれ少なかれ含める必要があるということです。そして、もしそうした場合、最終的なアプリケーションは、フレームワークを使用してアプリのコードとバグを最小限に抑えた場合と同じオーバーヘッドになります。
    * Uvicornを比較する場合は、Daphne、Hypercorn、uWSGIなどのアプリケーションサーバーと比較してください。
* **Starlette**:
    * Uvicornに次ぐ性能になるでしょう。実際、Starletteは実行にUvicornを使用しています。そのため、おそらく、より多くのコードを実行しなければならない分だけ、Uvicornより「遅く」なるだけです。
    * しかし、パスに基づくルーティングなどを使って、シンプルなwebアプリケーションを構築するためのツールを提供します。
    * Starletteを比較する場合は、Sanic、Flask、Djangoなどのwebフレームワーク（またはマイクロフレームワーク）と比較してください。
* **FastAPI**:
    * StarletteがUvicornを使用しており、それより速くできないのと同じように、**FastAPI**はStarletteを使用しているため、それより速くできません。
    * FastAPIはStarletteの上に、より多くの機能を提供します。データバリデーションやシリアライゼーションのように、APIを構築する際にほとんど常に必要な機能です。また、それを使用することで、自動ドキュメント化を無料で利用できます（自動ドキュメントは実行中のアプリケーションにオーバーヘッドを追加せず、起動時に生成されます）。
    * FastAPIを使用せず、Starletteを直接（またはSanic、Flask、Responderなど別のツールを）使用した場合、データバリデーションとシリアライゼーションをすべて自分で実装する必要があります。そのため、最終的なアプリケーションはFastAPIを使用して構築した場合と同じオーバーヘッドが発生します。そして多くの場合、このデータバリデーションとシリアライゼーションは、アプリケーションで書かれるコードの大部分になります。
    * そのため、FastAPIを使用することで、開発時間、バグ、コード行数を節約でき、使用しない場合（あなたがそれをすべて自分のコードで実装する必要があるため）と比べて、同じパフォーマンス（またはそれ以上）を得られる可能性があります。
    * FastAPIを比較する場合は、Flask-apispec、NestJS、Moltenなど、データバリデーション、シリアライゼーション、ドキュメント化を提供するwebアプリケーションフレームワーク（またはツール群）と比較してください。自動データバリデーション、シリアライゼーション、ドキュメント化が統合されたフレームワークです。
