# Про версії FastAPI { #about-fastapi-versions }

**FastAPI** уже використовується у продакшні в багатьох застосунках і системах. Покриття тестами підтримується на рівні 100%. Але розробка все ще рухається швидко.

Нові можливості додаються часто, помилки регулярно виправляються, а код постійно поліпшується.

Тому поточні версії все ще `0.x.x`, це відображає те, що кожна версія потенційно може містити несумісні зміни. Це відповідає правилам <a href="https://semver.org/" class="external-link" target="_blank">Семантичного версіонування</a>.

Ви можете створювати продакшн-застосунки з **FastAPI** вже зараз (і, ймовірно, робите це вже певний час), просто переконайтеся, що ви використовуєте версію, яка коректно працює з рештою вашого коду.

## Зафіксуйте версію `fastapi` { #pin-your-fastapi-version }

Перше, що слід зробити, - «зафіксувати» версію **FastAPI**, яку ви використовуєте, до конкретної останньої версії, що, як ви знаєте, правильно працює для вашого застосунку.

Наприклад, припустімо, що у вашому застосунку використовується версія `0.112.0`.

Якщо ви використовуєте файл `requirements.txt`, ви можете вказати версію так:

```txt
fastapi[standard]==0.112.0
```

це означатиме, що ви використовуватимете саме версію `0.112.0`.

Або ви також можете зафіксувати так:

```txt
fastapi[standard]>=0.112.0,<0.113.0
```

це означатиме, що ви використовуватимете версії `0.112.0` і вище, але менше `0.113.0`, наприклад, версія `0.112.2` все ще буде прийнятною.

Якщо ви використовуєте інший інструмент для керування встановленнями, як-от `uv`, Poetry, Pipenv чи інші, у всіх них є спосіб визначати конкретні версії для ваших пакетів.

## Доступні версії { #available-versions }

Ви можете переглянути доступні версії (наприклад, щоб перевірити поточну останню) в [Примітках до випусків](../release-notes.md){.internal-link target=_blank}.

## Про версії { #about-versions }

Відповідно до правил Семантичного версіонування, будь-яка версія нижче `1.0.0` потенційно може містити несумісні зміни.

FastAPI також дотримується правила, що будь-яка зміна «PATCH»-версії - це виправлення помилок і зміни без порушень сумісності.

/// tip | Порада

«PATCH» - це останнє число, наприклад, у `0.2.3` PATCH-версія - це `3`.

///

Тож ви можете зафіксувати версію так:

```txt
fastapi>=0.45.0,<0.46.0
```

Несумісні зміни та нові можливості додаються у «MINOR»-версіях.

/// tip | Порада

«MINOR» - це число посередині, наприклад, у `0.2.3` MINOR-версія - це `2`.

///

## Оновлення версій FastAPI { #upgrading-the-fastapi-versions }

Ви повинні додати тести для вашого застосунку.

З **FastAPI** це дуже легко (завдяки Starlette), перегляньте документацію: [Тестування](../tutorial/testing.md){.internal-link target=_blank}

Після того як у вас є тести, ви можете оновити версію **FastAPI** до новішої і переконатися, що весь ваш код працює правильно, запустивши тести.

Якщо все працює або після внесення необхідних змін і проходження всіх тестів, зафіксуйте вашу версію `fastapi` на цій новій версії.

## Про Starlette { #about-starlette }

Не варто фіксувати версію `starlette`.

Різні версії **FastAPI** використовуватимуть конкретну новішу версію Starlette.

Отже, просто дозвольте **FastAPI** використовувати відповідну версію Starlette.

## Про Pydantic { #about-pydantic }

Pydantic включає тести для **FastAPI** разом із власними тестами, тому нові версії Pydantic (вище `1.0.0`) завжди сумісні з FastAPI.

Ви можете зафіксувати Pydantic на будь-якій версії вище `1.0.0`, яка вам підходить.

Наприклад:

```txt
pydantic>=2.7.0,<3.0.0
```
