# Подприложения — Mounts (монтирование) { #sub-applications-mounts }

Если вам нужны два независимых приложения FastAPI, каждое со своим собственным OpenAPI и собственными интерфейсами документации, вы можете иметь основное приложение и «смонтировать» одно (или несколько) подприложений.

## Монтирование приложения **FastAPI** { #mounting-a-fastapi-application }

«Монтирование» означает добавление полностью независимого приложения по конкретному пути; далее оно будет обрабатывать всё под этим путём, используя объявленные в подприложении _операции пути_.

### Приложение верхнего уровня { #top-level-application }

Сначала создайте основное, верхнего уровня, приложение **FastAPI** и его *операции пути*:

{* ../../docs_src/sub_applications/tutorial001_py310.py hl[3, 6:8] *}

### Подприложение { #sub-application }

Затем создайте подприложение и его *операции пути*.

Это подприложение — обычное стандартное приложение FastAPI, но именно оно будет «смонтировано»:

{* ../../docs_src/sub_applications/tutorial001_py310.py hl[11, 14:16] *}

### Смонтируйте подприложение { #mount-the-sub-application }

В вашем приложении верхнего уровня, `app`, смонтируйте подприложение `subapi`.

В этом случае оно будет смонтировано по пути `/subapi`:

{* ../../docs_src/sub_applications/tutorial001_py310.py hl[11, 19] *}

### Проверьте автоматическую документацию API { #check-the-automatic-api-docs }

Теперь запустите команду `fastapi` с вашим файлом:

<div class="termy">

```console
$ fastapi dev main.py

<span style="color: green;">INFO</span>:     Uvicorn running on http://127.0.0.1:8000 (Press CTRL+C to quit)
```

</div>

И откройте документацию по адресу <a href="http://127.0.0.1:8000/docs" class="external-link" target="_blank">http://127.0.0.1:8000/docs</a>.

Вы увидите автоматическую документацию API для основного приложения, включающую только его собственные _операции пути_:

<img src="/img/tutorial/sub-applications/image01.png">

Затем откройте документацию для подприложения по адресу <a href="http://127.0.0.1:8000/subapi/docs" class="external-link" target="_blank">http://127.0.0.1:8000/subapi/docs</a>.

Вы увидите автоматическую документацию API для подприложения, включающую только его собственные _операции пути_, все под корректным префиксом подпути `/subapi`:

<img src="/img/tutorial/sub-applications/image02.png">

Если вы попробуете взаимодействовать с любым из двух интерфейсов, всё будет работать корректно, потому что браузер сможет обращаться к каждому конкретному приложению и подприложению.

### Технические подробности: `root_path` { #technical-details-root-path }

Когда вы монтируете подприложение, как описано выше, FastAPI позаботится о передаче пути монтирования для подприложения, используя механизм из спецификации ASGI под названием `root_path`.

Таким образом подприложение будет знать, что для интерфейса документации нужно использовать этот префикс пути.

У подприложения также могут быть свои собственные смонтированные подприложения, и всё будет работать корректно, потому что FastAPI автоматически обрабатывает все эти `root_path`.

Вы узнаете больше о `root_path` и о том, как использовать его явно, в разделе [За прокси](behind-a-proxy.md){.internal-link target=_blank}.
