# Параметри Cookie { #cookie-parameters }

Ви можете визначати параметри Cookie таким же чином, як визначаються параметри `Query` і `Path`.

## Імпорт `Cookie` { #import-cookie }

Спочатку імпортуйте `Cookie`:

{* ../../docs_src/cookie_params/tutorial001_an_py310.py hl[3] *}

## Визначення параметрів `Cookie` { #declare-cookie-parameters }

Потім визначте параметри cookie, використовуючи таку ж конструкцію як для `Path` і `Query`.

Ви можете визначити значення за замовчуванням, а також усі додаткові параметри валідації чи анотації:

{* ../../docs_src/cookie_params/tutorial001_an_py310.py hl[9] *}

/// note | Технічні деталі

`Cookie` це "сестра" класів `Path` і `Query`. Вони також наслідуються від одного спільного класу `Param`.

Але пам'ятайте, що коли ви імпортуєте `Query`, `Path`, `Cookie` та інше з `fastapi`, це фактично функції, що повертають спеціальні класи.

///

/// info

Для визначення cookies ви маєте використовувати `Cookie`, тому що в іншому випадку параметри будуть інтерпритовані, як параметри запиту.

///

/// info

Майте на увазі, що оскільки **браузери обробляють cookies** спеціальним чином і за лаштунками, вони **не** дозволяють **JavaScript** легко взаємодіяти з ними.

Якщо ви перейдете до **інтерфейсу документації API** за адресою `/docs`, ви зможете побачити **документацію** для cookies для ваших *операцій шляху*.

Але навіть якщо ви **заповните дані** і натиснете "Execute", оскільки інтерфейс документації працює з **JavaScript**, cookies не буде надіслано, і ви побачите повідомлення про **помилку**, ніби ви не ввели жодних значень.

///

## Підсумки { #recap }

Визначайте cookies за допомогою `Cookie`, використовуючи той же спільний шаблон, що і `Query` та `Path`.
