// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef SILRESTRICTIONATTRIBUTES_H
#define SILRESTRICTIONATTRIBUTES_H
#include <state_exports.h>
#include <AttributeSubject.h>

#include <SILAttributes.h>

// ****************************************************************************
// Class: SILRestrictionAttributes
//
// Purpose:
//    The class contains attributes for SIL restrictions.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class STATE_API SILRestrictionAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    SILRestrictionAttributes();
    SILRestrictionAttributes(const SILRestrictionAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    SILRestrictionAttributes(private_tmfs_t tmfs);
    SILRestrictionAttributes(const SILRestrictionAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~SILRestrictionAttributes();

    virtual SILRestrictionAttributes& operator = (const SILRestrictionAttributes &obj);
    virtual bool operator == (const SILRestrictionAttributes &obj) const;
    virtual bool operator != (const SILRestrictionAttributes &obj) const;
private:
    void Init();
    void Copy(const SILRestrictionAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectUseSet();
    void SelectSilAtts();

    // Property setting methods
    void SetUseSet(const unsignedCharVector &useSet_);
    void SetTopSet(int topSet_);
    void SetSilAtts(const SILAttributes &silAtts_);

    // Property getting methods
    const unsignedCharVector &GetUseSet() const;
          unsignedCharVector &GetUseSet();
    int                      GetTopSet() const;
    const SILAttributes      &GetSilAtts() const;
          SILAttributes      &GetSilAtts();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_useSet = 0,
        ID_topSet,
        ID_silAtts,
        ID__LAST
    };

private:
    unsignedCharVector useSet;
    int                topSet;
    SILAttributes      silAtts;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define SILRESTRICTIONATTRIBUTES_TMFS "u*ia"

#endif
